/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.oned;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.RegionLocation;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.core.partitioning.bsp.AbstractBSPTree;
import org.apache.commons.geometry.core.partitioning.bsp.AbstractRegionBSPTree;
import org.apache.commons.geometry.core.partitioning.bsp.BSPTree;
import org.apache.commons.geometry.core.partitioning.bsp.BSPTreeVisitor;
import org.apache.commons.geometry.core.partitioning.bsp.RegionCutRule;
import org.apache.commons.geometry.euclidean.oned.Interval;
import org.apache.commons.geometry.euclidean.oned.OrientedPoint;
import org.apache.commons.geometry.euclidean.oned.Vector1D;

public final class RegionBSPTree1D
extends AbstractRegionBSPTree<Vector1D, RegionNode1D> {
    private static final Comparator<BoundaryPair> BOUNDARY_PAIR_COMPARATOR = Comparator.comparingDouble(BoundaryPair::getMinValue);

    public RegionBSPTree1D() {
        this(false);
    }

    public RegionBSPTree1D(boolean full) {
        super(full);
    }

    public RegionBSPTree1D copy() {
        RegionBSPTree1D result = RegionBSPTree1D.empty();
        result.copy((BSPTree)this);
        return result;
    }

    public void add(Interval interval) {
        this.union(RegionBSPTree1D.intervalToTree(interval));
    }

    public RegionLocation classify(double x) {
        return this.classify(Vector1D.of(x));
    }

    public boolean contains(double x) {
        return this.contains(Vector1D.of(x));
    }

    public double getBoundarySize() {
        return 0.0;
    }

    public Vector1D project(Vector1D pt) {
        BoundaryProjector1D projector = new BoundaryProjector1D(pt);
        this.accept((BSPTreeVisitor)projector);
        return (Vector1D)projector.getProjected();
    }

    public Split<RegionBSPTree1D> split(Hyperplane<Vector1D> splitter) {
        return this.split(splitter, RegionBSPTree1D.empty(), RegionBSPTree1D.empty());
    }

    public double getMin() {
        double min = Double.POSITIVE_INFINITY;
        RegionNode1D node = (RegionNode1D)this.getRoot();
        while (!node.isLeaf()) {
            OrientedPoint pt = (OrientedPoint)node.getCutHyperplane();
            min = pt.getLocation();
            node = pt.isPositiveFacing() ? (RegionNode1D)node.getMinus() : (RegionNode1D)node.getPlus();
        }
        return node.isInside() ? Double.NEGATIVE_INFINITY : min;
    }

    public double getMax() {
        double max = Double.NEGATIVE_INFINITY;
        RegionNode1D node = (RegionNode1D)this.getRoot();
        while (!node.isLeaf()) {
            OrientedPoint pt = (OrientedPoint)node.getCutHyperplane();
            max = pt.getLocation();
            node = pt.isPositiveFacing() ? (RegionNode1D)node.getPlus() : (RegionNode1D)node.getMinus();
        }
        return node.isInside() ? Double.POSITIVE_INFINITY : max;
    }

    public List<Interval> toIntervals() {
        ArrayList<BoundaryPair> boundaryPairs = new ArrayList<BoundaryPair>();
        this.visitInsideIntervals((min, max) -> boundaryPairs.add(new BoundaryPair((OrientedPoint)((Object)min), (OrientedPoint)((Object)max))));
        boundaryPairs.sort(BOUNDARY_PAIR_COMPARATOR);
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        BoundaryPair start = null;
        BoundaryPair end = null;
        for (BoundaryPair current : boundaryPairs) {
            if (start == null) {
                start = current;
                end = current;
                continue;
            }
            if (Objects.equals((Object)end.getMax(), (Object)current.getMin())) {
                end = current;
                continue;
            }
            intervals.add(this.createInterval(start, end));
            start = current;
            end = current;
        }
        if (start != null) {
            intervals.add(this.createInterval(start, end));
        }
        return intervals;
    }

    private Interval createInterval(BoundaryPair start, BoundaryPair end) {
        OrientedPoint min = start.getMin();
        OrientedPoint max = end.getMax();
        if (min != null && min.isPositiveFacing()) {
            min = min.reverse();
        }
        if (max != null && !max.isPositiveFacing()) {
            max = max.reverse();
        }
        return Interval.of(min, max);
    }

    private void visitInsideIntervals(BiConsumer<OrientedPoint, OrientedPoint> visitor) {
        for (RegionNode1D node : this.nodes()) {
            if (!node.isInside()) continue;
            node.visitNodeInterval(visitor);
        }
    }

    protected RegionNode1D createNode() {
        return new RegionNode1D((AbstractBSPTree)this);
    }

    protected AbstractRegionBSPTree.RegionSizeProperties<Vector1D> computeRegionSizeProperties() {
        RegionSizePropertiesVisitor visitor = new RegionSizePropertiesVisitor();
        this.visitInsideIntervals(visitor);
        return visitor.getRegionSizeProperties();
    }

    protected boolean swapsInsideOutside(Transform<Vector1D> transform) {
        return false;
    }

    public static RegionBSPTree1D full() {
        return new RegionBSPTree1D(true);
    }

    public static RegionBSPTree1D empty() {
        return new RegionBSPTree1D(false);
    }

    public static RegionBSPTree1D from(Interval interval, Interval ... more) {
        RegionBSPTree1D tree = RegionBSPTree1D.intervalToTree(interval);
        for (Interval additional : more) {
            tree.add(additional);
        }
        return tree;
    }

    public static RegionBSPTree1D from(Iterable<Interval> intervals) {
        RegionBSPTree1D tree = new RegionBSPTree1D(false);
        for (Interval interval : intervals) {
            tree.add(interval);
        }
        return tree;
    }

    private static RegionBSPTree1D intervalToTree(Interval interval) {
        OrientedPoint minBoundary = interval.getMinBoundary();
        OrientedPoint maxBoundary = interval.getMaxBoundary();
        RegionBSPTree1D tree = RegionBSPTree1D.full();
        RegionNode1D node = (RegionNode1D)tree.getRoot();
        if (minBoundary != null) {
            tree.setNodeCut((AbstractBSPTree.AbstractNode)node, minBoundary.span(), tree.getSubtreeInitializer(RegionCutRule.MINUS_INSIDE));
            node = (RegionNode1D)node.getMinus();
        }
        if (maxBoundary != null) {
            tree.setNodeCut((AbstractBSPTree.AbstractNode)node, maxBoundary.span(), tree.getSubtreeInitializer(RegionCutRule.MINUS_INSIDE));
        }
        return tree;
    }

    private static final class RegionSizePropertiesVisitor
    implements BiConsumer<OrientedPoint, OrientedPoint> {
        private int count;
        private double size;
        private double rawCentroidSum;
        private double scaledCentroidSum;

        private RegionSizePropertiesVisitor() {
        }

        @Override
        public void accept(OrientedPoint min, OrientedPoint max) {
            ++this.count;
            double minLoc = min != null ? min.getLocation() : Double.NEGATIVE_INFINITY;
            double maxLoc = max != null ? max.getLocation() : Double.POSITIVE_INFINITY;
            double intervalSize = maxLoc - minLoc;
            double intervalCentroid = 0.5 * (maxLoc + minLoc);
            this.size += intervalSize;
            this.rawCentroidSum += intervalCentroid;
            this.scaledCentroidSum += intervalSize * intervalCentroid;
        }

        public AbstractRegionBSPTree.RegionSizeProperties<Vector1D> getRegionSizeProperties() {
            Vector1D centroid = null;
            if (this.count > 0 && Double.isFinite(this.size)) {
                centroid = this.size > 0.0 ? Vector1D.of(this.scaledCentroidSum / this.size) : Vector1D.of(this.rawCentroidSum / (double)this.count);
            }
            return new AbstractRegionBSPTree.RegionSizeProperties(this.size, centroid);
        }
    }

    private static final class NodeRegionVisitor
    implements BiConsumer<OrientedPoint, OrientedPoint> {
        private OrientedPoint min;
        private OrientedPoint max;

        private NodeRegionVisitor() {
        }

        @Override
        public void accept(OrientedPoint minBoundary, OrientedPoint maxBoundary) {
            this.min = minBoundary != null && minBoundary.isPositiveFacing() ? minBoundary.reverse() : minBoundary;
            this.max = maxBoundary != null && !maxBoundary.isPositiveFacing() ? maxBoundary.reverse() : maxBoundary;
        }

        public Interval getInterval() {
            return Interval.of(this.min, this.max);
        }
    }

    private static final class BoundaryProjector1D
    extends AbstractRegionBSPTree.BoundaryProjector<Vector1D, RegionNode1D> {
        BoundaryProjector1D(Vector1D point) {
            super((Point)point);
        }

        protected Vector1D disambiguateClosestPoint(Vector1D target, Vector1D a, Vector1D b) {
            int cmp = Vector1D.COORDINATE_ASCENDING_ORDER.compare(a, b);
            if (target.isInfinite() && target.getX() > 0.0) {
                return cmp < 0 ? b : a;
            }
            return cmp < 0 ? a : b;
        }
    }

    private static final class BoundaryPair {
        private final OrientedPoint min;
        private final OrientedPoint max;

        BoundaryPair(OrientedPoint min, OrientedPoint max) {
            this.min = min;
            this.max = max;
        }

        public OrientedPoint getMin() {
            return this.min;
        }

        public OrientedPoint getMax() {
            return this.max;
        }

        public double getMinValue() {
            return this.min != null ? this.min.getLocation() : Double.NEGATIVE_INFINITY;
        }
    }

    public static final class RegionNode1D
    extends AbstractRegionBSPTree.AbstractRegionNode<Vector1D, RegionNode1D> {
        private RegionNode1D(AbstractBSPTree<Vector1D, RegionNode1D> tree) {
            super(tree);
        }

        public Interval getNodeRegion() {
            NodeRegionVisitor visitor = new NodeRegionVisitor();
            this.visitNodeInterval(visitor);
            return visitor.getInterval();
        }

        private void visitNodeInterval(BiConsumer<? super OrientedPoint, ? super OrientedPoint> visitor) {
            RegionNode1D parent;
            OrientedPoint min = null;
            OrientedPoint max = null;
            RegionNode1D child = this;
            while ((min == null || max == null) && (parent = (RegionNode1D)child.getParent()) != null) {
                OrientedPoint pt = (OrientedPoint)parent.getCutHyperplane();
                if (pt.isPositiveFacing() && child.isMinus() || !pt.isPositiveFacing() && child.isPlus()) {
                    if (max == null) {
                        max = pt;
                    }
                } else if (min == null) {
                    min = pt;
                }
                child = parent;
            }
            visitor.accept(min, max);
        }

        protected RegionNode1D getSelf() {
            return this;
        }
    }
}

