/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.examples.serverpages;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.jci.utils.ConversionUtils;

public final class JspGenerator {
    private String quote(String s) {
        char[] input;
        StringBuilder sb = new StringBuilder();
        for (char c : input = s.toCharArray()) {
            if (c == '\"') {
                sb.append('\\');
            }
            if (c == '\\') {
                sb.append('\\');
            }
            if (c == '\n') {
                sb.append("\");\n").append("    out.write(\"");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private void wrap(StringBuilder pInput, Writer pOutput) throws IOException {
        pOutput.append("    out.write(\"");
        pOutput.append(this.quote(pInput.toString()));
        pOutput.append("\");").append('\n');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateJavaSource(String pResourceName, File pFile) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        OutputStreamWriter output = new OutputStreamWriter(outputStream);
        try {
            int c;
            String packageName;
            String className;
            InputStreamReader input = new InputStreamReader(new FileInputStream(pFile));
            int p = pResourceName.lastIndexOf(47);
            if (p < 0) {
                className = ConversionUtils.stripExtension((String)pResourceName);
                packageName = "";
            } else {
                className = ConversionUtils.stripExtension((String)pResourceName.substring(p + 1));
                packageName = pResourceName.substring(0, p).replace('/', '.');
                ((Writer)output).append("package ").append(packageName).append(";").append('\n');
            }
            ((Writer)output).append("import java.io.PrintWriter;").append('\n');
            ((Writer)output).append("import java.io.IOException;").append('\n');
            ((Writer)output).append("import javax.servlet.http.HttpServlet;").append('\n');
            ((Writer)output).append("import javax.servlet.http.HttpServletRequest;").append('\n');
            ((Writer)output).append("import javax.servlet.http.HttpServletResponse;").append('\n');
            ((Writer)output).append("import javax.servlet.ServletException;").append('\n');
            ((Writer)output).append("public class ").append(className).append(" extends HttpServlet {").append('\n');
            ((Writer)output).append("  protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {").append('\n');
            ((Writer)output).append("    final PrintWriter out = response.getWriter();").append('\n');
            char[] open = "<?".toCharArray();
            char[] close = "?>".toCharArray();
            StringBuilder sb = new StringBuilder();
            char[] watch = open;
            int w = 0;
            while ((c = ((Reader)input).read()) >= 0) {
                if (c == watch[w]) {
                    if (watch.length != ++w) continue;
                    if (watch == open) {
                        this.wrap(sb, output);
                        sb = new StringBuilder();
                        watch = close;
                    } else if (watch == close) {
                        ((Writer)output).append(sb.toString());
                        sb = new StringBuilder();
                        watch = open;
                    }
                    w = 0;
                    continue;
                }
                if (w > 0) {
                    sb.append(watch, 0, w);
                }
                sb.append((char)c);
                w = 0;
            }
            if (watch == open) {
                this.wrap(sb, output);
            }
            ((Writer)output).append("    out.close();").append('\n');
            ((Writer)output).append("    out.flush();").append('\n');
            ((Writer)output).append("  }").append('\n');
            ((Writer)output).append("}").append('\n');
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                ((Writer)output).close();
            }
            catch (IOException e) {}
        }
    }
}

