/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.pathable;

import java.net.URL;
import java.net.URLClassLoader;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.commons.logging.PathableClassLoader;
import org.apache.commons.logging.PathableTestSuite;

public class GeneralTestCase
extends TestCase {
    private static void checkAndSetContext() {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        GeneralTestCase.assertEquals((String)"ContextLoader is of unexpected type", (String)contextLoader.getClass().getName(), (String)PathableClassLoader.class.getName());
        URL[] noUrls = new URL[]{};
        Thread.currentThread().setContextClassLoader(new URLClassLoader(noUrls));
    }

    private static void checkAndSetProperties() {
        String prop = System.getProperty("no.such.property");
        GeneralTestCase.assertNull((String)"no.such.property is unexpectedly defined", (Object)prop);
        System.setProperty("no.such.property", "dummy value");
        prop = System.getProperty("no.such.property");
        GeneralTestCase.assertNotNull((String)"no.such.property is unexpectedly undefined", (Object)prop);
    }

    public static Test suite() throws Exception {
        Class<GeneralTestCase> thisClass = GeneralTestCase.class;
        ClassLoader thisClassLoader = thisClass.getClassLoader();
        PathableClassLoader loader = new PathableClassLoader(null);
        loader.useExplicitLoader("junit.", thisClassLoader);
        loader.addLogicalLib("testclasses");
        Class<?> testClass = loader.loadClass(thisClass.getName());
        return new PathableTestSuite(testClass, loader);
    }

    public void testResetContext1() {
        GeneralTestCase.checkAndSetContext();
    }

    public void testResetContext2() {
        GeneralTestCase.checkAndSetContext();
    }

    public void testResetProps1() {
        GeneralTestCase.checkAndSetProperties();
    }

    public void testResetProps2() {
        GeneralTestCase.checkAndSetProperties();
    }
}

