/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.transform;

import java.util.function.DoubleUnaryOperator;
import org.apache.commons.math4.transform.TransformException;
import org.apache.commons.numbers.complex.Complex;

final class TransformUtils {
    private static final int NUM_PARTS = 2;

    private TransformUtils() {
    }

    static double[] scaleInPlace(double[] f, double d) {
        int i = 0;
        while (i < f.length) {
            int n = i++;
            f[n] = f[n] * d;
        }
        return f;
    }

    static Complex[] scaleInPlace(Complex[] f, double d) {
        for (int i = 0; i < f.length; ++i) {
            f[i] = Complex.ofCartesian((double)(d * f[i].getReal()), (double)(d * f[i].getImaginary()));
        }
        return f;
    }

    static double[][] createRealImaginary(Complex[] dataC) {
        double[][] dataRI = new double[2][dataC.length];
        double[] dataR = dataRI[0];
        double[] dataI = dataRI[1];
        for (int i = 0; i < dataC.length; ++i) {
            Complex c = dataC[i];
            dataR[i] = c.getReal();
            dataI[i] = c.getImaginary();
        }
        return dataRI;
    }

    static Complex[] createComplex(double[][] dataRI) {
        if (dataRI.length != 2) {
            throw new TransformException("Size mismatch: {0} != {1}", dataRI.length, 2);
        }
        double[] dataR = dataRI[0];
        double[] dataI = dataRI[1];
        if (dataR.length != dataI.length) {
            throw new TransformException("Size mismatch: {0} != {1}", dataI.length, dataR.length);
        }
        int n = dataR.length;
        Complex[] c = new Complex[n];
        for (int i = 0; i < n; ++i) {
            c[i] = Complex.ofCartesian((double)dataR[i], (double)dataI[i]);
        }
        return c;
    }

    static double[] sample(DoubleUnaryOperator f, double min, double max, int n) {
        if (n <= 0) {
            throw new TransformException("Number {0} is not strictly positive", n);
        }
        if (min >= max) {
            throw new TransformException("Number {0} is larger than {1}", min, max);
        }
        double[] s = new double[n];
        double h = (max - min) / (double)n;
        for (int i = 0; i < n; ++i) {
            s[i] = f.applyAsDouble(min + (double)i * h);
        }
        return s;
    }
}

