/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.core;

import org.apache.commons.numbers.core.DD;
import org.apache.commons.numbers.core.Sum;

public enum Norm {
    L1(Norm::manhattan, Norm::manhattan, Norm::manhattan),
    MANHATTAN(L1),
    L2(Norm::euclidean, Norm::euclidean, Norm::euclidean),
    EUCLIDEAN(L2),
    LINF(Norm::maximum, Norm::maximum, Norm::maximum),
    MAXIMUM(LINF);

    private static final double SMALL_THRESH = 1.4916681462400413E-154;
    private static final double LARGE_THRESH = 2.0458691299350887E149;
    private static final double SAFE_SCALE_UP_THRESH = 7.888609052210118E-31;
    private static final double SCALE_DOWN = 2.409919865102884E-181;
    private static final double SCALE_UP = 4.149515568880993E180;
    private static final int EXP_DIFF_THRESHOLD_2D = 54;
    private final Two two;
    private final Three three;
    private final Array array;

    private Norm(Two two, Three three, Array array) {
        this.two = two;
        this.three = three;
        this.array = array;
    }

    private Norm(Norm alias) {
        this.two = alias.two;
        this.three = alias.three;
        this.array = alias.array;
    }

    public final double of(double x, double y) {
        return this.two.of(x, y);
    }

    public final double of(double x, double y, double z) {
        return this.three.of(x, y, z);
    }

    public final double of(double[] v) {
        Norm.ensureNonEmpty(v);
        return this.array.of(v);
    }

    private static double manhattan(double x, double y) {
        return Math.abs(x) + Math.abs(y);
    }

    private static double manhattan(double x, double y, double z) {
        return Sum.of(Math.abs(x)).add(Math.abs(y)).add(Math.abs(z)).getAsDouble();
    }

    private static double manhattan(double[] v) {
        Sum sum = Sum.create();
        for (double d : v) {
            sum.add(Math.abs(d));
        }
        return sum.getAsDouble();
    }

    private static double euclidean(double x, double y) {
        double rescale;
        double scale;
        double min;
        double max;
        double yabs;
        double xabs = Math.abs(x);
        if (Double.compare(xabs, yabs = Math.abs(y)) > 0) {
            max = xabs;
            min = yabs;
        } else {
            max = yabs;
            min = xabs;
        }
        if (!Double.isFinite(max)) {
            return xabs * yabs;
        }
        if (Math.getExponent(max) - Math.getExponent(min) > 54) {
            return max;
        }
        if (max > 2.0458691299350887E149) {
            scale = 2.409919865102884E-181;
            rescale = 4.149515568880993E180;
        } else if (max < 7.888609052210118E-31) {
            scale = 4.149515568880993E180;
            rescale = 2.409919865102884E-181;
        } else {
            scale = 1.0;
            rescale = 1.0;
        }
        double sx = xabs * scale;
        double sum = sx * sx;
        double comp = DD.twoSquareLow(sx, sum);
        double sy = yabs * scale;
        double py = sy * sy;
        comp += DD.twoSquareLow(sy, py);
        double sumPy = sum + py;
        comp += DD.twoSumLow(sum, py, sumPy);
        sum = sumPy;
        return Math.sqrt(sum + comp) * rescale;
    }

    private static double euclidean(double x, double y, double z) {
        double rescale;
        double scale;
        double xabs = Math.abs(x);
        double yabs = Math.abs(y);
        double zabs = Math.abs(z);
        double max = Math.max(Math.max(xabs, yabs), zabs);
        if (!Double.isFinite(max)) {
            return xabs * yabs * zabs;
        }
        if (max > 2.0458691299350887E149) {
            scale = 2.409919865102884E-181;
            rescale = 4.149515568880993E180;
        } else if (max < 7.888609052210118E-31) {
            scale = 4.149515568880993E180;
            rescale = 2.409919865102884E-181;
        } else {
            scale = 1.0;
            rescale = 1.0;
        }
        double sx = xabs * scale;
        double sum = sx * sx;
        double comp = DD.twoSquareLow(sx, sum);
        double sy = yabs * scale;
        double py = sy * sy;
        comp += DD.twoSquareLow(sy, py);
        double sumPy = sum + py;
        comp += DD.twoSumLow(sum, py, sumPy);
        sum = sumPy;
        double sz = zabs * scale;
        double pz = sz * sz;
        comp += DD.twoSquareLow(sz, pz);
        double sumPz = sum + pz;
        comp += DD.twoSumLow(sum, pz, sumPz);
        sum = sumPz;
        return Math.sqrt(sum + comp) * rescale;
    }

    private static double euclidean(double[] v) {
        double s1 = 0.0;
        double s2 = 0.0;
        double s3 = 0.0;
        double c1 = 0.0;
        double c2 = 0.0;
        double c3 = 0.0;
        for (int i = 0; i < v.length; ++i) {
            double cs;
            double s;
            double cp;
            double p;
            double sx;
            double x = Math.abs(v[i]);
            if (!Double.isFinite(x)) {
                return Norm.euclideanNormSpecial(v, i);
            }
            if (x > 2.0458691299350887E149) {
                sx = x * 2.409919865102884E-181;
                p = sx * sx;
                cp = DD.twoSquareLow(sx, p);
                s = s1 + p;
                cs = DD.twoSumLow(s1, p, s);
                c1 += cp + cs;
                s1 = s;
                continue;
            }
            if (x < 1.4916681462400413E-154) {
                sx = x * 4.149515568880993E180;
                p = sx * sx;
                cp = DD.twoSquareLow(sx, p);
                s = s3 + p;
                cs = DD.twoSumLow(s3, p, s);
                c3 += cp + cs;
                s3 = s;
                continue;
            }
            double p2 = x * x;
            double cp2 = DD.twoSquareLow(x, p2);
            double s4 = s2 + p2;
            double cs2 = DD.twoSumLow(s2, p2, s4);
            c2 += cp2 + cs2;
            s2 = s4;
        }
        if (s1 != 0.0) {
            double s2Adj = s2 * 2.409919865102884E-181 * 2.409919865102884E-181;
            double sum = s1 + s2Adj;
            double comp = DD.twoSumLow(s1, s2Adj, sum) + c1 + c2 * 2.409919865102884E-181 * 2.409919865102884E-181;
            return Math.sqrt(sum + comp) * 4.149515568880993E180;
        }
        if (s2 != 0.0) {
            double s3Adj = s3 * 2.409919865102884E-181 * 2.409919865102884E-181;
            double sum = s2 + s3Adj;
            double comp = DD.twoSumLow(s2, s3Adj, sum) + c2 + c3 * 2.409919865102884E-181 * 2.409919865102884E-181;
            return Math.sqrt(sum + comp);
        }
        return Math.sqrt(s3 + c3) * 2.409919865102884E-181;
    }

    private static double euclideanNormSpecial(double[] v, int start) {
        for (int i = start; i < v.length; ++i) {
            if (!Double.isNaN(v[i])) continue;
            return Double.NaN;
        }
        return Double.POSITIVE_INFINITY;
    }

    private static double maximum(double x, double y) {
        return Math.max(Math.abs(x), Math.abs(y));
    }

    private static double maximum(double x, double y, double z) {
        return Math.max(Math.abs(x), Math.max(Math.abs(y), Math.abs(z)));
    }

    private static double maximum(double[] v) {
        double max = 0.0;
        for (double d : v) {
            max = Math.max(max, Math.abs(d));
        }
        return max;
    }

    private static void ensureNonEmpty(double[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
    }

    @FunctionalInterface
    private static interface Array {
        public double of(double[] var1);
    }

    @FunctionalInterface
    private static interface Three {
        public double of(double var1, double var3, double var5);
    }

    @FunctionalInterface
    private static interface Two {
        public double of(double var1, double var3);
    }
}

