/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import java.util.Objects;
import org.apache.commons.numbers.arrays.Selection;
import org.apache.commons.statistics.descriptive.Interpolation;
import org.apache.commons.statistics.descriptive.NaNPolicy;
import org.apache.commons.statistics.descriptive.NaNTransformer;
import org.apache.commons.statistics.descriptive.NaNTransformers;
import org.apache.commons.statistics.descriptive.Statistics;

public final class Median {
    private static final Median DEFAULT = new Median(false, NaNPolicy.INCLUDE);
    private final boolean copy;
    private final NaNPolicy nanPolicy;
    private final NaNTransformer nanTransformer;

    private Median(boolean copy, NaNPolicy nanPolicy) {
        this.copy = copy;
        this.nanPolicy = nanPolicy;
        this.nanTransformer = NaNTransformers.createNaNTransformer(nanPolicy, copy);
    }

    public static Median withDefaults() {
        return DEFAULT;
    }

    public Median withCopy(boolean v) {
        return new Median(v, this.nanPolicy);
    }

    public Median with(NaNPolicy v) {
        return new Median(this.copy, Objects.requireNonNull(v));
    }

    public double evaluate(double[] values) {
        return this.compute(values, 0, values.length);
    }

    public double evaluateRange(double[] values, int from, int to) {
        Statistics.checkFromToIndex(from, to, values.length);
        return this.compute(values, from, to);
    }

    private double compute(double[] values, int from, int to) {
        int[] bounds = new int[2];
        double[] x = this.nanTransformer.apply(values, from, to, bounds);
        int end = bounds[1];
        int start = bounds[0];
        int n = end - start;
        if (n <= 2) {
            switch (n) {
                case 2: {
                    if (Double.compare(x[start + 1], x[start]) < 0) {
                        double t = x[start];
                        x[start] = x[start + 1];
                        x[start + 1] = t;
                    }
                    return Interpolation.mean(x[start], x[start + 1]);
                }
                case 1: {
                    return x[start];
                }
            }
            return Double.NaN;
        }
        int m = start + end >>> 1;
        if ((n & 1) == 1) {
            Selection.select((double[])x, (int)start, (int)end, (int)m);
            return x[m];
        }
        Selection.select((double[])x, (int)start, (int)end, (int[])new int[]{m - 1, m});
        return Interpolation.mean(x[m - 1], x[m]);
    }

    public double evaluate(int[] values) {
        return this.compute(values, 0, values.length);
    }

    public double evaluateRange(int[] values, int from, int to) {
        Statistics.checkFromToIndex(from, to, values.length);
        return this.compute(values, from, to);
    }

    private double compute(int[] values, int from, int to) {
        int end;
        int start;
        int[] x;
        if (this.copy) {
            x = Statistics.copy(values, from, to);
            start = 0;
            end = x.length;
        } else {
            x = values;
            start = from;
            end = to;
        }
        int n = end - start;
        if (n <= 2) {
            switch (n) {
                case 2: {
                    if (x[start + 1] < x[start]) {
                        int t = x[start];
                        x[start] = x[start + 1];
                        x[start + 1] = t;
                    }
                    return Interpolation.mean(x[start], x[start + 1]);
                }
                case 1: {
                    return x[start];
                }
            }
            return Double.NaN;
        }
        int m = start + end >>> 1;
        if ((n & 1) == 1) {
            Selection.select((int[])x, (int)start, (int)end, (int)m);
            return x[m];
        }
        Selection.select((int[])x, (int)start, (int)end, (int[])new int[]{m - 1, m});
        return Interpolation.mean(x[m - 1], x[m]);
    }
}

