/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing.targets;

import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.server.routing.targets.AbstractTarget;

public class LocalTarget
extends AbstractTarget {
    private final ActiveMQServer server;
    private final ManagementService managementService;

    public LocalTarget(TransportConfiguration connector, ActiveMQServer server) {
        super(connector, null);
        this.server = server;
        this.managementService = server.getManagementService();
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public void connect() throws Exception {
        if (this.getNodeID() == null) {
            this.setNodeID(this.server.getNodeID().toString());
        }
    }

    @Override
    public void disconnect() throws Exception {
    }

    @Override
    public boolean checkReadiness() {
        return true;
    }

    @Override
    public <T> T getAttribute(String resourceName, String attributeName, Class<T> attributeClass, int timeout) throws Exception {
        return (T)this.managementService.getAttribute(resourceName, attributeName);
    }

    @Override
    public <T> T invokeOperation(String resourceName, String operationName, Object[] operationParams, Class<T> operationClass, int timeout) throws Exception {
        return (T)this.managementService.invokeOperation(resourceName, operationName, operationParams);
    }
}

