/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.plugin;

import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.RoutingStatus;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.transaction.Transaction;

public interface ActiveMQServerMessagePlugin
extends ActiveMQServerBasePlugin {
    default public void beforeSend(ServerSession session, Transaction tx, Message message, boolean direct, boolean noAutoCreateQueue) throws ActiveMQException {
        this.beforeSend(tx, message, direct, noAutoCreateQueue);
    }

    default public void afterSend(ServerSession session, Transaction tx, Message message, boolean direct, boolean noAutoCreateQueue, RoutingStatus result) throws ActiveMQException {
        this.afterSend(tx, message, direct, noAutoCreateQueue, result);
    }

    default public void onSendException(ServerSession session, Transaction tx, Message message, boolean direct, boolean noAutoCreateQueue, Exception e) throws ActiveMQException {
    }

    @Deprecated
    default public void beforeSend(Transaction tx, Message message, boolean direct, boolean noAutoCreateQueue) throws ActiveMQException {
    }

    @Deprecated
    default public void afterSend(Transaction tx, Message message, boolean direct, boolean noAutoCreateQueue, RoutingStatus result) throws ActiveMQException {
    }

    default public void beforeMessageRoute(Message message, RoutingContext context, boolean direct, boolean rejectDuplicates) throws ActiveMQException {
    }

    default public void afterMessageRoute(Message message, RoutingContext context, boolean direct, boolean rejectDuplicates, RoutingStatus result) throws ActiveMQException {
    }

    default public void onMessageRouteException(Message message, RoutingContext context, boolean direct, boolean rejectDuplicates, Exception e) throws ActiveMQException {
    }

    default public boolean canAccept(ServerConsumer consumer, MessageReference reference) throws ActiveMQException {
        return true;
    }

    default public void beforeDeliver(ServerConsumer consumer, MessageReference reference) throws ActiveMQException {
        this.beforeDeliver(reference);
    }

    default public void afterDeliver(ServerConsumer consumer, MessageReference reference) throws ActiveMQException {
        this.afterDeliver(reference);
    }

    @Deprecated
    default public void beforeDeliver(MessageReference reference) throws ActiveMQException {
    }

    @Deprecated
    default public void afterDeliver(MessageReference reference) throws ActiveMQException {
    }

    @Deprecated
    default public void messageExpired(MessageReference message, SimpleString messageExpiryAddress) throws ActiveMQException {
    }

    default public void messageExpired(MessageReference message, SimpleString messageExpiryAddress, ServerConsumer consumer) throws ActiveMQException {
        this.messageExpired(message, messageExpiryAddress);
    }

    @Deprecated
    default public void messageAcknowledged(MessageReference ref, AckReason reason) throws ActiveMQException {
    }

    @Deprecated
    default public void messageAcknowledged(MessageReference ref, AckReason reason, ServerConsumer consumer) throws ActiveMQException {
        this.messageAcknowledged(ref, reason);
    }

    default public void messageAcknowledged(Transaction tx, MessageReference ref, AckReason reason, ServerConsumer consumer) throws ActiveMQException {
        this.messageAcknowledged(ref, reason, consumer);
    }
}

