/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket.jetty;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ReadListener;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.transport.websocket.InvalidPathException;
import org.apache.cxf.transport.websocket.WebSocketUtils;
import org.apache.cxf.transport.websocket.jetty.WebSocketServletHolder;
import org.eclipse.jetty.websocket.api.Session;

public class WebSocketVirtualServletRequest
implements HttpServletRequest {
    private static final Logger LOG = LogUtils.getL7dLogger(WebSocketVirtualServletRequest.class);
    private WebSocketServletHolder webSocketHolder;
    private InputStream in;
    private Map<String, String> requestHeaders;
    private Map<String, Object> attributes;

    public WebSocketVirtualServletRequest(WebSocketServletHolder websocket, InputStream in, Session session) throws IOException {
        String origin;
        this.webSocketHolder = websocket;
        this.in = in;
        Map ugHeaders = session.getUpgradeRequest().getHeaders();
        this.requestHeaders = WebSocketUtils.readHeaders(in);
        for (Map.Entry ent : ugHeaders.entrySet()) {
            if (this.requestHeaders.containsKey(ent.getKey())) continue;
            this.requestHeaders.put((String)ent.getKey(), (String)((List)ent.getValue()).get(0));
        }
        String path = this.requestHeaders.get("$uri");
        if (!path.startsWith(origin = websocket.getRequestURI())) {
            LOG.log(Level.WARNING, "invalid path: {0} not within {1}", new Object[]{path, origin});
            throw new InvalidPathException();
        }
        this.attributes = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        Object v = websocket.getAttribute("org.apache.cxf.transport.endpoint.address");
        if (v != null) {
            this.attributes.put("org.apache.cxf.transport.endpoint.address", v);
        }
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public Object getAttribute(String name) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "getAttribute({0}) -> {1}", new Object[]{name, this.attributes.get(name)});
        }
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        LOG.log(Level.FINE, "getAttributeNames()");
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        LOG.log(Level.FINE, "getCharacterEncoding()");
        return null;
    }

    public int getContentLength() {
        LOG.log(Level.FINE, "getContentLength()");
        return -1;
    }

    public String getContentType() {
        LOG.log(Level.FINE, "getContentType()");
        return this.requestHeaders.get("Content-Type");
    }

    public DispatcherType getDispatcherType() {
        LOG.log(Level.FINE, "getDispatcherType()");
        return this.webSocketHolder.getDispatcherType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return new ServletInputStream(){

            public int read() throws IOException {
                return WebSocketVirtualServletRequest.this.in.read();
            }

            public int read(byte[] b, int off, int len) throws IOException {
                return WebSocketVirtualServletRequest.this.in.read(b, off, len);
            }

            public boolean isFinished() {
                throw new UnsupportedOperationException();
            }

            public boolean isReady() {
                throw new UnsupportedOperationException();
            }

            public void setReadListener(ReadListener arg0) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String getLocalAddr() {
        LOG.log(Level.FINE, "getLocalAddr()");
        return this.webSocketHolder.getLocalAddr();
    }

    public String getLocalName() {
        LOG.log(Level.FINE, "getLocalName()");
        return this.webSocketHolder.getLocalName();
    }

    public int getLocalPort() {
        LOG.log(Level.FINE, "getLocalPort()");
        return this.webSocketHolder.getLocalPort();
    }

    public Locale getLocale() {
        LOG.log(Level.FINE, "getLocale()");
        return this.webSocketHolder.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        LOG.log(Level.FINE, "getLocales()");
        return this.webSocketHolder.getLocales();
    }

    public String getParameter(String name) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "getParameter({0})", name);
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        LOG.log(Level.FINE, "getParameterMap()");
        return null;
    }

    public Enumeration<String> getParameterNames() {
        LOG.log(Level.FINE, "getParameterNames()");
        return null;
    }

    public String[] getParameterValues(String name) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "getParameterValues({0})", name);
        }
        return null;
    }

    public String getProtocol() {
        LOG.log(Level.FINE, "getProtocol");
        return this.webSocketHolder.getProtocol();
    }

    public BufferedReader getReader() throws IOException {
        LOG.log(Level.FINE, "getReader");
        return new BufferedReader(new InputStreamReader(this.in, StandardCharsets.UTF_8));
    }

    public String getRealPath(String path) {
        LOG.log(Level.FINE, "getRealPath");
        return null;
    }

    public String getRemoteAddr() {
        LOG.log(Level.FINE, "getRemoteAddr");
        return this.webSocketHolder.getRemoteAddr();
    }

    public String getRemoteHost() {
        LOG.log(Level.FINE, "getRemoteHost");
        return this.webSocketHolder.getRemoteHost();
    }

    public int getRemotePort() {
        LOG.log(Level.FINE, "getRemotePort");
        return this.webSocketHolder.getRemotePort();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        LOG.log(Level.FINE, "getRequestDispatcher");
        return null;
    }

    public String getScheme() {
        LOG.log(Level.FINE, "getScheme");
        return this.webSocketHolder.getScheme();
    }

    public String getServerName() {
        return this.webSocketHolder.getServerName();
    }

    public int getServerPort() {
        LOG.log(Level.FINE, "getServerPort");
        return this.webSocketHolder.getServerPort();
    }

    public ServletContext getServletContext() {
        LOG.log(Level.FINE, "getServletContext");
        return this.webSocketHolder.getServletContext();
    }

    public boolean isAsyncStarted() {
        LOG.log(Level.FINE, "isAsyncStarted");
        return false;
    }

    public boolean isAsyncSupported() {
        LOG.log(Level.FINE, "isAsyncSupported");
        return false;
    }

    public boolean isSecure() {
        LOG.log(Level.FINE, "isSecure");
        return this.webSocketHolder.isSecure();
    }

    public void removeAttribute(String name) {
        LOG.log(Level.FINE, "removeAttribute");
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object o) {
        LOG.log(Level.FINE, "setAttribute");
        this.attributes.put(name, o);
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        LOG.log(Level.FINE, "setCharacterEncoding");
    }

    public AsyncContext startAsync() {
        LOG.log(Level.FINE, "startAsync");
        return null;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) {
        LOG.log(Level.FINE, "startAsync");
        return null;
    }

    public boolean authenticate(HttpServletResponse servletResponse) throws IOException, ServletException {
        LOG.log(Level.FINE, "authenticate");
        return false;
    }

    public String getAuthType() {
        LOG.log(Level.FINE, "getAuthType");
        return this.webSocketHolder.getAuthType();
    }

    public String getContextPath() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "getContextPath -> " + this.webSocketHolder.getContextPath());
        }
        return this.webSocketHolder.getContextPath();
    }

    public Cookie[] getCookies() {
        LOG.log(Level.FINE, "getCookies");
        return null;
    }

    public long getDateHeader(String name) {
        LOG.log(Level.FINE, "getDateHeader");
        return 0L;
    }

    public String getHeader(String name) {
        LOG.log(Level.FINE, "getHeader");
        return this.requestHeaders.get(name);
    }

    public Enumeration<String> getHeaderNames() {
        LOG.log(Level.FINE, "getHeaderNames");
        return Collections.enumeration(this.requestHeaders.keySet());
    }

    public Enumeration<String> getHeaders(String name) {
        LOG.log(Level.FINE, "getHeaders");
        return Collections.enumeration(Arrays.asList(this.requestHeaders.get(name)));
    }

    public int getIntHeader(String name) {
        LOG.log(Level.FINE, "getIntHeader");
        String v = this.requestHeaders.get(name);
        return v == null ? -1 : Integer.parseInt(v);
    }

    public String getMethod() {
        LOG.log(Level.FINE, "getMethod");
        return this.requestHeaders.get("$method");
    }

    public Part getPart(String name) throws IOException, ServletException {
        LOG.log(Level.FINE, "getPart");
        return null;
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        LOG.log(Level.FINE, "getParts");
        return null;
    }

    public String getPathInfo() {
        String uri = this.requestHeaders.get("$uri");
        String servletpath = this.webSocketHolder.getServletPath();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "getPathInfo " + servletpath + " " + uri);
        }
        return uri.substring(servletpath.length());
    }

    public String getPathTranslated() {
        String path = this.getPathInfo();
        String opathtrans = this.webSocketHolder.getPathTranslated();
        if (opathtrans == null) {
            return null;
        }
        String opathinfo = this.webSocketHolder.getPathInfo();
        LOG.log(Level.FINE, "getPathTranslated " + path + " " + opathinfo);
        int pos = opathtrans.indexOf(opathinfo);
        return opathtrans.substring(0, pos) + path;
    }

    public String getQueryString() {
        LOG.log(Level.FINE, "getQueryString");
        return null;
    }

    public String getRemoteUser() {
        LOG.log(Level.FINE, "getRemoteUser");
        return null;
    }

    public String getRequestURI() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "getRequestURI " + this.requestHeaders.get("$uri"));
        }
        return this.requestHeaders.get("$uri");
    }

    public StringBuffer getRequestURL() {
        StringBuffer sb = this.webSocketHolder.getRequestURL();
        String ouri = this.webSocketHolder.getRequestURI();
        String uri = this.getRequestURI();
        sb.append(uri.substring(ouri.length()));
        LOG.log(Level.FINE, "getRequestURL " + uri);
        return sb;
    }

    public String getRequestedSessionId() {
        LOG.log(Level.FINE, "getRequestedSessionId");
        return null;
    }

    public String getServletPath() {
        LOG.log(Level.FINE, "getServletPath " + this.webSocketHolder.getServletPath());
        return this.webSocketHolder.getServletPath();
    }

    public HttpSession getSession() {
        LOG.log(Level.FINE, "getSession");
        return null;
    }

    public HttpSession getSession(boolean create) {
        LOG.log(Level.FINE, "getSession");
        return null;
    }

    public Principal getUserPrincipal() {
        LOG.log(Level.FINE, "getUserPrincipal");
        return this.webSocketHolder.getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        LOG.log(Level.FINE, "isRequestedSessionIdFromCookie");
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        LOG.log(Level.FINE, "isRequestedSessionIdFromURL");
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        LOG.log(Level.FINE, "isRequestedSessionIdFromUrl");
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        LOG.log(Level.FINE, "isRequestedSessionIdValid");
        return false;
    }

    public boolean isUserInRole(String role) {
        LOG.log(Level.FINE, "isUserInRole");
        return false;
    }

    public void login(String username, String password) throws ServletException {
        LOG.log(Level.FINE, "login");
    }

    public void logout() throws ServletException {
        LOG.log(Level.FINE, "logout");
    }

    public long getContentLengthLong() {
        return -1L;
    }

    public String changeSessionId() {
        throw new UnsupportedOperationException();
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> arg0) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }
}

