/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.core.dsom;

import org.apache.daffodil.core.dpath.DFDLPathExpressionParser;
import org.apache.daffodil.core.dsom.SchemaComponent;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.schema.annotation.props.Found;
import org.apache.daffodil.lib.schema.annotation.props.LookupLocation;
import org.apache.daffodil.lib.util.DPathUtil$;
import org.apache.daffodil.lib.xml.NS;
import org.apache.daffodil.lib.xml.NamedQName;
import org.apache.daffodil.runtime1.BasicComponent;
import org.apache.daffodil.runtime1.dpath.NodeInfo;
import org.apache.daffodil.runtime1.dsom.CompiledExpression;
import org.apache.daffodil.runtime1.dsom.ConstantExpression;
import org.apache.daffodil.runtime1.dsom.DPathCompileInfo;
import org.apache.daffodil.runtime1.dsom.ExpressionCompilerBase;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;
import scala.xml.NamespaceBinding;

public class ExpressionCompiler<T>
implements ExpressionCompilerBase<T> {
    @Override
    public CompiledExpression<T> compileExpression(NamedQName qn, NodeInfo.Kind nodeInfoKind, String exprOrLiteral, NamespaceBinding namespaces, NS noPrefixNamespace, DPathCompileInfo compileInfoWhereExpressionWasLocated, boolean isEvaluatedAbove, BasicComponent host, DPathCompileInfo compileInfo) {
        compileInfo.initialize();
        compileInfoWhereExpressionWasLocated.initialize();
        CompiledExpression<T> res = DPathUtil$.MODULE$.isExpression(exprOrLiteral) ? this.compileRealExpression(qn, nodeInfoKind, exprOrLiteral, namespaces, noPrefixNamespace, compileInfoWhereExpressionWasLocated, isEvaluatedAbove, host, compileInfo) : this.convertLiteralToConstant(qn, nodeInfoKind, exprOrLiteral, namespaces, noPrefixNamespace, compileInfoWhereExpressionWasLocated, isEvaluatedAbove);
        return res;
    }

    public CompiledExpression<T> compileProperty(NamedQName qn, NodeInfo.Kind nodeInfoKind, Found property, BasicComponent host, DPathCompileInfo compileInfo, boolean isEvaluatedAbove) {
        return this.compileExpression(qn, nodeInfoKind, property.value(), property.location().namespaces(), property.location().noPrefixNamespace(), compileInfo, isEvaluatedAbove, host, compileInfo);
    }

    public boolean compileProperty$default$6() {
        return false;
    }

    public CompiledExpression<T> compileDelimiter(NamedQName qn, NodeInfo.Kind staticNodeInfoKind, NodeInfo.Kind runtimeNodeInfoKind, Found property, BasicComponent host, DPathCompileInfo compileInfo) {
        DPathCompileInfo compileInfoWhereExpressionWasLocated;
        NamespaceBinding namespacesForNamespaceResolution;
        String exprOrLiteral;
        boolean isEvaluatedAbove;
        block3: {
            CompiledExpression<T> compiled1;
            block2: {
                isEvaluatedAbove = false;
                exprOrLiteral = property.value();
                namespacesForNamespaceResolution = property.location().namespaces();
                compileInfoWhereExpressionWasLocated = this.propertyCompileInfo(property);
                compiled1 = this.compileExpression(qn, staticNodeInfoKind, exprOrLiteral, namespacesForNamespaceResolution, property.location().noPrefixNamespace(), compileInfoWhereExpressionWasLocated, isEvaluatedAbove, host, compileInfo);
                if (compiled1.isConstant()) break block2;
                NodeInfo.Kind kind = staticNodeInfoKind;
                NodeInfo.Kind kind2 = runtimeNodeInfoKind;
                if (kind != null ? !kind.equals(kind2) : kind2 != null) break block3;
            }
            return compiled1;
        }
        CompiledExpression<T> compiled2 = this.compileExpression(qn, runtimeNodeInfoKind, exprOrLiteral, namespacesForNamespaceResolution, property.location().noPrefixNamespace(), compileInfoWhereExpressionWasLocated, isEvaluatedAbove, host, compileInfo);
        return compiled2;
    }

    private DPathCompileInfo propertyCompileInfo(Found property) {
        DPathCompileInfo dPathCompileInfo;
        LookupLocation lookupLocation = property.location();
        if (lookupLocation instanceof SchemaComponent) {
            SchemaComponent sc = (SchemaComponent)lookupLocation;
            dPathCompileInfo = sc.dpathCompileInfo();
        } else if (lookupLocation instanceof DPathCompileInfo) {
            DPathCompileInfo di;
            dPathCompileInfo = di = (DPathCompileInfo)lookupLocation;
        } else {
            throw new MatchError((Object)lookupLocation);
        }
        DPathCompileInfo compileInfoWherePropertyWasLocated = dPathCompileInfo;
        return compileInfoWherePropertyWasLocated;
    }

    private CompiledExpression<T> compileRealExpression(NamedQName qn, NodeInfo.Kind nodeInfoKind, String exprOrLiteral, NamespaceBinding namespaces, NS noPrefixNamespace, DPathCompileInfo compileInfoWhereExpressionWasLocated, boolean isEvaluatedAbove, BasicComponent host, DPathCompileInfo compileInfo) {
        String expr = exprOrLiteral.trim();
        if (!expr.endsWith("}")) {
            String msg = "'%s' is an unterminated expression. Add missing closing brace, or escape opening brace with another opening brace.";
            throw compileInfoWhereExpressionWasLocated.SDE(msg, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{exprOrLiteral}));
        }
        DFDLPathExpressionParser compiler = new DFDLPathExpressionParser(qn, nodeInfoKind, namespaces, noPrefixNamespace, compileInfo, isEvaluatedAbove, host);
        CompiledExpression compiledDPath = compiler.compile(expr);
        return compiledDPath;
    }

    private CompiledExpression<T> convertLiteralToConstant(NamedQName qn, NodeInfo.Kind nodeInfoKind, String exprOrLiteral, NamespaceBinding namespaces, NS noPrefixNamespace, DPathCompileInfo compileInfoWhereExpressionWasLocated, boolean isEvaluatedAbove) {
        NodeInfo.Kind kind = nodeInfoKind;
        if (kind instanceof NodeInfo.AnyAtomicKind) {
            Object object;
            NodeInfo.AnyAtomicKind atomic = (NodeInfo.AnyAtomicKind)kind;
            String literal = exprOrLiteral.startsWith("{{") ? StringOps$.MODULE$.tail$extension(Predef$.MODULE$.augmentString(exprOrLiteral)) : exprOrLiteral;
            try {
                object = atomic.primType().fromXMLString(literal);
            }
            catch (Exception e) {
                String msg = "Unable to convert logical value \"%s\" to %s: %s";
                throw compileInfoWhereExpressionWasLocated.SDE(msg, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{exprOrLiteral, nodeInfoKind, e.getMessage()}));
            }
            Object logical = object;
            return new ConstantExpression<Object>(qn, nodeInfoKind, DataValue$.MODULE$.getAnyRef$extension(logical));
        }
        String msg = "No known primitive type to convert logical value to: %s";
        throw Assert$.MODULE$.invariantFailed(msg + compileInfoWhereExpressionWasLocated.schemaFileLocation().toString());
    }
}

