/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.lib.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.lib.util.Numbers$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public interface Numbers {
    public static boolean isDecimalDouble(BigDecimal bigDecimal) {
        return Numbers$.MODULE$.isDecimalDouble(bigDecimal);
    }

    public static boolean isValidInt(Number number) {
        return Numbers$.MODULE$.isValidInt(number);
    }

    public static boolean isValidLong(Number number) {
        return Numbers$.MODULE$.isValidLong(number);
    }

    public Nothing$ errorThrower(String var1);

    public static Integer asInt$(Numbers $this, Object n) {
        return $this.asInt(n);
    }

    default public Integer asInt(Object n) {
        int n2;
        Object object = n;
        if (object instanceof Float) {
            Float f = (Float)object;
            n2 = (int)Predef$.MODULE$.Float2float(f);
        } else if (object instanceof Double) {
            Double d = (Double)object;
            n2 = (int)Predef$.MODULE$.Double2double(d);
        } else if (object instanceof Byte) {
            Byte b = (Byte)object;
            n2 = Predef$.MODULE$.Byte2byte(b);
        } else if (object instanceof Short) {
            Short s = (Short)object;
            n2 = Predef$.MODULE$.Short2short(s);
        } else {
            if (object instanceof Integer) {
                Integer i = (Integer)object;
                return i;
            }
            if (object instanceof Long) {
                Long l = (Long)object;
                n2 = (int)Predef$.MODULE$.Long2long(l);
            } else if (object instanceof BigInteger) {
                BigInteger bi = (BigInteger)object;
                n2 = bi.intValue();
            } else if (object instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)object;
                n2 = bd.intValue();
            } else {
                throw this.errorThrower(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Unsupported conversion to Int. %s of type %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{n, Misc$.MODULE$.getNameFromClass(n)})));
            }
        }
        int value = n2;
        return value;
    }

    public static Byte asByte$(Numbers $this, Object n) {
        return $this.asByte(n);
    }

    default public Byte asByte(Object n) {
        byte by;
        Object object = n;
        if (object instanceof Float) {
            Float f = (Float)object;
            by = (byte)Predef$.MODULE$.Float2float(f);
        } else if (object instanceof Double) {
            Double d = (Double)object;
            by = (byte)Predef$.MODULE$.Double2double(d);
        } else {
            if (object instanceof Byte) {
                Byte b = (Byte)object;
                return b;
            }
            if (object instanceof Short) {
                Short s = (Short)object;
                by = (byte)Predef$.MODULE$.Short2short(s);
            } else if (object instanceof Integer) {
                Integer i = (Integer)object;
                by = (byte)Predef$.MODULE$.Integer2int(i);
            } else if (object instanceof Long) {
                Long l = (Long)object;
                by = (byte)Predef$.MODULE$.Long2long(l);
            } else if (object instanceof BigInteger) {
                BigInteger bi = (BigInteger)object;
                by = bi.byteValue();
            } else if (object instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)object;
                by = bd.byteValue();
            } else {
                throw this.errorThrower(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Unsupported conversion to Byte. %s of type %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{n, Misc$.MODULE$.getNameFromClass(n)})));
            }
        }
        byte value = by;
        return value;
    }

    public static Short asShort$(Numbers $this, Object n) {
        return $this.asShort(n);
    }

    default public Short asShort(Object n) {
        short s;
        Object object = n;
        if (object instanceof Float) {
            Float f = (Float)object;
            s = (short)Predef$.MODULE$.Float2float(f);
        } else if (object instanceof Double) {
            Double d = (Double)object;
            s = (short)Predef$.MODULE$.Double2double(d);
        } else if (object instanceof Byte) {
            Byte b = (Byte)object;
            s = Predef$.MODULE$.Byte2byte(b);
        } else {
            if (object instanceof Short) {
                Short s2 = (Short)object;
                return s2;
            }
            if (object instanceof Integer) {
                Integer i = (Integer)object;
                s = (short)Predef$.MODULE$.Integer2int(i);
            } else if (object instanceof Long) {
                Long l = (Long)object;
                s = (short)Predef$.MODULE$.Long2long(l);
            } else if (object instanceof BigInteger) {
                BigInteger bi = (BigInteger)object;
                s = bi.shortValue();
            } else if (object instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)object;
                s = bd.shortValue();
            } else {
                throw this.errorThrower(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Unsupported conversion to Short. %s of type %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{n, Misc$.MODULE$.getNameFromClass(n)})));
            }
        }
        short value = s;
        return value;
    }

    public static Long asLong$(Numbers $this, Object n) {
        return $this.asLong(n);
    }

    default public Long asLong(Object n) {
        long l;
        Object object = n;
        if (object instanceof Byte) {
            Byte b = (Byte)object;
            l = Predef$.MODULE$.Byte2byte(b);
        } else if (object instanceof Short) {
            Short s = (Short)object;
            l = Predef$.MODULE$.Short2short(s);
        } else if (object instanceof Integer) {
            Integer i = (Integer)object;
            l = Predef$.MODULE$.Integer2int(i);
        } else if (object instanceof Double) {
            Double d = (Double)object;
            l = (long)Predef$.MODULE$.Double2double(d);
        } else if (object instanceof Float) {
            Float f = (Float)object;
            l = (long)Predef$.MODULE$.Float2float(f);
        } else {
            if (object instanceof Long) {
                Long l2 = (Long)object;
                return l2;
            }
            if (object instanceof BigInteger) {
                BigInteger bi = (BigInteger)object;
                l = bi.longValue();
            } else if (object instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)object;
                l = bd.longValue();
            } else {
                throw this.errorThrower(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Unsupported conversion to Long. %s of type %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{n, Misc$.MODULE$.getNameFromClass(n)})));
            }
        }
        long value = l;
        return value;
    }

    public static BigInteger asBigInt$(Numbers $this, Object n) {
        return $this.asBigInt(n);
    }

    default public BigInteger asBigInt(Object n) {
        BigInteger bigInteger;
        Object object = n;
        if (object instanceof BigInteger) {
            BigInteger b;
            bigInteger = b = (BigInteger)object;
        } else if (object instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)object;
            bigInteger = bd.toBigInteger();
        } else if (object instanceof Double) {
            Double d = (Double)object;
            bigInteger = new BigDecimal(Predef$.MODULE$.Double2double(d)).toBigInteger();
        } else if (object instanceof Float) {
            Float f = (Float)object;
            bigInteger = new BigDecimal(Predef$.MODULE$.Float2float(f)).toBigInteger();
        } else if (object instanceof Number) {
            Number jn = (Number)object;
            bigInteger = new BigInteger(jn.toString());
        } else {
            throw this.errorThrower(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Unsupported conversion to BigInt. %s of type %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{n, Misc$.MODULE$.getNameFromClass(n)})));
        }
        BigInteger value = bigInteger;
        return value;
    }

    public static BigInteger asJBigInt$(Numbers $this, Object n) {
        return $this.asJBigInt(n);
    }

    default public BigInteger asJBigInt(Object n) {
        BigInteger bigInteger;
        Object object = n;
        if (object instanceof BigInteger) {
            BigInteger b;
            bigInteger = b = (BigInteger)object;
        } else if (object instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)object;
            bigInteger = bd.toBigInteger();
        } else if (object instanceof Double) {
            Double d = (Double)object;
            bigInteger = BigDecimal.valueOf(Predef$.MODULE$.Double2double(d)).toBigInteger();
        } else if (object instanceof Float) {
            Float f = (Float)object;
            bigInteger = new BigDecimal(f.toString()).toBigInteger();
        } else if (object instanceof Number) {
            Number jn = (Number)object;
            bigInteger = BigInteger.valueOf(jn.longValue());
        } else {
            throw this.errorThrower(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Unsupported conversion to BigInt. %s of type %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{n, Misc$.MODULE$.getNameFromClass(n)})));
        }
        BigInteger value = bigInteger;
        return value;
    }

    public static Float asFloat$(Numbers $this, Object n) {
        return $this.asFloat(n);
    }

    default public Float asFloat(Object n) {
        float f;
        Object object = n;
        if (object instanceof Float) {
            Float f2 = (Float)object;
            return f2;
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            f = (float)Predef$.MODULE$.Double2double(d);
        } else if (object instanceof Byte) {
            Byte b = (Byte)object;
            f = Predef$.MODULE$.Byte2byte(b);
        } else if (object instanceof Short) {
            Short s = (Short)object;
            f = Predef$.MODULE$.Short2short(s);
        } else if (object instanceof Integer) {
            Integer i = (Integer)object;
            f = Predef$.MODULE$.Integer2int(i);
        } else if (object instanceof Long) {
            Long l = (Long)object;
            f = Predef$.MODULE$.Long2long(l);
        } else if (object instanceof BigInteger) {
            BigInteger bi = (BigInteger)object;
            f = bi.floatValue();
        } else if (object instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)object;
            f = bd.floatValue();
        } else {
            throw this.errorThrower(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Unsupported conversion to Float. %s of type %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{n, Misc$.MODULE$.getNameFromClass(n)})));
        }
        float value = f;
        return Float.valueOf(value);
    }

    public static Double asDouble$(Numbers $this, Object n) {
        return $this.asDouble(n);
    }

    default public Double asDouble(Object n) {
        double d;
        Object object = n;
        if (object instanceof Float) {
            Float f = (Float)object;
            d = Predef$.MODULE$.Float2float(f);
        } else {
            if (object instanceof Double) {
                Double d2 = (Double)object;
                return d2;
            }
            if (object instanceof Byte) {
                Byte b = (Byte)object;
                d = Predef$.MODULE$.Byte2byte(b);
            } else if (object instanceof Short) {
                Short s = (Short)object;
                d = Predef$.MODULE$.Short2short(s);
            } else if (object instanceof Integer) {
                Integer i = (Integer)object;
                d = Predef$.MODULE$.Integer2int(i);
            } else if (object instanceof Long) {
                Long l = (Long)object;
                d = Predef$.MODULE$.Long2long(l);
            } else if (object instanceof BigInteger) {
                BigInteger bi = (BigInteger)object;
                d = bi.doubleValue();
            } else if (object instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)object;
                d = bd.doubleValue();
            } else {
                throw this.errorThrower(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Unsupported conversion to Double. %s of type %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{n, Misc$.MODULE$.getNameFromClass(n)})));
            }
        }
        double value = d;
        return value;
    }

    public static BigDecimal asBigDecimal$(Numbers $this, Object n) {
        return $this.asBigDecimal(n);
    }

    default public BigDecimal asBigDecimal(Object n) {
        BigDecimal bigDecimal;
        Object object = n;
        if (object instanceof Float) {
            Float f = (Float)object;
            bigDecimal = new BigDecimal(f.toString());
        } else if (object instanceof Double) {
            Double d = (Double)object;
            bigDecimal = BigDecimal.valueOf(Predef$.MODULE$.Double2double(d));
        } else if (object instanceof BigInteger) {
            BigInteger bi = (BigInteger)object;
            bigDecimal = new BigDecimal(bi.toString());
        } else if (object instanceof BigDecimal) {
            BigDecimal bd;
            bigDecimal = bd = (BigDecimal)object;
        } else if (object instanceof Long) {
            Long jl = (Long)object;
            bigDecimal = BigDecimal.valueOf(Predef$.MODULE$.Long2long(jl));
        } else if (object instanceof Integer) {
            Integer i = (Integer)object;
            bigDecimal = BigDecimal.valueOf(Predef$.MODULE$.Integer2int(i));
        } else if (object instanceof Short) {
            Short s = (Short)object;
            bigDecimal = BigDecimal.valueOf(Predef$.MODULE$.Short2short(s));
        } else if (object instanceof Byte) {
            Byte b = (Byte)object;
            bigDecimal = BigDecimal.valueOf(Predef$.MODULE$.Byte2byte(b));
        } else if (object instanceof Number) {
            Number jn = (Number)object;
            bigDecimal = new BigDecimal(jn.toString());
        } else {
            throw this.errorThrower(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Unsupported conversion to BigDecimal. %s of type %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{n, Misc$.MODULE$.getNameFromClass(n)})));
        }
        BigDecimal value = bigDecimal;
        return value;
    }

    public static BigDecimal asJBigDecimal$(Numbers $this, Object n) {
        return $this.asJBigDecimal(n);
    }

    default public BigDecimal asJBigDecimal(Object n) {
        BigDecimal bigDecimal;
        Object object = n;
        if (object instanceof Float) {
            Float f = (Float)object;
            bigDecimal = new BigDecimal(f.toString());
        } else if (object instanceof Double) {
            Double d = (Double)object;
            bigDecimal = BigDecimal.valueOf(Predef$.MODULE$.Double2double(d));
        } else if (object instanceof BigInteger) {
            BigInteger bi = (BigInteger)object;
            bigDecimal = new BigDecimal(bi);
        } else if (object instanceof BigDecimal) {
            BigDecimal bd;
            bigDecimal = bd = (BigDecimal)object;
        } else if (object instanceof Number) {
            Number jn = (Number)object;
            bigDecimal = BigDecimal.valueOf(jn.longValue());
        } else {
            throw this.errorThrower(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Unsupported conversion to BigDecimal. %s of type %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{n, Misc$.MODULE$.getNameFromClass(n)})));
        }
        BigDecimal value = bigDecimal;
        return value;
    }

    public static Boolean asBoolean$(Numbers $this, Object n) {
        return $this.asBoolean(n);
    }

    default public Boolean asBoolean(Object n) {
        Object object = n;
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return bool;
        }
        if (object instanceof Boolean) {
            boolean b = BoxesRunTime.unboxToBoolean((Object)object);
            return b;
        }
        throw this.errorThrower(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Unsupported conversion to Boolean. %s of type %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{n, Misc$.MODULE$.getNameFromClass(n)})));
    }

    public static Number asNumber$(Numbers $this, Object n) {
        return $this.asNumber(n);
    }

    default public Number asNumber(Object n) {
        Object object = n;
        if (object instanceof Byte) {
            byte b = BoxesRunTime.unboxToByte((Object)object);
            return b;
        }
        if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            return s;
        }
        if (object instanceof Integer) {
            int i = BoxesRunTime.unboxToInt((Object)object);
            return i;
        }
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            return l;
        }
        if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            return Float.valueOf(f);
        }
        if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            return d;
        }
        if (object instanceof Number) {
            Number jn = (Number)object;
            return jn;
        }
        throw this.errorThrower(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Unsupported conversion to Number. %s of type %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{n, Misc$.MODULE$.getNameFromClass(n)})));
    }

    public static Object asAnyRef$(Numbers $this, Object n) {
        return $this.asAnyRef(n);
    }

    default public Object asAnyRef(Object n) {
        return n;
    }

    public static boolean isZero$(Numbers $this, Number n1) {
        return $this.isZero(n1);
    }

    default public boolean isZero(Number n1) {
        Number number = n1;
        if (number instanceof Double) {
            Double d = (Double)number;
            return d == 0.0;
        }
        if (number instanceof Float) {
            Float f = (Float)number;
            return (double)f.floatValue() == 0.0;
        }
        if (number instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)number;
            return bd.signum() == 0;
        }
        if (number instanceof BigInteger) {
            BigInteger bi = (BigInteger)number;
            return bi.signum() == 0;
        }
        if (number instanceof Long) {
            Long l = (Long)number;
            return l == 0L;
        }
        if (number instanceof Integer) {
            Integer i = (Integer)number;
            return i == 0;
        }
        if (number instanceof Short) {
            Short s = (Short)number;
            return s == 0;
        }
        if (number instanceof Byte) {
            Byte b = (Byte)number;
            return b == 0;
        }
        throw this.errorThrower("Unknown JNumber type: " + n1.getClass().getName());
    }
}

