/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.kll;

import java.util.List;
import org.apache.datasketches.hive.kll.GetQuantilesUDF;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetQuantilesUDFTest {
    @Test
    public void nullSketch() {
        List result = new GetQuantilesUDF().evaluate(null, new Double[]{0.0});
        Assert.assertNull((Object)result);
    }

    @Test
    public void emptyListOfFractions() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        sketch.update(1.0f);
        sketch.update(2.0f);
        sketch.update(3.0f);
        List result = new GetQuantilesUDF().evaluate(new BytesWritable(sketch.toByteArray()), new Double[0]);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)0);
    }

    @Test
    public void fractionsNormalCase() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        sketch.update(1.0f);
        sketch.update(2.0f);
        sketch.update(3.0f);
        sketch.update(4.0f);
        List result = new GetQuantilesUDF().evaluate(new BytesWritable(sketch.toByteArray()), new Double[]{0.0, 0.5, 1.0});
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)3);
        Assert.assertEquals((double)((Float)result.get(0)).floatValue(), (double)1.0);
        Assert.assertEquals((double)((Float)result.get(1)).floatValue(), (double)2.0);
        Assert.assertEquals((double)((Float)result.get(2)).floatValue(), (double)4.0);
        result = new GetQuantilesUDF().evaluate(new BytesWritable(sketch.toByteArray()), Boolean.valueOf(false), new Double[]{0.0, 0.5, 1.0});
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)3);
        Assert.assertEquals((double)((Float)result.get(0)).floatValue(), (double)1.0);
        Assert.assertEquals((double)((Float)result.get(1)).floatValue(), (double)3.0);
        Assert.assertEquals((double)((Float)result.get(2)).floatValue(), (double)4.0);
    }
}

