/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.kll;

import org.apache.datasketches.hive.kll.GetRankUDF;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetRankUDFTest {
    @Test
    public void nullSketch() {
        Double result = new GetRankUDF().evaluate(null, 0.0f);
        Assert.assertNull((Object)result);
    }

    @Test
    public void normalCase() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        sketch.update(1.0f);
        sketch.update(2.0f);
        sketch.update(3.0f);
        sketch.update(4.0f);
        Double result = new GetRankUDF().evaluate(new BytesWritable(sketch.toByteArray()), 3.0f);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)result, (double)0.75);
        result = new GetRankUDF().evaluate(new BytesWritable(sketch.toByteArray()), Boolean.valueOf(false), 3.0f);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)result, (double)0.5);
    }
}

