/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.quantiles;

import org.apache.datasketches.hive.quantiles.GetQuantileFromDoublesSketchUDF;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetQuantileFromDoublesSektchUDFTest {
    @Test
    public void nullSketch() {
        Double result = new GetQuantileFromDoublesSketchUDF().evaluate(null, 0.0);
        Assert.assertNull((Object)result);
    }

    @Test
    public void normalCase() {
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        sketch.update(1.0);
        sketch.update(2.0);
        sketch.update(3.0);
        sketch.update(4.0);
        Double result = new GetQuantileFromDoublesSketchUDF().evaluate(new BytesWritable(sketch.toByteArray()), 0.5);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)result, (double)2.0);
        result = new GetQuantileFromDoublesSketchUDF().evaluate(new BytesWritable(sketch.toByteArray()), Boolean.valueOf(false), 0.5);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)result, (double)3.0);
    }
}

