/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import org.apache.datasketches.hive.tuple.DoubleSummarySketchToPercentileUDF;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.UpdatableSketch;
import org.apache.datasketches.tuple.UpdatableSketchBuilder;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryFactory;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DoubleSummarySketchToPercentileUDFTest {
    @Test
    public void nullSketch() {
        Double result = new DoubleSummarySketchToPercentileUDF().evaluate(null, 0.0);
        Assert.assertNull((Object)result);
    }

    @Test
    public void emptySketch() {
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
        Double result = new DoubleSummarySketchToPercentileUDF().evaluate(new BytesWritable(sketch.compact().toByteArray()), 0.0);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)result, (double)Double.NaN);
    }

    @Test
    public void normalCase() {
        int i;
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
        int iterations = 100000;
        for (i = 0; i < iterations; ++i) {
            sketch.update((long)i, (Object)i);
        }
        for (i = 0; i < iterations; ++i) {
            sketch.update((long)i, (Object)i);
        }
        Double result = new DoubleSummarySketchToPercentileUDF().evaluate(new BytesWritable(sketch.compact().toByteArray()), 50.0);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)result, (double)iterations, (double)((double)iterations * 0.02));
    }
}

