/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import java.util.Arrays;
import java.util.List;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.tuple.ArrayOfDoublesState;
import org.apache.datasketches.hive.tuple.DataToArrayOfDoublesSketchUDAFTest;
import org.apache.datasketches.hive.tuple.UnionArrayOfDoublesSketchUDAF;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketches;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UnionArrayOfDoublesSketchUDAFTest {
    private static final ObjectInspector intInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT);
    private static final ObjectInspector floatInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.FLOAT);
    private static final ObjectInspector binaryInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    private static final ObjectInspector structInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("nominalEntries", "numValues", "sketch"), Arrays.asList(intInspector, intInspector, binaryInspector));

    @Test(expectedExceptions={UDFArgumentException.class})
    public void tooFewArguments() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void tooManyArguments() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, intInspector, intInspector, intInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void invalidCategoryArg1() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{structInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void invalidTypeArg1() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void invalidCategoryArg2() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, structInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void invalidTypeArg2() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, floatInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void invalidCategorysArg3() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, intInspector, structInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void invalidTypeArg3() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, intInspector, floatInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test
    public void partial1ModeDefaultParams() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL1, inspectors);
            DataToArrayOfDoublesSketchUDAFTest.checkIntermediateResultInspector(resultInspector);
            ArrayOfDoublesState state = (ArrayOfDoublesState)eval.getNewAggregationBuffer();
            ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
            sketch1.update(1L, new double[]{1.0});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch1.compact().toByteArray())});
            ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
            sketch2.update(2L, new double[]{1.0});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch2.compact().toByteArray())});
            Object result = eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof List));
            List r = (List)result;
            Assert.assertEquals((int)r.size(), (int)3);
            Assert.assertEquals((int)((IntWritable)r.get(0)).get(), (int)4096);
            Assert.assertEquals((int)((IntWritable)r.get(1)).get(), (int)1);
            ArrayOfDoublesSketch resultSketch = ArrayOfDoublesSketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)r.get(2))));
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
        }
    }

    @Test
    public void partial1ModeExplicitParams() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, intInspector, intInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL1, inspectors);
            DataToArrayOfDoublesSketchUDAFTest.checkIntermediateResultInspector(resultInspector);
            int nomNumEntries = 16;
            int numValues = 2;
            ArrayOfDoublesState state = (ArrayOfDoublesState)eval.getNewAggregationBuffer();
            ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(16).setNumberOfValues(2).build();
            sketch1.update(1L, new double[]{1.0, 2.0});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch1.compact().toByteArray()), new IntWritable(16), new IntWritable(2)});
            ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(16).setNumberOfValues(2).build();
            sketch2.update(2L, new double[]{1.0, 2.0});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch2.compact().toByteArray()), new IntWritable(16), new IntWritable(2)});
            Object result = eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof List));
            List r = (List)result;
            Assert.assertEquals((int)r.size(), (int)3);
            Assert.assertEquals((int)((IntWritable)r.get(0)).get(), (int)16);
            Assert.assertEquals((int)((IntWritable)r.get(1)).get(), (int)2);
            ArrayOfDoublesSketch resultSketch = ArrayOfDoublesSketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)r.get(2))));
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
        }
    }

    @Test
    public void partial2Mode() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL2, new ObjectInspector[]{structInspector});
            DataToArrayOfDoublesSketchUDAFTest.checkIntermediateResultInspector(resultInspector);
            ArrayOfDoublesState state = (ArrayOfDoublesState)eval.getNewAggregationBuffer();
            ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
            sketch1.update(1L, new double[]{1.0});
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(4096), new IntWritable(1), new BytesWritable(sketch1.compact().toByteArray())));
            ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
            sketch2.update(2L, new double[]{1.0});
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(4096), new IntWritable(1), new BytesWritable(sketch2.compact().toByteArray())));
            Object result = eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof List));
            List r = (List)result;
            Assert.assertEquals((int)r.size(), (int)3);
            Assert.assertEquals((int)((IntWritable)r.get(0)).get(), (int)4096);
            Assert.assertEquals((int)((IntWritable)r.get(1)).get(), (int)1);
            ArrayOfDoublesSketch resultSketch = ArrayOfDoublesSketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)r.get(2))));
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
            eval.reset((GenericUDAFEvaluator.AggregationBuffer)state);
            result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNull((Object)result);
        }
    }

    @Test
    public void finalMode() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.FINAL, new ObjectInspector[]{structInspector});
            DataToArrayOfDoublesSketchUDAFTest.checkFinalResultInspector(resultInspector);
            ArrayOfDoublesState state = (ArrayOfDoublesState)eval.getNewAggregationBuffer();
            ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
            sketch1.update(1L, new double[]{1.0});
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(4096), new IntWritable(1), new BytesWritable(sketch1.compact().toByteArray())));
            ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
            sketch2.update(2L, new double[]{1.0});
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(4096), new IntWritable(1), new BytesWritable(sketch2.compact().toByteArray())));
            Object result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof BytesWritable));
            ArrayOfDoublesSketch resultSketch = ArrayOfDoublesSketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)result)));
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
        }
    }

    @Test
    public void completeModeDefaultParams() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.COMPLETE, inspectors);
            DataToArrayOfDoublesSketchUDAFTest.checkFinalResultInspector(resultInspector);
            ArrayOfDoublesState state = (ArrayOfDoublesState)eval.getNewAggregationBuffer();
            ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
            sketch1.update(1L, new double[]{1.0});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch1.compact().toByteArray())});
            ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
            sketch2.update(2L, new double[]{1.0});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch2.compact().toByteArray())});
            Object result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof BytesWritable));
            ArrayOfDoublesSketch resultSketch = ArrayOfDoublesSketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)result)));
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
            eval.reset((GenericUDAFEvaluator.AggregationBuffer)state);
            result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNull((Object)result);
        }
    }

    @Test
    public void completeModeExplicitParams() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, intInspector, intInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionArrayOfDoublesSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.COMPLETE, inspectors);
            DataToArrayOfDoublesSketchUDAFTest.checkFinalResultInspector(resultInspector);
            int nomNumEntries = 16;
            int numValues = 2;
            ArrayOfDoublesState state = (ArrayOfDoublesState)eval.getNewAggregationBuffer();
            ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(16).setNumberOfValues(2).build();
            sketch1.update(1L, new double[]{1.0, 2.0});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch1.compact().toByteArray()), new IntWritable(16), new IntWritable(2)});
            ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(16).setNumberOfValues(2).build();
            sketch2.update(2L, new double[]{1.0, 2.0});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch2.compact().toByteArray()), new IntWritable(16), new IntWritable(2)});
            Object result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof BytesWritable));
            ArrayOfDoublesSketch resultSketch = ArrayOfDoublesSketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)result)));
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
            eval.reset((GenericUDAFEvaluator.AggregationBuffer)state);
            result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNull((Object)result);
        }
    }
}

