/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.tuple;

import org.apache.datasketches.pig.tuple.DoubleSummarySketchToEstimates;
import org.apache.datasketches.pig.tuple.PigUtil;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.UpdatableSketch;
import org.apache.datasketches.tuple.UpdatableSketchBuilder;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryFactory;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DoubleSummarySketchToEstimatesTest {
    @Test
    public void nullInput() throws Exception {
        DoubleSummarySketchToEstimates func = new DoubleSummarySketchToEstimates();
        Tuple resultTuple = (Tuple)func.exec(null);
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void emptyInput() throws Exception {
        DoubleSummarySketchToEstimates func = new DoubleSummarySketchToEstimates();
        Tuple resultTuple = (Tuple)func.exec(TupleFactory.getInstance().newTuple());
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void emptySketch() throws Exception {
        DoubleSummarySketchToEstimates func = new DoubleSummarySketchToEstimates();
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
        Tuple inputTuple = PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray()));
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)2);
        Assert.assertEquals((Object)resultTuple.get(0), (Object)0.0);
        Assert.assertEquals((Object)resultTuple.get(0), (Object)0.0);
    }

    @Test
    public void normalCase() throws Exception {
        int i;
        DoubleSummarySketchToEstimates func = new DoubleSummarySketchToEstimates();
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
        int iterations = 100000;
        for (i = 0; i < iterations; ++i) {
            sketch.update((long)i, (Object)1.0);
        }
        for (i = 0; i < iterations; ++i) {
            sketch.update((long)i, (Object)1.0);
        }
        Tuple inputTuple = PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray()));
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)2);
        Assert.assertEquals((double)((Double)resultTuple.get(0)), (double)iterations, (double)((double)iterations * 0.03));
        Assert.assertEquals((double)((Double)resultTuple.get(1)), (double)(2 * iterations), (double)((double)(2 * iterations) * 0.03));
    }
}

