/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import javax.transaction.xa.Xid;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.XATransactionController;
import org.apache.derby.iapi.store.access.xa.XAResourceManager;
import org.apache.derby.iapi.store.access.xa.XAXactId;

class commit_method {
    private boolean online_xact;
    private AccessFactory store;

    public commit_method(AccessFactory store, boolean online_xact) {
        this.store = store;
        this.online_xact = online_xact;
    }

    public void commit(boolean one_phase, int format_id, byte[] global_id, byte[] branch_id, XATransactionController xa_tc) throws StandardException {
        boolean local_online_xact = this.online_xact;
        if (global_id == null) {
            local_online_xact = true;
        }
        if (xa_tc == null) {
            local_online_xact = false;
        }
        if (local_online_xact) {
            xa_tc.xa_commit(one_phase);
        } else {
            XAXactId xid = new XAXactId(format_id, global_id, branch_id);
            ContextManager cm = ((XAResourceManager)this.store.getXAResourceManager()).find((Xid)xid);
            ((XAResourceManager)this.store.getXAResourceManager()).commit(cm, (Xid)xid, one_phase);
        }
    }

    public void rollback(int format_id, byte[] global_id, byte[] branch_id, XATransactionController xa_tc) throws StandardException {
        boolean local_online_xact = this.online_xact;
        if (global_id == null) {
            local_online_xact = true;
        }
        if (xa_tc == null) {
            local_online_xact = false;
        }
        if (local_online_xact) {
            xa_tc.xa_rollback();
        } else {
            XAXactId xid = new XAXactId(format_id, global_id, branch_id);
            ContextManager cm = ((XAResourceManager)this.store.getXAResourceManager()).find((Xid)xid);
            ((XAResourceManager)this.store.getXAResourceManager()).rollback(cm, (Xid)xid);
        }
    }
}

