/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;

public class SynonymTest
extends BaseJDBCTestCase {
    public SynonymTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite(SynonymTest.class, "SynonymTest");
        return new CleanDatabaseTestSetup((Test)suite);
    }

    public void testViewDependency() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create synonym mySyn for sys.systables");
        stmt.executeUpdate("create view v1 as select * from mySyn");
        stmt.executeUpdate("create view v2 as select * from v1");
        SynonymTest.assertStatementError("X0Y23", stmt, "drop synonym mySyn");
        stmt.executeUpdate("drop view v2");
        SynonymTest.assertStatementError("X0Y23", stmt, "drop synonym mySyn");
        stmt.executeUpdate("drop view v1");
        stmt.executeUpdate("drop synonym mySyn");
        stmt.close();
    }

    public void testMetaDataCallOnSynonymsDERBY5244() throws SQLException {
        Statement st = this.createStatement();
        st.executeUpdate("create table t1Derby5422 ( c11 int not null, c12 char(2) )");
        st.executeUpdate("create synonym s1Derby5422 for t1Derby5422");
        st.executeUpdate("create view v1Derby5422 as select * from t1Derby5422");
        ResultSet rs = st.executeQuery("select * from S1DERBY5422");
        JDBC.assertEmpty(rs);
        DatabaseMetaData dbmd = this.getConnection().getMetaData();
        rs = dbmd.getColumns(null, null, "T1DERBY5422", null);
        JDBC.assertDrainResultsHasData(rs);
        rs = dbmd.getColumns(null, null, "V1DERBY5422", null);
        JDBC.assertDrainResultsHasData(rs);
        rs = dbmd.getColumns(null, null, "S1DERBY5422", null);
        JDBC.assertEmpty(rs);
    }

    public void testSynonymsInSearchedDeleteDERBY4110() throws SQLException {
        Statement st = this.createStatement();
        st.executeUpdate("create schema test1");
        st.executeUpdate("create schema test2");
        st.executeUpdate("create table test1.t1 ( id bigint not null )");
        st.executeUpdate("insert into test1.t1 values (1),(2)");
        st.executeUpdate("create synonym test2.t1 for test1.t1");
        st.executeUpdate("create unique index idx4110 on test1.t1 (id)");
        st.executeUpdate("set schema test2");
        st.executeUpdate("delete from t1 where id = 2");
        st.executeUpdate("drop synonym test2.t1");
        st.executeUpdate("drop table test1.t1");
        st.executeUpdate("drop schema test2 restrict");
        st.executeUpdate("drop schema test1 restrict");
    }

    public void testSynonymsForTablesWithDoubleQuotes() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create schema \"\"\"\"");
        s.execute("create table \"\"\"\".\"\"\"\" (x int)");
        s.execute("create synonym derby_5168_synonym for \"\"\"\".\"\"\"\"");
        JDBC.assertSingleValueResultSet(s.executeQuery("select aliasinfo from sys.sysaliases where alias = 'DERBY_5168_SYNONYM'"), "\"\"\"\".\"\"\"\"");
    }
}

