/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;

public class BlobClobTestSetup
extends BaseJDBCTestSetup {
    public static final int ID_NULLVALUES = 1;
    public static final int ID_SAMPLEVALUES = 2;
    public static int ID = 3;
    private static final byte[] blobData = new byte[]{101, 102, 103, 104, 105, 105, 104, 103, 102, 101};
    private static final String clobData = "This is a string, inserted into a CLOB";

    public BlobClobTestSetup(Test test) {
        super(test);
    }

    protected void setUp() throws IOException, SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("create table BLOBCLOB (ID int primary key, BLOBDATA blob,CLOBDATA clob)");
        statement.execute("insert into BLOBCLOB VALUES (1, null, null)");
        statement.execute("insert into BLOBCLOB VALUES (2, null, null)");
        statement.close();
    }

    @Override
    protected void tearDown() throws Exception {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("drop table BLOBCLOB");
        statement.close();
        super.tearDown();
    }

    public static Blob getSampleBlob(Connection connection) throws SQLException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(blobData, 0, blobData.length);
        PreparedStatement preparedStatement = connection.prepareStatement("update BLOBCLOB set BLOBDATA = ? where ID = ?");
        try {
            ((InputStream)byteArrayInputStream).reset();
        }
        catch (IOException iOException) {
            BlobClobTestSetup.fail((String)("Failed to reset blob input stream: " + iOException.getMessage()));
        }
        preparedStatement.setBlob(1, byteArrayInputStream, blobData.length);
        preparedStatement.setInt(2, 2);
        BlobClobTestSetup.assertEquals((String)"Invalid update count", (int)1, (int)preparedStatement.executeUpdate());
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select BLOBDATA from BLOBCLOB where ID = 2");
        resultSet.next();
        Blob blob = resultSet.getBlob(1);
        resultSet.close();
        statement.close();
        return blob;
    }

    public static Clob getSampleClob(Connection connection) throws SQLException {
        StringReader stringReader = new StringReader(clobData);
        PreparedStatement preparedStatement = connection.prepareStatement("update BLOBCLOB set CLOBDATA = ? where ID = ?");
        try {
            ((Reader)stringReader).reset();
        }
        catch (IOException iOException) {
            BlobClobTestSetup.fail((String)("Failed to reset clob input stream: " + iOException.getMessage()));
        }
        preparedStatement.setClob(1, stringReader, clobData.length());
        preparedStatement.setInt(2, 2);
        BlobClobTestSetup.assertEquals((String)"Invalid update count", (int)1, (int)preparedStatement.executeUpdate());
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select CLOBDATA from BLOBCLOB where ID = 2");
        resultSet.next();
        Clob clob = resultSet.getClob(1);
        resultSet.close();
        statement.close();
        return clob;
    }

    public static int getID() {
        return ID++;
    }
}

