/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.SecurityManagerSetup;

public class ReplicationRun_Distributed
extends ReplicationRun {
    public ReplicationRun_Distributed(String testcaseName) {
        super(testcaseName);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("ReplicationRun_Distributed Suite");
        suite.addTestSuite(ReplicationRun_Distributed.class);
        return SecurityManagerSetup.noSecurityManager((Test)suite);
    }

    public void testReplication() throws Exception {
        this.cleanAllTestHosts();
        this.initEnvironment();
        this.initMaster(masterServerHost, replicatedDb);
        this.startServer(masterJvmVersion, derbyMasterVersion, masterServerHost, "0.0.0.0", masterServerPort, masterDbSubPath);
        this.startServer(slaveJvmVersion, derbySlaveVersion, slaveServerHost, "0.0.0.0", slaveServerPort, slaveDbSubPath);
        this.startServerMonitor(slaveServerHost);
        this.bootMasterDatabase(jvmVersion, masterDatabasePath + FS + masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, null);
        this.initSlave(slaveServerHost, jvmVersion, replicatedDb);
        this.startSlave(jvmVersion, replicatedDb, slaveServerHost, slaveServerPort, slaveServerHost, slaveReplPort, testClientHost);
        this.util.sleep(sleepTime, "Before startMaster");
        this.startMaster(jvmVersion, replicatedDb, masterServerHost, masterServerPort, masterServerHost, slaveServerPort, slaveServerHost, slaveReplPort);
        this.runTest(replicationTest, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
        this.failOver(jvmVersion, masterDatabasePath, masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, testClientHost);
        this.connectPing(slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb, slaveServerHost, slaveServerPort, testClientHost);
        this.verifySlave();
        this.verifyMaster();
        this.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
        this.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
    }

    @Override
    void initEnvironment() throws IOException {
        this.util.DEBUG("*** Properties -----------------------------------------");
        userDir = System.getProperty("user.dir");
        this.util.DEBUG("user.dir:          " + userDir);
        userHome = System.getProperty("user.home");
        this.util.DEBUG("user.home:          " + userHome);
        this.util.writeToFile("exit;", userHome + FS + "ij_dummy_script.sql");
        this.util.DEBUG("derby.system.home: " + System.getProperty("derby.system.home"));
        String realPropertyFile = "replicationtest.properties";
        this.util.DEBUG("realPropertyFile: " + realPropertyFile);
        FileInputStream isCp = new FileInputStream(userDir + FS + realPropertyFile);
        Properties cp = new Properties();
        cp.load(isCp);
        this.util.printDebug = cp.getProperty("test.printDebug", "false").equalsIgnoreCase("true");
        this.util.DEBUG("printDebug: " + this.util.printDebug);
        showSysinfo = cp.getProperty("test.showSysinfo", "false").equalsIgnoreCase("true");
        this.util.DEBUG("showSysinfo: " + showSysinfo);
        testUser = cp.getProperty("test.testUser", "UNKNOWN");
        this.util.DEBUG("testUser: " + testUser);
        masterServerHost = cp.getProperty("test.masterServerHost", masterServerHost);
        this.util.DEBUG("masterServerHost: " + masterServerHost);
        cp.setProperty("test.serverHost", masterServerHost);
        masterServerPort = Integer.parseInt(cp.getProperty("test.masterServerPort", "" + masterServerPort));
        this.util.DEBUG("masterServerPort: " + masterServerPort);
        cp.setProperty("test.serverPort", "" + masterServerPort);
        slaveServerHost = cp.getProperty("test.slaveServerHost", slaveServerHost);
        this.util.DEBUG("slaveServerHost: " + slaveServerHost);
        slaveServerPort = Integer.parseInt(cp.getProperty("test.slaveServerPort", "" + slaveServerPort));
        this.util.DEBUG("slaveServerPort: " + slaveServerPort);
        slaveReplPort = Integer.parseInt(cp.getProperty("test.slaveReplPort", "" + slaveReplPort));
        this.util.DEBUG("slaveReplPort: " + slaveReplPort);
        testClientHost = cp.getProperty("test.testClientHost", testClientHost);
        this.util.DEBUG("testClientHost: " + testClientHost);
        masterDatabasePath = cp.getProperty("test.master.databasepath");
        this.util.DEBUG("masterDatabasePath: " + masterDatabasePath);
        slaveDatabasePath = cp.getProperty("test.slave.databasepath");
        this.util.DEBUG("slaveDatabasePath: " + slaveDatabasePath);
        replicatedDb = cp.getProperty("test.databaseName", "test");
        this.util.DEBUG("replicatedDb: " + replicatedDb);
        bootLoad = cp.getProperty("test.bootLoad");
        this.util.DEBUG("bootLoad: " + bootLoad);
        freezeDB = cp.getProperty("test.freezeDB");
        this.util.DEBUG("freezeDB: " + freezeDB);
        unFreezeDB = cp.getProperty("test.unFreezeDB");
        this.util.DEBUG("unFreezeDB: " + unFreezeDB);
        simpleLoad = System.getProperty("derby.tests.replSimpleLoad", "true").equalsIgnoreCase("true");
        this.util.DEBUG("simpleLoad: " + simpleLoad);
        simpleLoadTuples = Integer.parseInt(cp.getProperty("test.simpleloadtuples", "10000"));
        this.util.DEBUG("simpleLoadTuples: " + simpleLoadTuples);
        replicationTest = cp.getProperty("test.replicationTest");
        this.util.DEBUG("replicationTest: " + replicationTest);
        replicationVerify = cp.getProperty("test.replicationVerify");
        this.util.DEBUG("replicationVerify: " + replicationVerify);
        junitTest = cp.getProperty("test.junitTest", "true").equalsIgnoreCase("true");
        this.util.DEBUG("junitTest: " + junitTest);
        THREADS = Integer.parseInt(cp.getProperty("test.stressMultiThreads", "0"));
        this.util.DEBUG("THREADS: " + THREADS);
        MINUTES = Integer.parseInt(cp.getProperty("test.stressMultiMinutes", "0"));
        this.util.DEBUG("MINUTES: " + MINUTES);
        sqlLoadInit = cp.getProperty("test.sqlLoadInit");
        this.util.DEBUG("sqlLoadInit: " + sqlLoadInit);
        specialTestingJar = cp.getProperty("test.derbyTestingJar", null);
        this.util.DEBUG("specialTestingJar: " + specialTestingJar);
        jvmVersion = cp.getProperty("jvm.version");
        this.util.DEBUG("jvmVersion: " + jvmVersion);
        masterJvmVersion = cp.getProperty("jvm.masterversion");
        if (masterJvmVersion == null) {
            masterJvmVersion = jvmVersion;
        }
        this.util.DEBUG("masterJvmVersion: " + masterJvmVersion);
        slaveJvmVersion = cp.getProperty("jvm.slaveversion");
        if (slaveJvmVersion == null) {
            slaveJvmVersion = jvmVersion;
        }
        this.util.DEBUG("slaveJvmVersion: " + slaveJvmVersion);
        derbyVersion = cp.getProperty("derby.version");
        this.util.DEBUG("derbyVersion: " + derbyVersion);
        derbyMasterVersion = cp.getProperty("derby.masterversion");
        if (derbyMasterVersion == null) {
            derbyMasterVersion = derbyVersion;
        }
        this.util.DEBUG("derbyMasterVersion: " + derbyMasterVersion);
        derbySlaveVersion = cp.getProperty("derby.slaveversion");
        if (derbySlaveVersion == null) {
            derbySlaveVersion = derbyVersion;
        }
        this.util.DEBUG("derbySlaveVersion: " + derbySlaveVersion);
        Object derbyTestingJar = derbyVersion + FS + "derbyTesting.jar";
        if (specialTestingJar != null) {
            derbyTestingJar = specialTestingJar;
        }
        this.util.DEBUG("derbyTestingJar: " + (String)derbyTestingJar);
        junit_jar = cp.getProperty("junit_jar");
        this.util.DEBUG("junit_jar: " + junit_jar);
        test_jars = (String)derbyTestingJar + ":" + junit_jar;
        this.util.DEBUG("test_jars: " + test_jars);
        sleepTime = Integer.parseInt(cp.getProperty("test.sleepTime", "15000"));
        this.util.DEBUG("sleepTime: " + sleepTime);
        runUnReplicated = cp.getProperty("test.runUnReplicated", "false").equalsIgnoreCase("true");
        this.util.DEBUG("runUnReplicated: " + runUnReplicated);
        localEnv = cp.getProperty("test.localEnvironment", "false").equalsIgnoreCase("true");
        this.util.DEBUG("localEnv: " + localEnv);
        derbyProperties = "derby.infolog.append=true" + LF + "derby.drda.logConnections=true" + LF + "derby.drda.traceAll=true" + LF;
        this.util.DEBUG("--------------------------------------------------------");
        masterPreRepl = new ReplicationRun.Load("masterPreRepl", cp);
        masterPostRepl = new ReplicationRun.Load("masterPostRepl", cp);
        slavePreSlave = new ReplicationRun.Load("slavePreSlave", cp);
        masterPostSlave = new ReplicationRun.Load("masterPostSlave", cp);
        slavePostSlave = new ReplicationRun.Load("slavePostSlave", cp);
        this.util.DEBUG("--------------------------------------------------------");
        tuplesToInsertPerf = Integer.parseInt(cp.getProperty("test.inserts", "10000"));
        this.util.DEBUG("tuplesToInsertPerf: " + tuplesToInsertPerf);
        commitFreq = Integer.parseInt(cp.getProperty("test.commitFreq", "0"));
        this.util.DEBUG("commitFreq: " + commitFreq);
        this.util.DEBUG("--------------------------------------------------------");
        this.state.initEnvironment(cp);
        this.util.DEBUG("--------------------------------------------------------");
    }
}

