/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.FormatableHashtable;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.locks.LockOwner;
import org.apache.derby.iapi.services.locks.ShExQual;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyFactory;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.UserType;
import org.apache.derby.impl.store.access.CacheLock;
import org.apache.derby.impl.store.access.PC_XenaVersion;
import org.apache.derby.impl.store.access.RAMTransaction;
import org.apache.derby.impl.store.access.UTF;
import org.apache.derby.impl.store.access.UTFQualifier;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class PropertyConglomerate {
    protected long propertiesConglomId;
    protected Properties serviceProperties;
    private LockFactory lf;
    private Dictionary<String, Object> cachedSet;
    private CacheLock cachedLock;
    private PropertyFactory pf;

    PropertyConglomerate(TransactionController tc, boolean create, Properties serviceProperties, PropertyFactory pf) throws StandardException {
        this.pf = pf;
        if (!create) {
            String id = serviceProperties.getProperty("derby.storage.propertiesId");
            if (id == null) {
                create = true;
            } else {
                try {
                    this.propertiesConglomId = Long.valueOf(id);
                }
                catch (NumberFormatException nfe) {
                    throw Monitor.exceptionStartingModule(nfe);
                }
            }
        }
        if (create) {
            DataValueDescriptor[] template = this.makeNewTemplate();
            Properties conglomProperties = new Properties();
            conglomProperties.put("derby.storage.pageSize", "2048");
            conglomProperties.put("derby.storage.pageReservedSpace", "0");
            this.propertiesConglomId = tc.createConglomerate("heap", template, null, null, conglomProperties, 0);
            serviceProperties.put("derby.storage.propertiesId", Long.toString(this.propertiesConglomId));
        }
        this.serviceProperties = serviceProperties;
        this.lf = ((RAMTransaction)tc).getAccessManager().getLockFactory();
        this.cachedLock = new CacheLock(this);
        PC_XenaVersion softwareVersion = new PC_XenaVersion();
        if (create) {
            this.setProperty(tc, "PropertyConglomerateVersion", softwareVersion, true);
        } else {
            softwareVersion.upgradeIfNeeded(tc, this, serviceProperties);
        }
        this.getCachedDbProperties(tc);
    }

    private DataValueDescriptor[] makeNewTemplate(String key, Serializable value) {
        DataValueDescriptor[] template = new DataValueDescriptor[]{new UTF(key), new UserType(value)};
        return template;
    }

    private DataValueDescriptor[] makeNewTemplate() {
        DataValueDescriptor[] template = new DataValueDescriptor[]{new UTF(), new UserType()};
        return template;
    }

    private ScanController openScan(TransactionController tc, String key, int open_mode) throws StandardException {
        Qualifier[][] qualifiers = null;
        if (key != null) {
            qualifiers = new Qualifier[][]{new Qualifier[1]};
            qualifiers[0][0] = new UTFQualifier(0, key);
        }
        ScanController scan = tc.openScan(this.propertiesConglomId, false, open_mode, 7, 5, null, null, 0, qualifiers, null, 0);
        return scan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPropertyDefault(TransactionController tc, String key, Serializable value) throws StandardException {
        this.lockProperties(tc);
        Serializable valueToSave = null;
        if (this.propertyDefaultIsVisible(tc, key)) {
            valueToSave = this.validateApplyAndMap(tc, key, value, false);
        } else {
            PropertyConglomerate propertyConglomerate = this;
            synchronized (propertyConglomerate) {
                Hashtable<Object, Object> defaults = new Hashtable<Object, Object>();
                this.getProperties(tc, defaults, false, true);
                this.validate(key, value, defaults);
                valueToSave = this.map(key, value, defaults);
            }
        }
        this.savePropertyDefault(tc, key, valueToSave);
    }

    boolean propertyDefaultIsVisible(TransactionController tc, String key) throws StandardException {
        this.lockProperties(tc);
        return this.readProperty(tc, key) == null;
    }

    void saveProperty(TransactionController tc, String key, Serializable value) throws StandardException {
        DataValueDescriptor[] row;
        if (this.saveServiceProperty(key, value)) {
            return;
        }
        ScanController scan = this.openScan(tc, key, 4);
        if (scan.fetchNext(row = this.makeNewTemplate())) {
            if (value == null) {
                scan.delete();
            } else {
                row[1] = new UserType(value);
                scan.replace(row, null);
            }
            scan.close();
        } else {
            scan.close();
            scan = null;
            if (value != null) {
                row = this.makeNewTemplate(key, value);
                ConglomerateController cc = tc.openConglomerate(this.propertiesConglomId, false, 4, 7, 5);
                cc.insert(row);
                cc.close();
            }
        }
    }

    private boolean saveServiceProperty(String key, Serializable value) {
        if (PropertyUtil.isServiceProperty(key)) {
            if (value != null) {
                this.serviceProperties.put(key, value);
            } else {
                this.serviceProperties.remove(key);
            }
            return true;
        }
        return false;
    }

    void savePropertyDefault(TransactionController tc, String key, Serializable value) throws StandardException {
        if (this.saveServiceProperty(key, value)) {
            return;
        }
        FormatableHashtable defaults = (FormatableHashtable)this.readProperty(tc, "derby.defaultPropertyName");
        if (defaults == null) {
            defaults = new FormatableHashtable();
        }
        if (value == null) {
            defaults.remove(key);
        } else {
            defaults.put(key, value);
        }
        if (defaults.size() == 0) {
            defaults = null;
        }
        this.saveProperty(tc, "derby.defaultPropertyName", defaults);
    }

    private Serializable validateApplyAndMap(TransactionController tc, String key, Serializable value, boolean dbOnlyProperty) throws StandardException {
        Hashtable<Object, Object> d = new Hashtable<Object, Object>();
        this.getProperties(tc, d, false, false);
        Serializable mappedValue = this.pf.doValidateApplyAndMap(tc, key, value, d, dbOnlyProperty);
        if (key.equals("logDevice")) {
            throw StandardException.newException("XSRS8.S", new Object[0]);
        }
        if (mappedValue == null) {
            return value;
        }
        return mappedValue;
    }

    private Serializable map(String key, Serializable value, Dictionary set) throws StandardException {
        return this.pf.doMap(key, value, set);
    }

    private void validate(String key, Serializable value, Dictionary set) throws StandardException {
        this.pf.validateSingleProperty(key, value, set);
    }

    private boolean bootPasswordChange(TransactionController tc, String key, Serializable value) throws StandardException {
        if (key.equals("bootPassword")) {
            AccessFactory af = ((TransactionManager)tc).getAccessManager();
            RawStoreFactory rsf = (RawStoreFactory)PropertyConglomerate.findServiceModule(af, "org.apache.derby.iapi.store.raw.RawStoreFactory");
            this.serviceProperties.remove("bootPassword");
            value = rsf.changeBootPassword(this.serviceProperties, value);
            this.serviceProperties.put("encryptedBootPassword", value);
            return true;
        }
        return false;
    }

    void setProperty(TransactionController tc, String key, Serializable value, boolean dbOnlyProperty) throws StandardException {
        if (value != null && !(value instanceof Formatable) && !value.getClass().getName().startsWith("java.")) {
            SanityManager.THROWASSERT("Non-formattable, non-java class - " + value.getClass().getName());
        }
        this.lockProperties(tc);
        Serializable valueToValidateAndApply = value;
        if (value == null) {
            valueToValidateAndApply = this.getPropertyDefault(tc, key);
        }
        Serializable valueToSave = this.validateApplyAndMap(tc, key, valueToValidateAndApply, dbOnlyProperty);
        if (this.bootPasswordChange(tc, key, value)) {
            return;
        }
        if (value == null) {
            this.saveProperty(tc, key, null);
        } else {
            this.saveProperty(tc, key, valueToSave);
        }
    }

    private Serializable readProperty(TransactionController tc, String key) throws StandardException {
        ScanController scan = this.openScan(tc, key, 0);
        DataValueDescriptor[] row = this.makeNewTemplate();
        boolean isThere = scan.fetchNext(row);
        scan.close();
        if (!isThere) {
            return null;
        }
        return (Serializable)((UserType)row[1]).getObject();
    }

    private Serializable getCachedProperty(TransactionController tc, String key) throws StandardException {
        Dictionary<String, Object> dbProps = this.getCachedDbProperties(tc);
        if (dbProps.get(key) != null) {
            return (Serializable)dbProps.get(key);
        }
        return this.getCachedPropertyDefault(tc, key, dbProps);
    }

    private Serializable getCachedPropertyDefault(TransactionController tc, String key, Dictionary dbProps) throws StandardException {
        Dictionary defaults;
        if (dbProps == null) {
            dbProps = this.getCachedDbProperties(tc);
        }
        if ((defaults = (Dictionary)dbProps.get("derby.defaultPropertyName")) == null) {
            return null;
        }
        return (Serializable)defaults.get(key);
    }

    Serializable getProperty(TransactionController tc, String key) throws StandardException {
        if (PropertyUtil.isServiceProperty(key)) {
            return this.serviceProperties.getProperty(key);
        }
        if (this.iHoldTheUpdateLock(tc)) {
            Serializable v = this.readProperty(tc, key);
            if (v != null) {
                return v;
            }
            return this.getPropertyDefault(tc, key);
        }
        return this.getCachedProperty(tc, key);
    }

    Serializable getPropertyDefault(TransactionController tc, String key) throws StandardException {
        if (this.iHoldTheUpdateLock(tc)) {
            Dictionary defaults = (Dictionary)((Object)this.readProperty(tc, "derby.defaultPropertyName"));
            if (defaults == null) {
                return null;
            }
            return (Serializable)defaults.get(key);
        }
        return this.getCachedPropertyDefault(tc, key, null);
    }

    private <K, V> Dictionary<? super K, ? super V> copyValues(Dictionary<? super K, ? super V> to, Dictionary<K, V> from, boolean stringsOnly) {
        if (from == null) {
            return to;
        }
        Enumeration<K> keys = from.keys();
        while (keys.hasMoreElements()) {
            K key = keys.nextElement();
            V value = from.get(key);
            if (!(value instanceof String) && stringsOnly) continue;
            to.put(key, value);
        }
        return to;
    }

    Properties getProperties(TransactionController tc) throws StandardException {
        Properties p = new Properties();
        this.getProperties(tc, p, true, false);
        return p;
    }

    public void getProperties(TransactionController tc, Dictionary<Object, Object> d, boolean stringsOnly, boolean defaultsOnly) throws StandardException {
        Dictionary<String, Object> dbProps = this.iHoldTheUpdateLock(tc) ? this.readDbProperties(tc) : this.getCachedDbProperties(tc);
        FormatableHashtable defaults = (FormatableHashtable)dbProps.get("derby.defaultPropertyName");
        this.copyValues(d, defaults, stringsOnly);
        if (!defaultsOnly) {
            this.copyValues(d, dbProps, stringsOnly);
        }
    }

    void resetCache() {
        this.cachedSet = null;
    }

    private Dictionary<String, Object> readDbProperties(TransactionController tc) throws StandardException {
        Hashtable<String, Object> set = new Hashtable<String, Object>();
        ScanController scan = this.openScan(tc, null, 0);
        DataValueDescriptor[] row = this.makeNewTemplate();
        while (scan.fetchNext(row)) {
            Object key = ((UserType)row[0]).getObject();
            Object value = ((UserType)row[1]).getObject();
            if (!(key instanceof String)) {
                SanityManager.THROWASSERT("Key is not a string " + key.getClass().getName());
            }
            ((Dictionary)set).put((String)key, value);
        }
        scan.close();
        String[] servicePropertyList = PropertyUtil.getServicePropertyList();
        for (int i = 0; i < servicePropertyList.length; ++i) {
            String value = this.serviceProperties.getProperty(servicePropertyList[i]);
            if (value == null) continue;
            ((Dictionary)set).put(servicePropertyList[i], value);
        }
        return set;
    }

    private Dictionary<String, Object> getCachedDbProperties(TransactionController tc) throws StandardException {
        Dictionary<String, Object> dbProps = this.cachedSet;
        if (dbProps == null) {
            this.cachedSet = dbProps = this.readDbProperties(tc);
        }
        return dbProps;
    }

    void lockProperties(TransactionController tc) throws StandardException {
        CompatibilitySpace cs = tc.getLockSpace();
        LockOwner csGroup = cs.getOwner();
        this.lf.lockObject(cs, csGroup, this.cachedLock, ShExQual.EX, -2);
    }

    private boolean iHoldTheUpdateLock(TransactionController tc) throws StandardException {
        CompatibilitySpace cs = tc.getLockSpace();
        LockOwner csGroup = cs.getOwner();
        return this.lf.isLockHeld(cs, csGroup, this.cachedLock, ShExQual.EX);
    }

    private static Object findServiceModule(final Object serviceModule, final String factoryInterface) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.findServiceModule(serviceModule, factoryInterface);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw StandardException.plainWrapException(pae);
        }
    }
}

