/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SecurityManagerSetup;

public class DBInJarTest
extends BaseJDBCTestCase {
    public DBInJarTest(String name) {
        super(name);
    }

    public void testConnectDBInJar() throws SQLException {
        Connection beforejarconn = DriverManager.getConnection("jdbc:derby:testjardb;create=true");
        Statement bjstmt = beforejarconn.createStatement();
        bjstmt.executeUpdate("CREATE TABLE TAB (I INT)");
        bjstmt.executeUpdate("INSERT INTO TAB VALUES(1)");
        this.shutdownDB("jdbc:derby:testjardb;shutdown=true");
        Statement stmt = this.createStatement();
        stmt.executeUpdate("CALL CREATEARCHIVE('testjardb.jar', 'testjardb','testjardb')");
        Connection jarconn = DriverManager.getConnection("jdbc:derby:jar:(testjardb.jar)testjardb");
        Statement s = jarconn.createStatement();
        ResultSet rs = s.executeQuery("SELECT * from TAB");
        JDBC.assertSingleValueResultSet(rs, "1");
        rs = jarconn.getMetaData().getSchemas();
        String[][] expectedRows = new String[][]{{"APP", null}, {"NULLID", null}, {"SQLJ", null}, {"SYS", null}, {"SYSCAT", null}, {"SYSCS_DIAG", null}, {"SYSCS_UTIL", null}, {"SYSFUN", null}, {"SYSIBM", null}, {"SYSPROC", null}, {"SYSSTAT", null}};
        JDBC.assertFullResultSet(rs, expectedRows);
        this.shutdownDB("jdbc:derby:jar:(testjardb.jar)testjardb;shutdown=true");
        File jarreddb = new File(System.getProperty("derby.system.home") + "/testjardb.jar");
        DBInJarTest.assertTrue((String)("failed deleting " + jarreddb.getPath()), (boolean)jarreddb.delete());
        DBInJarTest.removeDirectory(new File(System.getProperty("derby.system.home") + "/testjardb"));
    }

    private void shutdownDB(String url) {
        try {
            DriverManager.getConnection(url);
            DBInJarTest.fail((String)"Expected exception on shutdown");
        }
        catch (SQLException se) {
            DBInJarTest.assertSQLState("08006", se);
        }
    }

    public void testConnectParenDBInJar() throws SQLException {
        Connection beforejarconn = DriverManager.getConnection("jdbc:derby:testparjardb;create=true");
        Statement bjstmt = beforejarconn.createStatement();
        bjstmt.executeUpdate("CREATE TABLE PARTAB (I INT)");
        bjstmt.executeUpdate("INSERT INTO PARTAB VALUES(1)");
        this.shutdownDB("jdbc:derby:testparjardb;shutdown=true");
        Statement stmt = this.createStatement();
        stmt.executeUpdate("CALL CREATEARCHIVE('test)jardb.jar', 'testparjardb','testparjardb')");
        Connection jarconn = DriverManager.getConnection("jdbc:derby:jar:(test)jardb.jar)testparjardb");
        Statement s = jarconn.createStatement();
        ResultSet rs = s.executeQuery("SELECT * from PARTAB");
        JDBC.assertSingleValueResultSet(rs, "1");
        this.shutdownDB("jdbc:derby:jar:(test)jardb.jar)testparjardb;shutdown=true");
        File jarredpardb = new File(System.getProperty("derby.system.home") + "/test)jardb.jar");
        DBInJarTest.assertTrue((String)("failed deleting " + jarredpardb.getPath()), (boolean)jarredpardb.delete());
        DBInJarTest.removeDirectory(new File(System.getProperty("derby.system.home") + "/testparjardb"));
    }

    public void testSpillHashToDisk() throws SQLException {
        this.createDerby2354Database();
        Connection jarConn = DriverManager.getConnection("jdbc:derby:jar:(d2354db.jar)d2354db");
        Statement stmt = jarConn.createStatement();
        JDBC.assertDrainResults(stmt.executeQuery("select distinct x from d2354"), 40000);
        JDBC.assertEmpty(stmt.executeQuery("select * from --DERBY-PROPERTIES joinOrder = FIXED\nsysibm.sysdummy1 t1(x),\nd2354 t2 --DERBY-PROPERTIES joinStrategy = HASH\nwhere t1.x = t2.x"));
        Statement scrollStmt = jarConn.createStatement(1004, 1007);
        JDBC.assertDrainResults(scrollStmt.executeQuery("select * from d2354"), 40000);
        stmt.close();
        scrollStmt.close();
        jarConn.close();
        this.shutdownDB("jdbc:derby:jar:(d2354db.jar)d2354db;shutdown=true");
        DBInJarTest.removeFiles(new String[]{System.getProperty("derby.system.home") + "/d2354db.jar"});
    }

    private void createDerby2354Database() throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:derby:d2354db;create=true");
        conn.setAutoCommit(false);
        Statement s = conn.createStatement();
        s.execute("create table d2354 (x varchar(100))");
        s.close();
        PreparedStatement insert = conn.prepareStatement("insert into d2354 values ? || 'some extra data to increase the size of the table'");
        for (int i = 0; i < 40000; ++i) {
            insert.setInt(1, i);
            insert.executeUpdate();
        }
        insert.close();
        conn.commit();
        conn.close();
        this.shutdownDB("jdbc:derby:d2354db;shutdown=true");
        this.createStatement().execute("CALL CREATEARCHIVE('d2354db.jar', 'd2354db', 'd2354db')");
        DBInJarTest.removeDirectory(new File(System.getProperty("derby.system.home") + "/d2354db"));
    }

    protected static Test baseSuite(String name) {
        BaseTestSuite suite = new BaseTestSuite(name);
        suite.addTestSuite(DBInJarTest.class);
        return new CleanDatabaseTestSetup(SecurityManagerSetup.noSecurityManager((Test)suite)){

            @Override
            protected void decorateSQL(Statement stmt) throws SQLException {
                stmt.execute("create procedure CREATEARCHIVE(jarName VARCHAR(20) , path VARCHAR(20), dbName VARCHAR(20)) LANGUAGE JAVA PARAMETER STYLE JAVA NO SQL EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.lang.dbjarUtil.createArchive'");
            }
        };
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("DBInJarTest");
        suite.addTest(DBInJarTest.baseSuite("DBInJarTest:embedded"));
        return suite;
    }
}

