/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BTreeMaxScanTest
extends BaseJDBCTestCase {
    private List<String> traceFlags = new ArrayList<String>();

    public BTreeMaxScanTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(BTreeMaxScanTest.class));
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        for (String flag : this.traceFlags) {
            SanityManager.DEBUG_PRINT((String)flag, (String)("Disable tracing for " + this.getName()));
            SanityManager.DEBUG_CLEAR((String)flag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRestartScanAfterWaitOnMaxRow() throws Exception {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table t(x int, y int)");
        PreparedStatement ins = this.prepareStatement("insert into t(x) values ?");
        for (int i = 1; i <= 800; ++i) {
            ins.setInt(1, i);
            ins.executeUpdate();
        }
        s.execute("create index i on t(x)");
        this.commit();
        s.execute("update t set y = 0 where x = 800");
        Connection c2 = this.openDefaultConnection();
        try {
            c2.setAutoCommit(false);
            Statement s2 = c2.createStatement();
            Result r = BTreeMaxScanTest.asyncGetSingleResult(s2, "select max(x) from t --derby-properties index=i");
            Thread.sleep(2000L);
            ins.setInt(1, 801);
            ins.executeUpdate();
            this.commit();
            BTreeMaxScanTest.assertEquals((String)"801", (String)r.get());
        }
        finally {
            c2.rollback();
            c2.close();
        }
        this.dropTable("T");
        this.commit();
    }

    public void testOppositeScanDirections() throws Exception {
        int i;
        this.setTraceFlag("BTreeMaxScan.latchConflict");
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table t(x int)");
        PreparedStatement ins = this.prepareStatement("insert into t values ?");
        final String[][] tableContents = new String[800][];
        for (int i2 = 1; i2 <= tableContents.length; ++i2) {
            String value = i2 <= 100 ? Integer.toString(i2) : null;
            ins.setString(1, value);
            ins.executeUpdate();
            tableContents[i2 - 1] = new String[]{value};
        }
        s.execute("create index i on t(x)");
        this.commit();
        String forwardSQL = "select x from t --derby-properties index=i";
        String backwardSQL = "select max(x) from t --derby-properties index=i";
        final PreparedStatement[] pss = new PreparedStatement[]{this.openDefaultConnection().prepareStatement(forwardSQL), this.openDefaultConnection().prepareStatement(forwardSQL), this.openDefaultConnection().prepareStatement(backwardSQL), this.openDefaultConnection().prepareStatement(backwardSQL)};
        final Exception[] exceptions = new Exception[pss.length];
        Thread[] threads = new Thread[pss.length];
        for (i = 0; i < pss.length; ++i) {
            final int threadNo = i;
            threads[i] = new Thread(){

                @Override
                public void run() {
                    String[][] stringArray;
                    if (threadNo < 2) {
                        stringArray = tableContents;
                    } else {
                        String[][] stringArrayArray = new String[1][];
                        stringArray = stringArrayArray;
                        stringArrayArray[0] = new String[]{"100"};
                    }
                    String[][] expected = stringArray;
                    try {
                        for (int j = 0; j < 1000; ++j) {
                            ResultSet rs = pss[threadNo].executeQuery();
                            JDBC.assertFullResultSet(rs, expected);
                        }
                    }
                    catch (Exception e) {
                        exceptions[threadNo] = e;
                    }
                }
            };
            threads[i].start();
        }
        for (i = 0; i < pss.length; ++i) {
            threads[i].join();
            pss[i].getConnection().close();
        }
        for (i = 0; i < exceptions.length; ++i) {
            if (exceptions[i] == null) continue;
            throw exceptions[i];
        }
        this.dropTable("T");
        this.commit();
    }

    public void testEmptyRightmostLeaf() throws Exception {
        int i;
        this.setTraceFlag("BTreeMaxScan.latchConflict");
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table t(x int)");
        PreparedStatement ins = this.prepareStatement("insert into t values ?");
        for (int i2 = 1; i2 <= 800; ++i2) {
            ins.setInt(1, i2);
            ins.executeUpdate();
        }
        s.execute("create index i on t(x)");
        this.commit();
        String forwardSQL = "select x from t --derby-properties index=i";
        String backwardSQL = "select max(x) from t --derby-properties index=i";
        final PreparedStatement[] pss = new PreparedStatement[]{this.openDefaultConnection().prepareStatement(forwardSQL), this.openDefaultConnection().prepareStatement(forwardSQL), this.openDefaultConnection().prepareStatement(backwardSQL), this.openDefaultConnection().prepareStatement(backwardSQL)};
        final Exception[] exceptions = new Exception[pss.length];
        Thread[] threads = new Thread[pss.length];
        final AtomicInt threadCount = new AtomicInt();
        for (int i3 = 0; i3 < pss.length; ++i3) {
            final int threadNo = i3;
            pss[i3].getConnection().setTransactionIsolation(1);
            threads[i3] = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        for (int j = 0; j < 1000; ++j) {
                            ResultSet rs = pss[threadNo].executeQuery();
                            if (threadNo < 2) {
                                int rowCount = JDBC.assertDrainResults(rs);
                                if (rowCount >= 400 && rowCount <= 800) continue;
                                Assert.fail((String)("Unexpected row count: " + rowCount));
                                continue;
                            }
                            Assert.assertTrue((boolean)rs.next());
                            int max = rs.getInt(1);
                            if (max < 400 || max > 800) {
                                Assert.fail((String)("Unexpected max value: " + max));
                            }
                            Assert.assertFalse((boolean)rs.next());
                            rs.close();
                        }
                    }
                    catch (Exception e) {
                        exceptions[threadNo] = e;
                    }
                    finally {
                        threadCount.decrement();
                    }
                }
            };
            threads[i3].start();
            threadCount.increment();
        }
        PreparedStatement deleteRows = this.prepareStatement("delete from t where x > 400");
        PreparedStatement insertRows = this.prepareStatement("insert into t select x+400 from t");
        while (threadCount.get() > 0) {
            BTreeMaxScanTest.assertEquals((String)"deleted rows", (int)400, (int)deleteRows.executeUpdate());
            this.commit();
            Thread.sleep(100L);
            BTreeMaxScanTest.assertEquals((String)"inserted rows", (int)400, (int)insertRows.executeUpdate());
            this.commit();
        }
        for (i = 0; i < pss.length; ++i) {
            threads[i].join();
            pss[i].getConnection().close();
        }
        for (i = 0; i < exceptions.length; ++i) {
            if (exceptions[i] == null) continue;
            throw exceptions[i];
        }
        this.dropTable("T");
        this.commit();
    }

    public void testSerializable() throws Exception {
        this.setAutoCommit(false);
        this.getConnection().setTransactionIsolation(8);
        Statement s = this.createStatement();
        s.execute("create table t(x int, y int)");
        s.execute("insert into t(x) values 0,1,2,3,4,null,null,null");
        s.execute("create index i on t(x)");
        PreparedStatement ps = this.prepareStatement("select max(x) from t --derby-properties index=i");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "4");
        this.commit();
        final Connection c2 = this.openDefaultConnection();
        final Statement s2 = c2.createStatement();
        c2.setAutoCommit(false);
        s2.execute("update t set y = x where x = 4");
        final Exception[] exception = new Exception[1];
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                    s2.execute("insert into t(x) values 5");
                    c2.commit();
                }
                catch (Exception sqle) {
                    exception[0] = sqle;
                }
            }
        };
        t.start();
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "5");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "5");
        this.commit();
        t.join();
        s2.close();
        c2.rollback();
        c2.close();
        if (exception[0] != null) {
            throw exception[0];
        }
        this.dropTable("T");
        this.commit();
    }

    private static Result asyncGetSingleResult(final Statement s, final String sql) {
        final Result result = new Result();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    ResultSet rs = s.executeQuery(sql);
                    Assert.assertEquals((String)"expected single value", (int)1, (int)rs.getMetaData().getColumnCount());
                    Assert.assertTrue((String)"empty result", (boolean)rs.next());
                    String val = rs.getString(1);
                    Assert.assertFalse((String)"multiple rows", (boolean)rs.next());
                    rs.close();
                    result.set(val);
                }
                catch (Exception e) {
                    result.error(e);
                }
            }
        };
        t.start();
        return result;
    }

    private void setTraceFlag(String flag) {
        if (TestConfiguration.getCurrent().doTrace()) {
            SanityManager.DEBUG_PRINT((String)flag, (String)("Enable tracing for " + this.getName()));
            SanityManager.DEBUG_SET((String)flag);
            this.traceFlags.add(flag);
        }
    }

    private static class AtomicInt {
        private int i;

        private AtomicInt() {
        }

        synchronized void increment() {
            ++this.i;
        }

        synchronized void decrement() {
            --this.i;
        }

        synchronized int get() {
            return this.i;
        }
    }

    private static class Result {
        private boolean complete;
        private Exception ex;
        private String value;

        private Result() {
        }

        synchronized void error(Exception ex) {
            this.ex = ex;
            this.complete = true;
            this.notifyAll();
        }

        synchronized void set(String value) {
            this.value = value;
            this.complete = true;
            this.notifyAll();
        }

        synchronized String get() throws Exception {
            while (!this.complete) {
                this.wait();
            }
            if (this.ex != null) {
                throw this.ex;
            }
            return this.value;
        }
    }
}

