/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;

public class DataSourcePropertiesTest
extends BaseJDBCTestCase {
    public DataSourcePropertiesTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("DataSourcePropertiesTest");
        if (JDBC.vmSupportsJDBC3()) {
            Method[] methodArray = DataSourcePropertiesTest.class.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                String string;
                Method method = methodArray[i];
                if (method.getParameterTypes().length > 0 || !method.getReturnType().equals(Void.TYPE) || !(string = method.getName()).startsWith("embedded")) continue;
                baseTestSuite.addTest((Test)new DataSourcePropertiesTest(string));
            }
        }
        return new CleanDatabaseTestSetup((Test)baseTestSuite);
    }

    public void embeddedTestAttributesAsPasswordWithoutPassword_ds() throws Exception {
        DataSource dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource, "password", "mypassword");
        JDBCDataSource.setBeanProperty(dataSource, "attributesAsPassword", Boolean.TRUE);
        Connection connection = dataSource.getConnection();
        connection.close();
    }

    public void embeddedTestAttributesAsPasswordWithoutPassword_pooled() throws Exception {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "password", "mypassword");
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "attributesAsPassword", Boolean.TRUE);
        PooledConnection pooledConnection = connectionPoolDataSource.getPooledConnection();
        Connection connection = pooledConnection.getConnection();
        connection.close();
    }

    public void embeddedTestAttributesAsPasswordWithoutPassword_xa() throws Exception {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(xADataSource, "password", "mypassword");
        JDBCDataSource.setBeanProperty(xADataSource, "attributesAsPassword", Boolean.TRUE);
        XAConnection xAConnection = xADataSource.getXAConnection();
        Connection connection = xAConnection.getConnection();
        connection.close();
    }

    public void embeddedTestAttributesAsPasswordWithPassword_ds() throws Exception {
        DataSource dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource, "attributesAsPassword", Boolean.TRUE);
        try {
            Connection connection = dataSource.getConnection("username", "mypassword");
            DataSourcePropertiesTest.fail((String)"Expected getConnection to fail.");
        }
        catch (SQLException sQLException) {
            DataSourcePropertiesTest.assertSQLState("XJ028", sQLException);
        }
    }

    public void embeddedTestAttributesAsPasswordWithPassword_pooled() throws Exception {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.setBeanProperty(connectionPoolDataSource, "attributesAsPassword", Boolean.TRUE);
        try {
            PooledConnection pooledConnection = connectionPoolDataSource.getPooledConnection("username", "mypassword");
            DataSourcePropertiesTest.fail((String)"Expected getPooledConnection to fail.");
        }
        catch (SQLException sQLException) {
            DataSourcePropertiesTest.assertSQLState("XJ028", sQLException);
        }
    }

    public void embeddedTestAttributesAsPasswordWithPassword_xa() throws Exception {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(xADataSource, "attributesAsPassword", Boolean.TRUE);
        try {
            XAConnection xAConnection = xADataSource.getXAConnection("username", "mypassword");
            DataSourcePropertiesTest.fail((String)"Expected getXAConnection to fail.");
        }
        catch (SQLException sQLException) {
            DataSourcePropertiesTest.assertSQLState("XJ028", sQLException);
        }
    }
}

