/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RoutinesDefinersRightsTest
extends BaseJDBCTestCase {
    private static final String pwSuffix = "pwSuffix";
    private static final String NOEXECUTEPERMISSION = "42504";
    private static final String NOCOLUMNPERMISSION = "42502";
    private static final String MULTIPLE_ELEMENTS = "42613";
    private static final int BOSS = 0;
    private static final int MIDDLEMANAGER = 1;
    private static final int FOOTSOLDIER = 2;
    private static final String[] users = new String[]{"test_dbo", "PHB", "Dilbert"};
    private static final double[] wages = new double[]{1000.0, 500.0, 100.0};
    private static final int[] categories = new int[]{0, 1, 2};

    public RoutinesDefinersRightsTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("RoutinesDefinersRightsTest");
        if (!JDBC.vmSupportsJSR169()) {
            suite.addTest(RoutinesDefinersRightsTest.makeSuite());
            suite.addTest(TestConfiguration.clientServerDecorator(RoutinesDefinersRightsTest.makeSuite()));
        }
        return suite;
    }

    private static Test makeSuite() {
        CleanDatabaseTestSetup clean = new CleanDatabaseTestSetup((Test)new BaseTestSuite(RoutinesDefinersRightsTest.class)){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                s.execute("create role middleManager");
                s.execute("create table s1.wages(employeeId int,                   category int,                   salary double,                   name VARCHAR(20))");
                PreparedStatement ps = s.getConnection().prepareStatement("insert into s1.wages values (?,?,?,?)");
                for (int i = 0; i <= 2; ++i) {
                    ps.setInt(1, 1000 + i);
                    ps.setInt(2, i);
                    ps.setDouble(3, wages[i]);
                    ps.setString(4, users[i]);
                    ps.execute();
                }
                ps.close();
                s.execute("create function s1.lookupWageFootSoldier(int) returns double language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.lang.RoutinesDefinersRightsTest.lookupWageFootSoldier' EXTERNAL SECURITY DEFINER reads sql data called on null input");
                s.execute("create procedure s1.updateWage() language java parameter style java modifies sql data external name 'org.apache.derbyTesting.functionTests.tests.lang.RoutinesDefinersRightsTest.updateWage' EXTERNAL SECURITY DEFINER ");
                s.execute("grant execute on function s1.lookupWageFootSoldier    to phb");
                s.execute("grant execute on procedure s1.updateWage    to phb");
                s.execute("create function s1.lookupWageFootSoldierI(int) returns double language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.lang.RoutinesDefinersRightsTest.lookupWageFootSoldier' EXTERNAL SECURITY INVOKER reads sql data called on null input");
                s.execute("grant execute on function     s1.lookupWageFootSoldierI to phb");
                s.execute("create procedure s1.spTestBuiltins() language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.lang.RoutinesDefinersRightsTest.spTestBuiltins' EXTERNAL SECURITY DEFINER reads sql data");
                s.execute("grant execute on procedure s1.spTestBuiltins    to phb");
                s.execute("create function s1.selectFootSoldiers() returns table (    employeeId int,    category int,    salary double,    name varchar(20))language java parameter style     derby_jdbc_result_set external name 'org.apache.derbyTesting.functionTests.tests.lang.RoutinesDefinersRightsTest.selectFootSoldiers' EXTERNAL SECURITY DEFINER reads sql data");
                s.execute("grant execute on function s1.selectFootSoldiers     to middleManager");
                s.execute("grant middleManager to phb");
                s.execute("create function s1.selectFootSoldiersI() returns table (    employeeId int,    category int,    salary double,    name varchar(20))language java parameter style     derby_jdbc_result_set external name 'org.apache.derbyTesting.functionTests.tests.lang.RoutinesDefinersRightsTest.selectFootSoldiers' EXTERNAL SECURITY INVOKER reads sql data");
                s.execute("grant execute on function s1.selectFootSoldiersI     to middleManager");
                s.execute("create schema phb authorization phb");
                s.execute("create function phb.lookupDilbertWage() returns double language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.lang.RoutinesDefinersRightsTest.lookupDilbertWage' EXTERNAL SECURITY DEFINER reads sql data called on null input");
                s.execute("grant execute on function phb.lookupDilbertWage     to dilbert");
                BaseJDBCTestCase.assertStatementError(new String[]{RoutinesDefinersRightsTest.MULTIPLE_ELEMENTS}, s, "create function phb.lookupDilbertWage() returns double language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.lang.RoutinesDefinersRightsTest.lookupDilbertWage' EXTERNAL SECURITY DEFINER EXTERNAL SECURITY INVOKER reads sql data called on null input");
            }
        };
        return TestConfiguration.sqlAuthorizationDecorator(DatabasePropertyTestSetup.builtinAuthentication((Test)clean, users, pwSuffix));
    }

    public void testDefinersRights() throws SQLException {
        Connection c = null;
        ResultSet rs = null;
        Statement stm = null;
        TestConfiguration.getCurrent().shutdownDatabase();
        c = this.openUserConnection("Dilbert");
        stm = c.createStatement();
        RoutinesDefinersRightsTest.assertStatementError(new String[]{NOEXECUTEPERMISSION}, stm, "values s1.lookupWageFootSoldier(1002)");
        stm.close();
        c.close();
        c = this.openUserConnection("PHB");
        stm = c.createStatement();
        rs = stm.executeQuery("values s1.lookupWageFootSoldier(1002)");
        JDBC.assertSingleValueResultSet(rs, "100.0");
        stm.executeUpdate("call s1.updateWage()");
        stm.close();
        c.close();
        Connection dboConn = this.getConnection();
        Statement dbos = dboConn.createStatement();
        rs = dbos.executeQuery("values s1.lookupWageFootSoldier(1002)");
        JDBC.assertSingleValueResultSet(rs, "100.0");
        rs = dbos.executeQuery("values s1.lookupWageFootSoldier(1001)");
        JDBC.assertSingleValueResultSet(rs, "-1.0");
        dbos.close();
        dboConn.close();
        c = this.openUserConnection("PHB");
        stm = c.createStatement();
        stm.executeUpdate("set role middlemanager");
        rs = stm.executeQuery("select * from table (s1.selectFootSoldiers()) as t");
        JDBC.assertFullResultSet(rs, new String[][]{{"1002", "2", "100.0", "Dilbert"}});
        rs = stm.executeQuery("values (current_user, session_user, current_role)");
        JDBC.assertFullResultSet(rs, new String[][]{{"PHB", "PHB", "\"MIDDLEMANAGER\""}});
        stm.close();
        c.close();
        c = this.openUserConnection("Dilbert");
        stm = c.createStatement();
        rs = stm.executeQuery("values phb.lookupDilbertWage()");
        JDBC.assertSingleValueResultSet(rs, "100.0");
        rs = stm.executeQuery("values (current_user, session_user, current_role)");
        JDBC.assertFullResultSet(rs, new String[][]{{"DILBERT", "DILBERT", null}});
        stm.close();
        c.close();
    }

    public void testBuiltins() throws SQLException {
        Connection c = this.openUserConnection("PHB");
        Statement stm = c.createStatement();
        stm.executeUpdate("set role middlemanager");
        stm.executeUpdate("call s1.spTestBuiltins()");
        stm.close();
        c.close();
    }

    public void testInvokersRights() throws SQLException {
        Connection c = null;
        ResultSet rs = null;
        Statement stm = null;
        c = this.openUserConnection("Dilbert");
        stm = c.createStatement();
        RoutinesDefinersRightsTest.assertStatementError(new String[]{NOEXECUTEPERMISSION}, stm, "values s1.lookupWageFootSoldierI(1002)");
        stm.close();
        c.close();
        c = this.openUserConnection("PHB");
        stm = c.createStatement();
        RoutinesDefinersRightsTest.assertStatementError(new String[]{NOCOLUMNPERMISSION}, stm, "values s1.lookupWageFootSoldierI(1002)");
        stm.close();
        c.close();
        Connection dboConn = this.getConnection();
        Statement dbos = dboConn.createStatement();
        rs = dbos.executeQuery("values s1.lookupWageFootSoldierI(1002)");
        JDBC.assertSingleValueResultSet(rs, "100.0");
        dbos.close();
        dboConn.close();
        c = this.openUserConnection("PHB");
        stm = c.createStatement();
        stm.executeUpdate("set role middlemanager");
        RoutinesDefinersRightsTest.assertStatementError(new String[]{NOCOLUMNPERMISSION}, stm, "select * from table (s1.selectFootSoldiersI()) as t");
        rs = stm.executeQuery("values (current_user, session_user, current_role)");
        JDBC.assertFullResultSet(rs, new String[][]{{"PHB", "PHB", "\"MIDDLEMANAGER\""}});
        stm.close();
        c.close();
    }

    public static double lookupWageFootSoldier(int employee) throws SQLException {
        Connection c = null;
        c = DriverManager.getConnection("jdbc:default:connection");
        Statement cStmt = c.createStatement();
        ResultSet rs = cStmt.executeQuery("select salary from s1.wages where employeeId=" + employee + " and category = 2");
        if (rs.next()) {
            double result = rs.getDouble(1);
            cStmt.close();
            rs.close();
            c.close();
            return result;
        }
        cStmt.close();
        rs.close();
        c.close();
        return -1.0;
    }

    public static void updateWage() throws SQLException {
        Connection c = null;
        c = DriverManager.getConnection("jdbc:default:connection");
        Statement cStmt = c.createStatement(1004, 1008);
        ResultSet rs = cStmt.executeQuery("select * from s1.wages");
        RoutinesDefinersRightsTest.assertTrue((boolean)rs.isBeforeFirst());
        rs.moveToInsertRow();
        rs.updateInt("EMPLOYEEID", 666);
        rs.updateInt("CATEGORY", 667);
        rs.updateDouble("SALARY", 666.0);
        rs.updateString("NAME", "N.N.");
        rs.insertRow();
        rs.close();
        rs = cStmt.executeQuery("select * from s1.wages where name = 'N.N.'");
        rs.next();
        rs.updateDouble("SALARY", 666.1);
        rs.updateRow();
        rs.close();
        rs = cStmt.executeQuery("select * from s1.wages where name = 'N.N.'");
        rs.next();
        rs.deleteRow();
        rs.close();
        cStmt.close();
        c.close();
    }

    public static ResultSet selectFootSoldiers() throws SQLException {
        Connection c = null;
        c = DriverManager.getConnection("jdbc:default:connection");
        Statement cStmt = c.createStatement();
        ResultSet rs = cStmt.executeQuery("select * from s1.wages where category = 2");
        return rs;
    }

    public static double lookupDilbertWage() throws SQLException {
        Connection c = null;
        c = DriverManager.getConnection("jdbc:default:connection");
        Statement stm = c.createStatement();
        c.commit();
        stm.executeUpdate("set role middlemanager");
        ResultSet rs = stm.executeQuery("values (current_user, session_user, current_role)");
        JDBC.assertFullResultSet(rs, new String[][]{{"PHB", "DILBERT", "\"MIDDLEMANAGER\""}});
        rs = stm.executeQuery("select salary from table (s1.selectFootSoldiers()) as t     where name='Dilbert'");
        rs.next();
        double result = rs.getDouble(1);
        rs.close();
        stm.close();
        c.close();
        return result;
    }

    public static void spTestBuiltins() throws SQLException {
        Connection c = null;
        c = DriverManager.getConnection("jdbc:default:connection");
        Statement cStmt = c.createStatement();
        ResultSet rs = cStmt.executeQuery("values (user, current_user, current schema,         session_user, current_role)");
        JDBC.assertFullResultSet(rs, new String[][]{{"TEST_DBO", "TEST_DBO", "TEST_DBO", "PHB", null}});
        cStmt.close();
        c.close();
    }
}

