/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derby.impl.tools.planexporter.AccessDatabase;
import org.apache.derby.tools.PlanExporter;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.XML;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XplainStatisticsTest
extends BaseJDBCTestCase {
    private static long timeSuiteStarted;
    private static String[] tableNames;

    public XplainStatisticsTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite allTests;
        timeSuiteStarted = new Date().getTime();
        Object test = allTests = new BaseTestSuite(XplainStatisticsTest.class, "XplainStatisticsTest");
        test = new SupportFilesSetup((Test)test);
        return new CleanDatabaseTestSetup((Test)test){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                XplainStatisticsTest.createSchemaObjects(s);
            }
        };
    }

    protected void setUp() throws SQLException {
        this.emptyStatementCache();
    }

    private static void createSchemaObjects(Statement st) throws SQLException {
        st.executeUpdate("CREATE TABLE AIRLINES (      AIRLINE CHAR(2) NOT NULL ,      AIRLINE_FULL VARCHAR(24),      BASIC_RATE DOUBLE PRECISION,      DISTANCE_DISCOUNT DOUBLE PRECISION,      BUSINESS_LEVEL_FACTOR DOUBLE PRECISION,      FIRSTCLASS_LEVEL_FACTOR DOUBLE PRECISION,      ECONOMY_SEATS INTEGER,      BUSINESS_SEATS INTEGER,      FIRSTCLASS_SEATS INTEGER)");
        st.executeUpdate("ALTER TABLE AIRLINES   ADD CONSTRAINT AIRLINES_PK Primary Key (AIRLINE)");
        st.executeUpdate("CREATE TABLE COUNTRIES (      COUNTRY VARCHAR(26) NOT NULL,      COUNTRY_ISO_CODE CHAR(2) NOT NULL ,      REGION VARCHAR(26))");
        st.executeUpdate("ALTER TABLE COUNTRIES   ADD CONSTRAINT COUNTRIES_PK Primary Key (COUNTRY_ISO_CODE)");
        st.executeUpdate("ALTER TABLE COUNTRIES   ADD CONSTRAINT COUNTRIES_UNQ_NM Unique (COUNTRY)");
        st.executeUpdate("CREATE TABLE CITIES (      CITY_ID INTEGER NOT NULL ,      CITY_NAME VARCHAR(24) NOT NULL,\tCOUNTRY VARCHAR(26) NOT NULL,\tAIRPORT VARCHAR(3),\tLANGUAGE  VARCHAR(16),      COUNTRY_ISO_CODE CHAR(2) )");
        st.executeUpdate("ALTER TABLE CITIES   ADD CONSTRAINT CITIES_PK Primary Key (CITY_ID)");
        st.executeUpdate("ALTER TABLE CITIES   ADD CONSTRAINT COUNTRIES_FK Foreign Key (COUNTRY_ISO_CODE)   REFERENCES COUNTRIES (COUNTRY_ISO_CODE)");
        st.executeUpdate("CREATE TABLE FLIGHTS (      FLIGHT_ID CHAR(6) NOT NULL ,      SEGMENT_NUMBER INTEGER NOT NULL ,      ORIG_AIRPORT CHAR(3),      DEPART_TIME TIME,      DEST_AIRPORT CHAR(3),      ARRIVE_TIME TIME,      MEAL CHAR(1),      FLYING_TIME DOUBLE PRECISION,      MILES INTEGER,      AIRCRAFT VARCHAR(6))");
        st.executeUpdate("CREATE INDEX DESTINDEX ON FLIGHTS (DEST_AIRPORT) ");
        st.executeUpdate("CREATE INDEX ORIGINDEX ON FLIGHTS (ORIG_AIRPORT) ");
        st.executeUpdate("ALTER TABLE FLIGHTS   ADD CONSTRAINT FLIGHTS_PK Primary Key (FLIGHT_ID, SEGMENT_NUMBER)");
        st.executeUpdate("CREATE TABLE FLIGHTAVAILABILITY (      FLIGHT_ID CHAR(6) NOT NULL ,      SEGMENT_NUMBER INTEGER NOT NULL ,      FLIGHT_DATE DATE NOT NULL ,      ECONOMY_SEATS_TAKEN INTEGER DEFAULT 0,      BUSINESS_SEATS_TAKEN INTEGER DEFAULT 0,      FIRSTCLASS_SEATS_TAKEN INTEGER DEFAULT 0)");
        st.executeUpdate("ALTER TABLE FLIGHTAVAILABILITY   ADD CONSTRAINT FLIGHTAVAIL_PK Primary Key        (FLIGHT_ID, SEGMENT_NUMBER, FLIGHT_DATE)");
        st.executeUpdate("ALTER TABLE FLIGHTAVAILABILITY   ADD CONSTRAINT FLIGHTS_FK2 Foreign Key (FLIGHT_ID, SEGMENT_NUMBER)   REFERENCES FLIGHTS (FLIGHT_ID, SEGMENT_NUMBER)");
        st.executeUpdate("CREATE TABLE MAPS (      MAP_ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY              (START WITH 1, INCREMENT BY 1),      MAP_NAME VARCHAR(24) NOT NULL,      REGION VARCHAR(26),      AREA DECIMAL(8,4) NOT NULL,      PHOTO_FORMAT VARCHAR(26) NOT NULL,      PICTURE BLOB(102400),      UNIQUE (MAP_ID, MAP_NAME))");
        st.executeUpdate("CREATE TABLE FLIGHTS_HISTORY (      FLIGHT_ID CHAR(6),      SEGMENT_NUMBER INTEGER,      ORIG_AIRPORT CHAR(3),      DEPART_TIME TIME,      DEST_AIRPORT CHAR(3),      ARRIVE_TIME TIME,      MEAL CHAR(1),      FLYING_TIME DOUBLE PRECISION,      MILES INTEGER,      AIRCRAFT VARCHAR(6),       STATUS VARCHAR (20))");
        st.executeUpdate("insert into FLIGHTS values ('AA1111',1,'ABQ','09:00:00','LAX','09:19:00','S',1.328,664,'B747')");
        st.executeUpdate("insert into FLIGHTS values ('AA1112',1,'LAX','09:00:00','ABQ','11:19:00','S',1.328,664,'B747')");
        st.executeUpdate("insert into FLIGHTS values ('AA1113',1,'ABQ','09:00:00','PHX','09:39:00','S',0.658,329,'B747')");
        st.executeUpdate("insert into FLIGHTS values ('AA1114',1,'PHX','09:00:00','ABQ','09:39:00','S',0.658,329,'B747')");
        st.executeUpdate("insert into FLIGHTS values ('AA1115',1,'ABQ','09:00:00','OKC','11:02:00','B',1.034,517,'B747')");
        st.executeUpdate("insert into FLIGHTS values ('AA1116',1,'OKC','09:00:00','ABQ','09:02:00','B',1.034,517,'B747')");
        st.executeUpdate("insert into FLIGHTS values ('AA1117',1,'AKL','09:00:00','HNL','18:48:00','L',8.804,4402,'B747')");
        st.executeUpdate("insert into FLIGHTS values ('AA1118',1,'HNL','13:30:00','AKL','21:18:00','D',8.804,4402,'DC10')");
        st.executeUpdate("insert into FLIGHTS values ('AA1119',1,'AKL','09:00:00','NRT','15:59:00','L',10.996,5498,'B747')");
        st.executeUpdate("insert into FLIGHTS values ('AA1120',1,'NRT','09:00:00','AKL','23:59:00','L',10.996,5498,'B747')");
        st.executeUpdate("insert into COUNTRIES values ( 'Afghanistan','AF','Asia')");
        st.executeUpdate("insert into COUNTRIES values ( 'Albania','AL','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('Algeria','DZ','North Africa')");
        st.executeUpdate("insert into COUNTRIES values ('American Samoa','AS','Pacific Islands')");
        st.executeUpdate("insert into COUNTRIES values ('Angola','AO','Africa')");
        st.executeUpdate("insert into COUNTRIES values ('Argentina','AR','South America')");
        st.executeUpdate("insert into COUNTRIES values ('Armenia','AM','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('Australia','AU','Australia and New Zealand')");
        st.executeUpdate("insert into COUNTRIES values ('Austria','AT','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('Azerbaijan','AZ','Central Asia')");
        st.executeUpdate("insert into COUNTRIES values ('Bahamas','BS','Caribbean')");
        st.executeUpdate("insert into COUNTRIES values ('Bangladesh','BD','Asia')");
        st.executeUpdate("insert into COUNTRIES values ('Barbados','BB','Caribbean')");
        st.executeUpdate("insert into COUNTRIES values ('Belgium','BE','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('Belize','BZ','Central America')");
        st.executeUpdate("insert into COUNTRIES values ('Bermuda','BM','Caribbean')");
        st.executeUpdate("insert into COUNTRIES values ('Bolivia','BO','South America')");
        st.executeUpdate("insert into COUNTRIES values ('Botswana','BW','Africa')");
        st.executeUpdate("insert into COUNTRIES values ('Brazil','BR','South America')");
        st.executeUpdate("insert into COUNTRIES values ('Bulgaria','BG','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('Cambodia','KH','Asia')");
        st.executeUpdate("insert into COUNTRIES values ('Cameroon','CM','Africa')");
        st.executeUpdate("insert into COUNTRIES values ('Canada','CA','North America')");
        st.executeUpdate("insert into COUNTRIES values ('Cape Verde','CV','Africa')");
        st.executeUpdate("insert into COUNTRIES values ('Chile','CL','South America')");
        st.executeUpdate("insert into COUNTRIES values ('China','CN','Asia')");
        st.executeUpdate("insert into COUNTRIES values ('Colombia','CO','South America')");
        st.executeUpdate("insert into COUNTRIES values ('Congo','CG','Africa')");
        st.executeUpdate("insert into COUNTRIES values ('Costa Rica','CR','Central America')");
        st.executeUpdate("insert into COUNTRIES values ('Cote d''Ivoire','CI','Africa')");
        st.executeUpdate("insert into COUNTRIES values ('Cuba','CU','Caribbean')");
        st.executeUpdate("insert into COUNTRIES values ('Czech Republic','CZ','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('Denmark','DK','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('Dominical Republic','DO','Caribbean')");
        st.executeUpdate("insert into COUNTRIES values ('Ecuador','EC','South America')");
        st.executeUpdate("insert into COUNTRIES values ('Egypt','EG','North Africa')");
        st.executeUpdate("insert into COUNTRIES values ('El Salvador','SV','Central America')");
        st.executeUpdate("insert into COUNTRIES values ('Ethiopia','ET','North Africa')");
        st.executeUpdate("insert into COUNTRIES values ('Falkland Islands','FK','South America')");
        st.executeUpdate("insert into COUNTRIES values ('Fiji','FJ','Pacific Islands')");
        st.executeUpdate("insert into COUNTRIES values ('Finland','FI','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('France','FR','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('Georgia','GE','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('Germany','DE','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('Ghana','GH','Africa')");
        st.executeUpdate("insert into COUNTRIES values ('Greece','GR','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('Guadeloupe','GP','Caribbean')");
        st.executeUpdate("insert into COUNTRIES values ('Guatemala','GT','Central America')");
        st.executeUpdate("insert into COUNTRIES values ('Honduras','HN','Central America')");
        st.executeUpdate("insert into COUNTRIES values ('Hungary','HU','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('Iceland','IS','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('India','IN','Asia')");
        st.executeUpdate("insert into COUNTRIES values ('Indonesia','ID','Asia')");
        st.executeUpdate("insert into COUNTRIES values ('Iran','IR','Middle East')");
        st.executeUpdate("insert into COUNTRIES values ('Iraq','IQ','Middle East')");
        st.executeUpdate("insert into COUNTRIES values ('Ireland','IE','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('Israel','IL','Middle East')");
        st.executeUpdate("insert into COUNTRIES values ('Italy','IT','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('Jamaica','JM','Caribbean')");
        st.executeUpdate("insert into COUNTRIES values ('Japan','JP','Asia')");
        st.executeUpdate("insert into COUNTRIES values ('Jordan','JO','Middle East')");
        st.executeUpdate("insert into COUNTRIES values ('Kenya','KE','Africa')");
        st.executeUpdate("insert into COUNTRIES values ('Korea, Republic of','KR','Asia')");
        st.executeUpdate("insert into COUNTRIES values ('Lebanon','LB','Middle East')");
        st.executeUpdate("insert into COUNTRIES values ('Lithuania','LT','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('Madagascar','MG','Africa')");
        st.executeUpdate("insert into COUNTRIES values ('Malaysia','MY','Asia')");
        st.executeUpdate("insert into COUNTRIES values ('Mali','ML','Africa')");
        st.executeUpdate("insert into COUNTRIES values ('Mexico','MX','North America')");
        st.executeUpdate("insert into COUNTRIES values ('Morocco','MA','North Africa')");
        st.executeUpdate("insert into COUNTRIES values ('Mozambique','MZ','Africa')");
        st.executeUpdate("insert into COUNTRIES values ('Nepal','NP','Asia')");
        st.executeUpdate("insert into COUNTRIES values ('Netherlands','NL','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('New Zealand','NZ','Australia and New Zealand')");
        st.executeUpdate("insert into COUNTRIES values ('Nicaragua','NI','Central America')");
        st.executeUpdate("insert into COUNTRIES values ('Nigeria','NG','Africa')");
        st.executeUpdate("insert into COUNTRIES values ('Norway','NO','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('Pakistan','PK','Central Asia')");
        st.executeUpdate("insert into COUNTRIES values ('Paraguay','PY','South America')");
        st.executeUpdate("insert into COUNTRIES values ('Peru','PE','South America')");
        st.executeUpdate("insert into COUNTRIES values ('Philippines','PH','Asia')");
        st.executeUpdate("insert into COUNTRIES values ('Poland','PL','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('Portugal','PT','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('Russia','RU','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('Samoa','WS','Pacific Islands')");
        st.executeUpdate("insert into COUNTRIES values ('Senegal','SN','Africa')");
        st.executeUpdate("insert into COUNTRIES values ('Sierra Leone','SL','Africa')");
        st.executeUpdate("insert into COUNTRIES values ('Singapore','SG','Asia')");
        st.executeUpdate("insert into COUNTRIES values ('Slovakia','SK','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('South Africa','ZA','Africa')");
        st.executeUpdate("insert into COUNTRIES values ('Spain','ES','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('Sri Lanka','LK','Asia')");
        st.executeUpdate("insert into COUNTRIES values ('Sudan','SD','Africa')");
        st.executeUpdate("insert into COUNTRIES values ('Sweden','SE','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('Switzerland','CH','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('Syrian Arab Republic','SY','Middle East')");
        st.executeUpdate("insert into COUNTRIES values ('Tajikistan','TJ','Central Asia')");
        st.executeUpdate("insert into COUNTRIES values ('Tanzania','TZ','Africa')");
        st.executeUpdate("insert into COUNTRIES values ('Thailand','TH','Asia')");
        st.executeUpdate("insert into COUNTRIES values ('Trinidad and Tobago','TT','Caribbean')");
        st.executeUpdate("insert into COUNTRIES values ('Tunisia','TN','North Africa')");
        st.executeUpdate("insert into COUNTRIES values ('Turkey','TR','Middle East')");
        st.executeUpdate("insert into COUNTRIES values ('Ukraine','UA','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('United Kingdom','GB','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('United States','US','North America')");
        st.executeUpdate("insert into COUNTRIES values ('Uruguay','UY','South America')");
        st.executeUpdate("insert into COUNTRIES values ('Uzbekistan','UZ','Central Asia')");
        st.executeUpdate("insert into COUNTRIES values ('Venezuela','VE','South America')");
        st.executeUpdate("insert into COUNTRIES values ('Viet Nam','VN','Asia')");
        st.executeUpdate("insert into COUNTRIES values ('Virgin Islands (British)','VG','Caribbean')");
        st.executeUpdate("insert into COUNTRIES values ('Virgin Islands (U.S.)','VI','Caribbean')");
        st.executeUpdate("insert into COUNTRIES values ('Yugoslavia','YU','Europe')");
        st.executeUpdate("insert into COUNTRIES values ('Zaire','ZR','Africa')");
        st.executeUpdate("insert into COUNTRIES values ('Zimbabwe','ZW','Africa')");
        st.executeUpdate("create table t (x int not null primary key, y char(250))");
        st.executeUpdate("insert into t values (1, 'a'), (2,'b'), (3,'c'), (4,'d')");
        st.executeUpdate("delete from t where x = 3");
    }

    private static boolean hasTable(Statement s, String schemaName, String tableName) throws SQLException {
        ResultSet rs = s.getConnection().getMetaData().getTables(null, schemaName, tableName, new String[]{"TABLE"});
        boolean tableFound = rs.next();
        rs.close();
        return tableFound;
    }

    private static void enableXplainStyle(Statement s) throws SQLException {
        XplainStatisticsTest.verifyXplainUnset(s);
        for (int i = 0; i < tableNames.length; ++i) {
            if (!XplainStatisticsTest.hasTable(s, "XPLTEST", tableNames[i])) continue;
            s.execute("delete from XPLTEST." + tableNames[i]);
        }
        s.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        s.execute("call syscs_util.syscs_set_xplain_schema('XPLTEST')");
        s.execute("call syscs_util.syscs_set_xplain_mode(0)");
    }

    private static void enableXplainStyleWithTiming(Statement s) throws SQLException {
        XplainStatisticsTest.enableXplainStyle(s);
        s.execute("call syscs_util.syscs_set_statistics_timing(1)");
    }

    private static void enableXplainOnlyMode(Statement s) throws SQLException {
        s.execute("call syscs_util.syscs_set_xplain_mode(1)");
    }

    private static void clearXplainOnlyMode(Statement s) throws SQLException {
        s.execute("call syscs_util.syscs_set_xplain_mode(0)");
    }

    private static void disableXplainStyle(Statement s, boolean exportPlan) throws Exception {
        s.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)");
        if (exportPlan) {
            String dbUrl = s.getConnection().getMetaData().getURL();
            ResultSet rs = s.executeQuery("select stmt_id from XPLTEST.sysxplain_statements");
            while (rs.next()) {
                String stmt_id = rs.getString(1);
                String output = XplainStatisticsTest.invokePlanExporterTool(dbUrl, "XPLTEST", stmt_id, "-xml", SupportFilesSetup.getReadWriteFileName(stmt_id + ".xml"));
                XplainStatisticsTest.assertEquals((String)"Unexpected output from PlanExporter", (String)"", (String)output);
            }
        }
        s.execute("call syscs_util.syscs_set_xplain_schema('')");
    }

    private static void verifyXplainUnset(Statement s) throws SQLException {
        JDBC.assertFullResultSet(s.executeQuery("values SYSCS_UTIL.syscs_get_xplain_schema()"), new String[][]{{""}});
        JDBC.assertFullResultSet(s.executeQuery("values SYSCS_UTIL.syscs_get_xplain_mode()"), new String[][]{{"0"}});
    }

    private void verifyNonNullDRDA_ID(Statement s) throws SQLException {
        ResultSet rs = s.executeQuery("select drda_id from xpltest.sysxplain_statements");
        while (rs.next()) {
            String drda_id = rs.getString("DRDA_ID");
            if (!rs.wasNull() && drda_id != null && drda_id.trim().length() != 0) continue;
            XplainStatisticsTest.fail((String)"While running in a network-client configuration, DRDA_ID was null or blank.");
        }
        rs.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String invokePlanExporterTool(String ... args) {
        PrintStream out = System.out;
        PrintStream err = System.err;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        PrintStream testOutput = new PrintStream(byteOut);
        XplainStatisticsTest.setSystemOut(testOutput);
        XplainStatisticsTest.setSystemErr(testOutput);
        try {
            PlanExporter.main((String[])args);
        }
        finally {
            XplainStatisticsTest.setSystemOut(out);
            XplainStatisticsTest.setSystemErr(err);
        }
        testOutput.flush();
        return byteOut.toString();
    }

    private void dumpResultSets(Statement s) throws SQLException {
        ResultSet rs = s.executeQuery("select * from xpltest.sysxplain_resultsets");
        while (rs.next()) {
            System.out.println(rs.getString("rs_id") + "," + rs.getString("op_identifier") + "," + rs.getString("op_details") + "," + rs.getString("no_opens") + "," + rs.getString("no_index_updates") + "," + rs.getString("lock_mode") + "," + rs.getString("lock_granularity") + "," + rs.getString("parent_rs_id") + "," + rs.getString("est_row_count") + "," + rs.getString("est_cost") + "," + rs.getString("affected_rows") + "," + rs.getString("deferred_rows") + "," + rs.getString("input_rows") + "," + rs.getString("seen_rows") + "," + rs.getString("seen_rows_right") + "," + rs.getString("filtered_rows") + "," + rs.getString("returned_rows") + "," + rs.getString("empty_right_rows") + "," + rs.getString("index_key_opt") + "," + rs.getString("scan_rs_id") + "," + rs.getString("sort_rs_id") + "," + rs.getString("stmt_id") + "," + rs.getString("timing_id"));
        }
        rs.close();
    }

    private void dumpStatements(Statement s) throws SQLException {
        ResultSet rs = s.executeQuery("select * from xpltest.sysxplain_statements");
        while (rs.next()) {
            System.out.println(rs.getString("stmt_id") + "," + rs.getString("stmt_name") + "," + rs.getString("stmt_type") + "," + rs.getString("stmt_text") + "," + rs.getString("jvm_id") + "," + rs.getString("os_identifier") + "," + rs.getString("xplain_mode") + "," + rs.getString("xplain_time") + "," + rs.getString("xplain_thread_id") + "," + rs.getString("transaction_id") + "," + rs.getString("session_id") + "," + rs.getString("database_name") + "," + rs.getString("drda_id") + "," + rs.getString("timing_id"));
        }
        rs.close();
    }

    private String getStmtID(Statement s) throws SQLException {
        ResultSet rs = s.executeQuery("select stmt_id from XPLTEST.sysxplain_statements");
        rs.next();
        String stmt_id = rs.getString(1);
        rs.close();
        return stmt_id;
    }

    private String[] getStmtIDArray(Statement s, int length) throws SQLException {
        String[] stmt_id = new String[length];
        int i = 0;
        ResultSet rs = s.executeQuery("select stmt_id from XPLTEST.sysxplain_statements");
        while (rs.next()) {
            stmt_id[i] = rs.getString(1);
            if (++i != length) continue;
            XplainStatisticsTest.assertFalse((boolean)rs.next());
        }
        rs.close();
        return stmt_id;
    }

    private Object getADocument(String file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource xml = new InputSource(new FileInputStream(SupportFilesSetup.getReadWriteURL(file + ".xml").getPath()));
        Document document = builder.parse(xml);
        document.getDocumentElement().normalize();
        return document;
    }

    private String readStatement(String file) throws Exception {
        Document document = (Document)this.getADocument(file);
        return document.getElementsByTagName("statement").item(0).getChildNodes().item(0).getNodeValue();
    }

    private int countNode(String file) throws Exception {
        Document document = (Document)this.getADocument(file);
        return document.getElementsByTagName("node").getLength();
    }

    private String getNodeName(String file) throws Exception {
        Document document = (Document)this.getADocument(file);
        NodeList lst = document.getElementsByTagName("node");
        Object name = "";
        for (int i = 0; i < lst.getLength(); ++i) {
            name = (String)name + lst.item(i).getAttributes().getNamedItem("name").getNodeValue() + "|";
        }
        return name;
    }

    private String getNodeAttribute(String file, String attribute, int node) throws Exception {
        Document document = (Document)this.getADocument(file);
        NodeList lst = document.getElementsByTagName("node");
        if (lst.item(node).getAttributes().getNamedItem(attribute) == null) {
            return "";
        }
        return lst.item(node).getAttributes().getNamedItem(attribute).getNodeValue();
    }

    public void testPlanExporterSchemaExistence() throws Exception {
        AccessDatabase access = new AccessDatabase(this.getConnection(), "NoSuchSchema", "nostmt");
        XplainStatisticsTest.assertTrue((String)"Unexpectedly thought schema exists", (!access.verifySchemaExistance() ? 1 : 0) != 0);
    }

    public void testPlanExporterSpecialCharactersInSchema() throws Exception {
        String schema = "DERBY-4904 \"double\" and 'single' quoted schema";
        String query = "select * from sysibm.sysdummy1";
        PreparedStatement setStats = this.prepareStatement("call syscs_util.syscs_set_runtimestatistics(?)");
        PreparedStatement setXplain = this.prepareStatement("call syscs_util.syscs_set_xplain_schema(?)");
        setStats.setInt(1, 1);
        setStats.execute();
        setXplain.setString(1, schema);
        setXplain.execute();
        Statement s = this.createStatement();
        JDBC.assertSingleValueResultSet(s.executeQuery(query), "Y");
        setStats.setInt(1, 0);
        setStats.execute();
        setXplain.setString(1, "");
        setXplain.execute();
        ResultSet rs = s.executeQuery("select stmt_id, stmt_text from " + JDBC.escape(schema, "SYSXPLAIN_STATEMENTS"));
        XplainStatisticsTest.assertTrue((boolean)rs.next());
        String stmtId = rs.getString(1);
        XplainStatisticsTest.assertEquals((String)query, (String)rs.getString(2));
        XplainStatisticsTest.assertFalse((boolean)rs.next());
        rs.close();
        String output = XplainStatisticsTest.invokePlanExporterTool(this.getConnection().getMetaData().getURL(), schema, stmtId, "-xml", SupportFilesSetup.getReadWriteFileName(stmtId + ".xml"));
        XplainStatisticsTest.assertEquals((String)"Unexpected output from PlanExporter", (String)"", (String)output);
        if (XML.classpathMeetsXMLReqs()) {
            XplainStatisticsTest.assertEquals((String)query, (String)this.readStatement(stmtId));
        }
    }

    public void testSimpleQueryMultiWithInvalidation() throws Exception {
        long runTime = 10000L;
        MTSimpleSelect select = new MTSimpleSelect(this.openDefaultConnection(), runTime);
        MTSimpleInvalidate invalidate = new MTSimpleInvalidate(this.openDefaultConnection(), runTime);
        Thread tInv = new Thread(invalidate);
        Thread tSel = new Thread(select);
        tInv.start();
        tSel.start();
        tInv.join();
        tSel.join();
        int selects = select.getActionCount();
        int invalidations = invalidate.getActionCount();
        XplainStatisticsTest.println("selects=" + selects + ", invalidations=" + invalidations);
        if (select.failed()) {
            XplainStatisticsTest.fail("select-thread failed", select.getError());
        }
        if (invalidate.failed()) {
            XplainStatisticsTest.fail("invalidate-thread failed", invalidate.getError());
        }
        Statement s = this.createStatement();
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_statements"), Integer.toString(selects));
    }

    public void testSimpleQuery() throws Exception {
        Statement s = this.createStatement();
        XplainStatisticsTest.enableXplainStyleWithTiming(s);
        String selectStatement = "SELECT country from countries WHERE region = 'Central America'";
        JDBC.assertUnorderedResultSet(s.executeQuery(selectStatement), new String[][]{{"Belize"}, {"Costa Rica"}, {"El Salvador"}, {"Guatemala"}, {"Honduras"}, {"Nicaragua"}});
        XplainStatisticsTest.disableXplainStyle(s, true);
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_statements"), "1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_statement_timings"), "1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_resultsets"), "2");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_resultset_timings"), "2");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_scan_props"), "1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_sort_props"), "0");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_statements  where stmt_text like '%from countries%' "), "1");
        JDBC.assertUnorderedResultSet(s.executeQuery("select op_identifier from xpltest.sysxplain_resultsets"), new String[][]{{"PROJECTION"}, {"TABLESCAN"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select stmt_type, stmt_text, xplain_mode  from xpltest.sysxplain_statements"), new String[][]{{"S", selectStatement, "F"}});
        if (!XplainStatisticsTest.usingDerbyNetClient()) {
            JDBC.assertSingleValueResultSet(s.executeQuery("select drda_id from xpltest.sysxplain_statements"), null);
        } else {
            this.verifyNonNullDRDA_ID(s);
        }
        JDBC.assertSingleValueResultSet(s.executeQuery("select no_opens from xpltest.sysxplain_resultsets where op_identifier = 'TABLESCAN'"), "1");
        JDBC.assertUnorderedResultSet(s.executeQuery("select no_opens, seen_rows, returned_rows,        lock_mode, lock_granularity from xpltest.sysxplain_resultsets where op_identifier = 'TABLESCAN'"), new String[][]{{"1", "6", "6", "IS", "R"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select sp.scan_object_name, sp.scan_object_type, sp.scan_type, sp.isolation_level, sp.no_visited_rows, sp.no_qualified_rows, sp.no_visited_pages, sp.no_fetched_columns, sp.bitset_of_fetched_columns from xpltest.sysxplain_scan_props sp join xpltest.sysxplain_resultsets rs on sp.scan_rs_id = rs.scan_rs_id where rs.op_identifier='TABLESCAN'"), new String[][]{{"COUNTRIES", "T", "HEAP", "RC", "114", "6", "2", "2", "{0, 2}"}});
        JDBC.assertSingleValueResultSet(s.executeQuery("select sp.no_visited_rows from xpltest.sysxplain_scan_props sp,      xpltest.sysxplain_resultsets rs,      xpltest.sysxplain_statements st where st.stmt_id = rs.stmt_id and      rs.scan_rs_id = sp.scan_rs_id and      rs.op_identifier = 'TABLESCAN' and      sp.scan_object_name = 'COUNTRIES'"), "114");
        this.verifySensibleStatementTimings(s);
        this.verifySensibleResultSetTimings(s);
        if (XML.classpathMeetsXMLReqs()) {
            String stmt_id = this.getStmtID(s);
            Assert.assertEquals((String)selectStatement, (String)this.readStatement(stmt_id));
            Assert.assertEquals((int)2, (int)this.countNode(stmt_id));
            Assert.assertEquals((String)"PROJECTION|TABLESCAN|", (String)this.getNodeName(stmt_id));
            Assert.assertEquals((String)"COUNTRIES", (String)this.getNodeAttribute(stmt_id, "scanned_object", 1));
            Assert.assertEquals((String)"HEAP", (String)this.getNodeAttribute(stmt_id, "scan_type", 1));
            Assert.assertEquals((String)"2", (String)this.getNodeAttribute(stmt_id, "visited_pages", 1));
        }
    }

    private String getStmtIDByName(Statement s, String sName) throws SQLException {
        String stmt_id = "?";
        ResultSet rs = s.executeQuery("select stmt_id from XPLTEST.sysxplain_statements where stmt_name='" + sName + "'");
        if (rs.next()) {
            stmt_id = rs.getString(1);
        }
        rs.close();
        return stmt_id;
    }

    public void testSimpleXplainOnly() throws Exception {
        Statement s = this.createStatement();
        XplainStatisticsTest.enableXplainStyle(s);
        XplainStatisticsTest.enableXplainOnlyMode(s);
        s.setCursorName("1");
        JDBC.assertEmpty(s.executeQuery("SELECT country from countries WHERE region = 'Central America'"));
        XplainStatisticsTest.clearXplainOnlyMode(s);
        XplainStatisticsTest.disableXplainStyle(s, true);
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_statements"), "1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_statements where stmt_name='1'"), "1");
        String stmt_id = this.getStmtIDByName(s, "1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_resultsets where stmt_id='" + stmt_id + "'"), "2");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_resultsets where stmt_id='" + stmt_id + "' and op_identifier='PROJECTION'"), "1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_resultsets where stmt_id='" + stmt_id + "' and op_identifier='TABLESCAN'"), "1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select op_details from xpltest.sysxplain_resultsets where stmt_id='" + stmt_id + "' and op_identifier='TABLESCAN'"), "T: COUNTRIES");
        XplainStatisticsTest.enableXplainStyle(s);
        XplainStatisticsTest.enableXplainOnlyMode(s);
        s.setCursorName("2");
        JDBC.assertEmpty(s.executeQuery("select sql_text from syscs_diag.transaction_table where status != 'IDLE'"));
        XplainStatisticsTest.clearXplainOnlyMode(s);
        XplainStatisticsTest.disableXplainStyle(s, true);
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_statements"), "1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_statements where stmt_name='2'"), "1");
        stmt_id = this.getStmtIDByName(s, "2");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_resultsets where stmt_id='" + stmt_id + "' and op_identifier='PROJECTION'"), "1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_resultsets where stmt_id='" + stmt_id + "' and       op_identifier='PROJECT-FILTER'"), "1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_resultsets where stmt_id='" + stmt_id + "' and op_identifier='VTI'"), "1");
        String selectStatement = "select region, count(country) from app.countries group by region";
        XplainStatisticsTest.enableXplainStyle(s);
        XplainStatisticsTest.enableXplainOnlyMode(s);
        s.setCursorName("3");
        JDBC.assertEmpty(s.executeQuery(selectStatement));
        XplainStatisticsTest.clearXplainOnlyMode(s);
        XplainStatisticsTest.disableXplainStyle(s, true);
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_resultsets"), "4");
        JDBC.assertFullResultSet(s.executeQuery("select op_identifier from xpltest.sysxplain_resultsets order by op_identifier"), new String[][]{{"GROUPBY"}, {"PROJECTION"}, {"PROJECTION"}, {"TABLESCAN"}});
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_resultsets where scan_rs_id is not null"), "1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_resultsets where sort_rs_id is not null"), "1");
        JDBC.assertFullResultSet(s.executeQuery("select s.stmt_text, rs.op_identifier, srt.no_input_rows, srt.no_output_rows  from xpltest.sysxplain_sort_props srt,  xpltest.sysxplain_resultsets rs,  xpltest.sysxplain_statements s  where rs.stmt_id = s.stmt_id and  rs.sort_rs_id = srt.sort_rs_id"), new String[][]{{selectStatement, "GROUPBY", "0", "0"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select srt.sort_type, srt.no_input_rows,  srt.no_output_rows, srt.no_merge_runs,  srt.merge_run_details, srt.eliminate_duplicates,  srt.in_sort_order, srt.distinct_aggregate from xpltest.sysxplain_sort_props srt join xpltest.sysxplain_resultsets rs on srt.sort_rs_id = rs.sort_rs_id where rs.op_identifier='GROUPBY'"), new String[][]{{"IN", "0", "0", null, null, null, "N", "N"}});
    }

    public void testXplainOnlyExecutePrepared() throws Exception {
        Statement s = this.createStatement();
        String selectStatement = "select region, count(country) from app.countries group by region";
        PreparedStatement ps = this.prepareStatement(selectStatement);
        XplainStatisticsTest.enableXplainStyle(s);
        XplainStatisticsTest.enableXplainOnlyMode(s);
        JDBC.assertEmpty(ps.executeQuery());
        XplainStatisticsTest.clearXplainOnlyMode(s);
        XplainStatisticsTest.disableXplainStyle(s, true);
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_resultsets"), "4");
        JDBC.assertFullResultSet(s.executeQuery("select op_identifier from xpltest.sysxplain_resultsets order by op_identifier"), new String[][]{{"GROUPBY"}, {"PROJECTION"}, {"PROJECTION"}, {"TABLESCAN"}});
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_resultsets where scan_rs_id is not null"), "1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_resultsets where sort_rs_id is not null"), "1");
        JDBC.assertFullResultSet(s.executeQuery("select s.stmt_text, rs.op_identifier, srt.no_input_rows, srt.no_output_rows  from xpltest.sysxplain_sort_props srt,  xpltest.sysxplain_resultsets rs,  xpltest.sysxplain_statements s  where rs.stmt_id = s.stmt_id and  rs.sort_rs_id = srt.sort_rs_id"), new String[][]{{selectStatement, "GROUPBY", "0", "0"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select srt.sort_type, srt.no_input_rows,  srt.no_output_rows, srt.no_merge_runs,  srt.merge_run_details, srt.eliminate_duplicates,  srt.in_sort_order, srt.distinct_aggregate from xpltest.sysxplain_sort_props srt join xpltest.sysxplain_resultsets rs on srt.sort_rs_id = rs.sort_rs_id where rs.op_identifier='GROUPBY'"), new String[][]{{"IN", "0", "0", null, null, null, "N", "N"}});
        JDBC.assertUnorderedResultSet(ps.executeQuery(), new String[][]{{"Africa", "19"}, {"Asia", "15"}, {"Australia and New Zealand", "2"}, {"Caribbean", "10"}, {"Central America", "6"}, {"Central Asia", "4"}, {"Europe", "29"}, {"Middle East", "7"}, {"North Africa", "5"}, {"North America", "3"}, {"Pacific Islands", "3"}, {"South America", "11"}});
        XplainStatisticsTest.enableXplainStyle(s);
        XplainStatisticsTest.enableXplainOnlyMode(s);
        JDBC.assertEmpty(ps.executeQuery());
        XplainStatisticsTest.clearXplainOnlyMode(s);
        XplainStatisticsTest.disableXplainStyle(s, true);
        JDBC.assertDrainResults(s.executeQuery("select * from xpltest.sysxplain_statements"), 1);
    }

    public void testXplainOnlyPrepared() throws Exception {
        Statement s = this.createStatement();
        String selectStatement = "select region, count(country) from app.countries group by region";
        XplainStatisticsTest.enableXplainStyle(s);
        XplainStatisticsTest.enableXplainOnlyMode(s);
        PreparedStatement ps2 = this.prepareStatement(selectStatement);
        XplainStatisticsTest.clearXplainOnlyMode(s);
        JDBC.assertUnorderedResultSet(ps2.executeQuery(), new String[][]{{"Africa", "19"}, {"Asia", "15"}, {"Australia and New Zealand", "2"}, {"Caribbean", "10"}, {"Central America", "6"}, {"Central Asia", "4"}, {"Europe", "29"}, {"Middle East", "7"}, {"North Africa", "5"}, {"North America", "3"}, {"Pacific Islands", "3"}, {"South America", "11"}});
        XplainStatisticsTest.disableXplainStyle(s, true);
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_resultsets"), "4");
        JDBC.assertFullResultSet(s.executeQuery("select op_identifier from xpltest.sysxplain_resultsets order by op_identifier"), new String[][]{{"GROUPBY"}, {"PROJECTION"}, {"PROJECTION"}, {"TABLESCAN"}});
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_resultsets where scan_rs_id is not null"), "1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_resultsets where sort_rs_id is not null"), "1");
        JDBC.assertFullResultSet(s.executeQuery("select s.stmt_text, rs.op_identifier, srt.no_input_rows, srt.no_output_rows  from xpltest.sysxplain_sort_props srt,  xpltest.sysxplain_resultsets rs,  xpltest.sysxplain_statements s  where rs.stmt_id = s.stmt_id and  rs.sort_rs_id = srt.sort_rs_id"), new String[][]{{selectStatement, "GROUPBY", "114", "12"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select srt.sort_type, srt.no_input_rows,  srt.no_output_rows, srt.no_merge_runs,  srt.merge_run_details, srt.eliminate_duplicates,  srt.in_sort_order, srt.distinct_aggregate from xpltest.sysxplain_sort_props srt join xpltest.sysxplain_resultsets rs on srt.sort_rs_id = rs.sort_rs_id where rs.op_identifier='GROUPBY'"), new String[][]{{"IN", "114", "12", null, null, null, "N", "N"}});
    }

    private void verifySensibleStatementTimings(Statement s) throws SQLException {
        ResultSet rs = s.executeQuery("select * from xpltest.sysxplain_statement_timings");
        while (rs.next()) {
            long parseTime = this.getNonNegativeLong(rs, "PARSE_TIME");
            long bindTime = this.getNonNegativeLong(rs, "BIND_TIME");
            long optimizeTime = this.getNonNegativeLong(rs, "OPTIMIZE_TIME");
            long generateTime = this.getNonNegativeLong(rs, "GENERATE_TIME");
            long compileTime = this.getNonNegativeLong(rs, "COMPILE_TIME");
            long executeTime = this.getNonNegativeLong(rs, "EXECUTE_TIME");
            long compTimeRoundingError = compileTime - (parseTime + bindTime + optimizeTime + generateTime);
            if (compTimeRoundingError < 0L || compTimeRoundingError > 2L) {
                XplainStatisticsTest.assertEquals((String)("compilation time did not compute (" + parseTime + "," + bindTime + "," + optimizeTime + "," + generateTime + ")"), (long)compileTime, (long)(parseTime + bindTime + optimizeTime + generateTime));
            }
            Timestamp beginCompTime = this.getNonNullTimestamp(rs, "BEGIN_COMP_TIME");
            Timestamp endCompTime = this.getNonNullTimestamp(rs, "END_COMP_TIME");
            Timestamp beginExeTime = this.getNonNullTimestamp(rs, "BEGIN_EXE_TIME");
            Timestamp endExeTime = this.getNonNullTimestamp(rs, "END_EXE_TIME");
            if (endCompTime.before(beginCompTime)) {
                XplainStatisticsTest.fail((String)("END_COMP_TIME " + endCompTime + " unexpectedly before BEGIN_COMP_TIME " + beginCompTime));
            }
            if (beginExeTime.before(endCompTime)) {
                XplainStatisticsTest.fail((String)("BEGIN_EXE_TIME " + beginExeTime + " unexpectedly before END_COMP_TIME " + endCompTime));
            }
            if (!endExeTime.before(beginExeTime)) continue;
            XplainStatisticsTest.fail((String)("END_EXE_TIME " + endExeTime + " unexpectedly before BEGIN_EXE_TIME " + beginExeTime));
        }
        rs.close();
    }

    private void verifySensibleResultSetTimings(Statement s) throws SQLException {
        ResultSet rs = s.executeQuery("select rs.op_identifier, rs.returned_rows, rt.* from xpltest.sysxplain_resultsets rs left outer join      xpltest.sysxplain_resultset_timings rt on rs.timing_id = rt.timing_id");
        while (rs.next()) {
            String opIdentifier = rs.getString("OP_IDENTIFIER");
            String timingId = rs.getString("TIMING_ID");
            XplainStatisticsTest.assertNotNull((String)("RESULTSET row missing for " + opIdentifier), (Object)timingId);
            this.getNonNegativeLong(rs, "CONSTRUCTOR_TIME");
            this.getNonNegativeLong(rs, "OPEN_TIME");
            this.getNonNegativeLong(rs, "NEXT_TIME");
            this.getNonNegativeLong(rs, "CLOSE_TIME");
            long returnedRows = rs.getLong("RETURNED_ROWS");
            if (returnedRows > 0L) {
                this.getNonNegativeLong(rs, "AVG_NEXT_TIME_PER_ROW");
            } else {
                long avgNextTimePerRow = rs.getLong("AVG_NEXT_TIME_PER_ROW");
                XplainStatisticsTest.assertTrue((String)("Expected NULL for avg-next on rs " + opIdentifier), (boolean)rs.wasNull());
            }
            if (opIdentifier.equals("PROJECTION")) {
                this.getNonNegativeLong(rs, "PROJECTION_TIME");
                this.getNonNegativeLong(rs, "RESTRICTION_TIME");
            } else {
                rs.getLong("PROJECTION_TIME");
                XplainStatisticsTest.assertTrue((String)("Expected NULL PROJECTION_TIME for " + opIdentifier), (boolean)rs.wasNull());
                rs.getLong("RESTRICTION_TIME");
                XplainStatisticsTest.assertTrue((String)("Expected NULL RESTRICTION_TIME for " + opIdentifier), (boolean)rs.wasNull());
            }
            if (opIdentifier.equals("MATERIALIZE")) {
                this.getNonNegativeLong(rs, "TEMP_CONG_CREATE_TIME");
                this.getNonNegativeLong(rs, "TEMP_CONG_FETCH_TIME");
                continue;
            }
            rs.getLong("TEMP_CONG_CREATE_TIME");
            XplainStatisticsTest.assertTrue((String)("Expected NULL TEMP_CONG_CREATE_TIME for " + opIdentifier), (boolean)rs.wasNull());
            rs.getLong("TEMP_CONG_FETCH_TIME");
            XplainStatisticsTest.assertTrue((String)("Expected NULL TEMP_CONG_FETCH_TIME for " + opIdentifier), (boolean)rs.wasNull());
        }
    }

    private long getNonNegativeLong(ResultSet rs, String cName) throws SQLException {
        long result = rs.getLong(cName);
        XplainStatisticsTest.assertTrue((String)(cName + " unexpectedly NULL"), (!rs.wasNull() ? 1 : 0) != 0);
        XplainStatisticsTest.assertTrue((String)(cName + " unexpectedly negative(" + result + ")"), (result >= 0L ? 1 : 0) != 0);
        return result;
    }

    private Timestamp getNonNullTimestamp(ResultSet rs, String cName) throws SQLException {
        Timestamp result = rs.getTimestamp(cName);
        XplainStatisticsTest.assertTrue((String)(cName + " unexpectedly NULL"), (!rs.wasNull() ? 1 : 0) != 0);
        XplainStatisticsTest.assertNotNull((String)(cName + " unexpectedly NULL"), (Object)result);
        XplainStatisticsTest.assertTrue((String)("Test started at " + timeSuiteStarted + " but " + cName + " value is " + result.getTime()), (result.getTime() >= timeSuiteStarted ? 1 : 0) != 0);
        return result;
    }

    public void testIndexScan() throws Exception {
        Statement s = this.createStatement();
        XplainStatisticsTest.enableXplainStyleWithTiming(s);
        String selectStatement = "SELECT flight_id from flights where dest_airport = 'ABQ'";
        JDBC.assertUnorderedResultSet(s.executeQuery(selectStatement), new String[][]{{"AA1112"}, {"AA1114"}, {"AA1116"}});
        XplainStatisticsTest.disableXplainStyle(s, true);
        JDBC.assertUnorderedResultSet(s.executeQuery("select op_identifier from xpltest.sysxplain_resultsets"), new String[][]{{"PROJECTION"}, {"ROWIDSCAN"}, {"INDEXSCAN"}});
        JDBC.assertSingleValueResultSet(s.executeQuery("select p.parent_rs_id  from xpltest.sysxplain_resultsets p,       xpltest.sysxplain_resultsets r,       xpltest.sysxplain_resultsets i   where p.rs_id = r.parent_rs_id and        r.rs_id = i.parent_rs_id and        p.op_identifier='PROJECTION' and        r.op_identifier='ROWIDSCAN' and        i.op_identifier='INDEXSCAN'"), null);
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(rs.op_identifier)  from xpltest.sysxplain_statements st  join xpltest.sysxplain_resultsets rs    on st.stmt_id = rs.stmt_id"), "3");
        JDBC.assertUnorderedResultSet(s.executeQuery("select sp.scan_object_name, sp.scan_object_type, sp.scan_type, sp.isolation_level, rs.lock_mode, rs.lock_granularity, sp.no_visited_rows, sp.no_qualified_rows, sp.no_visited_pages, sp.btree_height, sp.fetch_size, sp.no_fetched_columns, sp.bitset_of_fetched_columns from xpltest.sysxplain_scan_props sp join xpltest.sysxplain_resultsets rs on sp.scan_rs_id = rs.scan_rs_id where rs.op_identifier='INDEXSCAN'"), new String[][]{{"DESTINDEX", "I", "BTREE", "RC", "IS", "R", "4", "3", "1", "-1", "16", "2", "ALL"}});
        this.verifySensibleStatementTimings(s);
        this.verifySensibleResultSetTimings(s);
        if (XML.classpathMeetsXMLReqs()) {
            String stmt_id = this.getStmtID(s);
            Assert.assertEquals((String)selectStatement, (String)this.readStatement(stmt_id));
            Assert.assertEquals((int)3, (int)this.countNode(stmt_id));
            Assert.assertEquals((String)"PROJECTION|ROWIDSCAN|INDEXSCAN|", (String)this.getNodeName(stmt_id));
            Assert.assertEquals((String)"DESTINDEX", (String)this.getNodeAttribute(stmt_id, "scanned_object", 2));
            Assert.assertEquals((String)"BTREE", (String)this.getNodeAttribute(stmt_id, "scan_type", 2));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(stmt_id, "visited_pages", 2));
        }
    }

    public void testConstraintScan() throws Exception {
        Statement s = this.createStatement();
        XplainStatisticsTest.enableXplainStyle(s);
        String selectStatement = "SELECT region from countries where country = 'Cameroon'";
        JDBC.assertSingleValueResultSet(s.executeQuery(selectStatement), "Africa");
        XplainStatisticsTest.disableXplainStyle(s, true);
        JDBC.assertUnorderedResultSet(s.executeQuery("select op_identifier from xpltest.sysxplain_resultsets"), new String[][]{{"PROJECTION"}, {"ROWIDSCAN"}, {"CONSTRAINTSCAN"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select sp.scan_object_name, sp.scan_object_type, sp.scan_type, sp.isolation_level, sp.no_visited_rows, sp.no_qualified_rows, sp.no_visited_pages, rs.lock_mode, rs.lock_granularity, sp.no_fetched_columns, sp.bitset_of_fetched_columns from xpltest.sysxplain_scan_props sp join xpltest.sysxplain_resultsets rs on sp.scan_rs_id = rs.scan_rs_id where rs.op_identifier='CONSTRAINTSCAN'"), new String[][]{{"COUNTRIES_UNQ_NM", "C", "BTREE", "RC", "1", "1", "1", "SH", "R", "2", "ALL"}});
        if (XML.classpathMeetsXMLReqs()) {
            String stmt_id = this.getStmtID(s);
            Assert.assertEquals((String)selectStatement, (String)this.readStatement(stmt_id));
            Assert.assertEquals((int)3, (int)this.countNode(stmt_id));
            Assert.assertEquals((String)"PROJECTION|ROWIDSCAN|CONSTRAINTSCAN|", (String)this.getNodeName(stmt_id));
            Assert.assertEquals((String)"COUNTRIES_UNQ_NM", (String)this.getNodeAttribute(stmt_id, "scanned_object", 2));
            Assert.assertEquals((String)"BTREE", (String)this.getNodeAttribute(stmt_id, "scan_type", 2));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(stmt_id, "visited_pages", 2));
        }
    }

    public void testGroupBySortProps() throws Exception {
        Statement s = this.createStatement();
        XplainStatisticsTest.enableXplainStyleWithTiming(s);
        String selectStatement = "select region, count(country) from countries group by region";
        JDBC.assertUnorderedResultSet(s.executeQuery(selectStatement), new String[][]{{"Africa", "19"}, {"Asia", "15"}, {"Australia and New Zealand", "2"}, {"Caribbean", "10"}, {"Central America", "6"}, {"Central Asia", "4"}, {"Europe", "29"}, {"Middle East", "7"}, {"North Africa", "5"}, {"North America", "3"}, {"Pacific Islands", "3"}, {"South America", "11"}});
        XplainStatisticsTest.disableXplainStyle(s, true);
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_resultsets"), "4");
        JDBC.assertFullResultSet(s.executeQuery("select op_identifier from xpltest.sysxplain_resultsets order by op_identifier"), new String[][]{{"GROUPBY"}, {"PROJECTION"}, {"PROJECTION"}, {"TABLESCAN"}});
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_resultsets where scan_rs_id is not null"), "1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_resultsets where sort_rs_id is not null"), "1");
        JDBC.assertFullResultSet(s.executeQuery("select s.stmt_text, rs.op_identifier, srt.no_input_rows, srt.no_output_rows  from xpltest.sysxplain_sort_props srt,  xpltest.sysxplain_resultsets rs,  xpltest.sysxplain_statements s  where rs.stmt_id = s.stmt_id and  rs.sort_rs_id = srt.sort_rs_id"), new String[][]{{selectStatement, "GROUPBY", "114", "12"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select srt.sort_type, srt.no_input_rows,  srt.no_output_rows, srt.no_merge_runs,  srt.merge_run_details, srt.eliminate_duplicates,  srt.in_sort_order, srt.distinct_aggregate from xpltest.sysxplain_sort_props srt join xpltest.sysxplain_resultsets rs on srt.sort_rs_id = rs.sort_rs_id where rs.op_identifier='GROUPBY'"), new String[][]{{"IN", "114", "12", null, null, null, "N", "N"}});
        this.verifySensibleStatementTimings(s);
        this.verifySensibleResultSetTimings(s);
        if (XML.classpathMeetsXMLReqs()) {
            String stmt_id = this.getStmtID(s);
            Assert.assertEquals((String)selectStatement, (String)this.readStatement(stmt_id));
            Assert.assertEquals((int)4, (int)this.countNode(stmt_id));
            Assert.assertEquals((String)"PROJECTION|GROUPBY|PROJECTION|TABLESCAN|", (String)this.getNodeName(stmt_id));
            Assert.assertEquals((String)"IN", (String)this.getNodeAttribute(stmt_id, "sort_type", 1));
            Assert.assertEquals((String)"12", (String)this.getNodeAttribute(stmt_id, "sorter_output", 1));
        }
    }

    public void testDistinctAggregateSortProps() throws Exception {
        Statement s = this.createStatement();
        XplainStatisticsTest.enableXplainStyleWithTiming(s);
        String selectStatement = "select orig_airport, avg(distinct miles) from flights group by orig_airport";
        s.executeQuery(selectStatement).close();
        XplainStatisticsTest.disableXplainStyle(s, true);
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_sort_props"), "1");
        JDBC.assertUnorderedResultSet(s.executeQuery("select srt.sort_type, srt.no_input_rows,  srt.no_output_rows, srt.no_merge_runs,  srt.merge_run_details, srt.eliminate_duplicates,  srt.in_sort_order, srt.distinct_aggregate from xpltest.sysxplain_sort_props srt join xpltest.sysxplain_resultsets rs on srt.sort_rs_id = rs.sort_rs_id where rs.op_identifier='GROUPBY'"), new String[][]{{"IN", "10", "10", null, null, null, "N", "Y"}});
        this.verifySensibleStatementTimings(s);
        this.verifySensibleResultSetTimings(s);
        if (XML.classpathMeetsXMLReqs()) {
            String stmt_id = this.getStmtID(s);
            Assert.assertEquals((String)selectStatement, (String)this.readStatement(stmt_id));
            Assert.assertEquals((int)4, (int)this.countNode(stmt_id));
            Assert.assertEquals((String)"PROJECTION|GROUPBY|PROJECTION|TABLESCAN|", (String)this.getNodeName(stmt_id));
            Assert.assertEquals((String)"IN", (String)this.getNodeAttribute(stmt_id, "sort_type", 1));
            Assert.assertEquals((String)"10", (String)this.getNodeAttribute(stmt_id, "sorter_output", 1));
        }
    }

    public void testAggregationResultSet() throws Exception {
        Statement s = this.createStatement();
        XplainStatisticsTest.enableXplainStyle(s);
        String selectStatement = "select count(distinct region) from countries";
        JDBC.assertSingleValueResultSet(s.executeQuery(selectStatement), "12");
        XplainStatisticsTest.disableXplainStyle(s, true);
        JDBC.assertUnorderedResultSet(s.executeQuery("select op_identifier, op_details, no_opens from xpltest.sysxplain_resultsets where op_identifier = 'AGGREGATION'"), new String[][]{{"AGGREGATION", "DISTINCT", "1"}});
        if (XML.classpathMeetsXMLReqs()) {
            String stmt_id = this.getStmtID(s);
            Assert.assertEquals((String)selectStatement, (String)this.readStatement(stmt_id));
            Assert.assertEquals((int)4, (int)this.countNode(stmt_id));
            Assert.assertEquals((String)"PROJECTION|AGGREGATION|PROJECTION|TABLESCAN|", (String)this.getNodeName(stmt_id));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(stmt_id, "no_opens", 1));
        }
    }

    public void testInsertResultSet() throws Exception {
        Statement s = this.createStatement();
        s.executeUpdate("delete from AIRLINES");
        XplainStatisticsTest.enableXplainStyle(s);
        String insertStatement = "insert into AIRLINES values ('AA','Amazonian Airways',0.18,0.03,0.5,1.5,20,10,5)";
        int numRows = s.executeUpdate(insertStatement);
        XplainStatisticsTest.disableXplainStyle(s, true);
        XplainStatisticsTest.assertEquals((String)"Failed to insert into AIRLINES", (int)1, (int)numRows);
        JDBC.assertUnorderedResultSet(s.executeQuery("select stmt_type, stmt_text  from xpltest.sysxplain_statements"), new String[][]{{"I", insertStatement}});
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_resultsets"), "3");
        JDBC.assertUnorderedResultSet(s.executeQuery("select op_identifier, op_details,        no_index_updates, lock_mode,        lock_granularity, parent_rs_id,        affected_rows, deferred_rows from xpltest.sysxplain_resultsets where op_identifier = 'INSERT'"), new String[][]{{"INSERT", null, "1", null, "R", null, "1", "N"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select op_identifier, op_details, no_opens,        seen_rows, filtered_rows, returned_rows from xpltest.sysxplain_resultsets where op_identifier = 'NORMALIZE'"), new String[][]{{"NORMALIZE", null, "1", "1", "0", "1"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select op_identifier, op_details, no_opens,        seen_rows, filtered_rows, returned_rows from xpltest.sysxplain_resultsets where op_identifier = 'ROW'"), new String[][]{{"ROW", null, "1", "0", "0", "1"}});
        if (XML.classpathMeetsXMLReqs()) {
            String stmt_id = this.getStmtID(s);
            Assert.assertEquals((String)insertStatement, (String)this.readStatement(stmt_id));
            Assert.assertEquals((int)3, (int)this.countNode(stmt_id));
            Assert.assertEquals((String)"INSERT|NORMALIZE|ROW|", (String)this.getNodeName(stmt_id));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(stmt_id, "no_opens", 1));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(stmt_id, "returned_rows", 1));
        }
    }

    public void testUpdateResultSet() throws Exception {
        Statement s = this.createStatement();
        s.executeUpdate("delete from AIRLINES");
        String insertStatement = "insert into AIRLINES values ('AA','Amazonian Airways',0.18,0.03,0.5,1.5,20,10,5)";
        int numRows = s.executeUpdate(insertStatement);
        XplainStatisticsTest.assertEquals((String)"Failed to insert into AIRLINES", (int)1, (int)numRows);
        String updateStatement = "update AIRLINES set economy_seats=23,business_seats=7  where airline='AA'";
        XplainStatisticsTest.enableXplainStyle(s);
        numRows = s.executeUpdate(updateStatement);
        XplainStatisticsTest.assertEquals((String)"Failed to update AIRLINES", (int)1, (int)numRows);
        XplainStatisticsTest.disableXplainStyle(s, true);
        JDBC.assertUnorderedResultSet(s.executeQuery("select stmt_type, stmt_text  from xpltest.sysxplain_statements"), new String[][]{{"U", updateStatement}});
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_resultsets"), "4");
        JDBC.assertSingleValueResultSet(s.executeQuery("select op_identifier from xpltest.sysxplain_resultsets  where scan_rs_id is not null"), "CONSTRAINTSCAN");
        JDBC.assertUnorderedResultSet(s.executeQuery("select op_identifier, op_details, no_opens,        no_index_updates, lock_mode,        lock_granularity, parent_rs_id,        affected_rows, deferred_rows from xpltest.sysxplain_resultsets where op_identifier = 'UPDATE'"), new String[][]{{"UPDATE", null, null, "0", null, "R", null, "1", "N"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select op_identifier, op_details, no_opens,        seen_rows, filtered_rows, returned_rows from xpltest.sysxplain_resultsets where op_identifier = 'PROJECTION'"), new String[][]{{"PROJECTION", "2;", "1", "1", "0", "1"}});
        ResultSet myRS = s.executeQuery("select op_identifier, op_details, no_opens,        seen_rows, filtered_rows, returned_rows from xpltest.sysxplain_resultsets where op_identifier = 'ROWIDSCAN'");
        JDBC.assertUnorderedResultSet(s.executeQuery("select op_identifier, op_details, no_opens,        seen_rows, filtered_rows, returned_rows from xpltest.sysxplain_resultsets where op_identifier = 'ROWIDSCAN'"), new String[][]{{"ROWIDSCAN", "(0),AIRLINES", "1", "1", "0", "1"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select op_identifier, op_details, no_opens,        lock_mode, lock_granularity,        seen_rows, filtered_rows, returned_rows from xpltest.sysxplain_resultsets where op_identifier = 'CONSTRAINTSCAN'"), new String[][]{{"CONSTRAINTSCAN", "C: AIRLINES_PK", "1", "EX", "R", "1", "0", "1"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select sp.scan_object_name, sp.scan_object_type, sp.scan_type, sp.isolation_level, sp.no_visited_rows, sp.no_qualified_rows, sp.no_visited_pages, sp.no_visited_deleted_rows, sp.no_fetched_columns, sp.bitset_of_fetched_columns, sp.scan_qualifiers from xpltest.sysxplain_scan_props sp join xpltest.sysxplain_resultsets rs on sp.scan_rs_id = rs.scan_rs_id where rs.op_identifier='CONSTRAINTSCAN'"), new String[][]{{"AIRLINES_PK", "C", "BTREE", "RC", "1", "1", "1", "0", "2", "ALL", "None"}});
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_scan_props   where start_position is not null     and stop_position is not null"), "1");
        if (XML.classpathMeetsXMLReqs()) {
            String stmt_id = this.getStmtID(s);
            Assert.assertEquals((String)updateStatement, (String)this.readStatement(stmt_id));
            Assert.assertEquals((int)4, (int)this.countNode(stmt_id));
            Assert.assertEquals((String)"UPDATE|PROJECTION|ROWIDSCAN|CONSTRAINTSCAN|", (String)this.getNodeName(stmt_id));
            Assert.assertEquals((String)"", (String)this.getNodeAttribute(stmt_id, "no_opens", 0));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(stmt_id, "returned_rows", 1));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(stmt_id, "no_opens", 1));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(stmt_id, "returned_rows", 2));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(stmt_id, "no_opens", 2));
            Assert.assertEquals((String)"None", (String)this.getNodeAttribute(stmt_id, "scan_qualifiers", 3));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(stmt_id, "visited_pages", 3));
        }
    }

    public void testDeleteResultSet() throws Exception {
        Statement s = this.createStatement();
        s.executeUpdate("delete from AIRLINES");
        String insertStatement = "insert into AIRLINES values ('AA','Amazonian Airways',0.18,0.03,0.5,1.5,20,10,5)";
        int numRows = s.executeUpdate(insertStatement);
        XplainStatisticsTest.assertEquals((String)"Failed to insert into AIRLINES", (int)1, (int)numRows);
        String deleteStatement = "delete from airlines where airline='AA'";
        XplainStatisticsTest.enableXplainStyle(s);
        numRows = s.executeUpdate(deleteStatement);
        XplainStatisticsTest.assertEquals((String)"Failed to delete from AIRLINES", (int)1, (int)numRows);
        XplainStatisticsTest.disableXplainStyle(s, true);
        JDBC.assertUnorderedResultSet(s.executeQuery("select stmt_type, stmt_text  from xpltest.sysxplain_statements"), new String[][]{{"D", deleteStatement}});
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_resultsets"), "4");
        JDBC.assertUnorderedResultSet(s.executeQuery("select distinct op_identifier  from xpltest.sysxplain_resultsets  order by op_identifier"), new String[][]{{"CONSTRAINTSCAN"}, {"DELETE"}, {"PROJECTION"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select op_identifier, op_details, no_opens,        no_index_updates, lock_mode,        lock_granularity, parent_rs_id,        affected_rows, deferred_rows from xpltest.sysxplain_resultsets where op_identifier = 'DELETE'"), new String[][]{{"DELETE", null, null, "1", null, "R", null, "1", "N"}});
        if (XML.classpathMeetsXMLReqs()) {
            String stmt_id = this.getStmtID(s);
            Assert.assertEquals((String)deleteStatement, (String)this.readStatement(stmt_id));
            Assert.assertEquals((int)4, (int)this.countNode(stmt_id));
            Assert.assertEquals((String)"DELETE|PROJECTION|PROJECTION|CONSTRAINTSCAN|", (String)this.getNodeName(stmt_id));
            Assert.assertEquals((String)"", (String)this.getNodeAttribute(stmt_id, "no_opens", 0));
        }
    }

    public void testSortResultSet() throws Exception {
        Statement s = this.createStatement();
        XplainStatisticsTest.enableXplainStyle(s);
        String selectStatement = "select region from countries order by country";
        s.executeQuery(selectStatement).close();
        XplainStatisticsTest.disableXplainStyle(s, true);
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_resultsets"), "4");
        JDBC.assertUnorderedResultSet(s.executeQuery("select op_identifier, op_details, no_opens,        input_rows, seen_rows, filtered_rows,        returned_rows from xpltest.sysxplain_resultsets where op_identifier = 'SORT'"), new String[][]{{"SORT", null, "1", "114", "0", "0", "0"}});
        JDBC.assertFullResultSet(s.executeQuery("select s.stmt_text, rs.op_identifier, srt.no_input_rows, srt.no_output_rows,  srt.sort_type, srt.eliminate_duplicates,  srt.in_sort_order, srt.distinct_aggregate  from xpltest.sysxplain_sort_props srt,  xpltest.sysxplain_resultsets rs,  xpltest.sysxplain_statements s  where rs.stmt_id = s.stmt_id and  rs.sort_rs_id = srt.sort_rs_id"), new String[][]{{selectStatement, "SORT", "114", "114", "IN", "N", "N", null}});
        if (XML.classpathMeetsXMLReqs()) {
            String stmt_id = this.getStmtID(s);
            Assert.assertEquals((String)selectStatement, (String)this.readStatement(stmt_id));
            Assert.assertEquals((int)4, (int)this.countNode(stmt_id));
            Assert.assertEquals((String)"PROJECTION|SORT|PROJECTION|TABLESCAN|", (String)this.getNodeName(stmt_id));
            Assert.assertEquals((String)"IN", (String)this.getNodeAttribute(stmt_id, "sort_type", 1));
            Assert.assertEquals((String)"114", (String)this.getNodeAttribute(stmt_id, "sorter_output", 1));
            Assert.assertEquals((String)"114", (String)this.getNodeAttribute(stmt_id, "input_rows", 1));
        }
    }

    public void testUnionQuery() throws Exception {
        Statement s = this.createStatement();
        XplainStatisticsTest.enableXplainStyle(s);
        String selectStatement = "select country from countries where region = 'Central America'  union select country from countries where region = 'Africa'";
        s.executeQuery(selectStatement).close();
        XplainStatisticsTest.disableXplainStyle(s, true);
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_resultsets"), "6");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_resultsets   where parent_rs_id =         (select rs_id from xpltest.sysxplain_resultsets         where op_identifier = 'UNION')"), "2");
        JDBC.assertUnorderedResultSet(s.executeQuery("select op_identifier from xpltest.sysxplain_resultsets where scan_rs_id is not null"), new String[][]{{"TABLESCAN"}, {"TABLESCAN"}});
        JDBC.assertSingleValueResultSet(s.executeQuery("select op_identifier from xpltest.sysxplain_resultsets  where sort_rs_id is not null and parent_rs_id is null"), "SORT");
        JDBC.assertUnorderedResultSet(s.executeQuery("select op_identifier, op_details, no_opens,        seen_rows, seen_rows_right, filtered_rows,        returned_rows from xpltest.sysxplain_resultsets where op_identifier = 'UNION'"), new String[][]{{"UNION", "(2)", "1", "6", "19", "0", "25"}});
        JDBC.assertFullResultSet(s.executeQuery("select s.stmt_text, rs.op_identifier, srt.no_input_rows, srt.no_output_rows,  srt.sort_type, srt.eliminate_duplicates,  srt.in_sort_order, srt.distinct_aggregate  from xpltest.sysxplain_sort_props srt,  xpltest.sysxplain_resultsets rs,  xpltest.sysxplain_statements s  where rs.stmt_id = s.stmt_id and  rs.sort_rs_id = srt.sort_rs_id"), new String[][]{{selectStatement, "SORT", "25", "25", "IN", "Y", "N", null}});
        if (XML.classpathMeetsXMLReqs()) {
            String stmt_id = this.getStmtID(s);
            Assert.assertEquals((String)selectStatement, (String)this.readStatement(stmt_id));
            Assert.assertEquals((int)6, (int)this.countNode(stmt_id));
            Assert.assertEquals((String)"SORT|UNION|PROJECTION|TABLESCAN|PROJECTION|TABLESCAN|", (String)this.getNodeName(stmt_id));
            Assert.assertEquals((String)"IN", (String)this.getNodeAttribute(stmt_id, "sort_type", 0));
            Assert.assertEquals((String)"25", (String)this.getNodeAttribute(stmt_id, "sorter_output", 0));
            Assert.assertEquals((String)"25", (String)this.getNodeAttribute(stmt_id, "input_rows", 0));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(stmt_id, "no_opens", 1));
            Assert.assertEquals((String)"25", (String)this.getNodeAttribute(stmt_id, "returned_rows", 1));
        }
    }

    public void testDDLCreateTable() throws Exception {
        Statement s = this.createStatement();
        XplainStatisticsTest.enableXplainStyle(s);
        String ddlStatement = "create table t1 (a int, b char(10), c timestamp)";
        s.executeUpdate(ddlStatement);
        XplainStatisticsTest.disableXplainStyle(s, false);
        JDBC.assertUnorderedResultSet(s.executeQuery("select stmt_type, stmt_text  from xpltest.sysxplain_statements"), new String[][]{{"DDL", ddlStatement}});
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from xpltest.sysxplain_resultsets"), "0");
    }

    public void testMaxFromIndex() throws Exception {
        Statement s = this.createStatement();
        XplainStatisticsTest.enableXplainStyle(s);
        String selectStatement = "select max(country_iso_code) from countries";
        s.executeQuery(selectStatement).close();
        XplainStatisticsTest.disableXplainStyle(s, true);
        JDBC.assertUnorderedResultSet(s.executeQuery("select op_identifier, op_details, no_opens,        input_rows, seen_rows, filtered_rows,        returned_rows, index_key_opt from xpltest.sysxplain_resultsets where op_identifier = 'AGGREGATION'"), new String[][]{{"AGGREGATION", null, "1", "0", "0", "0", "0", "Y"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select op_identifier, op_details, no_opens,        seen_rows, filtered_rows, returned_rows from xpltest.sysxplain_resultsets where op_identifier = 'LASTINDEXKEYSCAN'"), new String[][]{{"LASTINDEXKEYSCAN", "I: COUNTRIES_PK, T: COUNTRIES", "1", "1", "0", "1"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select sp.scan_object_name, sp.scan_object_type,  sp.isolation_level, sp.no_visited_rows, sp.no_qualified_rows, sp.no_visited_pages, sp.no_visited_deleted_rows, sp.no_fetched_columns, sp.bitset_of_fetched_columns, sp.scan_qualifiers from xpltest.sysxplain_scan_props sp join xpltest.sysxplain_resultsets rs on sp.scan_rs_id = rs.scan_rs_id where rs.op_identifier='LASTINDEXKEYSCAN'"), new String[][]{{"COUNTRIES_PK", "I", "RC", null, null, null, null, null, null, null}});
        if (XML.classpathMeetsXMLReqs()) {
            String stmt_id = this.getStmtID(s);
            Assert.assertEquals((String)selectStatement, (String)this.readStatement(stmt_id));
            Assert.assertEquals((int)4, (int)this.countNode(stmt_id));
            Assert.assertEquals((String)"PROJECTION|AGGREGATION|PROJECTION|LASTINDEXKEYSCAN|", (String)this.getNodeName(stmt_id));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(stmt_id, "no_opens", 3));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(stmt_id, "returned_rows", 3));
            Assert.assertEquals((String)"COUNTRIES_PK", (String)this.getNodeAttribute(stmt_id, "scanned_object", 3));
            Assert.assertEquals((String)"", (String)this.getNodeAttribute(stmt_id, "visited_pages", 3));
            Assert.assertEquals((String)"", (String)this.getNodeAttribute(stmt_id, "scan_qualifiers", 3));
        }
    }

    public void testOuterJoin() throws Exception {
        Statement s = this.createStatement();
        XplainStatisticsTest.enableXplainStyle(s);
        String selectStatement = "select f.orig_airport,c.country  from flights f left outer join countries c  on f.orig_airport = c.country_iso_code";
        JDBC.assertUnorderedResultSet(s.executeQuery(selectStatement), new String[][]{{"ABQ", null}, {"LAX", null}, {"ABQ", null}, {"PHX", null}, {"ABQ", null}, {"OKC", null}, {"AKL", null}, {"HNL", null}, {"AKL", null}, {"NRT", null}});
        XplainStatisticsTest.disableXplainStyle(s, true);
        JDBC.assertUnorderedResultSet(s.executeQuery("select op_identifier from xpltest.sysxplain_resultsets "), new String[][]{{"PROJECTION"}, {"LONLJOIN"}, {"INDEXSCAN"}, {"ROWIDSCAN"}, {"CONSTRAINTSCAN"}});
        JDBC.assertFullResultSet(s.executeQuery("select op_identifier, op_details, no_opens,        seen_rows, seen_rows_right, filtered_rows,        returned_rows, empty_right_rows from xpltest.sysxplain_resultsets where op_identifier = 'LONLJOIN'"), new String[][]{{"LONLJOIN", "(1), Nested Loop Left Outer Join ResultSet", "1", "10", "0", "0", "10", "0"}});
        if (XML.classpathMeetsXMLReqs()) {
            String stmt_id = this.getStmtID(s);
            Assert.assertEquals((String)selectStatement, (String)this.readStatement(stmt_id));
            Assert.assertEquals((int)5, (int)this.countNode(stmt_id));
            Assert.assertEquals((String)"PROJECTION|LONLJOIN|INDEXSCAN|ROWIDSCAN|CONSTRAINTSCAN|", (String)this.getNodeName(stmt_id));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(stmt_id, "no_opens", 1));
            Assert.assertEquals((String)"10", (String)this.getNodeAttribute(stmt_id, "returned_rows", 1));
        }
    }

    public void testScanPositions() throws Exception {
        Statement s = this.createStatement();
        String[] searches = new String[]{"select * from flights where dest_airport = 'ABQ'", "select * from flights where dest_airport > 'HNL'", "select * from flights where dest_airport < 'HNL'", "select * from flights where dest_airport between 'H' and 'J'", "select * from flights where dest_airport like 'AB%'"};
        String[] startPrefixes = new String[]{">= on first 1 column(s).", "> on first 1 column(s).", "None", ">= on first 1 column(s).", ">= on first 1 column(s)."};
        String[] stopPrefixes = new String[]{"> on first 1 column(s).", "None", ">= on first 1 column(s).", "> on first 1 column(s).", ">= on first 1 column(s)."};
        XplainStatisticsTest.enableXplainStyle(s);
        for (int i = 0; i < searches.length; ++i) {
            s.executeQuery(searches[i]).close();
        }
        XplainStatisticsTest.disableXplainStyle(s, true);
        ResultSet rs = s.executeQuery("select s.stmt_text, sp.start_position, sp.stop_position   from xpltest.sysxplain_statements s,        xpltest.sysxplain_resultsets rs,        xpltest.sysxplain_scan_props sp  where s.stmt_id = rs.stmt_id and        rs.scan_rs_id = sp.scan_rs_id");
        int matchedStatements = 0;
        while (rs.next()) {
            String sText = rs.getString("stmt_text");
            String startPos = rs.getString("start_position").trim();
            String stopPos = rs.getString("stop_position").trim();
            boolean foundStmt = false;
            for (int i = 0; i < searches.length; ++i) {
                if (!searches[i].equals(sText)) continue;
                ++matchedStatements;
                foundStmt = true;
                if (!startPos.startsWith(startPrefixes[i])) {
                    XplainStatisticsTest.fail((String)("Expected start_position for statement '" + searches[i] + "' to start with '" + startPrefixes[i] + "', but it actually was " + startPos));
                }
                if (stopPos.startsWith(stopPrefixes[i])) break;
                XplainStatisticsTest.fail((String)("Expected stop_position for statement '" + searches[i] + "' to start with '" + stopPrefixes[i] + "', but it actually was " + stopPos));
                break;
            }
            XplainStatisticsTest.assertTrue((String)("Found unexpected statement " + sText), (boolean)foundStmt);
        }
        XplainStatisticsTest.assertEquals((String)"Captured wrong number of statements?", (int)searches.length, (int)matchedStatements);
        if (XML.classpathMeetsXMLReqs()) {
            String[] stmt_id = this.getStmtIDArray(s, searches.length);
            for (int i = 0; i < stmt_id.length; ++i) {
                Assert.assertEquals((String)searches[i], (String)this.readStatement(stmt_id[i]));
            }
        }
    }

    public void testScanDeletedRows() throws Exception {
        Statement s = this.createStatement();
        XplainStatisticsTest.enableXplainStyle(s);
        String selectStatement = "select x from t";
        JDBC.assertUnorderedResultSet(s.executeQuery(selectStatement), new String[][]{{"1"}, {"2"}, {"4"}});
        XplainStatisticsTest.disableXplainStyle(s, true);
        JDBC.assertFullResultSet(s.executeQuery("select sp.scan_object_type, sp.scan_type, sp.isolation_level, sp.no_visited_rows, sp.no_qualified_rows, sp.no_visited_pages, sp.no_visited_deleted_rows, sp.no_fetched_columns, sp.bitset_of_fetched_columns, sp.scan_qualifiers from xpltest.sysxplain_scan_props sp join xpltest.sysxplain_resultsets rs on sp.scan_rs_id = rs.scan_rs_id where rs.op_identifier='CONSTRAINTSCAN'"), new String[][]{{"C", "BTREE", "RC", "4", "3", "1", "1", "1", "{0}", "None"}});
        if (XML.classpathMeetsXMLReqs()) {
            String stmt_id = this.getStmtID(s);
            Assert.assertEquals((String)selectStatement, (String)this.readStatement(stmt_id));
            Assert.assertEquals((int)1, (int)this.countNode(stmt_id));
            Assert.assertEquals((String)"CONSTRAINTSCAN|", (String)this.getNodeName(stmt_id));
            Assert.assertEquals((String)"BTREE", (String)this.getNodeAttribute(stmt_id, "scan_type", 0));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(stmt_id, "visited_pages", 0));
            Assert.assertEquals((String)"None", (String)this.getNodeAttribute(stmt_id, "scan_qualifiers", 0));
        }
    }

    public void testAlwaysEmptyResultSet() throws Exception {
        String sql = "select * from sysibm.sysdummy1 where false -- DERBY-6268";
        Statement s = this.createStatement();
        XplainStatisticsTest.enableXplainStyle(s);
        JDBC.assertEmpty(s.executeQuery(sql));
        XplainStatisticsTest.disableXplainStyle(s, true);
        PreparedStatement ps = this.prepareStatement("select * from xpltest.sysxplain_statements where stmt_text = ?");
        ps.setString(1, sql);
        JDBC.assertDrainResults(ps.executeQuery(), 1);
    }

    public void testTableNotValid() throws SQLException {
        Statement s = this.createStatement();
        for (int i = 0; i < tableNames.length; ++i) {
            if (!XplainStatisticsTest.hasTable(s, "XPLTEST", tableNames[i])) continue;
            s.executeUpdate("drop table xpltest." + tableNames[i]);
        }
        s.executeUpdate("create table xpltest.sysxplain_resultsets(a int)");
        try {
            XplainStatisticsTest.enableXplainStyle(s);
            XplainStatisticsTest.fail((String)"Expected an error from table with wrong shape");
        }
        catch (SQLException e) {
            XplainStatisticsTest.assertSQLState("Expected 42X14 error for missing column", "42X14", e);
            if (e.getMessage().indexOf("RS_ID") < 0) {
                XplainStatisticsTest.fail((String)("Expected message about missing column RS_ID, not " + e.getMessage()));
            }
        }
        finally {
            s.executeUpdate("drop table xpltest.sysxplain_resultsets");
        }
    }

    public void testPlanExporterEncoding() throws Exception {
        String table = "D4902_BL\u00c5B\u00c6R";
        String queryText = "SELECT * FROM " + table;
        Statement s = this.createStatement();
        s.execute("CREATE TABLE " + table + "(X INT)");
        XplainStatisticsTest.enableXplainStyle(s);
        JDBC.assertEmpty(s.executeQuery(queryText));
        XplainStatisticsTest.disableXplainStyle(s, true);
        ResultSet rs = s.executeQuery("SELECT STMT_ID, STMT_TEXT FROM XPLTEST.SYSXPLAIN_STATEMENTS");
        XplainStatisticsTest.assertTrue((boolean)rs.next());
        String stmtId = rs.getString(1);
        XplainStatisticsTest.assertEquals((String)queryText, (String)rs.getString(2));
        XplainStatisticsTest.assertFalse((boolean)rs.next());
        rs.close();
        if (XML.classpathMeetsXMLReqs()) {
            XplainStatisticsTest.assertEquals((String)queryText, (String)this.readStatement(stmtId));
        }
    }

    public void testPlanExporterHandlingSpecialCharacters() throws Exception {
        String table = "A \"double\" and 'single' quoted table name with some other special characters, like <, > and &";
        String escapedTable = JDBC.escape(table);
        String queryText = "SELECT * FROM " + escapedTable + " WHERE X < LENGTH('a & b') AND X > 1";
        Statement s = this.createStatement();
        s.execute("CREATE TABLE " + escapedTable + "(X INT)");
        XplainStatisticsTest.enableXplainStyle(s);
        JDBC.assertEmpty(s.executeQuery(queryText));
        XplainStatisticsTest.disableXplainStyle(s, true);
        ResultSet rs = s.executeQuery("SELECT STMT_ID, STMT_TEXT FROM XPLTEST.SYSXPLAIN_STATEMENTS");
        XplainStatisticsTest.assertTrue((boolean)rs.next());
        String stmtId = rs.getString(1);
        XplainStatisticsTest.assertEquals((String)queryText, (String)rs.getString(2));
        XplainStatisticsTest.assertFalse((boolean)rs.next());
        rs.close();
        if (XML.classpathMeetsXMLReqs()) {
            XplainStatisticsTest.assertEquals((String)queryText, (String)this.readStatement(stmtId));
            Assert.assertEquals((String)"TABLESCAN|", (String)this.getNodeName(stmtId));
            XplainStatisticsTest.assertEquals((String)table, (String)this.getNodeAttribute(stmtId, "scanned_object", 0));
        }
    }

    static {
        tableNames = new String[]{"SYSXPLAIN_STATEMENTS", "SYSXPLAIN_STATEMENT_TIMINGS", "SYSXPLAIN_RESULTSETS", "SYSXPLAIN_RESULTSET_TIMINGS", "SYSXPLAIN_SORT_PROPS", "SYSXPLAIN_SCAN_PROPS"};
    }

    private static class MTSimpleSelect
    extends AbstractMTThread {
        public MTSimpleSelect(Connection con, long runTime) {
            super(con, runTime);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Random rand = new Random();
            long start = System.currentTimeMillis();
            try {
                Statement s = this.con.createStatement();
                XplainStatisticsTest.enableXplainStyleWithTiming(s);
                PreparedStatement ps = this.con.prepareStatement("SELECT country from countries WHERE region = 'Central America'");
                while (System.currentTimeMillis() - start < this.runTime) {
                    JDBC.assertUnorderedResultSet(ps.executeQuery(), new String[][]{{"Belize"}, {"Costa Rica"}, {"El Salvador"}, {"Guatemala"}, {"Honduras"}, {"Nicaragua"}});
                    ++this.count;
                    try {
                        Thread.sleep(rand.nextInt(50));
                    }
                    catch (InterruptedException interruptedException) {}
                }
                s.close();
                ps.close();
            }
            catch (Throwable t) {
                this.error = t;
            }
            finally {
                try {
                    this.con.rollback();
                    this.con.close();
                }
                catch (SQLException s) {}
            }
        }
    }

    private static class MTSimpleInvalidate
    extends AbstractMTThread {
        public MTSimpleInvalidate(Connection con, long runTime) {
            super(con, runTime);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long start = System.currentTimeMillis();
            try {
                PreparedStatement ps = this.con.prepareStatement("call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS(?, ?, ?)");
                ps.setString(1, "APP");
                ps.setString(2, "COUNTRIES");
                ps.setNull(3, 12);
                while (System.currentTimeMillis() - start < this.runTime) {
                    ps.execute();
                    ++this.count;
                }
                ps.close();
            }
            catch (Throwable t) {
                this.error = t;
            }
            finally {
                try {
                    this.con.rollback();
                    this.con.close();
                }
                catch (SQLException ps) {}
            }
        }
    }

    private static abstract class AbstractMTThread
    implements Runnable {
        protected final Connection con;
        protected final long runTime;
        protected int count;
        protected Throwable error;

        protected AbstractMTThread(Connection con, long runTime) {
            this.con = con;
            this.runTime = runTime;
        }

        public int getActionCount() {
            return this.count;
        }

        public boolean failed() {
            return this.error != null;
        }

        public Throwable getError() {
            return this.error;
        }
    }
}

