/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.BaseTestSuite;

public class ReplicationRun_Local_StateTest_part1_3
extends ReplicationRun {
    public ReplicationRun_Local_StateTest_part1_3(String testcaseName) {
        super(testcaseName);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("ReplicationRun_Local_StateTest_part1_3 Suite");
        suite.addTestSuite(ReplicationRun_Local_StateTest_part1_3.class);
        return suite;
    }

    public void testReplication_Local_StateTest_part1_3() throws Exception {
        this.cleanAllTestHosts();
        this.initEnvironment();
        this.initMaster(masterServerHost, replicatedDb);
        this.startServer(masterJvmVersion, derbyMasterVersion, masterServerHost, "0.0.0.0", masterServerPort, masterDbSubPath);
        this.startServer(slaveJvmVersion, derbySlaveVersion, slaveServerHost, "0.0.0.0", slaveServerPort, slaveDbSubPath);
        this.startServerMonitor(slaveServerHost);
        this.bootMasterDatabase(jvmVersion, masterDatabasePath + FS + masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, null);
        this.initSlave(slaveServerHost, jvmVersion, replicatedDb);
        this.startSlave(jvmVersion, replicatedDb, slaveServerHost, slaveServerPort, slaveServerHost, slaveReplPort, testClientHost);
        this.startMaster(jvmVersion, replicatedDb, masterServerHost, masterServerPort, masterServerHost, slaveServerPort, slaveServerHost, slaveReplPort);
        this._testPostStartedMasterAndSlave_Failover();
        this.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
        this.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
    }

    private void _testPostStartedMasterAndSlave_Failover() {
        String msg;
        String ss;
        int ec;
        Connection conn = null;
        String db = slaveDatabasePath + FS + ReplicationRun.slaveDbSubPath + FS + replicatedDb;
        String connectionURL = "jdbc:derby://" + slaveServerHost + ":" + slaveServerPort + "/" + db + ";failover=true";
        this.util.DEBUG("1. testPostStartedMasterAndSlave_Failover: " + connectionURL);
        try {
            conn = DriverManager.getConnection(connectionURL);
            this.util.DEBUG("Successfully connected as: " + connectionURL);
            ReplicationRun_Local_StateTest_part1_3.assertTrue((String)("Successfully connected as: " + connectionURL), (boolean)false);
        }
        catch (SQLException se) {
            ec = se.getErrorCode();
            ss = se.getSQLState();
            msg = "As expected: Failover on slave should fail: " + ec + " " + ss + " " + se.getMessage();
            this.util.DEBUG(msg);
        }
        db = masterDatabasePath + FS + ReplicationRun.masterDbSubPath + FS + replicatedDb;
        connectionURL = "jdbc:derby://" + masterServerHost + ":" + masterServerPort + "/" + db + ";failover=true";
        this.util.DEBUG("2. testPostStartedMasterAndSlave_Failover: " + connectionURL);
        try {
            conn = DriverManager.getConnection(connectionURL);
            this.util.DEBUG("Unexpectedly connected as: " + connectionURL);
            ReplicationRun_Local_StateTest_part1_3.assertTrue((String)("Unexpectedly connected as: " + connectionURL), (boolean)false);
        }
        catch (SQLException se) {
            ec = se.getErrorCode();
            ss = se.getSQLState();
            msg = ec + " " + ss + " " + se.getMessage();
            ReplicationRun_Local_StateTest_part1_3.assertTrue((String)("connectionURL  failed: " + msg), (boolean)"XRE20".equals(ss));
            this.util.DEBUG("Failover on master succeeded: " + connectionURL + " " + msg);
        }
    }
}

