/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public class JoinTest
extends BaseJDBCTestCase {
    private static final String SYNTAX_ERROR = "42X01";
    private static final String AMBIGUOUS_COLNAME = "42X03";
    private static final String COLUMN_NOT_IN_SCOPE = "42X04";
    private static final String NON_COMPARABLE = "42818";
    private static final String NO_COLUMNS = "42X81";
    private static final String TABLE_NAME_NOT_IN_SCOPE = "42X10";
    private static final String VALUES_WITH_NULL = "42X07";

    public JoinTest(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(JoinTest.class);
    }

    public void testNullabilityInValues() throws SQLException {
        Statement statement = this.createStatement();
        JoinTest.assertStatementError(VALUES_WITH_NULL, statement, "select a.* from (values (null)) a left outer join (values ('a')) b on 1=1");
        JoinTest.assertStatementError(VALUES_WITH_NULL, statement, "select a.* from (values (null)) a");
        String[][] stringArray = new String[][]{{"a"}, {"a"}, {"b"}, {"b"}, {null}, {null}};
        JDBC.assertUnorderedResultSet(statement.executeQuery("select a.* from (values ('a'),('b'),(cast(null as char(1)))) a left outer join (values ('c'),('d')) b on 1=1"), stringArray);
    }

    public void testNullabilityInLeftOrRightOuterJoin() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table t (c1 int not null, c2 int not null, c3 int)");
        ResultSet resultSet = statement.executeQuery("select * from t t1 left outer join t t2 on 1=1");
        JDBC.assertNullability(resultSet, new boolean[]{false, false, true, true, true, true});
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("select * from t t1 right outer join t t2 on 1=1");
        JDBC.assertNullability(resultSet, new boolean[]{true, true, true, false, false, true});
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("select cast(t1.c1 as int), cast(t2.c2 as int) from t t1 left outer join t t2 on 1=1");
        JDBC.assertNullability(resultSet, new boolean[]{false, true});
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("select cast(t1.c1 as int), cast(t2.c2 as int) from t t1 right outer join t t2 on 1=1");
        JDBC.assertNullability(resultSet, new boolean[]{true, false});
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("select t1.c1, t2.c1, t3.c1 from t t1 left join (t t2 left join t t3 on 1=1) on 1=1");
        JDBC.assertNullability(resultSet, new boolean[]{false, true, true});
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("select t1.c1, t2.c1, t3.c1 from t t1 right join (t t2 right join t t3 on 1=1) on 1=1");
        JDBC.assertNullability(resultSet, new boolean[]{true, true, false});
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("select t1.c1, t2.c1, t3.c1, t4.c1 from (t t1 left join t t2 on 1=1) left join (t t3 left join t t4 on 1=1) on 1=1");
        JDBC.assertNullability(resultSet, new boolean[]{false, true, true, true});
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("select t1.c1, t2.c1, t3.c1, t4.c1 from (t t1 left join t t2 on 1=1) right join (t t3 left join t t4 on 1=1) on 1=1");
        JDBC.assertNullability(resultSet, new boolean[]{true, true, false, true});
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("select t1.c1, t2.c1, t3.c1, t4.c1 from (t t1 right join t t2 on 1=1) left join (t t3 left join t t4 on 1=1) on 1=1");
        JDBC.assertNullability(resultSet, new boolean[]{true, false, true, true});
        JDBC.assertEmpty(resultSet);
    }

    public void testDerby4372() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table d4372_1 (a int, b int)");
        statement.execute("create table d4372_2 (c int)");
        statement.execute("insert into d4372_1 values (1,1),(null,1),(1,null),(2,2),(2,null),(null,2),(3,3),(null,3),(3,null),(null,null)");
        statement.execute("insert into d4372_2 values (1), (3)");
        String[][] stringArray = new String[][]{{"1", "1", "1"}, {null, "1", "1"}, {"1", null, "1"}, {"3", "3", "3"}, {null, "3", "3"}, {"3", null, "3"}};
        PreparedStatement preparedStatement = this.prepareStatement("select * from d4372_1 join d4372_2 on c in (a, b)");
        JDBC.assertUnorderedResultSet(preparedStatement.executeQuery(), stringArray);
        statement.execute("create index d4372_idx on d4372_2(c)");
        JDBC.assertUnorderedResultSet(preparedStatement.executeQuery(), stringArray);
        statement.execute("drop table d4372_1");
        statement.execute("drop table d4372_2");
    }

    public void testCrossJoins() throws SQLException {
        this.setAutoCommit(false);
        String[][] stringArray = new String[][]{{"1", "one"}, {"2", "two"}, {"3", null}, {"5", "five"}, {"6", "six"}};
        String[][] stringArray2 = new String[][]{{"1", null}, {"2", "II"}, {"4", "IV"}};
        Statement statement = this.createStatement();
        statement.execute("create table t1(c1 int, c2 varchar(10))");
        this.fillTable("insert into t1 values (?,?)", stringArray);
        statement.execute("create table t2(c1 int, c2 varchar(10))");
        this.fillTable("insert into t2 values (?,?)", stringArray2);
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 cross join t2"), JoinTest.cross(stringArray, stringArray2));
        JoinTest.assertStatementError(SYNTAX_ERROR, statement, "select * from t1 cross join t1 USING(c1)");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 a cross join t1 b"), JoinTest.cross(stringArray, stringArray));
        JDBC.assertUnorderedResultSet(statement.executeQuery("select t2.*, t1.* from t1 cross join t2"), JoinTest.cross(stringArray2, stringArray));
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 cross join t2 cross join t1 t3"), JoinTest.cross(stringArray, JoinTest.cross(stringArray2, stringArray)));
        JDBC.assertUnorderedResultSet(statement.executeQuery("select t1.c2 from t1 cross join t2"), JoinTest.project(new int[]{1}, JoinTest.cross(stringArray, stringArray2)));
        JDBC.assertUnorderedResultSet(statement.executeQuery("select t1.c1, t2.c2, t2.c2 from t1 cross join t2"), JoinTest.project(new int[]{0, 3, 3}, JoinTest.cross(stringArray, stringArray2)));
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from t1 cross join t2"), Integer.toString(stringArray.length * stringArray2.length));
        String[][] stringArray3 = new String[][]{{"1", "one", "1", null}, {"2", "two", "2", "II"}};
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 cross join t2 where t1.c1=t2.c1"), stringArray3);
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 inner join t2 on t1.c1=t2.c1"), stringArray3);
        JDBC.assertFullResultSet(statement.executeQuery("select * from t1 cross join t2 order by t1.c1 desc"), JoinTest.reverse(JoinTest.cross(stringArray, stringArray2)));
        JDBC.assertFullResultSet(statement.executeQuery("select t1.c1, count(t1.c2) from t1 cross join t2 group by t1.c1 order by t1.c1"), new String[][]{{"1", "3"}, {"2", "3"}, {"3", "0"}, {"5", "3"}, {"6", "3"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from (values 1,2) v1 cross join (values 'a','b') v2"), new String[][]{{"1", "a"}, {"1", "b"}, {"2", "a"}, {"2", "b"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 a cross join t2 b inner join t2 c on 1=1"), JoinTest.cross(stringArray, JoinTest.cross(stringArray2, stringArray2)));
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 a inner join t2 b on 1=1 cross join t2 c"), JoinTest.cross(stringArray, JoinTest.cross(stringArray2, stringArray2)));
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 a inner join (t2 b cross join t2 c) on 1=1"), JoinTest.cross(stringArray, JoinTest.cross(stringArray2, stringArray2)));
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 a inner join t2 b cross join t2 c on 1=1"), JoinTest.cross(stringArray, JoinTest.cross(stringArray2, stringArray2)));
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from t2 a cross join t1 b right join t2 c on a.c1=c.c1"), Integer.toString(stringArray.length * stringArray2.length));
        String[][] stringArray4 = new String[][]{{null, null, null, null, "4", "IV"}};
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t2 a cross join t1 b right join t2 c on b.c1=c.c1 where c.c1=4"), stringArray4);
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from (t2 a cross join t1 b) right join t2 c on b.c1=c.c1 where c.c1=4"), stringArray4);
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t2 a cross join (t1 b right join t2 c on b.c1=c.c1) where c.c1=4"), new String[][]{{"1", null, null, null, "4", "IV"}, {"2", "II", null, null, "4", "IV"}, {"4", "IV", null, null, "4", "IV"}});
        JoinTest.assertStatementError(AMBIGUOUS_COLNAME, statement, "select * from t1 cross join t1");
        JoinTest.assertStatementError(AMBIGUOUS_COLNAME, statement, "select c1 from t1 cross join t2");
        JoinTest.assertStatementError(SYNTAX_ERROR, statement, "select * from t1 cross join t2 on t1.c1 = t2.c2");
        JoinTest.assertStatementError(SYNTAX_ERROR, statement, "select * from t1 inner join t2 cross join t2 t3");
        JoinTest.assertStatementError(SYNTAX_ERROR, statement, "select * from t1 left join t2 cross join t2 t3");
        JoinTest.assertStatementError(SYNTAX_ERROR, statement, "select * from t1 right join t2 cross join t2 t3");
        JoinTest.assertStatementError(SYNTAX_ERROR, statement, "select * from t1 cross join t2 inner join t2 t3");
    }

    private void fillTable(String string, String[][] stringArray) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement(string);
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length; ++j) {
                preparedStatement.setString(j + 1, stringArray[i][j]);
            }
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
    }

    private static String[][] cross(String[][] stringArray, String[][] stringArray2) {
        String[][] stringArray3 = new String[stringArray.length * stringArray2.length][];
        for (int i = 0; i < stringArray3.length; ++i) {
            String[] stringArray4 = stringArray[i / stringArray2.length];
            String[] stringArray5 = stringArray2[i % stringArray2.length];
            stringArray3[i] = new String[stringArray4.length + stringArray5.length];
            System.arraycopy(stringArray4, 0, stringArray3[i], 0, stringArray4.length);
            System.arraycopy(stringArray5, 0, stringArray3[i], stringArray4.length, stringArray5.length);
        }
        return stringArray3;
    }

    private static String[][] project(int[] nArray, String[][] stringArray) {
        String[][] stringArray2 = new String[stringArray.length][nArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                stringArray2[i][j] = stringArray[i][nArray[j]];
            }
        }
        return stringArray2;
    }

    private static String[][] reverse(String[][] stringArray) {
        String[][] stringArray2 = new String[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[stringArray.length - 1 - i];
        }
        return stringArray2;
    }

    public void testUsingClause() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table t1(a int, b int, c int)");
        statement.execute("create table t2(b int, c int, d int)");
        statement.execute("create table t3(d int, e varchar(5), f int)");
        statement.execute("insert into t1 values (1,2,3),(2,3,4),(4,4,4)");
        statement.execute("insert into t2 values (1,2,3),(2,3,4),(5,5,5)");
        statement.execute("insert into t3 values (2,'abc',3),(4,'def',5),(null,null,null)");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 join t2 using (b)"), new String[][]{{"2", "1", "3", "3", "4"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 inner join t2 using (b)"), new String[][]{{"2", "1", "3", "3", "4"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 left join t2 using (b)"), new String[][]{{"2", "1", "3", "3", "4"}, {"3", "2", "4", null, null}, {"4", "4", "4", null, null}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 left outer join t2 using (b)"), new String[][]{{"2", "1", "3", "3", "4"}, {"3", "2", "4", null, null}, {"4", "4", "4", null, null}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 right join t2 using (b)"), new String[][]{{"2", "1", "3", "3", "4"}, {"1", null, null, "2", "3"}, {"5", null, null, "5", "5"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 right outer join t2 using (b)"), new String[][]{{"2", "1", "3", "3", "4"}, {"1", null, null, "2", "3"}, {"5", null, null, "5", "5"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 join t2 using (b, c)"), new String[][]{{"2", "3", "1", "4"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 join t2 using (c, b)"), new String[][]{{"3", "2", "1", "4"}});
        JDBC.assertSingleValueResultSet(statement.executeQuery("select t1.* from t1 join t2 using (b, c)"), "1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select t2.* from t1 join t2 using (b, c)"), "4");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select t1.*, t2.* from t1 join t2 using (b, c)"), new String[][]{{"1", "4"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select t1.* from t1 left join t2 using (b, c)"), new String[][]{{"1"}, {"2"}, {"4"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select t1.* from t1 right join t2 using (b, c)"), new String[][]{{"1"}, {null}, {null}});
        JDBC.assertSingleValueResultSet(statement.executeQuery("select t3.e from t1 join t2 using (b) join t3 using (d)"), "def");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select t3.e from t1 join t2 join t3 using (d) using (b)"), "def");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 left join t2 using (b) right join t3 using (d)"), new String[][]{{"2", null, null, null, null, "abc", "3"}, {"4", "2", "1", "3", "3", "def", "5"}, {null, null, null, null, null, null, null}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 left join t2 right join t3 using (d) using (b)"), new String[][]{{"2", "1", "3", "4", "3", "def", "5"}, {"3", "2", "4", null, null, null, null}, {"4", "4", "4", null, null, null, null}});
        JDBC.assertSingleValueResultSet(statement.executeQuery("select a from t1 join t2 using (b, c)"), "1");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 join t2 using (\"B\")"), new String[][]{{"2", "1", "3", "3", "4"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select b from t1 left join t2 using (b)"), new String[][]{{"2"}, {"3"}, {"4"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select b from t1 right join t2 using (b)"), new String[][]{{"1"}, {"2"}, {"5"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select d, t2.d, t3.d from t2 left join t3 using (d)"), new String[][]{{"3", "3", null}, {"4", "4", "4"}, {"5", "5", null}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select d, t2.d, t3.d from t2 right join t3 using (d)"), new String[][]{{"2", null, "2"}, {"4", "4", "4"}, {null, null, null}});
        JDBC.assertEmpty(statement.executeQuery("select * from t2 left join t3 using (d) where d is null"));
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t2 right join t3 using (d) where d is null"), new String[][]{{null, null, null, null, null}});
        JDBC.assertFullResultSet(statement.executeQuery("select c from t1 left join t2 using (b, c) order by c desc nulls last"), new String[][]{{"4"}, {"4"}, {"3"}});
        JDBC.assertFullResultSet(statement.executeQuery("select c from t1 left join t2 using (b, c) order by t1.c desc nulls last"), new String[][]{{"4"}, {"4"}, {"3"}});
        JDBC.assertFullResultSet(statement.executeQuery("select c from t1 left join t2 using (b, c) order by t2.c desc nulls last"), new String[][]{{"3"}, {"4"}, {"4"}});
        JDBC.assertSingleValueResultSet(statement.executeQuery("select c from t1 right join t2 using (b, c) order by c desc nulls last fetch next row only"), "5");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select c from t1 right join t2 using (b, c) order by t1.c desc nulls last fetch next row only"), "3");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select c from t1 right join t2 using (b, c) order by t2.c desc nulls last fetch next row only"), "5");
        JDBC.assertFullResultSet(statement.executeQuery("select b, count(t2.b) from t1 left join t2 using (b) group by b order by b"), new String[][]{{"2", "1"}, {"3", "0"}, {"4", "0"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 table_a(col1, col2, col3) inner join t3 table_b(col1, col2, col3) using (col1)"), new String[][]{{"2", "3", "4", "abc", "3"}, {"4", "4", "4", "def", "5"}});
        JoinTest.assertStatementError(AMBIGUOUS_COLNAME, statement, "select b from t1 join t2 using (b) join t3 using(c)");
        JoinTest.assertStatementError(AMBIGUOUS_COLNAME, statement, "select b from t1 join t2 using (c)");
        JoinTest.assertStatementError(AMBIGUOUS_COLNAME, statement, "select * from t1 join t2 using (b) order by c");
        JoinTest.assertStatementError(SYNTAX_ERROR, statement, "select * from t1 join t2 using (t1.b)");
        JoinTest.assertStatementError(SYNTAX_ERROR, statement, "select * from t1 join t2 using b");
        JoinTest.assertStatementError(SYNTAX_ERROR, statement, "select * from t1 join t2 using ()");
        JoinTest.assertStatementError(NON_COMPARABLE, statement, "select * from t2 a(x,y,z) join t3 b(x,y,z) using(y)");
        JoinTest.assertStatementError(COLUMN_NOT_IN_SCOPE, statement, "select t3.e from t1 join t2 join t3 using (b) using (d)");
        JoinTest.assertStatementError(COLUMN_NOT_IN_SCOPE, statement, "select * from t1 join t2 using (a)");
        JoinTest.assertStatementError(COLUMN_NOT_IN_SCOPE, statement, "select * from t1 join t2 using (d)");
        JoinTest.assertStatementError(COLUMN_NOT_IN_SCOPE, statement, "select * from t1 join t2 using (a,d)");
        JoinTest.assertStatementError(COLUMN_NOT_IN_SCOPE, statement, "select * from t1 join t2 using (a,b,c)");
        JoinTest.assertStatementError(COLUMN_NOT_IN_SCOPE, statement, "select * from t1 join t2 using (x)");
        JoinTest.assertStatementError(COLUMN_NOT_IN_SCOPE, statement, "select * from t1 join t2 using (b,c,x)");
        JoinTest.assertStatementError(AMBIGUOUS_COLNAME, statement, "select * from (t1 cross join t2) join t2 tt2 using(b)");
        JoinTest.assertStatementError(NO_COLUMNS, statement, "select x.* from t1 x inner join t1 y using (a,b,c)");
        JoinTest.assertStatementError(NO_COLUMNS, statement, "select x.* from t1 x left join t1 y using (a,b,c)");
        JoinTest.assertStatementError(NO_COLUMNS, statement, "select x.* from t1 x right join t1 y using (a,b,c)");
        JoinTest.assertStatementError(NO_COLUMNS, statement, "select x.*, y.* from t1 x inner join t1 y using (a, b, c)");
        JoinTest.assertStatementError(TABLE_NAME_NOT_IN_SCOPE, statement, "select xyz.* from t1 join t2 using (b)");
    }

    public void testNaturalJoin() throws SQLException {
        this.setAutoCommit(false);
        String[][] stringArray = new String[][]{{"1", "2", "3"}, {"4", "5", "6"}, {"7", "8", "9"}};
        String[][] stringArray2 = new String[][]{{"4", "3", "2"}, {"1", "2", "3"}, {"3", "2", "1"}};
        String[][] stringArray3 = new String[][]{{"4", "100"}};
        Statement statement = this.createStatement();
        statement.execute("create table t1(a int, b int, c int)");
        statement.execute("create table t2(d int, c int, b int)");
        statement.execute("create table t3(d int, e int)");
        this.fillTable("insert into t1 values (?,?,?)", stringArray);
        this.fillTable("insert into t2 values (?,?,?)", stringArray2);
        this.fillTable("insert into t3 values (?,?)", stringArray3);
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t2 natural join t3"), new String[][]{{"4", "3", "2", "100"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t3 natural join t2"), new String[][]{{"4", "100", "3", "2"}});
        ResultSet resultSet = statement.executeQuery("select * from t1 natural join t2");
        JDBC.assertColumnNames(resultSet, "B", "C", "A", "D");
        JDBC.assertUnorderedResultSet(resultSet, new String[][]{{"2", "3", "1", "4"}});
        resultSet = statement.executeQuery("select * from t2 natural join t1");
        JDBC.assertColumnNames(resultSet, "C", "B", "D", "A");
        JDBC.assertUnorderedResultSet(resultSet, new String[][]{{"3", "2", "4", "1"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 natural join t3"), JoinTest.cross(stringArray, stringArray3));
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 as a(c1, c2, c3) natural join t2 as b(c4, c5, c6)"), JoinTest.cross(stringArray, stringArray2));
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from (values 1,2) v1(x) natural join (values 'a','b') v2(y)"), new String[][]{{"1", "a"}, {"1", "b"}, {"2", "a"}, {"2", "b"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from (select * from t1) table1 natural join (select * from t2) table2"), new String[][]{{"2", "3", "1", "4"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from (select b+c from t1) as x natural join (select b+c from t2) as y"), JoinTest.cross(new String[][]{{"5"}, {"11"}, {"17"}}, new String[][]{{"5"}, {"5"}, {"3"}}));
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from (select b+c c1 from t1) as x natural join (select b+c c1 from t2) as y"), new String[][]{{"5"}, {"5"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 natural join t2 natural join t3"), new String[][]{{"4", "2", "3", "1", "100"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from (t1 natural join t2) natural join t3"), new String[][]{{"4", "2", "3", "1", "100"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 natural join (t2 natural join t3)"), new String[][]{{"2", "3", "1", "4", "100"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 natural join t2 cross join t3"), new String[][]{{"2", "3", "1", "4", "4", "100"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 natural join t2 inner join t3 on 1=1"), new String[][]{{"2", "3", "1", "4", "4", "100"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 cross join t2 natural join t3"), new String[][]{{"4", "1", "2", "3", "3", "2", "100"}, {"4", "4", "5", "6", "3", "2", "100"}, {"4", "7", "8", "9", "3", "2", "100"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 inner join t2 on 1=1 natural join t3"), new String[][]{{"4", "1", "2", "3", "3", "2", "100"}, {"4", "4", "5", "6", "3", "2", "100"}, {"4", "7", "8", "9", "3", "2", "100"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 inner join t2 natural join t3 on 1=1"), new String[][]{{"1", "2", "3", "4", "3", "2", "100"}, {"4", "5", "6", "4", "3", "2", "100"}, {"7", "8", "9", "4", "3", "2", "100"}});
        statement.execute("create table insert_src (c1 int, c2 int, c3 int, c4 int)");
        statement.execute("insert into insert_src select * from t1 natural join t2");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from insert_src"), new String[][]{{"2", "3", "1", "4"}});
        JDBC.assertSingleValueResultSet(statement.executeQuery("select t1.* from t1 natural join t2"), "1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select t2.* from t1 natural join t2"), "4");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select t1.*, t2.* from t1 natural join t2"), new String[][]{{"1", "4"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 natural inner join t2"), new String[][]{{"2", "3", "1", "4"}});
        String[][] stringArray4 = new String[][]{{"2", "3", "1", "4"}, {"5", "6", "4", null}, {"8", "9", "7", null}};
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 natural left join t2"), stringArray4);
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 natural left outer join t2"), stringArray4);
        JDBC.assertUnorderedResultSet(statement.executeQuery("select b, t1.b, t2.b from t1 natural left join t2"), new String[][]{{"2", "2", "2"}, {"5", "5", null}, {"8", "8", null}});
        String[][] stringArray5 = new String[][]{{"1", "2", null, "3"}, {"2", "3", "1", "4"}, {"3", "2", null, "1"}};
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 natural right join t2"), stringArray5);
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 natural right outer join t2"), stringArray5);
        JDBC.assertUnorderedResultSet(statement.executeQuery("select b, t1.b, t2.b from t1 natural right join t2"), new String[][]{{"1", null, "1"}, {"2", "2", "2"}, {"3", null, "3"}});
        JoinTest.assertStatementError(SYNTAX_ERROR, statement, "select * from t1 natural join t2 on t1.b=t2.b");
        JoinTest.assertStatementError(SYNTAX_ERROR, statement, "select * from t1 natural join t2 using (b)");
        JoinTest.assertStatementError(SYNTAX_ERROR, statement, "select * from t1 natural cross join t2");
        JoinTest.assertStatementError(AMBIGUOUS_COLNAME, statement, "select * from t1 t(d,x,y) natural join (t2 cross join t3)");
        JoinTest.assertStatementError(NO_COLUMNS, statement, "select x.* from t1 x natural join t1 y");
        JoinTest.assertStatementError(NO_COLUMNS, statement, "select y.* from t1 x natural join t1 y");
        JoinTest.assertStatementError(NO_COLUMNS, statement, "select x.*, y.* from t1 x natural join t1 y");
        JoinTest.assertStatementError(NON_COMPARABLE, statement, "select * from t1 natural join (values ('one', 'two')) v1(a,b)");
    }

    public void testSubqueryInON() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table t1(a int)");
        statement.execute("insert into t1 values 1,2,3");
        statement.execute("create table t2(b int)");
        statement.execute("insert into t2 values 1,2");
        statement.execute("create table t3(c int)");
        statement.execute("insert into t3 values 2,3");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 join t2 on a = some (select c from t3)"), new String[][]{{"2", "1"}, {"2", "2"}, {"3", "1"}, {"3", "2"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t1 left join t2 on a = b and b not in (select c from t3)"), new String[][]{{"1", "1"}, {"2", null}, {"3", null}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from t3 join t2 on exists (select * from t2 join t1 on exists (select * from t3 where c = a))"), new String[][]{{"2", "1"}, {"2", "2"}, {"3", "1"}, {"3", "2"}});
        JDBC.assertSingleValueResultSet(statement.executeQuery("select a from t1 join t2 on a = (select count(*) from t3) and a = b"), "2");
        JDBC.assertEmpty(statement.executeQuery("select * from t1 join t2 on exists (select * from t3 x left join t3 y on 1=0 where y.c=1)"));
    }

    public void testDerby4387() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table c (a int, b int, c int)");
        statement.executeUpdate("create table cc (aa int)");
        ResultSet resultSet = statement.executeQuery("select * from cc t1, c t2, cc t3     where t3.aa = t2.a and           t3.aa = t2.b and           t3.aa = t2.c");
        this.rollback();
    }

    public void testDerby_4405() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("CREATE TABLE COUNTRIES(COUNTRY VARCHAR(26) UNIQUE NOT NULL,COUNTRY_ISO_CODE CHAR(2) PRIMARY KEY NOT NULL)");
        statement.execute("CREATE TABLE CITIES(CITY_ID INTEGER primary key NOT NULL ,COUNTRY VARCHAR(26) NOT NULL,AIRPORT VARCHAR(3))");
        statement.execute("CREATE TABLE FLIGHTS(FLIGHT_ID CHAR(6) NOT NULL ,ORIG_AIRPORT CHAR(3),PRIMARY KEY (FLIGHT_ID))");
        statement.execute("CREATE INDEX ORIGINDEX ON FLIGHTS (ORIG_AIRPORT)");
        PreparedStatement preparedStatement = this.getConnection().prepareStatement("insert into COUNTRIES values ( ?,? )");
        JoinTest.insertTourRow(preparedStatement, "Afghanistan", "AF");
        JoinTest.insertTourRow(preparedStatement, "Albania", "AL");
        JoinTest.insertTourRow(preparedStatement, "Algeria", "DZ");
        JoinTest.insertTourRow(preparedStatement, "American Samoa", "AS");
        JoinTest.insertTourRow(preparedStatement, "Angola", "AO");
        JoinTest.insertTourRow(preparedStatement, "Argentina", "AR");
        JoinTest.insertTourRow(preparedStatement, "Armenia", "AM");
        JoinTest.insertTourRow(preparedStatement, "Australia", "AU");
        JoinTest.insertTourRow(preparedStatement, "Austria", "AT");
        JoinTest.insertTourRow(preparedStatement, "Azerbaijan", "AZ");
        JoinTest.insertTourRow(preparedStatement, "Bahamas", "BS");
        JoinTest.insertTourRow(preparedStatement, "Bangladesh", "BD");
        JoinTest.insertTourRow(preparedStatement, "Barbados", "BB");
        JoinTest.insertTourRow(preparedStatement, "Belgium", "BE");
        JoinTest.insertTourRow(preparedStatement, "Belize", "BZ");
        JoinTest.insertTourRow(preparedStatement, "Bermuda", "BM");
        JoinTest.insertTourRow(preparedStatement, "Bolivia", "BO");
        JoinTest.insertTourRow(preparedStatement, "Botswana", "BW");
        JoinTest.insertTourRow(preparedStatement, "Brazil", "BR");
        JoinTest.insertTourRow(preparedStatement, "Bulgaria", "BG");
        JoinTest.insertTourRow(preparedStatement, "Cambodia", "KH");
        JoinTest.insertTourRow(preparedStatement, "Cameroon", "CM");
        JoinTest.insertTourRow(preparedStatement, "Canada", "CA");
        JoinTest.insertTourRow(preparedStatement, "Cape Verde", "CV");
        JoinTest.insertTourRow(preparedStatement, "Chile", "CL");
        JoinTest.insertTourRow(preparedStatement, "China", "CN");
        JoinTest.insertTourRow(preparedStatement, "Colombia", "CO");
        JoinTest.insertTourRow(preparedStatement, "Congo", "CG");
        JoinTest.insertTourRow(preparedStatement, "Costa Rica", "CR");
        JoinTest.insertTourRow(preparedStatement, "Cote d'Ivoire", "CI");
        JoinTest.insertTourRow(preparedStatement, "Cuba", "CU");
        JoinTest.insertTourRow(preparedStatement, "Czech Republic", "CZ");
        JoinTest.insertTourRow(preparedStatement, "Denmark", "DK");
        JoinTest.insertTourRow(preparedStatement, "Dominical Republic", "DO");
        JoinTest.insertTourRow(preparedStatement, "Ecuador", "EC");
        JoinTest.insertTourRow(preparedStatement, "Egypt", "EG");
        JoinTest.insertTourRow(preparedStatement, "El Salvador", "SV");
        JoinTest.insertTourRow(preparedStatement, "Ethiopia", "ET");
        JoinTest.insertTourRow(preparedStatement, "Falkland Islands", "FK");
        JoinTest.insertTourRow(preparedStatement, "Fiji", "FJ");
        JoinTest.insertTourRow(preparedStatement, "Finland", "FI");
        JoinTest.insertTourRow(preparedStatement, "France", "FR");
        JoinTest.insertTourRow(preparedStatement, "Georgia", "GE");
        JoinTest.insertTourRow(preparedStatement, "Germany", "DE");
        JoinTest.insertTourRow(preparedStatement, "Ghana", "GH");
        JoinTest.insertTourRow(preparedStatement, "Greece", "GR");
        JoinTest.insertTourRow(preparedStatement, "Guadeloupe", "GP");
        JoinTest.insertTourRow(preparedStatement, "Guatemala", "GT");
        JoinTest.insertTourRow(preparedStatement, "Honduras", "HN");
        JoinTest.insertTourRow(preparedStatement, "Hungary", "HU");
        JoinTest.insertTourRow(preparedStatement, "Iceland", "IS");
        JoinTest.insertTourRow(preparedStatement, "India", "IN");
        JoinTest.insertTourRow(preparedStatement, "Indonesia", "ID");
        JoinTest.insertTourRow(preparedStatement, "Iran", "IR");
        JoinTest.insertTourRow(preparedStatement, "Iraq", "IQ");
        JoinTest.insertTourRow(preparedStatement, "Ireland", "IE");
        JoinTest.insertTourRow(preparedStatement, "Israel", "IL");
        JoinTest.insertTourRow(preparedStatement, "Italy", "IT");
        JoinTest.insertTourRow(preparedStatement, "Jamaica", "JM");
        JoinTest.insertTourRow(preparedStatement, "Japan", "JP");
        JoinTest.insertTourRow(preparedStatement, "Jordan", "JO");
        JoinTest.insertTourRow(preparedStatement, "Kenya", "KE");
        JoinTest.insertTourRow(preparedStatement, "Lebanon", "LB");
        JoinTest.insertTourRow(preparedStatement, "Lithuania", "LT");
        JoinTest.insertTourRow(preparedStatement, "Madagascar", "MG");
        JoinTest.insertTourRow(preparedStatement, "Malaysia", "MY");
        JoinTest.insertTourRow(preparedStatement, "Mali", "ML");
        JoinTest.insertTourRow(preparedStatement, "Mexico", "MX");
        JoinTest.insertTourRow(preparedStatement, "Morocco", "MA");
        JoinTest.insertTourRow(preparedStatement, "Mozambique", "MZ");
        JoinTest.insertTourRow(preparedStatement, "Nepal", "NP");
        JoinTest.insertTourRow(preparedStatement, "Netherlands", "NL");
        JoinTest.insertTourRow(preparedStatement, "New Zealand", "NZ");
        JoinTest.insertTourRow(preparedStatement, "Nicaragua", "NI");
        JoinTest.insertTourRow(preparedStatement, "Nigeria", "NG");
        JoinTest.insertTourRow(preparedStatement, "Norway", "NO");
        JoinTest.insertTourRow(preparedStatement, "Pakistan", "PK");
        JoinTest.insertTourRow(preparedStatement, "Paraguay", "PY");
        JoinTest.insertTourRow(preparedStatement, "Peru", "PE");
        JoinTest.insertTourRow(preparedStatement, "Philippines", "PH");
        JoinTest.insertTourRow(preparedStatement, "Poland", "PL");
        JoinTest.insertTourRow(preparedStatement, "Portugal", "PT");
        JoinTest.insertTourRow(preparedStatement, "Russia", "RU");
        JoinTest.insertTourRow(preparedStatement, "Samoa", "WS");
        JoinTest.insertTourRow(preparedStatement, "Senegal", "SN");
        JoinTest.insertTourRow(preparedStatement, "Sierra Leone", "SL");
        JoinTest.insertTourRow(preparedStatement, "Singapore", "SG");
        JoinTest.insertTourRow(preparedStatement, "Slovakia", "SK");
        JoinTest.insertTourRow(preparedStatement, "South Africa", "ZA");
        JoinTest.insertTourRow(preparedStatement, "Spain", "ES");
        JoinTest.insertTourRow(preparedStatement, "Sri Lanka", "LK");
        JoinTest.insertTourRow(preparedStatement, "Sudan", "SD");
        JoinTest.insertTourRow(preparedStatement, "Sweden", "SE");
        JoinTest.insertTourRow(preparedStatement, "Switzerland", "CH");
        JoinTest.insertTourRow(preparedStatement, "Syrian Arab Republic", "SY");
        JoinTest.insertTourRow(preparedStatement, "Tajikistan", "TJ");
        JoinTest.insertTourRow(preparedStatement, "Tanzania", "TZ");
        JoinTest.insertTourRow(preparedStatement, "Thailand", "TH");
        JoinTest.insertTourRow(preparedStatement, "Trinidad and Tobago", "TT");
        JoinTest.insertTourRow(preparedStatement, "Tunisia", "TN");
        JoinTest.insertTourRow(preparedStatement, "Turkey", "TR");
        JoinTest.insertTourRow(preparedStatement, "Ukraine", "UA");
        JoinTest.insertTourRow(preparedStatement, "United Kingdom", "GB");
        JoinTest.insertTourRow(preparedStatement, "United States", "US");
        JoinTest.insertTourRow(preparedStatement, "Uruguay", "UY");
        JoinTest.insertTourRow(preparedStatement, "Uzbekistan", "UZ");
        JoinTest.insertTourRow(preparedStatement, "Venezuela", "VE");
        JoinTest.insertTourRow(preparedStatement, "Viet Nam", "VN");
        JoinTest.insertTourRow(preparedStatement, "Virgin Islands (British)", "VG");
        JoinTest.insertTourRow(preparedStatement, "Virgin Islands (U.S.)", "VI");
        JoinTest.insertTourRow(preparedStatement, "Yugoslavia", "YU");
        JoinTest.insertTourRow(preparedStatement, "Zaire", "ZR");
        JoinTest.insertTourRow(preparedStatement, "Zimbabwe", "ZW");
        preparedStatement = this.getConnection().prepareStatement("insert into CITIES VALUES (?,?,?)");
        JoinTest.insertTourRow(preparedStatement, 1, "Netherlands", "AMS");
        JoinTest.insertTourRow(preparedStatement, 2, "Greece", "ATH");
        JoinTest.insertTourRow(preparedStatement, 3, "New Zealand", "AKL");
        JoinTest.insertTourRow(preparedStatement, 4, "Lebanon", "BEY");
        JoinTest.insertTourRow(preparedStatement, 5, "Colombia", "BOG");
        JoinTest.insertTourRow(preparedStatement, 6, "India", "BOM");
        JoinTest.insertTourRow(preparedStatement, 7, "Hungary", "BUD");
        JoinTest.insertTourRow(preparedStatement, 8, "Argentina", "BUE");
        JoinTest.insertTourRow(preparedStatement, 9, "Egypt", "CAI");
        JoinTest.insertTourRow(preparedStatement, 10, "India", "CCU");
        JoinTest.insertTourRow(preparedStatement, 11, "South Africa", "CPT");
        JoinTest.insertTourRow(preparedStatement, 12, "Venezuela", "CCS");
        JoinTest.insertTourRow(preparedStatement, 13, "Morocco", "CAS");
        JoinTest.insertTourRow(preparedStatement, 14, "Denmark", "CPH");
        JoinTest.insertTourRow(preparedStatement, 15, "Ireland", "DUB");
        JoinTest.insertTourRow(preparedStatement, 16, "Switzerland", "GVA");
        JoinTest.insertTourRow(preparedStatement, 17, "China", "HKG");
        JoinTest.insertTourRow(preparedStatement, 18, "Turkey", "IST");
        JoinTest.insertTourRow(preparedStatement, 19, "Indonesia", "JKT");
        JoinTest.insertTourRow(preparedStatement, 20, "Afghanistan", "KBL");
        JoinTest.insertTourRow(preparedStatement, 21, "Pakistan", "KHI");
        JoinTest.insertTourRow(preparedStatement, 22, "Nigeria", "LOS");
        JoinTest.insertTourRow(preparedStatement, 23, "Peru", "LIM");
        JoinTest.insertTourRow(preparedStatement, 24, "Portugal", "LIS");
        JoinTest.insertTourRow(preparedStatement, 25, "United Kingdom", "LHR");
        JoinTest.insertTourRow(preparedStatement, 26, "Spain", "MAD");
        JoinTest.insertTourRow(preparedStatement, 27, "Philippines", "MNL");
        JoinTest.insertTourRow(preparedStatement, 28, "Australia", "MEL");
        JoinTest.insertTourRow(preparedStatement, 29, "Mexico", "MEX");
        JoinTest.insertTourRow(preparedStatement, 30, "Canada", "YUL");
        JoinTest.insertTourRow(preparedStatement, 31, "Russia", "SVO");
        JoinTest.insertTourRow(preparedStatement, 32, "Kenya", "NBO");
        JoinTest.insertTourRow(preparedStatement, 33, "Japan", "OSA");
        JoinTest.insertTourRow(preparedStatement, 34, "Norway", "OSL");
        JoinTest.insertTourRow(preparedStatement, 35, "France", "CDG");
        JoinTest.insertTourRow(preparedStatement, 36, "Czech Republic", "PRG");
        JoinTest.insertTourRow(preparedStatement, 37, "Iceland", "REY");
        JoinTest.insertTourRow(preparedStatement, 38, "Brazil", "GIG");
        JoinTest.insertTourRow(preparedStatement, 39, "Italy", "FCO");
        JoinTest.insertTourRow(preparedStatement, 40, "Chile", "SCL");
        JoinTest.insertTourRow(preparedStatement, 41, "Brazil", "GRU");
        JoinTest.insertTourRow(preparedStatement, 43, "China", "SHA");
        JoinTest.insertTourRow(preparedStatement, 44, "Singapore", "SIN");
        JoinTest.insertTourRow(preparedStatement, 45, "Sweden", "ARN");
        JoinTest.insertTourRow(preparedStatement, 46, "Australia", "SYD");
        JoinTest.insertTourRow(preparedStatement, 47, "United States", "SJC");
        JoinTest.insertTourRow(preparedStatement, 48, "Iran", "THR");
        JoinTest.insertTourRow(preparedStatement, 49, "Japan", "NRT");
        JoinTest.insertTourRow(preparedStatement, 50, "Canada", "YYZ");
        JoinTest.insertTourRow(preparedStatement, 51, "Poland", "WAW");
        JoinTest.insertTourRow(preparedStatement, 52, "United States", "ALB");
        JoinTest.insertTourRow(preparedStatement, 53, "United States", "ABQ");
        JoinTest.insertTourRow(preparedStatement, 54, "United States", "ATL");
        JoinTest.insertTourRow(preparedStatement, 55, "United States", "BOI");
        JoinTest.insertTourRow(preparedStatement, 56, "United States", "BOS");
        JoinTest.insertTourRow(preparedStatement, 57, "United States", "CHS");
        JoinTest.insertTourRow(preparedStatement, 58, "United States", "MDW");
        JoinTest.insertTourRow(preparedStatement, 59, "United States", "CLE");
        JoinTest.insertTourRow(preparedStatement, 60, "United States", "DFW");
        JoinTest.insertTourRow(preparedStatement, 61, "United States", "DEN");
        JoinTest.insertTourRow(preparedStatement, 62, "United States", "DSM");
        JoinTest.insertTourRow(preparedStatement, 63, "United States", "FAI");
        JoinTest.insertTourRow(preparedStatement, 64, "United States", "HLN");
        JoinTest.insertTourRow(preparedStatement, 65, "United States", "HNL");
        JoinTest.insertTourRow(preparedStatement, 66, "United States", "HOU");
        JoinTest.insertTourRow(preparedStatement, 67, "United States", "JNU");
        JoinTest.insertTourRow(preparedStatement, 68, "United States", "MCI");
        JoinTest.insertTourRow(preparedStatement, 69, "United States", "LAX");
        JoinTest.insertTourRow(preparedStatement, 70, "United States", "MEM");
        JoinTest.insertTourRow(preparedStatement, 71, "United States", "MIA");
        JoinTest.insertTourRow(preparedStatement, 72, "United States", "MKE");
        JoinTest.insertTourRow(preparedStatement, 73, "United States", "MSP");
        JoinTest.insertTourRow(preparedStatement, 74, "United States", "BNA");
        JoinTest.insertTourRow(preparedStatement, 75, "United States", "MSY");
        JoinTest.insertTourRow(preparedStatement, 76, "United States", "JFK");
        JoinTest.insertTourRow(preparedStatement, 77, "United States", "OKC");
        JoinTest.insertTourRow(preparedStatement, 78, "United States", "PHL");
        JoinTest.insertTourRow(preparedStatement, 79, "United States", "PHX");
        JoinTest.insertTourRow(preparedStatement, 80, "United States", "STL");
        JoinTest.insertTourRow(preparedStatement, 81, "United States", "SLC");
        JoinTest.insertTourRow(preparedStatement, 82, "United States", "SAT");
        JoinTest.insertTourRow(preparedStatement, 83, "United States", "SAN");
        JoinTest.insertTourRow(preparedStatement, 84, "United States", "SFO");
        JoinTest.insertTourRow(preparedStatement, 85, "United States", "SJU");
        JoinTest.insertTourRow(preparedStatement, 86, "United States", "SEA");
        JoinTest.insertTourRow(preparedStatement, 87, "United States", "IAD");
        preparedStatement = this.getConnection().prepareStatement("insert into FLIGHTS values (?,?)");
        JoinTest.insertTourRow(preparedStatement, "AA1111", "ABQ");
        JoinTest.insertTourRow(preparedStatement, "AA1112", "LAX");
        JoinTest.insertTourRow(preparedStatement, "AA1113", "ABQ");
        JoinTest.insertTourRow(preparedStatement, "AA1114", "PHX");
        JoinTest.insertTourRow(preparedStatement, "AA1115", "ABQ");
        JoinTest.insertTourRow(preparedStatement, "AA1116", "OKC");
        JoinTest.insertTourRow(preparedStatement, "AA1117", "AKL");
        JoinTest.insertTourRow(preparedStatement, "AA1118", "HNL");
        JoinTest.insertTourRow(preparedStatement, "AA1119", "AKL");
        JoinTest.insertTourRow(preparedStatement, "AA1120", "NRT");
        JoinTest.insertTourRow(preparedStatement, "AA1121", "AKL");
        JoinTest.insertTourRow(preparedStatement, "AA1122", "SYD");
        JoinTest.insertTourRow(preparedStatement, "AA1123", "ALB");
        JoinTest.insertTourRow(preparedStatement, "AA1124", "JFK");
        JoinTest.insertTourRow(preparedStatement, "AA1125", "ALB");
        JoinTest.insertTourRow(preparedStatement, "AA1126", "BOS");
        JoinTest.insertTourRow(preparedStatement, "AA1127", "ALB");
        JoinTest.insertTourRow(preparedStatement, "AA1128", "IAD");
        JoinTest.insertTourRow(preparedStatement, "US1517", "AMS");
        JoinTest.insertTourRow(preparedStatement, "US1516", "JFK");
        JoinTest.insertTourRow(preparedStatement, "AA1131", "AMS");
        JoinTest.insertTourRow(preparedStatement, "AA1132", "ATH");
        JoinTest.insertTourRow(preparedStatement, "AA1133", "AMS");
        JoinTest.insertTourRow(preparedStatement, "AA1134", "CDG");
        JoinTest.insertTourRow(preparedStatement, "AA1135", "ARN");
        JoinTest.insertTourRow(preparedStatement, "AA1136", "BOS");
        JoinTest.insertTourRow(preparedStatement, "AA1137", "ARN");
        JoinTest.insertTourRow(preparedStatement, "AA1138", "SVO");
        JoinTest.insertTourRow(preparedStatement, "AA1139", "ARN");
        JoinTest.insertTourRow(preparedStatement, "AA1140", "CPH");
        JoinTest.insertTourRow(preparedStatement, "AA1141", "ATH");
        JoinTest.insertTourRow(preparedStatement, "AA1142", "LHR");
        JoinTest.insertTourRow(preparedStatement, "AA1143", "ATH");
        JoinTest.insertTourRow(preparedStatement, "AA1144", "CAI");
        JoinTest.insertTourRow(preparedStatement, "AA1145", "ATH");
        JoinTest.insertTourRow(preparedStatement, "AA1146", "CDG");
        JoinTest.insertTourRow(preparedStatement, "AA1147", "ATL");
        JoinTest.insertTourRow(preparedStatement, "AA1148", "LAX");
        JoinTest.insertTourRow(preparedStatement, "AA1149", "ATL");
        JoinTest.insertTourRow(preparedStatement, "AA1150", "DFW");
        JoinTest.insertTourRow(preparedStatement, "AA1151", "ATL");
        JoinTest.insertTourRow(preparedStatement, "AA1152", "SEA");
        JoinTest.insertTourRow(preparedStatement, "AA1153", "BEY");
        JoinTest.insertTourRow(preparedStatement, "AA1154", "CAI");
        JoinTest.insertTourRow(preparedStatement, "AA1270", "BEY");
        JoinTest.insertTourRow(preparedStatement, "AA1269", "MAD");
        JoinTest.insertTourRow(preparedStatement, "AA1157", "BEY");
        JoinTest.insertTourRow(preparedStatement, "AA1158", "BOM");
        JoinTest.insertTourRow(preparedStatement, "AA1159", "BNA");
        JoinTest.insertTourRow(preparedStatement, "AA1160", "MIA");
        JoinTest.insertTourRow(preparedStatement, "AA1161", "BNA");
        JoinTest.insertTourRow(preparedStatement, "AA1162", "JFK");
        JoinTest.insertTourRow(preparedStatement, "AA1163", "BNA");
        JoinTest.insertTourRow(preparedStatement, "AA1164", "GIG");
        JoinTest.insertTourRow(preparedStatement, "US1591", "BOG");
        JoinTest.insertTourRow(preparedStatement, "AA1190", "MIA");
        JoinTest.insertTourRow(preparedStatement, "AA1167", "BOG");
        JoinTest.insertTourRow(preparedStatement, "AA1168", "LIM");
        JoinTest.insertTourRow(preparedStatement, "AA1169", "BOG");
        JoinTest.insertTourRow(preparedStatement, "AA1170", "GIG");
        JoinTest.insertTourRow(preparedStatement, "AA1171", "BOI");
        JoinTest.insertTourRow(preparedStatement, "AA1172", "SEA");
        JoinTest.insertTourRow(preparedStatement, "AA1173", "BOI");
        JoinTest.insertTourRow(preparedStatement, "AA1174", "DSM");
        JoinTest.insertTourRow(preparedStatement, "AA1175", "BOI");
        JoinTest.insertTourRow(preparedStatement, "AA1176", "HLN");
        JoinTest.insertTourRow(preparedStatement, "AA1177", "BOM");
        JoinTest.insertTourRow(preparedStatement, "AA1178", "CCU");
        JoinTest.insertTourRow(preparedStatement, "AA1179", "BOM");
        JoinTest.insertTourRow(preparedStatement, "AA1180", "KHI");
        JoinTest.insertTourRow(preparedStatement, "AA1181", "BOM");
        JoinTest.insertTourRow(preparedStatement, "AA1182", "HKG");
        JoinTest.insertTourRow(preparedStatement, "AA1183", "BOS");
        JoinTest.insertTourRow(preparedStatement, "AA1184", "SFO");
        JoinTest.insertTourRow(preparedStatement, "AA1185", "BOS");
        JoinTest.insertTourRow(preparedStatement, "AA1186", "MIA");
        JoinTest.insertTourRow(preparedStatement, "AA1187", "BOS");
        JoinTest.insertTourRow(preparedStatement, "AA1188", "IAD");
        JoinTest.insertTourRow(preparedStatement, "AA1189", "BUD");
        JoinTest.insertTourRow(preparedStatement, "AA1191", "BUD");
        JoinTest.insertTourRow(preparedStatement, "AA1192", "SVO");
        JoinTest.insertTourRow(preparedStatement, "AA1193", "BUD");
        JoinTest.insertTourRow(preparedStatement, "AA1194", "FCO");
        JoinTest.insertTourRow(preparedStatement, "AA1195", "CAI");
        JoinTest.insertTourRow(preparedStatement, "AA1196", "MIA");
        JoinTest.insertTourRow(preparedStatement, "AA1197", "CAI");
        JoinTest.insertTourRow(preparedStatement, "AA1198", "IST");
        JoinTest.insertTourRow(preparedStatement, "AA1199", "CAI");
        JoinTest.insertTourRow(preparedStatement, "AA1200", "GIG");
        JoinTest.insertTourRow(preparedStatement, "AA1201", "CAS");
        JoinTest.insertTourRow(preparedStatement, "AA1202", "KHI");
        JoinTest.insertTourRow(preparedStatement, "AA1203", "CAS");
        JoinTest.insertTourRow(preparedStatement, "AA1204", "LOS");
        JoinTest.insertTourRow(preparedStatement, "AA1205", "CAS");
        JoinTest.insertTourRow(preparedStatement, "AA1206", "MAD");
        JoinTest.insertTourRow(preparedStatement, "AA1207", "CCS");
        JoinTest.insertTourRow(preparedStatement, "AA1208", "SCL");
        JoinTest.insertTourRow(preparedStatement, "AA1209", "CCS");
        JoinTest.insertTourRow(preparedStatement, "AA1210", "MEX");
        JoinTest.insertTourRow(preparedStatement, "AA1211", "CCS");
        JoinTest.insertTourRow(preparedStatement, "AA1212", "BUE");
        JoinTest.insertTourRow(preparedStatement, "AA1213", "CCU");
        JoinTest.insertTourRow(preparedStatement, "AA1214", "HKG");
        JoinTest.insertTourRow(preparedStatement, "AA1215", "CCU");
        JoinTest.insertTourRow(preparedStatement, "AA1216", "NRT");
        JoinTest.insertTourRow(preparedStatement, "AA1217", "CCU");
        JoinTest.insertTourRow(preparedStatement, "AA1218", "SIN");
        JoinTest.insertTourRow(preparedStatement, "AA1219", "CDG");
        JoinTest.insertTourRow(preparedStatement, "AA1220", "LHR");
        JoinTest.insertTourRow(preparedStatement, "AA1221", "CDG");
        JoinTest.insertTourRow(preparedStatement, "AA1222", "JFK");
        JoinTest.insertTourRow(preparedStatement, "AA1223", "CDG");
        JoinTest.insertTourRow(preparedStatement, "AA1224", "SVO");
        JoinTest.insertTourRow(preparedStatement, "AA1225", "CHS");
        JoinTest.insertTourRow(preparedStatement, "AA1226", "ATL");
        JoinTest.insertTourRow(preparedStatement, "AA1227", "CHS");
        JoinTest.insertTourRow(preparedStatement, "AA1228", "MCI");
        JoinTest.insertTourRow(preparedStatement, "AA1229", "CHS");
        JoinTest.insertTourRow(preparedStatement, "AA1230", "MSY");
        JoinTest.insertTourRow(preparedStatement, "AA1231", "CLE");
        JoinTest.insertTourRow(preparedStatement, "AA1232", "LAX");
        JoinTest.insertTourRow(preparedStatement, "AA1233", "CLE");
        JoinTest.insertTourRow(preparedStatement, "AA1234", "DFW");
        JoinTest.insertTourRow(preparedStatement, "AA1235", "CLE");
        JoinTest.insertTourRow(preparedStatement, "AA1236", "MDW");
        JoinTest.insertTourRow(preparedStatement, "AA1237", "CPH");
        JoinTest.insertTourRow(preparedStatement, "AA1238", "FCO");
        JoinTest.insertTourRow(preparedStatement, "AA1239", "CPH");
        JoinTest.insertTourRow(preparedStatement, "AA1240", "REY");
        JoinTest.insertTourRow(preparedStatement, "AA1241", "CPH");
        JoinTest.insertTourRow(preparedStatement, "AA1242", "CDG");
        JoinTest.insertTourRow(preparedStatement, "AA1243", "CPT");
        JoinTest.insertTourRow(preparedStatement, "AA1244", "LOS");
        JoinTest.insertTourRow(preparedStatement, "AA1245", "CPT");
        JoinTest.insertTourRow(preparedStatement, "AA1246", "NBO");
        JoinTest.insertTourRow(preparedStatement, "AA1247", "CPT");
        JoinTest.insertTourRow(preparedStatement, "AA1248", "LHR");
        JoinTest.insertTourRow(preparedStatement, "AA1249", "DEN");
        JoinTest.insertTourRow(preparedStatement, "AA1250", "SEA");
        JoinTest.insertTourRow(preparedStatement, "AA1251", "DEN");
        JoinTest.insertTourRow(preparedStatement, "AA1252", "BOI");
        JoinTest.insertTourRow(preparedStatement, "AA1253", "DEN");
        JoinTest.insertTourRow(preparedStatement, "AA1254", "JFK");
        JoinTest.insertTourRow(preparedStatement, "AA1255", "DFW");
        JoinTest.insertTourRow(preparedStatement, "AA1256", "SAT");
        JoinTest.insertTourRow(preparedStatement, "AA1257", "DFW");
        JoinTest.insertTourRow(preparedStatement, "AA1258", "ATL");
        JoinTest.insertTourRow(preparedStatement, "AA1259", "DFW");
        JoinTest.insertTourRow(preparedStatement, "AA1260", "MIA");
        JoinTest.insertTourRow(preparedStatement, "AA1261", "DSM");
        JoinTest.insertTourRow(preparedStatement, "AA1262", "MDW");
        JoinTest.insertTourRow(preparedStatement, "AA1263", "DSM");
        JoinTest.insertTourRow(preparedStatement, "AA1264", "SLC");
        JoinTest.insertTourRow(preparedStatement, "AA1265", "DSM");
        JoinTest.insertTourRow(preparedStatement, "AA1266", "OKC");
        JoinTest.insertTourRow(preparedStatement, "AA1267", "DUB");
        JoinTest.insertTourRow(preparedStatement, "AA1268", "LHR");
        JoinTest.insertTourRow(preparedStatement, "AA1272", "CDG");
        JoinTest.insertTourRow(preparedStatement, "AA1273", "BUE");
        JoinTest.insertTourRow(preparedStatement, "AA1274", "SCL");
        JoinTest.insertTourRow(preparedStatement, "AA1275", "BUE");
        JoinTest.insertTourRow(preparedStatement, "AA1276", "GRU");
        JoinTest.insertTourRow(preparedStatement, "US1509", "BUE");
        JoinTest.insertTourRow(preparedStatement, "US1508", "MIA");
        JoinTest.insertTourRow(preparedStatement, "AA1279", "FAI");
        JoinTest.insertTourRow(preparedStatement, "AA1280", "JNU");
        JoinTest.insertTourRow(preparedStatement, "AA1281", "FAI");
        JoinTest.insertTourRow(preparedStatement, "AA1282", "SEA");
        JoinTest.insertTourRow(preparedStatement, "US1443", "FAI");
        JoinTest.insertTourRow(preparedStatement, "US1444", "NRT");
        JoinTest.insertTourRow(preparedStatement, "AA1285", "FCO");
        JoinTest.insertTourRow(preparedStatement, "AA1286", "CDG");
        JoinTest.insertTourRow(preparedStatement, "AA1287", "FCO");
        JoinTest.insertTourRow(preparedStatement, "AA1288", "CAI");
        JoinTest.insertTourRow(preparedStatement, "AA1289", "FCO");
        JoinTest.insertTourRow(preparedStatement, "AA1290", "JFK");
        JoinTest.insertTourRow(preparedStatement, "AA1291", "GIG");
        JoinTest.insertTourRow(preparedStatement, "AA1292", "MIA");
        JoinTest.insertTourRow(preparedStatement, "AA1293", "GIG");
        JoinTest.insertTourRow(preparedStatement, "AA1294", "LIM");
        JoinTest.insertTourRow(preparedStatement, "AA1295", "GIG");
        JoinTest.insertTourRow(preparedStatement, "AA1296", "BUE");
        JoinTest.insertTourRow(preparedStatement, "US1249", "GRU");
        JoinTest.insertTourRow(preparedStatement, "US1250", "CCS");
        JoinTest.insertTourRow(preparedStatement, "US1251", "GRU");
        JoinTest.insertTourRow(preparedStatement, "US1252", "JFK");
        JoinTest.insertTourRow(preparedStatement, "US1253", "GRU");
        JoinTest.insertTourRow(preparedStatement, "US1254", "LAX");
        JoinTest.insertTourRow(preparedStatement, "AA1053", "GRU");
        JoinTest.insertTourRow(preparedStatement, "AA1054", "LIM");
        JoinTest.insertTourRow(preparedStatement, "US1255", "GVA");
        JoinTest.insertTourRow(preparedStatement, "US1256", "CPH");
        JoinTest.insertTourRow(preparedStatement, "US1257", "GVA");
        JoinTest.insertTourRow(preparedStatement, "US1258", "LIS");
        JoinTest.insertTourRow(preparedStatement, "US1259", "GVA");
        JoinTest.insertTourRow(preparedStatement, "US1260", "OSL");
        JoinTest.insertTourRow(preparedStatement, "US1266", "HKG");
        JoinTest.insertTourRow(preparedStatement, "US1264", "SIN");
        JoinTest.insertTourRow(preparedStatement, "US1267", "HLN");
        JoinTest.insertTourRow(preparedStatement, "US1268", "SEA");
        JoinTest.insertTourRow(preparedStatement, "US1269", "HLN");
        JoinTest.insertTourRow(preparedStatement, "US1270", "BOI");
        JoinTest.insertTourRow(preparedStatement, "US1271", "HLN");
        JoinTest.insertTourRow(preparedStatement, "US1272", "DEN");
        JoinTest.insertTourRow(preparedStatement, "US1276", "HNL");
        JoinTest.insertTourRow(preparedStatement, "US1274", "NRT");
        JoinTest.insertTourRow(preparedStatement, "US1277", "HNL");
        JoinTest.insertTourRow(preparedStatement, "US1278", "SYD");
        JoinTest.insertTourRow(preparedStatement, "US1281", "HOU");
        JoinTest.insertTourRow(preparedStatement, "US1282", "SAT");
        JoinTest.insertTourRow(preparedStatement, "US1283", "HOU");
        JoinTest.insertTourRow(preparedStatement, "US1284", "IAD");
        JoinTest.insertTourRow(preparedStatement, "US1285", "IAD");
        JoinTest.insertTourRow(preparedStatement, "US1286", "BOS");
        JoinTest.insertTourRow(preparedStatement, "US1287", "IAD");
        JoinTest.insertTourRow(preparedStatement, "US1288", "MSP");
        JoinTest.insertTourRow(preparedStatement, "US1289", "IAD");
        JoinTest.insertTourRow(preparedStatement, "US1290", "MIA");
        JoinTest.insertTourRow(preparedStatement, "US1291", "IST");
        JoinTest.insertTourRow(preparedStatement, "US1292", "THR");
        JoinTest.insertTourRow(preparedStatement, "US1293", "IST");
        JoinTest.insertTourRow(preparedStatement, "US1294", "FCO");
        JoinTest.insertTourRow(preparedStatement, "US1295", "IST");
        JoinTest.insertTourRow(preparedStatement, "US1296", "ATH");
        JoinTest.insertTourRow(preparedStatement, "US1381", "JFK");
        JoinTest.insertTourRow(preparedStatement, "US1382", "CDG");
        JoinTest.insertTourRow(preparedStatement, "US1349", "JFK");
        JoinTest.insertTourRow(preparedStatement, "US1300", "LAX");
        JoinTest.insertTourRow(preparedStatement, "US1301", "JFK");
        JoinTest.insertTourRow(preparedStatement, "US1302", "GRU");
        JoinTest.insertTourRow(preparedStatement, "US1303", "JKT");
        JoinTest.insertTourRow(preparedStatement, "US1304", "HKG");
        JoinTest.insertTourRow(preparedStatement, "US1308", "JKT");
        JoinTest.insertTourRow(preparedStatement, "US1307", "SYD");
        JoinTest.insertTourRow(preparedStatement, "US1309", "JNU");
        JoinTest.insertTourRow(preparedStatement, "US1310", "SEA");
        JoinTest.insertTourRow(preparedStatement, "US1311", "JNU");
        JoinTest.insertTourRow(preparedStatement, "US1312", "SFO");
        JoinTest.insertTourRow(preparedStatement, "US1313", "JNU");
        JoinTest.insertTourRow(preparedStatement, "US1314", "HNL");
        JoinTest.insertTourRow(preparedStatement, "US1315", "KBL");
        JoinTest.insertTourRow(preparedStatement, "US1316", "KHI");
        JoinTest.insertTourRow(preparedStatement, "US1317", "KBL");
        JoinTest.insertTourRow(preparedStatement, "US1318", "IST");
        JoinTest.insertTourRow(preparedStatement, "US1321", "KHI");
        JoinTest.insertTourRow(preparedStatement, "US1322", "IST");
        JoinTest.insertTourRow(preparedStatement, "US1323", "KHI");
        JoinTest.insertTourRow(preparedStatement, "US1324", "IST");
        JoinTest.insertTourRow(preparedStatement, "US1325", "KHI");
        JoinTest.insertTourRow(preparedStatement, "US1326", "THR");
        JoinTest.insertTourRow(preparedStatement, "US1327", "LAX");
        JoinTest.insertTourRow(preparedStatement, "US1328", "HNL");
        JoinTest.insertTourRow(preparedStatement, "US1329", "LAX");
        JoinTest.insertTourRow(preparedStatement, "US1330", "GRU");
        JoinTest.insertTourRow(preparedStatement, "US1331", "LAX");
        JoinTest.insertTourRow(preparedStatement, "US1332", "NRT");
        JoinTest.insertTourRow(preparedStatement, "US1333", "LHR");
        JoinTest.insertTourRow(preparedStatement, "US1334", "WAW");
        JoinTest.insertTourRow(preparedStatement, "US1335", "LHR");
        JoinTest.insertTourRow(preparedStatement, "US1336", "YYZ");
        JoinTest.insertTourRow(preparedStatement, "US1337", "LHR");
        JoinTest.insertTourRow(preparedStatement, "US1338", "NBO");
        JoinTest.insertTourRow(preparedStatement, "US1501", "LIM");
        JoinTest.insertTourRow(preparedStatement, "US1340", "MIA");
        JoinTest.insertTourRow(preparedStatement, "US1344", "LIM");
        JoinTest.insertTourRow(preparedStatement, "US1342", "BUE");
        JoinTest.insertTourRow(preparedStatement, "US1345", "LIS");
        JoinTest.insertTourRow(preparedStatement, "US1346", "CDG");
        JoinTest.insertTourRow(preparedStatement, "US1347", "LIS");
        JoinTest.insertTourRow(preparedStatement, "US1348", "CAS");
        JoinTest.insertTourRow(preparedStatement, "US1353", "LOS");
        JoinTest.insertTourRow(preparedStatement, "US1354", "MAD");
        JoinTest.insertTourRow(preparedStatement, "US1355", "LOS");
        JoinTest.insertTourRow(preparedStatement, "US1356", "ATH");
        JoinTest.insertTourRow(preparedStatement, "US1357", "MAD");
        JoinTest.insertTourRow(preparedStatement, "US1358", "CDG");
        JoinTest.insertTourRow(preparedStatement, "US1361", "MAD");
        JoinTest.insertTourRow(preparedStatement, "US1362", "JFK");
        JoinTest.insertTourRow(preparedStatement, "US1363", "MCI");
        JoinTest.insertTourRow(preparedStatement, "US1364", "LAX");
        JoinTest.insertTourRow(preparedStatement, "US1365", "MCI");
        JoinTest.insertTourRow(preparedStatement, "US1366", "DFW");
        JoinTest.insertTourRow(preparedStatement, "US1367", "MCI");
        JoinTest.insertTourRow(preparedStatement, "US1368", "JFK");
        JoinTest.insertTourRow(preparedStatement, "US1379", "MDW");
        JoinTest.insertTourRow(preparedStatement, "US1380", "LAX");
        JoinTest.insertTourRow(preparedStatement, "US1473", "MDW");
        JoinTest.insertTourRow(preparedStatement, "US1474", "JFK");
        JoinTest.insertTourRow(preparedStatement, "US1383", "MDW");
        JoinTest.insertTourRow(preparedStatement, "US1384", "ATL");
        JoinTest.insertTourRow(preparedStatement, "US1385", "MEL");
        JoinTest.insertTourRow(preparedStatement, "US1386", "SYD");
        JoinTest.insertTourRow(preparedStatement, "US1387", "MEL");
        JoinTest.insertTourRow(preparedStatement, "US1388", "SIN");
        JoinTest.insertTourRow(preparedStatement, "US1389", "MEL");
        JoinTest.insertTourRow(preparedStatement, "US1390", "HNL");
        JoinTest.insertTourRow(preparedStatement, "US1391", "MEM");
        JoinTest.insertTourRow(preparedStatement, "US1392", "MIA");
        JoinTest.insertTourRow(preparedStatement, "US1393", "MEM");
        JoinTest.insertTourRow(preparedStatement, "US1394", "JFK");
        JoinTest.insertTourRow(preparedStatement, "US1395", "MEM");
        JoinTest.insertTourRow(preparedStatement, "US1396", "LAX");
        JoinTest.insertTourRow(preparedStatement, "US1397", "MEX");
        JoinTest.insertTourRow(preparedStatement, "US1398", "SFO");
        JoinTest.insertTourRow(preparedStatement, "US1399", "MEX");
        JoinTest.insertTourRow(preparedStatement, "US1400", "LAX");
        JoinTest.insertTourRow(preparedStatement, "US1401", "MEX");
        JoinTest.insertTourRow(preparedStatement, "US1402", "BOG");
        JoinTest.insertTourRow(preparedStatement, "US1403", "MIA");
        JoinTest.insertTourRow(preparedStatement, "US1404", "GRU");
        JoinTest.insertTourRow(preparedStatement, "US1405", "MIA");
        JoinTest.insertTourRow(preparedStatement, "US1406", "LAX");
        JoinTest.insertTourRow(preparedStatement, "US1407", "MIA");
        JoinTest.insertTourRow(preparedStatement, "US1408", "JFK");
        JoinTest.insertTourRow(preparedStatement, "US1409", "MKE");
        JoinTest.insertTourRow(preparedStatement, "US1410", "JFK");
        JoinTest.insertTourRow(preparedStatement, "US1411", "MKE");
        JoinTest.insertTourRow(preparedStatement, "US1412", "MDW");
        JoinTest.insertTourRow(preparedStatement, "US1413", "MKE");
        JoinTest.insertTourRow(preparedStatement, "US1414", "JFK");
        JoinTest.insertTourRow(preparedStatement, "US1415", "MNL");
        JoinTest.insertTourRow(preparedStatement, "US1416", "SYD");
        JoinTest.insertTourRow(preparedStatement, "US1417", "MNL");
        JoinTest.insertTourRow(preparedStatement, "US1418", "TPE");
        JoinTest.insertTourRow(preparedStatement, "US1419", "MNL");
        JoinTest.insertTourRow(preparedStatement, "US1420", "SIN");
        JoinTest.insertTourRow(preparedStatement, "AA1419", "MNL");
        JoinTest.insertTourRow(preparedStatement, "AA1420", "HKG");
        JoinTest.insertTourRow(preparedStatement, "AA1421", "MNL");
        JoinTest.insertTourRow(preparedStatement, "US1422", "HNL");
        JoinTest.insertTourRow(preparedStatement, "US1423", "MSP");
        JoinTest.insertTourRow(preparedStatement, "US1424", "MDW");
        JoinTest.insertTourRow(preparedStatement, "AA1423", "MDW");
        JoinTest.insertTourRow(preparedStatement, "AA1424", "MIA");
        JoinTest.insertTourRow(preparedStatement, "US1427", "MSY");
        JoinTest.insertTourRow(preparedStatement, "US1428", "SFO");
        JoinTest.insertTourRow(preparedStatement, "US1429", "MSY");
        JoinTest.insertTourRow(preparedStatement, "US1430", "ATL");
        JoinTest.insertTourRow(preparedStatement, "US1431", "MSY");
        JoinTest.insertTourRow(preparedStatement, "US1432", "JFK");
        JoinTest.insertTourRow(preparedStatement, "US1433", "NBO");
        JoinTest.insertTourRow(preparedStatement, "US1434", "FCO");
        JoinTest.insertTourRow(preparedStatement, "US1435", "NBO");
        JoinTest.insertTourRow(preparedStatement, "US1436", "MAD");
        JoinTest.insertTourRow(preparedStatement, "US1437", "NBO");
        JoinTest.insertTourRow(preparedStatement, "US1438", "CAS");
        JoinTest.insertTourRow(preparedStatement, "US1439", "NRT");
        JoinTest.insertTourRow(preparedStatement, "US1440", "SYD");
        JoinTest.insertTourRow(preparedStatement, "US1441", "NRT");
        JoinTest.insertTourRow(preparedStatement, "US1442", "LAX");
        JoinTest.insertTourRow(preparedStatement, "US1445", "OKC");
        JoinTest.insertTourRow(preparedStatement, "US1446", "SLC");
        JoinTest.insertTourRow(preparedStatement, "US1447", "OKC");
        JoinTest.insertTourRow(preparedStatement, "US1448", "JFK");
        JoinTest.insertTourRow(preparedStatement, "US1449", "OKC");
        JoinTest.insertTourRow(preparedStatement, "US1450", "LAX");
        JoinTest.insertTourRow(preparedStatement, "US1451", "OSA");
        JoinTest.insertTourRow(preparedStatement, "US1452", "NRT");
        JoinTest.insertTourRow(preparedStatement, "US1453", "OSA");
        JoinTest.insertTourRow(preparedStatement, "US1454", "TPE");
        JoinTest.insertTourRow(preparedStatement, "US1455", "OSA");
        JoinTest.insertTourRow(preparedStatement, "US1456", "SVO");
        JoinTest.insertTourRow(preparedStatement, "US1457", "OSL");
        JoinTest.insertTourRow(preparedStatement, "US1458", "PRG");
        JoinTest.insertTourRow(preparedStatement, "US1459", "OSL");
        JoinTest.insertTourRow(preparedStatement, "US1460", "ARN");
        JoinTest.insertTourRow(preparedStatement, "US1461", "OSL");
        JoinTest.insertTourRow(preparedStatement, "US1462", "WAW");
        JoinTest.insertTourRow(preparedStatement, "AA1462", "OSL");
        JoinTest.insertTourRow(preparedStatement, "AA1463", "CDG");
        JoinTest.insertTourRow(preparedStatement, "US1463", "PHL");
        JoinTest.insertTourRow(preparedStatement, "US1464", "IAD");
        JoinTest.insertTourRow(preparedStatement, "US1465", "PHL");
        JoinTest.insertTourRow(preparedStatement, "US1466", "MIA");
        JoinTest.insertTourRow(preparedStatement, "US1469", "PHX");
        JoinTest.insertTourRow(preparedStatement, "US1470", "LAX");
        JoinTest.insertTourRow(preparedStatement, "US1471", "PHX");
        JoinTest.insertTourRow(preparedStatement, "US1472", "SEA");
        JoinTest.insertTourRow(preparedStatement, "US1475", "PRG");
        JoinTest.insertTourRow(preparedStatement, "US1476", "CDG");
        JoinTest.insertTourRow(preparedStatement, "US1477", "PRG");
        JoinTest.insertTourRow(preparedStatement, "US1478", "FCO");
        JoinTest.insertTourRow(preparedStatement, "US1479", "PRG");
        JoinTest.insertTourRow(preparedStatement, "US1480", "REY");
        JoinTest.insertTourRow(preparedStatement, "US1481", "REY");
        JoinTest.insertTourRow(preparedStatement, "US1482", "SVO");
        JoinTest.insertTourRow(preparedStatement, "US1483", "REY");
        JoinTest.insertTourRow(preparedStatement, "US1484", "CDG");
        JoinTest.insertTourRow(preparedStatement, "US1485", "REY");
        JoinTest.insertTourRow(preparedStatement, "US1486", "DUB");
        JoinTest.insertTourRow(preparedStatement, "US1487", "SAN");
        JoinTest.insertTourRow(preparedStatement, "US1488", "SFO");
        JoinTest.insertTourRow(preparedStatement, "US1489", "SAN");
        JoinTest.insertTourRow(preparedStatement, "US1490", "DFW");
        JoinTest.insertTourRow(preparedStatement, "US1491", "SAN");
        JoinTest.insertTourRow(preparedStatement, "US1492", "MEX");
        JoinTest.insertTourRow(preparedStatement, "US1493", "SAT");
        JoinTest.insertTourRow(preparedStatement, "US1494", "ATL");
        JoinTest.insertTourRow(preparedStatement, "US1495", "SAT");
        JoinTest.insertTourRow(preparedStatement, "US1496", "LAX");
        JoinTest.insertTourRow(preparedStatement, "US1497", "SAT");
        JoinTest.insertTourRow(preparedStatement, "US1498", "MIA");
        JoinTest.insertTourRow(preparedStatement, "US1499", "SCL");
        JoinTest.insertTourRow(preparedStatement, "US1500", "GRU");
        JoinTest.insertTourRow(preparedStatement, "US1503", "SCL");
        JoinTest.insertTourRow(preparedStatement, "US1504", "BUE");
        JoinTest.insertTourRow(preparedStatement, "US1505", "SEA");
        JoinTest.insertTourRow(preparedStatement, "AA1505", "SFO");
        JoinTest.insertTourRow(preparedStatement, "US1506", "SEA");
        JoinTest.insertTourRow(preparedStatement, "US1507", "JFK");
        JoinTest.insertTourRow(preparedStatement, "US1510", "SEL");
        JoinTest.insertTourRow(preparedStatement, "US1511", "NRT");
        JoinTest.insertTourRow(preparedStatement, "US1514", "SEL");
        JoinTest.insertTourRow(preparedStatement, "US1515", "SHA");
        JoinTest.insertTourRow(preparedStatement, "US1518", "SFO");
        JoinTest.insertTourRow(preparedStatement, "US1519", "SCL");
        JoinTest.insertTourRow(preparedStatement, "US1529", "SFO");
        JoinTest.insertTourRow(preparedStatement, "US1521", "HNL");
        JoinTest.insertTourRow(preparedStatement, "US1522", "SHA");
        JoinTest.insertTourRow(preparedStatement, "US1523", "SIN");
        JoinTest.insertTourRow(preparedStatement, "US1524", "SHA");
        JoinTest.insertTourRow(preparedStatement, "US1525", "HKG");
        JoinTest.insertTourRow(preparedStatement, "US1526", "SHA");
        JoinTest.insertTourRow(preparedStatement, "US1527", "SVO");
        JoinTest.insertTourRow(preparedStatement, "AA1528", "SIN");
        JoinTest.insertTourRow(preparedStatement, "AA1529", "SYD");
        JoinTest.insertTourRow(preparedStatement, "AA1532", "SIN");
        JoinTest.insertTourRow(preparedStatement, "AA1533", "HKG");
        JoinTest.insertTourRow(preparedStatement, "US1536", "SJU");
        JoinTest.insertTourRow(preparedStatement, "US1537", "CCS");
        JoinTest.insertTourRow(preparedStatement, "US1538", "SJU");
        JoinTest.insertTourRow(preparedStatement, "US1539", "MEL");
        JoinTest.insertTourRow(preparedStatement, "US1540", "SLC");
        JoinTest.insertTourRow(preparedStatement, "US1541", "DEN");
        JoinTest.insertTourRow(preparedStatement, "US1542", "SLC");
        JoinTest.insertTourRow(preparedStatement, "US1543", "SFO");
        JoinTest.insertTourRow(preparedStatement, "US1544", "SLC");
        JoinTest.insertTourRow(preparedStatement, "US1545", "MDW");
        JoinTest.insertTourRow(preparedStatement, "US1546", "STL");
        JoinTest.insertTourRow(preparedStatement, "US1547", "MDW");
        JoinTest.insertTourRow(preparedStatement, "US1548", "STL");
        JoinTest.insertTourRow(preparedStatement, "US1549", "JFK");
        JoinTest.insertTourRow(preparedStatement, "US1550", "STL");
        JoinTest.insertTourRow(preparedStatement, "US1551", "LAX");
        JoinTest.insertTourRow(preparedStatement, "US1552", "SVO");
        JoinTest.insertTourRow(preparedStatement, "US1553", "CDG");
        JoinTest.insertTourRow(preparedStatement, "US1554", "SVO");
        JoinTest.insertTourRow(preparedStatement, "US1555", "NRT");
        JoinTest.insertTourRow(preparedStatement, "US1558", "SYD");
        JoinTest.insertTourRow(preparedStatement, "US1559", "AKL");
        JoinTest.insertTourRow(preparedStatement, "US1560", "SYD");
        JoinTest.insertTourRow(preparedStatement, "US1561", "HNL");
        JoinTest.insertTourRow(preparedStatement, "US1562", "SYD");
        JoinTest.insertTourRow(preparedStatement, "US1563", "HKG");
        JoinTest.insertTourRow(preparedStatement, "US1564", "THR");
        JoinTest.insertTourRow(preparedStatement, "US1565", "KBL");
        JoinTest.insertTourRow(preparedStatement, "US1566", "THR");
        JoinTest.insertTourRow(preparedStatement, "US1567", "KHI");
        JoinTest.insertTourRow(preparedStatement, "US1568", "THR");
        JoinTest.insertTourRow(preparedStatement, "US1569", "CAI");
        JoinTest.insertTourRow(preparedStatement, "US1572", "TPE");
        JoinTest.insertTourRow(preparedStatement, "US1573", "SYD");
        JoinTest.insertTourRow(preparedStatement, "US1574", "TPE");
        JoinTest.insertTourRow(preparedStatement, "US1575", "OSA");
        JoinTest.insertTourRow(preparedStatement, "US1576", "WAW");
        JoinTest.insertTourRow(preparedStatement, "US1577", "PRG");
        JoinTest.insertTourRow(preparedStatement, "US1578", "WAW");
        JoinTest.insertTourRow(preparedStatement, "US1579", "SVO");
        JoinTest.insertTourRow(preparedStatement, "US1580", "WAW");
        JoinTest.insertTourRow(preparedStatement, "US1581", "ARN");
        JoinTest.insertTourRow(preparedStatement, "US1584", "YUL");
        JoinTest.insertTourRow(preparedStatement, "US1585", "JFK");
        JoinTest.insertTourRow(preparedStatement, "US1586", "YUL");
        JoinTest.insertTourRow(preparedStatement, "US1587", "SFO");
        JoinTest.insertTourRow(preparedStatement, "US1588", "YYZ");
        JoinTest.insertTourRow(preparedStatement, "US1589", "SEA");
        JoinTest.insertTourRow(preparedStatement, "US1590", "YYZ");
        JoinTest.insertTourRow(preparedStatement, "US1592", "YYZ");
        JoinTest.insertTourRow(preparedStatement, "US1593", "LHR");
        JoinTest.insertTourRow(preparedStatement, "AA1600", "SFO");
        JoinTest.insertTourRow(preparedStatement, "AA1601", "LAX");
        JoinTest.insertTourRow(preparedStatement, "AA1602", "SFO");
        JoinTest.insertTourRow(preparedStatement, "AA1603", "LAX");
        JoinTest.insertTourRow(preparedStatement, "US1600", "YYZ");
        JoinTest.insertTourRow(preparedStatement, "US1601", "SCL");
        statement.execute("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM CITIES LEFT OUTER JOIN     (SELECT * FROM FLIGHTS, COUNTRIES) S   ON CITIES.AIRPORT = S.ORIG_AIRPORT   WHERE S.COUNTRY_ISO_CODE = 'US'");
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        JoinTest.assertTrue((boolean)runtimeStatisticsParser.usedHashJoin());
        resultSet = statement.executeQuery("SELECT * FROM CITIES LEFT OUTER JOIN FLIGHTS     INNER JOIN COUNTRIES ON 1=1     ON CITIES.AIRPORT = FLIGHTS.ORIG_AIRPORT   WHERE COUNTRIES.COUNTRY_ISO_CODE = 'US'");
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        JoinTest.assertFalse((boolean)runtimeStatisticsParser.usedNLLeftOuterJoin());
        JoinTest.assertTrue((boolean)runtimeStatisticsParser.usedHashJoin());
        resultSet = statement.executeQuery("SELECT * FROM FLIGHTS     INNER JOIN COUNTRIES ON 1=1     RIGHT OUTER JOIN CITIES     ON CITIES.AIRPORT = FLIGHTS.ORIG_AIRPORT   WHERE COUNTRIES.COUNTRY_ISO_CODE = 'US'");
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        JoinTest.assertFalse((boolean)runtimeStatisticsParser.usedNLLeftOuterJoin());
        JoinTest.assertTrue((boolean)runtimeStatisticsParser.usedHashJoin());
        resultSet = statement.executeQuery("SELECT * FROM CITIES LEFT OUTER JOIN    (FLIGHTS CROSS JOIN COUNTRIES)   ON CITIES.AIRPORT = FLIGHTS.ORIG_AIRPORT   WHERE COUNTRIES.COUNTRY_ISO_CODE = 'US'");
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        JoinTest.assertFalse((boolean)runtimeStatisticsParser.usedNLLeftOuterJoin());
        JoinTest.assertTrue((boolean)runtimeStatisticsParser.usedHashJoin());
        resultSet = statement.executeQuery("SELECT * FROM    (FLIGHTS CROSS JOIN COUNTRIES) RIGHT OUTER JOIN     CITIES ON CITIES.AIRPORT = FLIGHTS.ORIG_AIRPORT   WHERE COUNTRIES.COUNTRY_ISO_CODE = 'US'");
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        JoinTest.assertFalse((boolean)runtimeStatisticsParser.usedNLLeftOuterJoin());
        JoinTest.assertTrue((boolean)runtimeStatisticsParser.usedHashJoin());
    }

    static void insertTourRow(PreparedStatement preparedStatement, String string, String string2) throws SQLException {
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.execute();
    }

    static void insertTourRow(PreparedStatement preparedStatement, int n, String string, String string2) throws SQLException {
        preparedStatement.setInt(1, n);
        preparedStatement.setString(2, string);
        preparedStatement.setString(3, string2);
        preparedStatement.execute();
    }

    public void testDerby_4679() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table abstract_instance (    jz_discriminator int,     item_id char(32),     family_item_id char(32),     state_id char(32),     visibility bigint)");
        statement.execute("create table lab_resource_operatingsystem (    jz_parent_id char(32),     item_id char(32))");
        statement.execute("create table operating_system_software_install (    jz_parent_id char(32),     item_id char(32))");
        statement.execute("create table family (    item_id char(32),     root_item_id char(32))");
        statement.execute("insert into abstract_instance (    jz_discriminator,     item_id,     family_item_id,     visibility) values (238, 'aaaa', 'bbbb', 0),       (0, 'cccc', 'dddd', 0),       (1, 'eeee', '_5VetVWTeEd-Q8aOqWJPEIQ', 0)");
        statement.execute("insert into lab_resource_operatingsystem values ('aaaa', 'cccc')");
        statement.execute("insert into operating_system_software_install values ('cccc', 'eeee')");
        statement.execute("insert into family values ('dddd', '_5ZDlwWTeEd-Q8aOqWJPEIQ'),       ('bbbb', '_5nN9mmTeEd-Q8aOqWJPEIQ')");
        ResultSet resultSet = statement.executeQuery("select distinct t1.ITEM_ID, t1.state_id, t1.JZ_DISCRIMINATOR    from ((((((select * from ABSTRACT_INSTANCE z1       where z1.JZ_DISCRIMINATOR = 238) t1       left outer join LAB_RESOURCE_OPERATINGSYSTEM j1           on (t1.ITEM_ID = j1.JZ_PARENT_ID))      left outer join ABSTRACT_INSTANCE t2         on (j1.ITEM_ID = t2.ITEM_ID))     left outer join OPERATING_SYSTEM_SOFTWARE_INSTALL j2        on (t2.ITEM_ID = j2.JZ_PARENT_ID))   left outer join ABSTRACT_INSTANCE t3 on        (j2.ITEM_ID = t3.ITEM_ID)   inner join FAMILY t5 on (t2.FAMILY_ITEM_ID = t5.ITEM_ID))  inner join FAMILY t7 on (t1.FAMILY_ITEM_ID = t7.ITEM_ID)) where (t3.FAMILY_ITEM_ID IN('_5VetVWTeEd-Q8aOqWJPEIQ') and       (t5.ROOT_ITEM_ID = '_5ZDlwWTeEd-Q8aOqWJPEIQ') and       (t7.ROOT_ITEM_ID ='_5nN9mmTeEd-Q8aOqWJPEIQ') and       (t1.VISIBILITY = 0))");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"aaaa", null, "238"}});
        resultSet = statement.executeQuery("select distinct t1.ITEM_ID, t1.state_id, t1.JZ_DISCRIMINATOR     from ((((((select * from ABSTRACT_INSTANCE z1       where z1.JZ_DISCRIMINATOR = 238) t1       left outer join LAB_RESOURCE_OPERATINGSYSTEM j1           on (t1.ITEM_ID = j1.JZ_PARENT_ID))      left outer join ABSTRACT_INSTANCE t2          on (j1.ITEM_ID = t2.ITEM_ID))     left outer join OPERATING_SYSTEM_SOFTWARE_INSTALL j2        on (t2.ITEM_ID = j2.JZ_PARENT_ID))   left outer join (select * from ABSTRACT_INSTANCE) tCorr        on (j2.ITEM_ID = tCorr.ITEM_ID)   inner join FAMILY t5 on (t2.FAMILY_ITEM_ID = t5.ITEM_ID))  inner join FAMILY t7 on (t1.FAMILY_ITEM_ID = t7.ITEM_ID)) where (tCorr.FAMILY_ITEM_ID IN('_5VetVWTeEd-Q8aOqWJPEIQ') and       (t5.ROOT_ITEM_ID = '_5ZDlwWTeEd-Q8aOqWJPEIQ') and       (t7.ROOT_ITEM_ID ='_5nN9mmTeEd-Q8aOqWJPEIQ') and       (t1.VISIBILITY = 0))");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"aaaa", null, "238"}});
        resultSet = statement.executeQuery("select distinct t1.ITEM_ID, t1.state_id, t1.JZ_DISCRIMINATOR     from ((((((select * from ABSTRACT_INSTANCE z1       where z1.JZ_DISCRIMINATOR = 238) t1       left outer join LAB_RESOURCE_OPERATINGSYSTEM j1           on (t1.ITEM_ID = j1.JZ_PARENT_ID))      left outer join ABSTRACT_INSTANCE t2          on (j1.ITEM_ID = t2.ITEM_ID))     left outer join OPERATING_SYSTEM_SOFTWARE_INSTALL j2         on (t2.ITEM_ID = j2.JZ_PARENT_ID))   left outer join        (values (238, 'aaaa', 'bbbb', 0),       (0, 'cccc', 'dddd', 0),       (1, 'eeee', '_5VetVWTeEd-Q8aOqWJPEIQ', 0))        tCorr(jz_discriminator,item_id,family_item_id,visibility)       on (j2.ITEM_ID = tCorr.ITEM_ID)   inner join FAMILY t5 on (t2.FAMILY_ITEM_ID = t5.ITEM_ID))  inner join FAMILY t7 on (t1.FAMILY_ITEM_ID = t7.ITEM_ID)) where (tCorr.FAMILY_ITEM_ID IN('_5VetVWTeEd-Q8aOqWJPEIQ') and       (t5.ROOT_ITEM_ID = '_5ZDlwWTeEd-Q8aOqWJPEIQ') and       (t7.ROOT_ITEM_ID ='_5nN9mmTeEd-Q8aOqWJPEIQ') and       (t1.VISIBILITY = 0))");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"aaaa", null, "238"}});
        statement.executeUpdate("create view tView as select * from ABSTRACT_INSTANCE");
        resultSet = statement.executeQuery("select distinct t1.ITEM_ID, t1.state_id, t1.JZ_DISCRIMINATOR     from ((((((select * from ABSTRACT_INSTANCE z1       where z1.JZ_DISCRIMINATOR = 238) t1       left outer join LAB_RESOURCE_OPERATINGSYSTEM j1           on (t1.ITEM_ID = j1.JZ_PARENT_ID))      left outer join ABSTRACT_INSTANCE t2          on (j1.ITEM_ID = t2.ITEM_ID))     left outer join OPERATING_SYSTEM_SOFTWARE_INSTALL j2         on (t2.ITEM_ID = j2.JZ_PARENT_ID))   left outer join tView on (j2.ITEM_ID = tView.ITEM_ID)   inner join FAMILY t5 on (t2.FAMILY_ITEM_ID = t5.ITEM_ID))  inner join FAMILY t7 on (t1.FAMILY_ITEM_ID = t7.ITEM_ID)) where (tView.FAMILY_ITEM_ID IN('_5VetVWTeEd-Q8aOqWJPEIQ') and       (t5.ROOT_ITEM_ID = '_5ZDlwWTeEd-Q8aOqWJPEIQ') and       (t7.ROOT_ITEM_ID ='_5nN9mmTeEd-Q8aOqWJPEIQ') and       (t1.VISIBILITY = 0))");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"aaaa", null, "238"}});
        this.rollback();
    }

    public void testDerby_4695() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table b2 (c1 int, c2 int, c3 char(1),                  c4 int, c5 int, c6 int)");
        statement.executeUpdate("create table b4 (c7 int, c4 int, c6 int)");
        statement.executeUpdate("create table b3 (c1 int, c9 int, c5 int, c6 int)");
        statement.executeUpdate("create table b (c1 int, c2 int, c3 char(1),                 c4 int, c5 int, c6 int)");
        statement.executeUpdate("create view bvw (c5, c1 ,c2 ,c3 ,c4) as select c5, c1 ,c2 ,c3 ,c4 from b2 union select c5, c1 ,c2 ,c3 ,c4 from b");
        statement.executeUpdate("insert into b4 (c7,c4,c6) values (4, 42, 31)");
        statement.executeUpdate("insert into b2 (c5,c1,c3,c4,c6)     values (3,4, 'F',43,23)");
        statement.executeUpdate("insert into b3 (c5,c1,c9,c6) values (2,3,19,28)");
        statement.executeUpdate("insert into b values (4, 10, 'x', 10, 10, 10)");
        ResultSet resultSet = statement.executeQuery("select b3.* from b3 join bvw on (b3.c1 = bvw.c5)                     join b4 on (bvw.c1 = b4.c7)     where b4.c4 = 42");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"3", "19", "2", "28"}});
        resultSet = statement.executeQuery("select b3.*, bvw.c1 from b3 inner join bvw on (b3.c1 = bvw.c5)                             inner join b4  on (bvw.c1 = b4.c7)                             inner join b  on  (bvw.c1 = b.c1)                            inner join b bcorr on                                                bvw.c1 = bcorr.c1    where b4.c4 = 42");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"3", "19", "2", "28", "4"}});
        this.rollback();
    }

    public void testDerby_5933() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table a (a1 int, a2 int, a3 int, a4 int)");
        statement.executeUpdate("create table b (b1 int)");
        statement.executeUpdate("create table c (c1 int)");
        statement.executeUpdate("create table d (d1 int)");
        statement.executeUpdate("insert into a values (1,2,1,2), (2,3,1,3), (1,4,1,4)");
        statement.executeUpdate("insert into b values 1");
        statement.executeUpdate("insert into d values 2,3,4");
        ResultSet resultSet = statement.executeQuery("select a1 from a inner join b on a3 = b1     left outer join c on a4 = c1         inner join d on a2 = d1 where b1 = 1 order by a1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}, {"1"}, {"2"}});
        this.rollback();
    }
}

