/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.IOException;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;

public class AnsiTrimTest
extends BaseJDBCTestCase {
    public AnsiTrimTest(String string) {
        super(string);
    }

    public static void decorate(Statement statement) throws SQLException {
        statement.executeUpdate("create table tt (id int, v varchar(16), c char(16), cl clob(10240))");
        statement.executeUpdate("insert into tt values (1, 'abcaca', 'abcaca', 'abcaca')");
        statement.executeUpdate("create table nt (v varchar(2))");
        statement.executeUpdate("insert into nt values (null)");
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("AnsiTrimTest");
        baseTestSuite.addTestSuite(AnsiTrimTest.class);
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            public void decorateSQL(Statement statement) throws SQLException {
                AnsiTrimTest.decorate(statement);
            }
        };
    }

    public void testColumnsWithConstant() throws SQLException {
        this.positiveTest("select trim(' ' from v) from tt where id = 1", "abcaca");
        this.positiveTest("select trim('a' from v) from tt where id = 1", "bcac");
        this.positiveTest("select trim(both 'a' from v) from tt where id = 1", "bcac");
        this.positiveTest("select trim(leading 'a' from v) from tt where id = 1", "bcaca");
        this.positiveTest("select trim(trailing 'a' from v) from tt where id = 1", "abcac");
        this.positiveTest("select trim(' ' from c) from tt where id = 1", "abcaca");
        this.positiveTest("select trim('a' from c) from tt where id = 1", "bcaca          ");
        this.positiveTest("select trim(both 'a' from c) from tt where id = 1", "bcaca          ");
        this.positiveTest("select trim(leading 'a' from c) from tt where id = 1", "bcaca          ");
        this.positiveTest("select trim(trailing 'a' from c) from tt where id = 1", "abcaca          ");
    }

    public void testTrimCharIsExpr() throws SQLException {
        this.positiveTest("SELECT count(*) FROM tt  WHERE id = 1 AND (trim (leading substr(v,1,1) from v)) = 'bcaca'", 1);
        this.positiveTest("select trim (both (case when length(v) = 6 then 'a' else 'b' end) from v) from tt", "bcac");
        this.positiveTest("SELECT trim(TRAILING lcase(ucase('a')) from v) from tt", "abcac");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTrimFromClobColumn() throws SQLException, IOException {
        String string = "SELECT trim('a' from cl) from tt";
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            AnsiTrimTest.assertTrue((boolean)resultSet.next());
            Clob clob = resultSet.getClob(1);
            char[] cArray = new char[128];
            AnsiTrimTest.assertEquals((long)4L, (long)clob.length());
            clob.getCharacterStream().read(cArray);
            AnsiTrimTest.assertEquals((String)"bcac", (String)new String(cArray, 0, 4));
            AnsiTrimTest.assertFalse((boolean)resultSet.next());
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public void testTrimSourceIsExpr() throws SQLException {
        this.positiveTest("SELECT trim(' ' from cast(v as char(7))) from tt", "abcaca");
        this.positiveTest("SELECT trim('a' from v||v) from tt", "bcacaabcac");
        this.positiveTest("SELECT trim('a' from ltrim(rtrim(c))) from tt", "bcac");
    }

    public void testTrimResultIsEmpty() throws SQLException {
        this.positiveTest("select trim(' ' from '     ' ) from tt", "");
        this.positiveTest("select trim(LEADING ' ' from '     ' ) from tt", "");
        this.positiveTest("select trim(TRAILING ' ' from '     ' ) from tt", "");
        this.positiveTest("select trim(BOTH ' ' from '     ' ) from tt", "");
    }

    public void testSourceIsEmpty() throws SQLException {
        this.positiveTest("select trim(' ' from '') from tt", "");
        this.positiveTest("select trim(leading ' ' from '') from tt", "");
        this.positiveTest("select trim(trailing ' ' from '') from tt", "");
        this.positiveTest("select trim(both ' ' from '') from tt", "");
    }

    public void testSourceIsNull() throws SQLException {
        this.positiveTest("select trim(' ' from v) from nt", null);
        this.positiveTest("select trim(leading ' ' from v) from nt", null);
        this.positiveTest("select trim(trailing ' ' from v) from nt", null);
        this.positiveTest("select trim(both ' ' from v) from nt", null);
    }

    public void testSourceIsSingleChar() throws SQLException {
        this.positiveTest("select trim(' ' from 'a') from nt", "a");
        this.positiveTest("select trim(leading ' ' from 'a') from nt", "a");
        this.positiveTest("select trim(trailing ' ' from 'a') from nt", "a");
        this.positiveTest("select trim(both ' ' from 'a') from nt", "a");
        this.positiveTest("select trim('a' from 'a') from nt", "");
        this.positiveTest("select trim(leading 'a' from 'a') from nt", "");
        this.positiveTest("select trim(trailing 'a' from 'a') from nt", "");
        this.positiveTest("select trim(both 'a' from 'a') from nt", "");
    }

    public void testCharIsNull() throws SQLException {
        this.positiveTest("select trim ((values cast (null as char(1))) from v) from tt", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void positiveTest(String string, Object object) throws SQLException {
        ResultSet resultSet = null;
        try (PreparedStatement preparedStatement = null;){
            preparedStatement = this.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            JDBC.assertFullResultSet(resultSet, new Object[][]{{object}}, false, true);
        }
    }
}

