/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import junit.framework.Assert;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class XML {
    private static final boolean HAVE_JAXP = JDBC.haveClass("org.w3c.dom.Document");
    private static final boolean HAVE_JAXP_IMPL = HAVE_JAXP && XML.checkJAXPImplementation();
    private static final boolean HAVE_XPATH = HAVE_JAXP_IMPL && XML.checkXPathSupport();
    private static final String HELPER_FILE_LOCATION = "org/apache/derbyTesting/functionTests/tests/lang/xmlTestFiles/";

    public static boolean classpathHasJAXP() {
        return HAVE_JAXP_IMPL;
    }

    public static boolean classpathMeetsXMLReqs() {
        return HAVE_XPATH;
    }

    public static void insertFile(Connection conn, String tableName, String colName, String fName, int numRows) throws IOException, SQLException {
        fName = HELPER_FILE_LOCATION + (String)fName;
        URL xFile = BaseTestCase.getTestResource((String)fName);
        Assert.assertNotNull((String)("XML input file missing: " + (String)fName), (Object)xFile);
        int charCount = 0;
        char[] cA = new char[1024];
        InputStreamReader reader = new InputStreamReader(BaseTestCase.openTestResource(xFile));
        int len = reader.read(cA, 0, cA.length);
        while (len != -1) {
            charCount += len;
            len = reader.read(cA, 0, cA.length);
        }
        reader.close();
        PreparedStatement pSt = conn.prepareStatement("insert into " + tableName + "(" + colName + ") values (xmlparse(document cast (? as clob) preserve whitespace))");
        for (int i = 0; i < numRows; ++i) {
            reader = new InputStreamReader(BaseTestCase.openTestResource(xFile));
            pSt.setCharacterStream(1, (Reader)reader, charCount);
            pSt.execute();
            reader.close();
        }
        pSt.close();
    }

    public static void insertDocWithDTD(Connection conn, String tableName, String colName, String fName, String dtdName, int numRows) throws IOException, SQLException {
        fName = HELPER_FILE_LOCATION + (String)fName;
        URL xFile = BaseTestCase.getTestResource((String)fName);
        Assert.assertNotNull((String)("XML input file missing: " + (String)fName), (Object)xFile);
        int charCount = 0;
        char[] cA = new char[1024];
        StringBuffer sBuf = new StringBuffer();
        InputStreamReader reader = new InputStreamReader(BaseTestCase.openTestResource(xFile));
        int len = reader.read(cA, 0, cA.length);
        while (len != -1) {
            sBuf.append(cA, 0, len);
            charCount += len;
            len = reader.read(cA, 0, cA.length);
        }
        reader.close();
        URL dtdURL = SupportFilesSetup.getReadOnlyURL(dtdName);
        Assert.assertNotNull((String)("DTD file missing: " + dtdName), (Object)dtdURL);
        String docAsString = sBuf.toString();
        int pos = docAsString.indexOf(dtdName);
        if (pos != -1) {
            sBuf.replace(pos, pos + dtdName.length(), dtdURL.toExternalForm());
        }
        docAsString = sBuf.toString();
        PreparedStatement pSt = conn.prepareStatement("insert into " + tableName + "(" + colName + ") values (xmlparse(document cast (? as clob) preserve whitespace))");
        for (int i = 0; i < numRows; ++i) {
            pSt.setString(1, docAsString);
            pSt.execute();
        }
        pSt.close();
    }

    private static boolean checkXPathSupport() {
        try {
            Class<?> factoryClass = Class.forName("javax.xml.xpath.XPathFactory");
            Method newFactory = factoryClass.getMethod("newInstance", new Class[0]);
            Object factory = newFactory.invoke(null, new Object[0]);
            return factory != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean checkJAXPImplementation() {
        try {
            Class<?> factoryClass = Class.forName("javax.xml.parsers.DocumentBuilderFactory");
            Method newFactory = factoryClass.getMethod("newInstance", new Class[0]);
            Object factory = newFactory.invoke(null, new Object[0]);
            return factory != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected static String getJAXPParserLocation() {
        if (!XML.classpathHasJAXP()) {
            return null;
        }
        try {
            Class<?> jaxpFinderClass = Class.forName("org.apache.derbyTesting.junit.JAXPFinder");
            Method locatorMethod = jaxpFinderClass.getDeclaredMethod("getJAXPParserLocation", new Class[0]);
            return (String)locatorMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e.getClass().getName() + ": " + e.getMessage());
        }
    }
}

