/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.derby.iapi.jdbc.AuthenticationService;
import org.apache.derby.iapi.jdbc.EngineLOB;
import org.apache.derby.iapi.jdbc.EnginePreparedStatement;
import org.apache.derby.iapi.jdbc.EngineStatement;
import org.apache.derby.iapi.jdbc.InternalDriver;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.drda.AppRequester;
import org.apache.derby.impl.drda.CcsidManager;
import org.apache.derby.impl.drda.CharacterEncodings;
import org.apache.derby.impl.drda.CodePoint;
import org.apache.derby.impl.drda.CodePointNameTable;
import org.apache.derby.impl.drda.ConsistencyToken;
import org.apache.derby.impl.drda.DDMReader;
import org.apache.derby.impl.drda.DDMWriter;
import org.apache.derby.impl.drda.DRDAProtocolException;
import org.apache.derby.impl.drda.DRDAProtocolExceptionInfo;
import org.apache.derby.impl.drda.DRDAResultSet;
import org.apache.derby.impl.drda.DRDASocketTimeoutException;
import org.apache.derby.impl.drda.DRDAStatement;
import org.apache.derby.impl.drda.DRDAString;
import org.apache.derby.impl.drda.DRDAXAProtocol;
import org.apache.derby.impl.drda.Database;
import org.apache.derby.impl.drda.DecryptionManager;
import org.apache.derby.impl.drda.EXTDTAInputStream;
import org.apache.derby.impl.drda.EXTDTAReaderInputStream;
import org.apache.derby.impl.drda.FailingEXTDTAInputStream;
import org.apache.derby.impl.drda.FdocaConstants;
import org.apache.derby.impl.drda.NetworkServerControlImpl;
import org.apache.derby.impl.drda.PiggyBackedSessionData;
import org.apache.derby.impl.drda.Pkgnamcsn;
import org.apache.derby.impl.drda.SQLTypes;
import org.apache.derby.impl.drda.Session;
import org.apache.derby.impl.drda.SignedBinary;
import org.apache.derby.impl.drda.StandardEXTDTAReaderInputStream;
import org.apache.derby.impl.drda.XADatabase;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.shared.common.error.MessageUtils;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.shared.common.stream.HeaderPrintWriter;

class DRDAConnThread
extends Thread {
    private static final String leftBrace = "{";
    private static final String rightBrace = "}";
    private static final byte NULL_VALUE = -1;
    private static final String SYNTAX_ERR = "42X01";
    private static final int MGRLVL_3 = 3;
    private static final int MGRLVL_4 = 4;
    private static final int MGRLVL_5 = 5;
    private static final int MGRLVL_6 = 6;
    private static final int MGRLVL_7 = 7;
    private static final int COMMIT = 1;
    private static final int ROLLBACK = 2;
    private int correlationID;
    private InputStream sockis;
    private OutputStream sockos;
    private DDMReader reader;
    private DDMWriter writer;
    private DRDAXAProtocol xaProto;
    private static int[] ACCRDB_REQUIRED = new int[]{8463, 8501, 4398, 47, 53};
    private static int MAX_REQUIRED_LEN = 5;
    private int currentRequiredLength = 0;
    private int[] required = new int[MAX_REQUIRED_LEN];
    private NetworkServerControlImpl server;
    private Session session;
    private volatile long timeSlice;
    private volatile boolean logConnections;
    private boolean sendWarningsOnCNTQRY = false;
    private volatile boolean close;
    private static HeaderPrintWriter logStream;
    private AppRequester appRequester;
    private Database database;
    private int sqlamLevel;
    private byte diagnosticLevel = (byte)-16;
    private List<Integer> unknownManagers;
    private List<Integer> knownManagers;
    private SQLException databaseAccessException;
    private Pkgnamcsn prevPkgnamcsn = null;
    private DRDAString rdbnam = null;
    private DRDAString rdbcolid = null;
    private DRDAString pkgid = null;
    private DRDAString pkgcnstkn = null;
    private int pkgsn;
    private static final String TIMEOUT_STATEMENT = "SET STATEMENT_TIMEOUT ";
    private int pendingStatementTimeout;
    private static DecryptionManager decryptionManager;
    private byte[] myPublicKey;
    private byte[] myTargetSeed;
    private static byte[] prdIdBytes;
    private static final byte[] eod00000;
    private static final byte[] eod02000;
    private static final byte[] nullSQLState;
    private static final byte[] errD5_D6;
    private static final byte[] warn0_warnA;
    private static final String AUTHENTICATION_PROVIDER_BUILTIN_CLASS = "org.apache.derby.impl.jdbc.authentication.BasicAuthenticationServiceImpl";
    private static final String AUTHENTICATION_PROVIDER_NONE_CLASS = "org.apache.derby.impl.jdbc.authentication.NoneAuthenticationServiceImpl";
    private static final DRDAProtocolExceptionInfo dummy;
    private boolean deferredReset = false;
    private Calendar gmtCalendar;
    private static String SQLERRMC_TOKEN_DELIMITER;
    private static String SQLERRMC_PREFORMATTED_MESSAGE_DELIMITER;

    DRDAConnThread(Session session, NetworkServerControlImpl server, long timeSlice, boolean logConnections) {
        super(NetworkServerControlImpl.getUniqueThreadName("DRDAConnThread"));
        this.session = session;
        this.server = server;
        this.timeSlice = timeSlice;
        this.logConnections = logConnections;
        this.pendingStatementTimeout = -1;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.trace("Starting new connection thread");
        while (!this.closed()) {
            Session prevSession = this.session;
            this.session = this.server.getNextSession(this.session);
            if (this.session == null) {
                this.close();
            }
            if (this.closed()) break;
            if (this.session != prevSession) {
                this.initializeForSession();
            }
            try {
                long timeStart = System.currentTimeMillis();
                switch (this.session.state) {
                    case 1: {
                        this.sessionInitialState();
                        if (this.session == null) break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        long currentTimeSlice;
                        do {
                            try {
                                this.processCommands();
                            }
                            catch (DRDASocketTimeoutException dRDASocketTimeoutException) {
                                // empty catch block
                            }
                        } while ((currentTimeSlice = this.getTimeSlice()) <= 0L || System.currentTimeMillis() - timeStart < currentTimeSlice);
                        break;
                    }
                    default: {
                        this.agentError("Session in invalid state:" + this.session.state);
                    }
                }
            }
            catch (Exception e) {
                if (e instanceof DRDAProtocolException && ((DRDAProtocolException)e).isDisconnectException()) {
                    this.closeSession();
                    continue;
                }
                this.handleException(e);
            }
            catch (Error error) {
                try {
                    this.closeSession();
                }
                catch (Throwable t) {
                    try {
                        this.session.clientSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                finally {
                    throw error;
                }
            }
        }
        this.trace("Ending connection thread");
        this.server.removeThread(this);
    }

    protected InputStream getInputStream() {
        return this.sockis;
    }

    protected OutputStream getOutputStream() {
        return this.sockos;
    }

    private static byte[] getProductIDBytes() {
        if (prdIdBytes == null) {
            prdIdBytes = NetworkServerControlImpl.prdIdBytes();
        }
        return prdIdBytes;
    }

    protected DDMReader getReader() {
        return this.reader;
    }

    protected DDMWriter getWriter() {
        return this.writer;
    }

    protected int getCorrelationID() {
        return this.correlationID;
    }

    protected Session getSession() {
        return this.session;
    }

    protected Database getDatabase() {
        return this.database;
    }

    protected NetworkServerControlImpl getServer() {
        return this.server;
    }

    protected byte[] getCrrtkn() {
        return this.database == null ? null : this.database.crrtkn;
    }

    protected String getDbName() {
        return this.database == null ? null : this.database.getDatabaseName();
    }

    protected void close() {
        this.close = true;
    }

    protected void setLogConnections(boolean value) {
        this.logConnections = value;
    }

    protected void setTimeSlice(long value) {
        this.timeSlice = value;
    }

    protected void markCommunicationsFailure(String arg1, String arg2, String arg3, String arg4) throws DRDAProtocolException {
        this.markCommunicationsFailure(null, arg1, arg2, arg3, arg4);
    }

    protected void markCommunicationsFailure(Exception e, String arg1, String arg2, String arg3, String arg4) throws DRDAProtocolException {
        if (e != null) {
            DRDAConnThread.println2Log(this.getDbName(), this.session.drdaID, e.getMessage());
            this.server.consoleExceptionPrintTrace(e);
        }
        Object[] oa = new Object[]{arg1, arg2, arg3, arg4};
        throw DRDAProtocolException.newDisconnectException(this, oa);
    }

    protected void throwSyntaxrm(int errcd, int cpArg) throws DRDAProtocolException {
        throw new DRDAProtocolException(DRDAProtocolException.DRDA_Proto_SYNTAXRM, this, cpArg, errcd);
    }

    protected void agentError(String msg) throws DRDAProtocolException {
        throw DRDAProtocolException.newAgentError(this, 64, this.getDbName(), msg);
    }

    protected void missingCodePoint(int codePoint) throws DRDAProtocolException {
        this.throwSyntaxrm(14, codePoint);
    }

    protected static void println2Log(String dbname, String drdaID, String msg) {
        int endOfName;
        if (logStream == null) {
            logStream = Monitor.getStream();
        }
        if (dbname != null && (endOfName = dbname.indexOf(59)) != -1) {
            dbname = dbname.substring(0, endOfName);
        }
        logStream.printlnWithHeader("(DATABASE = " + dbname + "), (DRDAID = " + drdaID + "), " + msg);
    }

    protected void writeRDBNAM(String rdbnam) throws DRDAProtocolException {
        CcsidManager currentManager = this.writer.getCurrentCcsidManager();
        int len = Math.max(18, currentManager.getByteLength(rdbnam));
        this.writer.writeScalarPaddedString(8464, rdbnam, len);
    }

    private void initialize() {
        this.sockis = this.session.sessionInput;
        this.sockos = this.session.sessionOutput;
        this.reader = new DDMReader(this, this.session.dssTrace);
        this.writer = new DDMWriter(this, this.session.dssTrace);
        this.rdbnam = new DRDAString(this.writer);
        this.rdbcolid = new DRDAString(this.writer);
        this.pkgid = new DRDAString(this.writer);
        this.pkgcnstkn = new DRDAString(this.writer);
    }

    private void initializeForSession() {
        this.sockis = this.session.sessionInput;
        this.sockos = this.session.sessionOutput;
        this.reader.initialize(this, this.session.dssTrace);
        this.writer.reset(this.session.dssTrace);
        this.database = this.session.database;
        this.appRequester = this.session.appRequester;
        if (this.session.state == 2) {
            this.sqlamLevel = this.appRequester.getManagerLevel(9223);
        }
        this.reader.setEbcdicCcsid();
        this.writer.setEbcdicCcsid();
    }

    private void sessionInitialState() throws Exception {
        if (this.reader.isCmd()) {
            try {
                this.server.processCommands(this.reader, this.writer, this.session);
                this.reader.initialize(this, null);
                this.writer.reset(null);
                this.closeSession();
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (Throwable t) {
                this.server.consoleExceptionPrintTrace(t);
            }
        } else {
            this.exchangeServerAttributes();
        }
    }

    private void cleanUpAndCloseResultSet(DRDAStatement stmt, SQLException sqle, int writerMark) throws DRDAProtocolException {
        if (stmt != null) {
            this.writer.clearDSSesBackToMark(writerMark);
            if (!stmt.rsIsClosed()) {
                try {
                    stmt.rsClose();
                }
                catch (SQLException ec) {
                    this.trace("Warning: Error closing result set");
                }
                this.writeABNUOWRM();
                this.writeSQLCARD(sqle, 0L, 0L);
            }
        } else {
            this.writeSQLCARDs(sqle, 0L);
        }
        this.errorInChain(sqle);
    }

    private void processCommands() throws DRDAProtocolException {
        DRDAStatement stmt = null;
        boolean PRPSQLSTTfailed = false;
        boolean checkSecurityCodepoint = this.session.requiresSecurityCodepoint();
        do {
            this.correlationID = this.reader.readDssHeader();
            int codePoint = this.reader.readLengthAndCodePoint(false);
            int writerMark = this.writer.markDSSClearPoint();
            if (checkSecurityCodepoint) {
                this.verifyInOrderACCSEC_SECCHK(codePoint, this.session.getRequiredSecurityCodepoint());
            }
            switch (codePoint) {
                case 8198: {
                    try {
                        stmt = this.parseCNTQRY();
                        if (stmt == null) break;
                        this.writeQRYDTA(stmt);
                        if (stmt.rsIsClosed()) {
                            this.writeENDQRYRM(4);
                            this.writeNullSQLCARDobject();
                        }
                        this.checkWarning(null, null, stmt.getResultSet(), 0L, false, this.sendWarningsOnCNTQRY);
                        this.writePBSD();
                    }
                    catch (SQLException e) {
                        this.cleanUpAndCloseResultSet(stmt, e, writerMark);
                    }
                    break;
                }
                case 8202: {
                    try {
                        long updateCount = this.parseEXCSQLIMM();
                        if (!this.database.RDBUPDRM_sent) {
                            this.writeRDBUPDRM();
                        }
                        this.checkWarning(null, this.database.getDefaultStatement().getStatement(), null, updateCount, true, true);
                        this.writePBSD();
                    }
                    catch (SQLException e) {
                        this.writer.clearDSSesBackToMark(writerMark);
                        this.writeSQLCARDs(e, 0L);
                        this.errorInChain(e);
                    }
                    break;
                }
                case 8212: {
                    try {
                        if (!this.parseEXCSQLSET()) break;
                        this.writeSQLCARDs(null, 0L);
                    }
                    catch (SQLWarning w) {
                        this.writeSQLCARD(w, 0L, 0L);
                    }
                    catch (SQLException e) {
                        this.writer.clearDSSesBackToMark(writerMark);
                        this.writeSQLCARDs(e, 0L);
                        this.errorInChain(e);
                    }
                    break;
                }
                case 8205: {
                    PRPSQLSTTfailed = false;
                    try {
                        int sqldaType;
                        this.database.getConnection().clearWarnings();
                        this.database.getCurrentStatement().sqldaType = sqldaType = this.parsePRPSQLSTT();
                        if (sqldaType > 0) {
                            this.writeSQLDARD(this.database.getCurrentStatement(), sqldaType == 2, this.database.getConnection().getWarnings());
                            break;
                        }
                        this.checkWarning(this.database.getConnection(), null, null, 0L, true, true);
                    }
                    catch (SQLException e) {
                        this.writer.clearDSSesBackToMark(writerMark);
                        this.writeSQLCARDs(e, 0L, true);
                        PRPSQLSTTfailed = true;
                        this.errorInChain(e);
                    }
                    break;
                }
                case 8204: {
                    try {
                        if (PRPSQLSTTfailed) {
                            this.skipRemainder(true);
                            this.writeOPNQFLRM(null);
                            break;
                        }
                        Pkgnamcsn pkgnamcsn = this.parseOPNQRY();
                        if (pkgnamcsn != null) {
                            stmt = this.database.getDRDAStatement(pkgnamcsn);
                            EnginePreparedStatement ps = stmt.getPreparedStatement();
                            ps.clearWarnings();
                            if (this.pendingStatementTimeout >= 0) {
                                ps.setQueryTimeout(this.pendingStatementTimeout);
                                this.pendingStatementTimeout = -1;
                            }
                            stmt.execute();
                            this.writeOPNQRYRM(false, stmt);
                            this.checkWarning(null, ps, null, 0L, false, true);
                            long sentVersion = stmt.versionCounter;
                            long currentVersion = stmt.ps.getVersionCounter();
                            if (stmt.sqldaType == 2 && currentVersion != sentVersion) {
                                this.writeSQLDARD(stmt, true, null);
                            }
                            this.writeQRYDSC(stmt, false);
                            stmt.rsSuspend();
                            if (stmt.getQryprctyp() == 9239 && stmt.getQryrowset() != 0) {
                                DRDAResultSet drdars = stmt.getCurrentDrdaResultSet();
                                try {
                                    if (drdars != null && !drdars.hasLobColumns()) {
                                        this.writeQRYDTA(stmt);
                                    }
                                }
                                catch (SQLException sqle) {
                                    this.cleanUpAndCloseResultSet(stmt, sqle, writerMark);
                                }
                            }
                        }
                        this.writePBSD();
                    }
                    catch (SQLException e) {
                        this.writer.clearDSSesBackToMark(writerMark);
                        this.writeOPNQFLRM(e);
                    }
                    break;
                }
                case 8206: {
                    try {
                        this.trace("Received commit");
                        if (!this.database.getConnection().getAutoCommit()) {
                            this.database.getConnection().clearWarnings();
                            this.database.commit();
                            this.writeENDUOWRM(1);
                            this.checkWarning(this.database.getConnection(), null, null, 0L, true, true);
                        }
                        this.database.RDBUPDRM_sent = false;
                    }
                    catch (SQLException e) {
                        this.writer.clearDSSesBackToMark(writerMark);
                        this.writeENDUOWRM(1);
                        this.writeSQLCARDs(e, 0L);
                        this.errorInChain(e);
                    }
                    break;
                }
                case 8207: {
                    try {
                        this.trace("Received rollback");
                        this.database.getConnection().clearWarnings();
                        this.database.rollback();
                        this.writeENDUOWRM(2);
                        this.checkWarning(this.database.getConnection(), null, null, 0L, true, true);
                        this.database.RDBUPDRM_sent = false;
                    }
                    catch (SQLException e) {
                        this.writer.clearDSSesBackToMark(writerMark);
                        this.writeENDUOWRM(2);
                        this.writeSQLCARDs(e, 0L);
                        this.errorInChain(e);
                    }
                    break;
                }
                case 8197: {
                    try {
                        stmt = this.parseCLSQRY();
                        stmt.rsClose();
                        this.writeSQLCARDs(null, 0L);
                    }
                    catch (SQLException e) {
                        this.writer.clearDSSesBackToMark(writerMark);
                        this.writeSQLCARDs(e, 0L);
                        this.errorInChain(e);
                    }
                    break;
                }
                case 4161: {
                    this.parseEXCSAT();
                    this.writeEXCSATRD();
                    break;
                }
                case 4205: {
                    int securityCheckCode = this.parseACCSEC();
                    this.writeACCSECRD(securityCheckCode);
                    if (this.appRequester.supportsUtf8Ccsid()) {
                        this.switchToUtf8();
                    } else {
                        this.switchToEbcdic();
                    }
                    checkSecurityCodepoint = true;
                    break;
                }
                case 4206: {
                    if (!this.parseDRDAConnection()) break;
                    checkSecurityCodepoint = false;
                    break;
                }
                case 8194: {
                    this.reader.skipBytes();
                    this.writeSQLCARDs(null, 0L);
                    break;
                }
                case 8196: {
                    this.reader.skipBytes();
                    this.parseSQLSTTDss();
                    this.writeSQLCARDs(null, 0L);
                    break;
                }
                case 9241: {
                    this.reader.skipBytes();
                    break;
                }
                case 8201: {
                    this.reader.skipBytes();
                    this.writeSQLCARDs(null, 0L);
                    break;
                }
                case 8200: {
                    if (PRPSQLSTTfailed) {
                        this.reader.skipBytes();
                        this.writeSQLCARDs(null, 0L);
                        break;
                    }
                    try {
                        boolean rtnOutput = this.parseDSCSQLSTT();
                        this.writeSQLDARD(this.database.getCurrentStatement(), rtnOutput, null);
                    }
                    catch (SQLException e) {
                        this.writer.clearDSSesBackToMark(writerMark);
                        this.server.consoleExceptionPrint(e);
                        try {
                            this.writeSQLDARD(this.database.getCurrentStatement(), true, e);
                        }
                        catch (SQLException e2) {
                            this.agentError("Why am I getting another SQLException?");
                        }
                        this.errorInChain(e);
                    }
                    break;
                }
                case 8203: {
                    if (PRPSQLSTTfailed) {
                        this.skipRemainder(true);
                        this.writeSQLCARDs(null, 0L);
                        break;
                    }
                    try {
                        this.parseEXCSQLSTT();
                        DRDAStatement curStmt = this.database.getCurrentStatement();
                        if (curStmt != null) {
                            curStmt.rsSuspend();
                        }
                        this.writePBSD();
                    }
                    catch (SQLException e) {
                        this.skipRemainder(true);
                        this.writer.clearDSSesBackToMark(writerMark);
                        this.server.consoleExceptionPrint(e);
                        this.writeSQLCARDs(e, 0L);
                        this.errorInChain(e);
                    }
                    break;
                }
                case 4181: {
                    if (this.xaProto == null) {
                        this.xaProto = new DRDAXAProtocol(this);
                    }
                    this.xaProto.parseSYNCCTL();
                    try {
                        this.writePBSD();
                    }
                    catch (SQLException se) {
                        this.server.consoleExceptionPrint(se);
                        this.errorInChain(se);
                    }
                    break;
                }
                default: {
                    this.codePointNotSupported(codePoint);
                }
            }
            String cpStr = new CodePointNameTable().lookup(codePoint);
            try {
                PiggyBackedSessionData pbsd = this.database.getPiggyBackedSessionData(false);
                if (!this.deferredReset && pbsd != null) {
                    pbsd.refresh();
                    SanityManager.ASSERT(!pbsd.isModified(), "Unexpected PBSD modification: " + String.valueOf(pbsd) + " after codePoint " + cpStr);
                }
            }
            catch (SQLException sqle) {
                this.server.consoleExceptionPrint(sqle);
                SanityManager.THROWASSERT("Unexpected exception after codePoint " + cpStr, sqle);
            }
            this.finalizeChain();
        } while (this.reader.isChainedWithSameID() || this.reader.isChainedWithDiffID());
    }

    private void errorInChain(SQLException e) throws DRDAProtocolException {
        if (this.reader.terminateChainOnErr() && this.getExceptionSeverity(e) > 8) {
            this.trace("terminating the chain on error...");
            this.skipRemainder(false);
        }
    }

    private void exchangeServerAttributes() throws DRDAProtocolException {
        int codePoint;
        this.correlationID = this.reader.readDssHeader();
        if (this.correlationID == 0) {
            SanityManager.THROWASSERT("Unexpected value for correlationId = " + this.correlationID);
        }
        if ((codePoint = this.reader.readLengthAndCodePoint(false)) != 4161) {
            throw new DRDAProtocolException(DRDAProtocolException.DRDA_Proto_PRCCNVRM, this, codePoint, 6);
        }
        this.parseEXCSAT();
        this.writeEXCSATRD();
        this.finalizeChain();
        this.session.setState(2);
    }

    private boolean parseDRDAConnection() throws DRDAProtocolException {
        boolean sessionOK = true;
        int securityCheckCode = this.parseSECCHK();
        this.trace("*** SECCHKRM securityCheckCode is: " + securityCheckCode);
        this.writeSECCHKRM(securityCheckCode);
        if (securityCheckCode != 0) {
            return false;
        }
        this.correlationID = this.reader.readDssHeader();
        int codePoint = this.reader.readLengthAndCodePoint(false);
        this.verifyRequiredObject(codePoint, 8193);
        int svrcod = this.parseACCRDB();
        if (this.database.getConnection() == null && this.databaseAccessException == null) {
            this.writeRDBfailure(8730);
            return false;
        }
        if (this.databaseAccessException != null) {
            int failureType = this.getRdbAccessErrorCodePoint();
            if (failureType == 8721 || failureType == 8907) {
                this.writeRDBfailure(failureType);
            } else {
                this.writeRDBfailure(8730);
            }
            return false;
        }
        if (this.database.accessCount > 1) {
            this.writeRDBfailure(8711);
            return false;
        }
        this.writeACCRDBRM(svrcod);
        this.session.appRequester = this.server.getAppRequester(this.appRequester);
        return sessionOK;
    }

    private void switchToUtf8() {
        this.writer.setUtf8Ccsid();
        this.reader.setUtf8Ccsid();
    }

    private void switchToEbcdic() {
        this.writer.setEbcdicCcsid();
        this.reader.setEbcdicCcsid();
    }

    private void writeRDBfailure(int codePoint) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(codePoint);
        this.writer.writeScalar2Bytes(4425, 8);
        this.writeRDBNAM(this.database.getDatabaseName());
        this.writer.endDdmAndDss();
        switch (codePoint) {
            case 8730: {
                this.writer.createDssObject();
                this.writer.writeScalarString(47, "QTDSQLASC");
                this.writeTYPDEFOVR();
                this.writer.endDss();
            }
            case 8721: 
            case 8907: {
                this.writeSQLCARD(this.databaseAccessException, 0L, 0L);
            }
            case 8711: {
                this.skipRemainder(false);
                this.finalizeChain();
            }
        }
    }

    private int getRdbAccessErrorCodePoint() {
        String sqlState = this.databaseAccessException.getSQLState();
        if (sqlState.regionMatches(0, "XJ004.C", 0, 5)) {
            return 8721;
        }
        if (this.isAuthenticationException(this.databaseAccessException) || sqlState.regionMatches(0, "28502", 0, 5)) {
            return 8907;
        }
        return 8730;
    }

    private boolean isAuthenticationException(SQLException sqlException) {
        boolean authFail = false;
        StandardException se = StandardException.getArgumentFerry(sqlException);
        if (se != null) {
            String msgId = se.getMessageId();
            if (msgId.equals("08004.C.1")) {
                authFail = true;
            }
        } else {
            String sqlState = sqlException.getSQLState();
            if (sqlState.regionMatches(0, "08004", 0, 5)) {
                authFail = true;
            }
        }
        return authFail;
    }

    private int verifyUserIdPassword() throws DRDAProtocolException {
        this.databaseAccessException = null;
        return this.getConnFromDatabaseName();
    }

    private int getConnFromDatabaseName() throws DRDAProtocolException {
        Properties p = new Properties();
        this.databaseAccessException = null;
        if (this.session.drdaID == null) {
            this.session.drdaID = leftBrace + this.session.connNum + rightBrace;
        }
        p.put("drdaID", this.session.drdaID);
        if (this.database.securityMechanism == 8 && this.database.getDatabaseName().indexOf("password") == -1) {
            p.put("drdaSecMec", String.valueOf(this.database.securityMechanism));
            p.put("drdaSecTokenIn", DecryptionManager.toHexString(this.database.secTokenIn, 0, this.database.secTokenIn.length));
            p.put("drdaSecTokenOut", DecryptionManager.toHexString(this.database.secTokenOut, 0, this.database.secTokenOut.length));
        }
        try {
            this.database.makeConnection(p);
        }
        catch (SQLException se) {
            this.databaseAccessException = se;
            while (se != null) {
                this.trace(se.getMessage());
                DRDAConnThread.println2Log(this.database.getDatabaseName(), this.session.drdaID, se.getMessage());
                se = se.getNextException();
            }
            if (this.isAuthenticationException(this.databaseAccessException)) {
                return 19;
            }
            return 0;
        }
        catch (Exception e) {
            DRDAConnThread.println2Log(this.database.getDatabaseName(), this.session.drdaID, "Driver not loaded" + e.getMessage());
            try {
                this.agentError("Driver not loaded");
            }
            catch (DRDAProtocolException dpe) {
                try {
                    this.server.startNetworkServer();
                }
                catch (Exception re) {
                    DRDAConnThread.println2Log(this.database.getDatabaseName(), this.session.drdaID, "Failed attempt to reload driver " + re.getMessage());
                }
                throw dpe;
            }
        }
        if (this.getLogConnections()) {
            DRDAConnThread.println2Log(this.database.getDatabaseName(), this.session.drdaID, "Apache Derby Network Server connected to database " + this.database.getDatabaseName());
        }
        return 0;
    }

    private void parseEXCSAT() throws DRDAProtocolException {
        this.deferredReset = false;
        if (this.appRequester != null) {
            if (!this.appRequester.isXARequester()) {
                this.deferredReset = true;
            }
            this.parseEXCSAT2();
            return;
        }
        this.appRequester = new AppRequester();
        this.reader.markCollection();
        int codePoint = this.reader.getCodePoint();
        while (codePoint != -1) {
            switch (codePoint) {
                case 4446: {
                    this.appRequester.extnam = this.reader.readString();
                    this.trace("extName = " + this.appRequester.extnam);
                    if (this.appRequester.extnam.length() <= 255) break;
                    this.tooBig(4446);
                    break;
                }
                case 5124: {
                    this.parseMGRLVLLS(1);
                    break;
                }
                case 4445: {
                    this.appRequester.spvnam = this.reader.readString();
                    if (this.appRequester.spvnam == null) break;
                    this.badObjectLength(4445);
                    break;
                }
                case 4461: {
                    this.appRequester.srvnam = this.reader.readString();
                    this.trace("serverName = " + this.appRequester.srvnam);
                    if (this.appRequester.srvnam.length() <= 255) break;
                    this.tooBig(4461);
                    break;
                }
                case 4442: {
                    this.appRequester.srvrlslv = this.reader.readString();
                    this.trace("serverlslv = " + this.appRequester.srvrlslv);
                    if (this.appRequester.srvrlslv.length() <= 255) break;
                    this.tooBig(4442);
                    break;
                }
                case 4423: {
                    this.appRequester.srvclsnm = this.reader.readString();
                    this.trace("serverClassName = " + this.appRequester.srvclsnm);
                    if (this.appRequester.srvclsnm.length() <= 255) break;
                    this.tooBig(4423);
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
    }

    private void parseEXCSAT2() throws DRDAProtocolException {
        this.reader.markCollection();
        int codePoint = this.reader.getCodePoint();
        while (codePoint != -1) {
            switch (codePoint) {
                case 4423: 
                case 4442: 
                case 4445: 
                case 4446: 
                case 4461: {
                    this.reader.skipBytes();
                    break;
                }
                case 5124: {
                    this.parseMGRLVLLS(2);
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
    }

    private void parseMGRLVLLS(int time) throws DRDAProtocolException {
        this.unknownManagers = new ArrayList<Integer>();
        this.knownManagers = new ArrayList<Integer>();
        ArrayList<Integer> errorManagers = new ArrayList<Integer>();
        ArrayList<Integer> errorManagersLevel = new ArrayList<Integer>();
        this.trace("Manager Levels");
        while (this.reader.moreDdmData()) {
            int manager = this.reader.readNetworkShort();
            int managerLevel = this.reader.readNetworkShort();
            if (CodePoint.isKnownManager(manager)) {
                this.knownManagers.add(manager);
                int currentLevel = this.appRequester.getManagerLevel(manager);
                if (currentLevel == -1) {
                    this.appRequester.setManagerLevel(manager, managerLevel);
                } else if (currentLevel != managerLevel) {
                    errorManagers.add(manager);
                    errorManagersLevel.add(managerLevel);
                }
            } else {
                this.unknownManagers.add(manager);
            }
            this.trace("Manager = " + Integer.toHexString(manager) + " ManagerLevel " + managerLevel);
        }
        this.sqlamLevel = this.appRequester.getManagerLevel(9223);
        if (errorManagers.size() > 0) {
            Object[] oa = new Object[errorManagers.size() * 2];
            int j = 0;
            for (int i = 0; i < errorManagers.size(); ++i) {
                oa[j++] = errorManagers.get(i);
                oa[j++] = errorManagersLevel.get(i);
            }
            throw new DRDAProtocolException(DRDAProtocolException.DRDA_Proto_MGRLVLRM, this, 0, 0, oa);
        }
    }

    private void writeEXCSATRD() throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(5187);
        this.writer.writeScalarString(4446, NetworkServerControlImpl.att_extnam());
        if (this.knownManagers != null && this.knownManagers.size() > 0) {
            this.writeMGRLEVELS();
        }
        this.writer.writeScalarString(4423, NetworkServerControlImpl.att_srvclsnm());
        this.writer.writeScalarString(4461, "NetworkServerControl");
        this.writer.writeScalarString(4442, NetworkServerControlImpl.att_srvrlslv());
        this.writer.endDdmAndDss();
    }

    private void writeMGRLEVELS() throws DRDAProtocolException {
        this.writer.startDdm(5124);
        for (int manager : this.knownManagers) {
            int appLevel = this.appRequester.getManagerLevel(manager);
            int serverLevel = this.server.getManagerLevel(manager);
            if (serverLevel >= appLevel) {
                this.writer.writeCodePoint4Bytes(manager, appLevel);
                continue;
            }
            this.writer.writeCodePoint4Bytes(manager, serverLevel);
            this.appRequester.setManagerLevel(manager, serverLevel);
        }
        for (int manager : this.unknownManagers) {
            this.writer.writeCodePoint4Bytes(manager, 0);
        }
        this.writer.endDdm();
    }

    private int parseACCSEC() throws DRDAProtocolException {
        int securityCheckCode = 0;
        int securityMechanism = 0;
        byte[] secTokenIn = null;
        this.reader.markCollection();
        int codePoint = this.reader.getCodePoint();
        while (codePoint != -1) {
            switch (codePoint) {
                case 4502: {
                    if (this.reader.getDdmLength() == 0L) break;
                    this.badObjectLength(4502);
                    break;
                }
                case 4514: {
                    this.checkLength(4514, 2);
                    securityMechanism = this.reader.readNetworkShort();
                    this.trace("parseACCSEC - Security mechanism = " + securityMechanism);
                    if (this.server.getSecurityMechanism() != -1 && securityMechanism != this.server.getSecurityMechanism()) {
                        securityCheckCode = 1;
                        this.trace("parseACCSEC - SECCHKCD_NOTSUPPORTED [1] - " + securityMechanism + " <> " + this.server.getSecurityMechanism() + "\n");
                        break;
                    }
                    if (securityMechanism == 3 || securityMechanism == 4) break;
                    if ((securityMechanism != 9 || securityMechanism == 9 && !this.server.supportsEUSRIDPWD()) && securityMechanism != 8) {
                        securityCheckCode = 1;
                        this.trace("parseACCSEC - SECCHKCD_NOTSUPPORTED [2]\n");
                        break;
                    }
                    if (securityMechanism == 8) break;
                    try {
                        if (decryptionManager == null) {
                            decryptionManager = new DecryptionManager();
                        }
                        this.myPublicKey = decryptionManager.obtainPublicKey();
                    }
                    catch (SQLException e) {
                        DRDAConnThread.println2Log(null, this.session.drdaID, e.getMessage());
                        securityCheckCode = 10;
                    }
                    break;
                }
                case 8464: {
                    String dbname = this.parseRDBNAM();
                    Database d = this.session.getDatabase(dbname);
                    if (d == null) {
                        this.initializeDatabase(dbname);
                        break;
                    }
                    if (!this.deferredReset) {
                        d.reset();
                    }
                    this.database = d;
                    break;
                }
                case 4572: {
                    secTokenIn = this.reader.readBytes();
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
        if (securityMechanism == 0) {
            this.missingCodePoint(4514);
        }
        if (this.database == null) {
            this.initializeDatabase(null);
        }
        this.database.securityMechanism = securityMechanism;
        this.database.secTokenIn = secTokenIn;
        if (securityCheckCode == 0 && this.database.securityMechanism == 8) {
            SanityManager.ASSERT(securityCheckCode == 0, "SECMEC_USRSSBPWD: securityCheckCode should not already be set, found it initialized with a value of '" + securityCheckCode + "'.");
            securityCheckCode = this.validateSecMecUSRSSBPWD();
        }
        if (securityCheckCode == 0 && (this.database.securityMechanism == 9 || this.database.securityMechanism == 8) && this.database.secTokenIn == null) {
            securityCheckCode = 14;
        }
        if (securityCheckCode == 0 && (this.database.securityMechanism == 3 || this.database.securityMechanism == 4) && this.database.secTokenIn != null) {
            securityCheckCode = 14;
        }
        this.trace("** ACCSECRD securityCheckCode is: " + securityCheckCode);
        this.session.setState(securityCheckCode == 0 ? 3 : 2);
        return securityCheckCode;
    }

    private Pkgnamcsn parseOPNQRY() throws DRDAProtocolException, SQLException {
        DRDAStatement stmt;
        Pkgnamcsn pkgnamcsn = null;
        boolean gotQryblksz = false;
        int blksize = 0;
        int qryblkctl = 9239;
        int maxblkext = 0;
        int qryrowset = -1;
        int qryclsimp = 2;
        int outovropt = 1;
        this.reader.markCollection();
        int codePoint = this.reader.getCodePoint();
        while (codePoint != -1) {
            switch (codePoint) {
                case 8464: {
                    this.setDatabase(8204);
                    break;
                }
                case 8467: {
                    pkgnamcsn = this.parsePKGNAMCSN();
                    break;
                }
                case 8468: {
                    blksize = this.parseQRYBLKSZ();
                    gotQryblksz = true;
                    break;
                }
                case 8498: {
                    qryblkctl = this.reader.readNetworkShort();
                    if (qryblkctl != 9232) {
                        this.invalidCodePoint(qryblkctl);
                    }
                    this.trace("!!qryblkctl = " + Integer.toHexString(qryblkctl));
                    gotQryblksz = true;
                    break;
                }
                case 8513: {
                    maxblkext = this.reader.readSignedNetworkShort();
                    this.trace("maxblkext = " + maxblkext);
                    break;
                }
                case 8519: {
                    outovropt = this.parseOUTOVROPT();
                    break;
                }
                case 8534: {
                    qryrowset = this.parseQRYROWSET(0);
                    break;
                }
                case 8541: {
                    qryclsimp = this.parseQRYCLSIMP();
                    break;
                }
                case 8542: {
                    this.parseQRYCLSRLS();
                    break;
                }
                case 6400: {
                    this.parseMONITOR();
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
        if (pkgnamcsn == null) {
            this.missingCodePoint(8467);
        }
        if (!gotQryblksz) {
            this.missingCodePoint(8468);
        }
        if ((stmt = this.database.getDRDAStatement(pkgnamcsn)) == null) {
            this.invalidValue(8467);
        }
        stmt.setOPNQRYOptions(blksize, qryblkctl, maxblkext, outovropt, qryrowset, qryclsimp);
        if (this.reader.isChainedWithSameID()) {
            this.trace("&&&&&& parsing SQLDTA");
            this.parseOPNQRYobjects(stmt);
        }
        return pkgnamcsn;
    }

    private void parseOPNQRYobjects(DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        do {
            this.correlationID = this.reader.readDssHeader();
            block7: while (this.reader.moreDssData()) {
                int codePoint = this.reader.readLengthAndCodePoint(false);
                switch (codePoint) {
                    case 47: {
                        this.setStmtOrDbByteOrder(false, stmt, this.parseTYPDEFNAM());
                        continue block7;
                    }
                    case 53: {
                        this.parseTYPDEFOVR(stmt);
                        continue block7;
                    }
                    case 9234: {
                        this.parseSQLDTA(stmt);
                        continue block7;
                    }
                    case 5228: {
                        this.readAndSetAllExtParams(stmt, false);
                        continue block7;
                    }
                }
                this.invalidCodePoint(codePoint);
            }
        } while (this.reader.isChainedWithSameID());
    }

    private int parseOUTOVROPT() throws DRDAProtocolException {
        this.checkLength(8519, 1);
        int outovropt = this.reader.readUnsignedByte();
        this.trace("output override option: " + outovropt);
        if (outovropt != 1 && outovropt != 2) {
            this.invalidValue(8519);
        }
        return outovropt;
    }

    private int parseQRYBLKSZ() throws DRDAProtocolException {
        this.checkLength(8468, 4);
        int blksize = this.reader.readNetworkInt();
        this.trace("qryblksz = " + blksize);
        if (blksize < 512 || blksize > 0xA00000) {
            this.invalidValue(8468);
        }
        return blksize;
    }

    private int parseQRYROWSET(int minVal) throws DRDAProtocolException {
        this.checkLength(8534, 4);
        int qryrowset = this.reader.readNetworkInt();
        this.trace("qryrowset = " + qryrowset);
        if (qryrowset < minVal || qryrowset > Short.MAX_VALUE) {
            this.invalidValue(8534);
        }
        return qryrowset;
    }

    private int parseQRYCLSIMP() throws DRDAProtocolException {
        this.checkLength(8541, 1);
        int qryclsimp = this.reader.readUnsignedByte();
        this.trace("qryclsimp = " + qryclsimp);
        if (qryclsimp != 0 && qryclsimp != 1 && qryclsimp != 2) {
            this.invalidValue(8541);
        }
        return qryclsimp;
    }

    private int parseQRYCLSRLS() throws DRDAProtocolException {
        this.reader.skipBytes();
        return 0;
    }

    private void writeQRYPOPRM() throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(8719);
        this.writer.writeScalar2Bytes(4425, 8);
        this.writeRDBNAM(this.database.getDatabaseName());
        this.writePKGNAMCSN();
        this.writer.endDdmAndDss();
    }

    private void writeQRYNOPRM(int svrCod) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(8706);
        this.writer.writeScalar2Bytes(4425, svrCod);
        this.writeRDBNAM(this.database.getDatabaseName());
        this.writePKGNAMCSN();
        this.writer.endDdmAndDss();
    }

    private void writeOPNQFLRM(SQLException e) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(8722);
        this.writer.writeScalar2Bytes(4425, 8);
        this.writeRDBNAM(this.database.getDatabaseName());
        this.writer.endDdm();
        this.writer.startDdm(9224);
        this.writeSQLCAGRP(e, 0L, 0L);
        this.writer.endDdmAndDss();
    }

    private void writePKGNAMCSN(byte[] pkgcnstkn) throws DRDAProtocolException {
        this.writer.startDdm(8467);
        if (this.rdbnam.length() <= 18 && this.rdbcolid.length() <= 18 && this.pkgid.length() <= 18) {
            this.writer.writeScalarPaddedString(this.rdbnam, 18);
            this.writer.writeScalarPaddedString(this.rdbcolid, 18);
            this.writer.writeScalarPaddedString(this.pkgid, 18);
            this.writer.writeScalarPaddedBytes(pkgcnstkn, 8, (byte)0);
            this.writer.writeShort(this.pkgsn);
        } else {
            int len = Math.max(18, this.rdbnam.length());
            this.writer.writeShort(len);
            this.writer.writeScalarPaddedString(this.rdbnam, len);
            len = Math.max(18, this.rdbcolid.length());
            this.writer.writeShort(len);
            this.writer.writeScalarPaddedString(this.rdbcolid, len);
            len = Math.max(18, this.pkgid.length());
            this.writer.writeShort(len);
            this.writer.writeScalarPaddedString(this.pkgid, len);
            this.writer.writeScalarPaddedBytes(pkgcnstkn, 8, (byte)0);
            this.writer.writeShort(this.pkgsn);
        }
        this.writer.endDdm();
    }

    private void writePKGNAMCSN() throws DRDAProtocolException {
        this.writePKGNAMCSN(this.pkgcnstkn.getBytes());
    }

    private DRDAStatement parseCNTQRY() throws DRDAProtocolException, SQLException {
        DRDAStatement stmt;
        Pkgnamcsn pkgnamcsn = null;
        boolean gotQryblksz = false;
        boolean qryrelscr = true;
        long qryrownbr = 1L;
        boolean qryrfrtbl = false;
        int nbrrow = 1;
        int blksize = 0;
        int maxblkext = -1;
        boolean gotQryinsid = false;
        int qryscrorn = 1;
        boolean qryrowsns = false;
        boolean gotQryrowsns = false;
        boolean qryblkrst = false;
        boolean qryrtndta = true;
        int qryrowset = -1;
        int rtnextdta = 1;
        this.reader.markCollection();
        int codePoint = this.reader.getCodePoint();
        while (codePoint != -1) {
            block0 : switch (codePoint) {
                case 8464: {
                    this.setDatabase(8198);
                    break;
                }
                case 8467: {
                    pkgnamcsn = this.parsePKGNAMCSN();
                    break;
                }
                case 8468: {
                    blksize = this.parseQRYBLKSZ();
                    gotQryblksz = true;
                    break;
                }
                case 8508: {
                    qryrelscr = this.readBoolean(8508);
                    this.trace("qryrelscr = " + qryrelscr);
                    break;
                }
                case 8530: {
                    this.checkLength(8530, 1);
                    qryscrorn = this.reader.readUnsignedByte();
                    this.trace("qryscrorn = " + qryscrorn);
                    switch (qryscrorn) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            break block0;
                        }
                    }
                    this.invalidValue(8530);
                    break;
                }
                case 8509: {
                    this.checkLength(8509, 8);
                    qryrownbr = this.reader.readNetworkLong();
                    this.trace("qryrownbr = " + qryrownbr);
                    break;
                }
                case 8531: {
                    this.checkLength(8531, 1);
                    qryrowsns = this.readBoolean(8531);
                    this.trace("qryrowsns = " + qryrowsns);
                    gotQryrowsns = true;
                    break;
                }
                case 8532: {
                    this.checkLength(8532, 1);
                    qryblkrst = this.readBoolean(8532);
                    this.trace("qryblkrst = " + qryblkrst);
                    break;
                }
                case 8533: {
                    qryrtndta = this.readBoolean(8533);
                    this.trace("qryrtndta = " + qryrtndta);
                    break;
                }
                case 8534: {
                    qryrowset = this.parseQRYROWSET(1);
                    this.trace("qryrowset = " + qryrowset);
                    break;
                }
                case 8510: {
                    qryrfrtbl = this.readBoolean(8510);
                    this.trace("qryrfrtbl = " + qryrfrtbl);
                    break;
                }
                case 8506: {
                    this.checkLength(8506, 4);
                    nbrrow = this.reader.readNetworkInt();
                    this.trace("nbrrow = " + nbrrow);
                    break;
                }
                case 8513: {
                    this.checkLength(8513, 2);
                    maxblkext = this.reader.readSignedNetworkShort();
                    this.trace("maxblkext = " + maxblkext);
                    break;
                }
                case 8520: {
                    this.checkLength(8520, 1);
                    rtnextdta = this.reader.readUnsignedByte();
                    if (rtnextdta != 1 && rtnextdta != 2) {
                        this.invalidValue(8520);
                    }
                    this.trace("rtnextdta = " + rtnextdta);
                    break;
                }
                case 8539: {
                    this.checkLength(8539, 8);
                    long qryinsid = this.reader.readNetworkLong();
                    gotQryinsid = true;
                    this.trace("qryinsid = " + qryinsid);
                    break;
                }
                case 6400: {
                    this.parseMONITOR();
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
        if (pkgnamcsn == null) {
            this.missingCodePoint(8467);
        }
        if (!gotQryblksz) {
            this.missingCodePoint(8468);
        }
        if (this.sqlamLevel >= 7 && !gotQryinsid) {
            this.missingCodePoint(8539);
        }
        if ((stmt = this.database.getDRDAStatement(pkgnamcsn)) == null) {
            this.invalidValue(8198);
        }
        if (stmt.rsIsClosed()) {
            this.writeQRYNOPRM(8);
            this.skipRemainder(true);
            return null;
        }
        stmt.setQueryOptions(blksize, qryrelscr, qryrownbr, qryrfrtbl, nbrrow, maxblkext, qryscrorn, qryrowsns, qryblkrst, qryrtndta, qryrowset, rtnextdta);
        if (this.reader.isChainedWithSameID()) {
            this.parseCNTQRYobjects(stmt);
        }
        return stmt;
    }

    private void skipRemainder(boolean onlySkipSameIds) throws DRDAProtocolException {
        this.reader.skipDss();
        while (this.reader.isChainedWithSameID() || !onlySkipSameIds && this.reader.isChainedWithDiffID()) {
            this.reader.readDssHeader();
            this.reader.skipDss();
        }
    }

    private void parseCNTQRYobjects(DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        do {
            this.correlationID = this.reader.readDssHeader();
            block4: while (this.reader.moreDssData()) {
                int codePoint = this.reader.readLengthAndCodePoint(false);
                switch (codePoint) {
                    case 9237: {
                        this.parseOUTOVR(stmt);
                        continue block4;
                    }
                }
                this.invalidCodePoint(codePoint);
            }
        } while (this.reader.isChainedWithSameID());
    }

    private void parseOUTOVR(DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        boolean first = true;
        int start = 0;
        while (true) {
            int[] outovr_drdaType;
            int dtaGrpLen = this.reader.readUnsignedByte();
            int tripType = this.reader.readUnsignedByte();
            int tripId = this.reader.readUnsignedByte();
            if (tripType == 113) break;
            int numVars = (dtaGrpLen - 3) / 3;
            this.trace("num of vars is: " + numVars);
            if (first) {
                outovr_drdaType = new int[numVars];
                first = false;
            } else {
                int[] oldoutovr_drdaType = stmt.getOutovr_drdaType();
                int oldlen = oldoutovr_drdaType.length;
                outovr_drdaType = new int[oldlen + numVars];
                System.arraycopy(oldoutovr_drdaType, 0, outovr_drdaType, 0, oldlen);
                start = oldlen;
            }
            for (int i = start; i < numVars + start; ++i) {
                int drdaType = this.reader.readUnsignedByte();
                if (!this.database.supportsLocator() && drdaType >= 24 && drdaType <= 27) {
                    this.trace("ignoring drdaType: " + drdaType);
                    this.reader.readNetworkShort();
                    continue;
                }
                outovr_drdaType[i] = drdaType;
                this.trace("drdaType is: " + outovr_drdaType[i]);
                int precision = this.reader.readNetworkShort();
                this.trace("drdaLength is: " + precision);
                int n = i;
                outovr_drdaType[n] = outovr_drdaType[n] | precision << 8;
            }
            stmt.setOutovr_drdaType(outovr_drdaType);
        }
        this.reader.skipBytes();
    }

    private void writePBSD() throws SQLException, DRDAProtocolException {
        if (!this.appRequester.supportsSessionDataCaching()) {
            return;
        }
        PiggyBackedSessionData pbsd = this.database.getPiggyBackedSessionData(true);
        SanityManager.ASSERT(pbsd != null, "pbsd is not expected to be null");
        this.deferredReset = false;
        pbsd.refresh();
        if (pbsd.isModified()) {
            this.writer.createDssReply();
            this.writer.startDdm(49152);
            if (pbsd.isIsoModified()) {
                this.writer.writeScalar1Byte(49153, pbsd.getIso());
            }
            if (pbsd.isSchemaModified()) {
                this.writer.startDdm(49154);
                this.writer.writeString(pbsd.getSchema());
                this.writer.endDdm();
            }
            this.writer.endDdmAndDss();
        }
        pbsd.setUnmodified();
        PiggyBackedSessionData pbsdNew = this.database.getPiggyBackedSessionData(true);
        SanityManager.ASSERT(pbsdNew == pbsd, "pbsdNew and pbsd are expected to reference the same object");
        pbsd.refresh();
        SanityManager.ASSERT(!pbsd.isModified(), "pbsd=(" + String.valueOf(pbsd) + ") is not expected to be modified");
    }

    private void writeOPNQRYRM(boolean isDssObject, DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        this.trace("WriteOPNQRYRM");
        if (isDssObject) {
            this.writer.createDssObject();
        } else {
            this.writer.createDssReply();
        }
        this.writer.startDdm(8709);
        this.writer.writeScalar2Bytes(4425, 0);
        int prcType = stmt.getQryprctyp();
        this.trace("sending QRYPRCTYP: " + prcType);
        this.writer.writeScalar2Bytes(8450, prcType);
        if (stmt.getCurrentDrdaResultSet().withHoldCursor == 1) {
            this.writer.writeScalar1Byte(8479, -15);
        }
        if (this.sqlamLevel >= 7) {
            this.writer.writeScalarHeader(8539, 8);
            this.writer.writeInt(0);
            this.writer.writeInt(this.session.qryinsid++);
            if (stmt.isScrollable()) {
                this.writer.writeScalar1Byte(8521, -15);
                if (stmt.getConcurType() == 1008 && stmt.getResultSet().getType() == 1004) {
                    this.writer.writeScalar1Byte(8535, 2);
                } else {
                    this.writer.writeScalar1Byte(8535, 1);
                }
            }
            if (stmt.getConcurType() == 1008) {
                if (stmt.getResultSet() != null) {
                    if (stmt.getResultSet().getConcurrency() == 1008) {
                        this.writer.writeScalar1Byte(8528, 4);
                    } else {
                        this.writer.writeScalar1Byte(8528, 1);
                    }
                } else {
                    this.writer.writeScalar1Byte(8528, 4);
                }
            } else {
                this.writer.writeScalar1Byte(8528, 1);
            }
        }
        this.writer.endDdmAndDss();
    }

    private void writeENDQRYRM(int svrCod) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(8715);
        this.writer.writeScalar2Bytes(4425, svrCod);
        this.writer.endDdmAndDss();
    }

    private void writeABNUOWRM() throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(8717);
        this.writer.writeScalar2Bytes(4425, 8);
        this.writeRDBNAM(this.database.getDatabaseName());
        this.writer.endDdmAndDss();
    }

    private String parseRDBNAM() throws DRDAProtocolException {
        byte[] rdbName = this.reader.readBytes();
        if (rdbName.length == 0) {
            this.rdbNotFound(null);
        }
        if (rdbName.length < 18 || rdbName.length > 1024) {
            this.badObjectLength(8464);
        }
        String name = this.reader.convertBytes(rdbName);
        name = name.trim();
        this.trace("RdbName " + name);
        return name;
    }

    private void writeACCSECRD(int securityCheckCode) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(5292);
        if (securityCheckCode != 1) {
            this.writer.writeScalar2Bytes(4514, this.database.securityMechanism);
        } else if (this.server.getSecurityMechanism() != -1) {
            this.writer.writeScalar2Bytes(4514, this.server.getSecurityMechanism());
        } else {
            this.writer.writeScalar2Bytes(4514, 3);
            if (this.server.supportsEUSRIDPWD()) {
                this.writer.writeScalar2Bytes(4514, 9);
            }
            this.writer.writeScalar2Bytes(4514, 4);
            this.writer.writeScalar2Bytes(4514, 8);
        }
        if (securityCheckCode != 0) {
            this.writer.writeScalar1Byte(4516, securityCheckCode);
        } else if (this.database.securityMechanism == 9) {
            this.writer.writeScalarBytes(4572, this.myPublicKey);
        } else if (this.database.securityMechanism == 8) {
            this.writer.writeScalarBytes(4572, this.myTargetSeed);
        }
        this.writer.endDdmAndDss();
        if (securityCheckCode != 0) {
            this.skipRemainder(false);
        }
        this.finalizeChain();
    }

    /*
     * Unable to fully structure code
     */
    private int parseSECCHK() throws DRDAProtocolException {
        block43: {
            block42: {
                securityCheckCode = 0;
                securityMechanism = 0;
                this.databaseAccessException = null;
                this.reader.markCollection();
                codePoint = this.reader.getCodePoint();
                if (!this.deferredReset) break block42;
                while (codePoint != -1) {
                    switch (codePoint) {
                        case 4502: 
                        case 4512: 
                        case 4513: 
                        case 4514: 
                        case 4572: 
                        case 4574: 
                        case 8464: {
                            this.reader.skipBytes();
                            break;
                        }
                        default: {
                            this.invalidCodePoint(codePoint);
                        }
                    }
                    codePoint = this.reader.getCodePoint();
                }
                break block43;
            }
            while (codePoint != -1) {
                switch (codePoint) {
                    case 4502: {
                        this.reader.skipBytes();
                        break;
                    }
                    case 4514: {
                        this.checkLength(4514, 2);
                        securityMechanism = this.reader.readNetworkShort();
                        this.trace("parseSECCHK - Security mechanism = " + securityMechanism);
                        if (securityMechanism == this.database.securityMechanism) break;
                        this.invalidValue(4514);
                        break;
                    }
                    case 4572: {
                        if (this.database.securityMechanism != 9 && this.database.securityMechanism != 8) {
                            securityCheckCode = 14;
                            this.reader.skipBytes();
                            break;
                        }
                        if (this.database.securityMechanism != 9) ** GOTO lbl58
                        if (this.database.decryptedUserId != null) ** GOTO lbl47
                        try {
                            this.database.decryptedUserId = this.reader.readEncryptedString(DRDAConnThread.decryptionManager, this.database.securityMechanism, this.myPublicKey, this.database.secTokenIn);
                        }
                        catch (SQLException se) {
                            DRDAConnThread.println2Log(this.database.getDatabaseName(), this.session.drdaID, se.getMessage());
                            if (securityCheckCode != 0) ** GOTO lbl44
                            securityCheckCode = 19;
                        }
lbl44:
                        // 3 sources

                        this.database.userId = this.database.decryptedUserId;
                        this.trace("**decrypted userid is: " + this.database.userId);
                        break;
lbl47:
                        // 1 sources

                        if (this.database.decryptedPassword != null) break;
                        try {
                            this.database.decryptedPassword = this.reader.readEncryptedString(DRDAConnThread.decryptionManager, this.database.securityMechanism, this.myPublicKey, this.database.secTokenIn);
                        }
                        catch (SQLException se) {
                            DRDAConnThread.println2Log(this.database.getDatabaseName(), this.session.drdaID, se.getMessage());
                            if (securityCheckCode != 0) ** GOTO lbl55
                            securityCheckCode = 15;
                        }
lbl55:
                        // 3 sources

                        this.database.password = this.database.decryptedPassword;
                        this.trace("**decrypted password is: " + this.database.password);
                        break;
lbl58:
                        // 1 sources

                        if (this.database.securityMechanism == 8) {
                            if (this.database.passwordSubstitute != null) break;
                            this.database.passwordSubstitute = this.reader.readBytes();
                            this.trace("** Substitute Password is:" + DecryptionManager.toHexString(this.database.passwordSubstitute, 0, this.database.passwordSubstitute.length));
                            this.database.password = DecryptionManager.toHexString(this.database.passwordSubstitute, 0, this.database.passwordSubstitute.length);
                            break;
                        }
                        this.tooMany(4572);
                        break;
                    }
                    case 4513: {
                        this.database.password = this.reader.readString();
                        this.trace("PASSWORD " + this.database.password);
                        break;
                    }
                    case 4574: {
                        this.reader.skipBytes();
                        break;
                    }
                    case 4512: {
                        this.database.userId = this.reader.readString();
                        this.trace("USERID " + this.database.userId);
                        break;
                    }
                    case 8464: {
                        dbname = this.parseRDBNAM();
                        if (this.database != null) {
                            if (this.database.getDatabaseName() == null) {
                                this.database.setDatabaseName(dbname);
                                this.session.addDatabase(this.database);
                                this.session.database = this.database;
                                break;
                            }
                            if (this.database.getDatabaseName().equals(dbname)) break;
                            this.rdbnamMismatch(4206);
                            break;
                        }
                        this.initializeDatabase(dbname);
                        break;
                    }
                    default: {
                        this.invalidCodePoint(codePoint);
                    }
                }
                codePoint = this.reader.getCodePoint();
            }
            if (securityMechanism == 0) {
                this.missingCodePoint(4514);
            }
            if (this.getDbName() == null) {
                this.missingCodePoint(8464);
            }
            if (securityCheckCode == 0 && (this.database.securityMechanism == 3 || this.database.securityMechanism == 4)) {
                if (this.database.userId == null) {
                    securityCheckCode = 18;
                } else if (this.database.securityMechanism == 3 && this.database.password == null) {
                    securityCheckCode = 16;
                }
            }
            if (securityCheckCode == 0 && this.database.securityMechanism == 8) {
                if (this.database.userId == null) {
                    securityCheckCode = 18;
                } else if (this.database.passwordSubstitute == null) {
                    securityCheckCode = 16;
                }
            }
            if (securityCheckCode == 0 && this.database.securityMechanism == 9) {
                if (this.database.decryptedUserId == null) {
                    securityCheckCode = 18;
                } else if (this.database.decryptedPassword == null) {
                    securityCheckCode = 16;
                }
            }
        }
        if (securityCheckCode == 0 && this.databaseAccessException == null) {
            if (this.deferredReset) {
                try {
                    this.database.getConnection().resetFromPool();
                    this.database.getConnection().setHoldability(1);
                    this.database.getConnection().setTransactionIsolation(2);
                }
                catch (SQLException sqle) {
                    this.handleException(sqle);
                }
            } else {
                securityCheckCode = this.verifyUserIdPassword();
            }
        }
        if (securityCheckCode == 0) {
            this.session.setState(4);
        }
        return securityCheckCode;
    }

    private void writeSECCHKRM(int securityCheckCode) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(4633);
        this.writer.writeScalar2Bytes(4425, this.svrcodFromSecchkcd(securityCheckCode));
        this.writer.writeScalar1Byte(4516, securityCheckCode);
        this.writer.endDdmAndDss();
        if (securityCheckCode != 0) {
            this.skipRemainder(false);
        }
        this.finalizeChain();
    }

    private int svrcodFromSecchkcd(int securityCheckCode) {
        if (securityCheckCode == 0 || securityCheckCode == 2 || securityCheckCode == 5 || securityCheckCode == 8) {
            return 0;
        }
        return 8;
    }

    private int parseACCRDB() throws DRDAProtocolException {
        int svrcod = 0;
        this.copyToRequired(ACCRDB_REQUIRED);
        this.reader.markCollection();
        int codePoint = this.reader.getCodePoint();
        while (codePoint != -1) {
            switch (codePoint) {
                case 8463: {
                    this.checkLength(8463, 2);
                    int sqlam = this.reader.readNetworkShort();
                    this.trace("RDBACCCL = " + sqlam);
                    if (sqlam != 9223) {
                        this.invalidValue(8463);
                    }
                    this.removeFromRequired(8463);
                    break;
                }
                case 8501: {
                    this.database.crrtkn = this.reader.readBytes();
                    this.trace("crrtkn " + this.convertToHexString(this.database.crrtkn));
                    this.removeFromRequired(8501);
                    int l = this.database.crrtkn.length;
                    if (l > 255) {
                        this.tooBig(8501);
                    }
                    if (l < 9 || l > 23) {
                        this.invalidValue(8501);
                    }
                    byte[] part1 = new byte[l - 6];
                    System.arraycopy(this.database.crrtkn, 0, part1, 0, part1.length);
                    long time = SignedBinary.getLong(this.database.crrtkn, l - 8, 1);
                    this.session.drdaID = this.reader.convertBytes(part1) + time + leftBrace + this.session.connNum + rightBrace;
                    this.trace("******************************************drdaID is: " + this.session.drdaID);
                    this.database.setDrdaID(this.session.drdaID);
                    break;
                }
                case 8464: {
                    String dbname = this.parseRDBNAM();
                    if (this.database != null) {
                        if (!this.database.getDatabaseName().equals(dbname)) {
                            this.rdbnamMismatch(8193);
                        }
                    } else {
                        Database d = this.session.getDatabase(dbname);
                        if (d == null) {
                            this.initializeDatabase(dbname);
                        } else {
                            this.database = d;
                            ++this.database.accessCount;
                        }
                    }
                    this.removeFromRequired(8464);
                    break;
                }
                case 4398: {
                    this.appRequester.setClientVersion(this.reader.readString());
                    this.trace("prdId " + this.appRequester.prdid);
                    if (this.appRequester.prdid.length() > 8) {
                        this.tooBig(4398);
                    }
                    if (this.appRequester.getClientType() != 3) {
                        this.invalidClient(this.appRequester.prdid);
                    }
                    this.sendWarningsOnCNTQRY = true;
                    if (this.appRequester.getClientType() == 3 && this.appRequester.greaterThanOrEqualTo(10, 2, 0)) {
                        this.diagnosticLevel = (byte)-15;
                    }
                    this.removeFromRequired(4398);
                    break;
                }
                case 47: {
                    this.setStmtOrDbByteOrder(true, null, this.parseTYPDEFNAM());
                    this.removeFromRequired(47);
                    break;
                }
                case 53: {
                    this.parseTYPDEFOVR(null);
                    this.removeFromRequired(53);
                    break;
                }
                case 8474: {
                    this.checkLength(8474, 1);
                    this.database.rdbAllowUpdates = this.readBoolean(8474);
                    this.trace("rdbAllowUpdates = " + this.database.rdbAllowUpdates);
                    break;
                }
                case 8452: {
                    if (this.reader.getDdmLength() > 255L) {
                        this.tooBig(8452);
                    }
                    this.reader.skipBytes();
                    break;
                }
                case 8507: {
                    if (this.reader.readByte() != -15) break;
                    this.database.sendTRGDFTRT = true;
                    break;
                }
                case 8480: 
                case 8481: {
                    this.codePointNotSupported(codePoint);
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
        this.checkRequired(8193);
        if (this.database.ccsidDBC != 0 && !this.server.supportsCCSID(this.database.ccsidDBC) || this.database.ccsidMBC != 0 && !this.server.supportsCCSID(this.database.ccsidMBC)) {
            svrcod = 4;
        }
        return svrcod;
    }

    private String parseTYPDEFNAM() throws DRDAProtocolException {
        String typDefNam = this.reader.readString();
        this.trace("typeDefName " + typDefNam);
        if (typDefNam.length() > 255) {
            this.tooBig(47);
        }
        this.checkValidTypDefNam(typDefNam);
        if (!(typDefNam.equals("QTDSQLASC") || typDefNam.equals("QTDSQLJVM") || typDefNam.equals("QTDSQLX86"))) {
            this.valueNotSupported(47);
        }
        return typDefNam;
    }

    private void setStmtOrDbByteOrder(boolean setDatabase, DRDAStatement stmt, String typDefNam) {
        int byteOrder;
        int n = byteOrder = typDefNam.equals("QTDSQLX86") ? 2 : 1;
        if (setDatabase) {
            this.database.typDefNam = typDefNam;
            this.database.byteOrder = byteOrder;
        } else {
            stmt.typDefNam = typDefNam;
            stmt.byteOrder = byteOrder;
        }
    }

    private void writeACCRDBRM(int svrcod) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(8705);
        this.writer.writeScalar2Bytes(4425, svrcod);
        this.writer.writeScalarString(4398, NetworkServerControlImpl.prdId());
        this.writer.writeScalarString(47, "QTDSQLASC");
        this.writeTYPDEFOVR();
        this.writer.endDdmAndDss();
        if (this.appRequester.getClientType() == 3 && this.appRequester.greaterThanOrEqualTo(10, 7, 0)) {
            try {
                this.writePBSD();
            }
            catch (SQLException se) {
                this.server.consoleExceptionPrint(se);
                this.errorInChain(se);
            }
        }
        this.finalizeChain();
    }

    private void writeTYPDEFOVR() throws DRDAProtocolException {
        this.writer.startDdm(53);
        this.writer.writeScalar2Bytes(4508, 1208);
        this.writer.writeScalar2Bytes(4510, 1208);
        if (this.database.sendTRGDFTRT) {
            this.writer.startDdm(8485);
            this.writer.writeShort(9269);
            this.writer.endDdm();
            this.writer.startDdm(4512);
            this.writer.writeString(this.database.userId);
            this.writer.endDdm();
        }
        this.writer.endDdm();
    }

    /*
     * Unable to fully structure code
     */
    private void parseTYPDEFOVR(DRDAStatement st) throws DRDAProtocolException {
        ccsidSBC = 0;
        ccsidDBC = 0;
        ccsidMBC = 0;
        ccsidSBCEncoding = null;
        ccsidDBCEncoding = null;
        ccsidMBCEncoding = null;
        this.reader.markCollection();
        codePoint = this.reader.getCodePoint();
        if (codePoint == -1 && st != null) {
            this.missingCodePoint(4508);
        }
        while (codePoint != -1) {
            switch (codePoint) {
                case 4508: {
                    this.checkLength(4508, 2);
                    ccsidSBC = this.reader.readNetworkShort();
                    try {
                        ccsidSBCEncoding = CharacterEncodings.getJavaEncoding(ccsidSBC);
                    }
                    catch (Exception e) {
                        this.valueNotSupported(4508);
                    }
                    this.trace("ccsidsbc = " + ccsidSBC + " encoding = " + ccsidSBCEncoding);
                    break;
                }
                case 4509: {
                    this.checkLength(4509, 2);
                    ccsidDBC = this.reader.readNetworkShort();
                    try {
                        ccsidDBCEncoding = CharacterEncodings.getJavaEncoding(ccsidDBC);
                    }
                    catch (Exception e) {
                        ccsidDBCEncoding = null;
                        if (st == null) ** GOTO lbl33
                        this.valueNotSupported(4508);
                    }
lbl33:
                    // 3 sources

                    this.trace("ccsiddbc = " + ccsidDBC + " encoding = " + ccsidDBCEncoding);
                    break;
                }
                case 4510: {
                    this.checkLength(4510, 2);
                    ccsidMBC = this.reader.readNetworkShort();
                    try {
                        ccsidMBCEncoding = CharacterEncodings.getJavaEncoding(ccsidMBC);
                    }
                    catch (Exception e) {
                        ccsidMBCEncoding = null;
                        if (st == null) ** GOTO lbl45
                        this.valueNotSupported(4510);
                    }
lbl45:
                    // 3 sources

                    this.trace("ccsidmbc = " + ccsidMBC + " encoding = " + ccsidMBCEncoding);
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
        if (st == null) {
            if (ccsidSBC != 0) {
                this.database.ccsidSBC = ccsidSBC;
                this.database.ccsidSBCEncoding = ccsidSBCEncoding;
            }
            if (ccsidDBC != 0) {
                this.database.ccsidDBC = ccsidDBC;
                this.database.ccsidDBCEncoding = ccsidDBCEncoding;
            }
            if (ccsidMBC != 0) {
                this.database.ccsidMBC = ccsidMBC;
                this.database.ccsidMBCEncoding = ccsidMBCEncoding;
            }
        } else {
            if (ccsidSBC != 0) {
                st.ccsidSBC = ccsidSBC;
                st.ccsidSBCEncoding = ccsidSBCEncoding;
            }
            if (ccsidDBC != 0) {
                st.ccsidDBC = ccsidDBC;
                st.ccsidDBCEncoding = ccsidDBCEncoding;
            }
            if (ccsidMBC != 0) {
                st.ccsidMBC = ccsidMBC;
                st.ccsidMBCEncoding = ccsidMBCEncoding;
            }
        }
    }

    private int parsePRPSQLSTT() throws DRDAProtocolException, SQLException {
        boolean rtnsqlda = false;
        boolean rtnOutput = true;
        Pkgnamcsn pkgnamcsn = null;
        Database databaseToSet = null;
        this.reader.markCollection();
        int codePoint = this.reader.getCodePoint();
        while (codePoint != -1) {
            switch (codePoint) {
                case 8464: {
                    this.setDatabase(8205);
                    databaseToSet = this.database;
                    break;
                }
                case 8467: {
                    pkgnamcsn = this.parsePKGNAMCSN();
                    break;
                }
                case 8470: {
                    rtnsqlda = this.readBoolean(8470);
                    break;
                }
                case 8518: {
                    rtnOutput = this.parseTYPSQLDA();
                    break;
                }
                case 6400: {
                    this.parseMONITOR();
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
        DRDAStatement stmt = this.database.newDRDAStatement(pkgnamcsn);
        String sqlStmt = this.parsePRPSQLSTTobjects(stmt);
        if (databaseToSet != null) {
            stmt.setDatabase(this.database);
        }
        stmt.explicitPrepare(sqlStmt);
        this.database.setCurrentStatement(stmt);
        if (!rtnsqlda) {
            return 0;
        }
        if (rtnOutput) {
            return 2;
        }
        return 1;
    }

    private String parsePRPSQLSTTobjects(DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        String sqlStmt = null;
        do {
            this.correlationID = this.reader.readDssHeader();
            block7: while (this.reader.moreDssData()) {
                int codePoint = this.reader.readLengthAndCodePoint(false);
                switch (codePoint) {
                    case 9236: {
                        sqlStmt = this.parseEncodedString();
                        this.trace("sqlStmt = " + sqlStmt);
                        continue block7;
                    }
                    case 47: {
                        this.setStmtOrDbByteOrder(false, stmt, this.parseTYPDEFNAM());
                        continue block7;
                    }
                    case 53: {
                        this.parseTYPDEFOVR(stmt);
                        continue block7;
                    }
                    case 9296: {
                        this.parseSQLATTR(stmt);
                        continue block7;
                    }
                }
                this.invalidCodePoint(codePoint);
            }
        } while (this.reader.isChainedWithSameID());
        if (sqlStmt == null) {
            this.missingCodePoint(9236);
        }
        return sqlStmt;
    }

    private boolean parseTYPSQLDA() throws DRDAProtocolException {
        this.checkLength(8518, 1);
        byte sqldaType = this.reader.readByte();
        this.trace("typSQLDa " + sqldaType);
        if (sqldaType == 0 || sqldaType == 2 || sqldaType == 4) {
            return true;
        }
        if (sqldaType == 1 || sqldaType == 3 || sqldaType == 5) {
            return false;
        }
        this.invalidValue(8518);
        return false;
    }

    protected void parseSQLATTR(DRDAStatement stmt) throws DRDAProtocolException {
        String attrs = this.parseEncodedString();
        this.trace("sqlattr = '" + attrs + "'");
        boolean validAttribute = false;
        if (attrs.indexOf("INSENSITIVE SCROLL") != -1 || attrs.indexOf("SCROLL INSENSITIVE") != -1) {
            stmt.scrollType = 1004;
            stmt.concurType = 1007;
            validAttribute = true;
        }
        if (attrs.indexOf("SENSITIVE DYNAMIC SCROLL") != -1 || attrs.indexOf("SENSITIVE STATIC SCROLL") != -1) {
            stmt.scrollType = 1005;
            validAttribute = true;
        }
        if (attrs.indexOf("FOR UPDATE") != -1) {
            validAttribute = true;
            stmt.concurType = 1008;
        }
        if (attrs.indexOf("WITH HOLD") != -1) {
            stmt.withHoldCursor = 1;
            validAttribute = true;
        }
        if (!validAttribute) {
            this.invalidValue(9296);
        }
    }

    private boolean parseDSCSQLSTT() throws DRDAProtocolException, SQLException {
        boolean rtnOutput = true;
        Pkgnamcsn pkgnamcsn = null;
        this.reader.markCollection();
        int codePoint = this.reader.getCodePoint();
        while (codePoint != -1) {
            switch (codePoint) {
                case 8518: {
                    rtnOutput = this.parseTYPSQLDA();
                    break;
                }
                case 8464: {
                    this.setDatabase(8200);
                    break;
                }
                case 8467: {
                    pkgnamcsn = this.parsePKGNAMCSN();
                    DRDAStatement stmt = this.database.getDRDAStatement(pkgnamcsn);
                    if (stmt != null) break;
                    this.invalidValue(8467);
                    break;
                }
                case 6400: {
                    this.parseMONITOR();
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
        if (pkgnamcsn == null) {
            this.missingCodePoint(8467);
        }
        return rtnOutput;
    }

    private void parseEXCSQLSTT() throws DRDAProtocolException, SQLException {
        boolean sendSQLDTARD;
        boolean hasResultSet;
        boolean isProcedure;
        this.reader.markCollection();
        int codePoint = this.reader.getCodePoint();
        boolean outputExpected = false;
        Pkgnamcsn pkgnamcsn = null;
        int numRows = 1;
        int blkSize = 0;
        int maxrslcnt = 0;
        int maxblkext = 0;
        int qryrowset = -1;
        int outovropt = 1;
        byte[] rslsetflg = null;
        String procName = null;
        while (codePoint != -1) {
            switch (codePoint) {
                case 8464: {
                    this.setDatabase(8203);
                    break;
                }
                case 8467: {
                    pkgnamcsn = this.parsePKGNAMCSN();
                    break;
                }
                case 8465: {
                    outputExpected = this.readBoolean(8465);
                    this.trace("outexp = " + outputExpected);
                    break;
                }
                case 8506: {
                    this.checkLength(8506, 4);
                    numRows = this.reader.readNetworkInt();
                    this.trace("# of rows: " + numRows);
                    break;
                }
                case 8504: {
                    procName = this.reader.readString();
                    this.trace("Procedure Name = " + procName);
                    break;
                }
                case 8468: {
                    blkSize = this.parseQRYBLKSZ();
                    break;
                }
                case 8512: {
                    this.checkLength(8512, 2);
                    maxrslcnt = this.reader.readNetworkShort();
                    this.trace("max rs count: " + maxrslcnt);
                    break;
                }
                case 8513: {
                    this.checkLength(8513, 2);
                    maxblkext = this.reader.readNetworkShort();
                    this.trace("max extra blocks: " + maxblkext);
                    break;
                }
                case 8514: {
                    for (byte b : rslsetflg = this.reader.readBytes()) {
                        this.trace("rslsetflg: " + b);
                    }
                    break;
                }
                case 8453: {
                    this.parseRDBCMTOK();
                    break;
                }
                case 8519: {
                    outovropt = this.parseOUTOVROPT();
                    break;
                }
                case 8534: {
                    qryrowset = this.parseQRYROWSET(0);
                    break;
                }
                case 6400: {
                    this.parseMONITOR();
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
        if (pkgnamcsn == null) {
            this.missingCodePoint(8467);
        }
        boolean needPrepareCall = false;
        DRDAStatement stmt = this.database.getDRDAStatement(pkgnamcsn);
        boolean bl = isProcedure = procName != null || stmt != null && stmt.wasExplicitlyPrepared() && stmt.isCall;
        if (isProcedure) {
            if (stmt == null || !stmt.wasExplicitlyPrepared()) {
                stmt = this.database.newDRDAStatement(pkgnamcsn);
                stmt.setQryprctyp(9239);
                needPrepareCall = true;
            }
            stmt.procName = procName;
            stmt.outputExpected = outputExpected;
        } else {
            if (stmt == null) {
                this.invalidValue(8467);
            }
            stmt.setQryprctyp(9239);
        }
        stmt.nbrrow = numRows;
        stmt.qryrowset = qryrowset;
        stmt.blksize = blkSize;
        stmt.maxblkext = maxblkext;
        stmt.maxrslcnt = maxrslcnt;
        stmt.outovropt = outovropt;
        stmt.rslsetflg = rslsetflg;
        if (this.pendingStatementTimeout >= 0) {
            stmt.getPreparedStatement().setQueryTimeout(this.pendingStatementTimeout);
            this.pendingStatementTimeout = -1;
        }
        this.database.setCurrentStatement(stmt);
        if (this.reader.isChainedWithSameID()) {
            hasResultSet = this.parseEXCSQLSTTobjects(stmt);
        } else {
            if (isProcedure && needPrepareCall) {
                String prepareString = "call " + stmt.procName + "()";
                this.trace("$$$prepareCall is: " + prepareString);
                this.database.getConnection().clearWarnings();
                CallableStatement callableStatement = (CallableStatement)stmt.prepare(prepareString);
            }
            stmt.ps.clearWarnings();
            hasResultSet = stmt.execute();
        }
        ResultSet rs = null;
        if (hasResultSet) {
            rs = stmt.getResultSet();
        }
        hasResultSet = rs != null;
        int numResults = 0;
        if (hasResultSet) {
            numResults = stmt.getNumResultSets();
            this.writeRSLSETRM(stmt);
        }
        boolean bl2 = sendSQLDTARD = stmt.hasOutputParams() && outputExpected;
        if (isProcedure) {
            if (sendSQLDTARD) {
                this.writer.createDssObject();
                this.writer.startDdm(9235);
                this.writer.startDdm(16);
                this.writeQRYDSC(stmt, true);
                this.writer.endDdm();
                this.writer.startDdm(5242);
                this.writeFDODTA(stmt);
                this.writer.endDdm();
                this.writer.endDdmAndDss();
                if (stmt.getExtDtaObjects() != null) {
                    this.writeEXTDTA(stmt);
                }
            } else if (hasResultSet) {
                this.writeNullSQLCARDobject();
            }
        }
        stmt.finishParams();
        EnginePreparedStatement ps = stmt.getPreparedStatement();
        int rsNum = 0;
        do {
            if (hasResultSet) {
                stmt.setCurrentDrdaResultSet(rsNum);
                stmt.setQryrtndta(true);
                if (!isProcedure) {
                    this.checkWarning(null, ps, null, -1L, true, true);
                }
                if (rsNum == 0) {
                    this.writeSQLRSLRD(stmt);
                }
                this.writeOPNQRYRM(true, stmt);
                this.writeSQLCINRD(stmt);
                this.writeQRYDSC(stmt, false);
                stmt.rsSuspend();
                if (stmt.getQryprctyp() != 9239) continue;
                this.writeQRYDTA(stmt);
                continue;
            }
            if (sendSQLDTARD) continue;
            long updateCount = ps.getLargeUpdateCount();
            this.checkWarning(this.database.getConnection(), stmt.ps, null, updateCount, true, true);
        } while (hasResultSet && ++rsNum < numResults);
    }

    private void parseRDBCMTOK() throws DRDAProtocolException {
        boolean rdbcmtok = this.readBoolean(8453);
        this.trace("rdbcmtok = " + rdbcmtok);
    }

    private boolean parseEXCSQLSTTobjects(DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        boolean gotSQLDTA = false;
        boolean gotEXTDTA = false;
        boolean result = false;
        do {
            this.correlationID = this.reader.readDssHeader();
            block8: while (this.reader.moreDssData()) {
                int codePoint = this.reader.readLengthAndCodePoint(true);
                switch (codePoint) {
                    case 47: {
                        this.setStmtOrDbByteOrder(false, stmt, this.parseTYPDEFNAM());
                        stmt.setTypDefValues();
                        continue block8;
                    }
                    case 53: {
                        this.parseTYPDEFOVR(stmt);
                        stmt.setTypDefValues();
                        continue block8;
                    }
                    case 9234: {
                        this.parseSQLDTA(stmt);
                        gotSQLDTA = true;
                        continue block8;
                    }
                    case 5228: {
                        this.readAndSetAllExtParams(stmt, true);
                        stmt.ps.clearWarnings();
                        result = stmt.execute();
                        gotEXTDTA = true;
                        continue block8;
                    }
                    case 9237: {
                        this.parseOUTOVR(stmt);
                        continue block8;
                    }
                }
                this.invalidCodePoint(codePoint);
            }
        } while (this.reader.isChainedWithSameID());
        if (!gotSQLDTA) {
            this.missingCodePoint(9234);
        }
        if (!gotEXTDTA) {
            stmt.ps.clearWarnings();
            result = stmt.execute();
        }
        return result;
    }

    private void writeSQLCINRD(DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        ResultSet rs = stmt.getResultSet();
        this.writer.createDssObject();
        this.writer.startDdm(9227);
        if (this.sqlamLevel >= 7) {
            this.writeSQLDHROW(rs.getHoldability());
        }
        ResultSetMetaData rsmeta = rs.getMetaData();
        int ncols = rsmeta.getColumnCount();
        this.writer.writeShort(ncols);
        if (this.sqlamLevel >= 7) {
            for (int i = 0; i < ncols; ++i) {
                this.writeSQLDAGRP(rsmeta, null, i, true);
            }
        } else {
            for (int i = 0; i < ncols; ++i) {
                this.writeVCMorVCS(rsmeta.getColumnName(i + 1));
                this.writeVCMorVCS(rsmeta.getColumnLabel(i + 1));
                this.writeVCMorVCS(null);
            }
        }
        this.writer.endDdmAndDss();
    }

    private void writeSQLRSLRD(DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        int numResults = stmt.getNumResultSets();
        this.writer.createDssObject();
        this.writer.startDdm(9230);
        this.writer.writeShort(numResults);
        for (int i = 0; i < numResults; ++i) {
            this.writer.writeInt(i);
            this.writeVCMorVCS(stmt.getResultSetCursorName(i));
            this.writer.writeInt(1);
        }
        this.writer.endDdmAndDss();
    }

    private void writeRSLSETRM(DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        int numResults = stmt.getNumResultSets();
        this.writer.createDssReply();
        this.writer.startDdm(8729);
        this.writer.writeScalar2Bytes(4425, 0);
        this.writer.startDdm(8505);
        for (int i = 0; i < numResults; ++i) {
            this.writePKGNAMCSN(stmt.getResultSetPkgcnstkn(i).getBytes());
        }
        this.writer.endDdm();
        this.writer.endDdmAndDss();
    }

    private void parseSQLDTA(DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        try {
            this.parseSQLDTA_work(stmt);
        }
        catch (SQLException se) {
            this.skipRemainder(true);
            throw se;
        }
    }

    private void parseSQLDTA_work(DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        EnginePreparedStatement ps = stmt.getPreparedStatement();
        ParameterMetaData pmeta = null;
        stmt.clearDrdaParams();
        int numVars = 0;
        boolean rtnParam = false;
        this.reader.markCollection();
        int codePoint = this.reader.getCodePoint();
        while (codePoint != -1) {
            switch (codePoint) {
                case 16: {
                    while (this.reader.getDdmLength() > 6L) {
                        int dtaGrpLen = this.reader.readUnsignedByte();
                        int numVarsInGrp = (dtaGrpLen - 3) / 3;
                        this.trace("num of vars in this group is: " + numVarsInGrp);
                        this.reader.readByte();
                        this.reader.readByte();
                        for (int j = 0; j < numVarsInGrp; ++j) {
                            byte t = this.reader.readByte();
                            this.trace("drdaType is: 0x" + Integer.toHexString(t));
                            int drdaLength = this.reader.readNetworkShort();
                            this.trace("drdaLength is: " + drdaLength);
                            stmt.addDrdaParam(t, drdaLength);
                        }
                    }
                    numVars = stmt.getDrdaParamCount();
                    this.trace("numVars = " + numVars);
                    if (ps == null) {
                        StringBuilder marks = new StringBuilder();
                        marks.append("(?");
                        for (int i = 1; i < numVars; ++i) {
                            marks.append(", ?");
                        }
                        String prepareString = "call " + stmt.procName + marks.toString() + ")";
                        this.trace("$$ prepareCall is: " + prepareString);
                        CallableStatement cs = null;
                        try {
                            cs = (CallableStatement)stmt.prepare(prepareString);
                            stmt.registerAllOutParams();
                        }
                        catch (SQLException se) {
                            if (!stmt.outputExpected || !se.getSQLState().equals("42X50")) {
                                throw se;
                            }
                            this.trace("****** second try with return parameter...");
                            prepareString = numVars == 1 ? "? = call " + stmt.procName + "()" : "? = call " + stmt.procName + "(" + marks.substring(3) + ")";
                            this.trace("$$ prepareCall is: " + prepareString);
                            try {
                                cs = (CallableStatement)stmt.prepare(prepareString);
                            }
                            catch (SQLException se2) {
                                throw se;
                            }
                            rtnParam = true;
                        }
                        stmt.ps = ps = (EnginePreparedStatement)((Object)cs);
                    }
                    pmeta = stmt.getParameterMetaData();
                    this.reader.readBytes(6);
                    break;
                }
                case 5242: {
                    this.reader.readByte();
                    for (int i = 0; i < numVars; ++i) {
                        int nullData;
                        if ((stmt.getParamDRDAType(i + 1) & 1) == 1 && ((nullData = this.reader.readUnsignedByte()) & 0xFF) == 255) {
                            this.trace("******param null");
                            if (pmeta.getParameterMode(i + 1) != 4) {
                                ps.setNull(i + 1, pmeta.getParameterType(i + 1));
                            }
                            if (!stmt.isOutputParam(i + 1)) continue;
                            stmt.registerOutParam(i + 1);
                            continue;
                        }
                        this.readAndSetParams(i, stmt, pmeta);
                    }
                    break;
                }
                case 5228: {
                    this.readAndSetAllExtParams(stmt, false);
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
    }

    private int getByteOrder() {
        DRDAStatement stmt = this.database.getCurrentStatement();
        return stmt != null && stmt.typDefNam != null ? stmt.byteOrder : this.database.byteOrder;
    }

    private Calendar getGMTCalendar() {
        if (this.gmtCalendar == null) {
            TimeZone gmt = TimeZone.getTimeZone("GMT");
            this.gmtCalendar = Calendar.getInstance(gmt);
        }
        return this.gmtCalendar;
    }

    private void readAndSetParams(int i, DRDAStatement stmt, ParameterMetaData pmeta) throws DRDAProtocolException, SQLException {
        EnginePreparedStatement ps = stmt.getPreparedStatement();
        int drdaType = (stmt.getParamDRDAType(i + 1) | 1) & 0xFF;
        int paramLenNumBytes = stmt.getParamLen(i + 1);
        if (ps instanceof CallableStatement && stmt.isOutputParam(i + 1)) {
            CallableStatement cs = (CallableStatement)((Object)ps);
            cs.registerOutParameter(i + 1, stmt.getOutputParamType(i + 1));
        }
        switch (drdaType) {
            case 191: {
                boolean paramVal = this.reader.readByte() == 1;
                this.trace("boolean parameter value is: " + paramVal);
                ps.setBoolean(i + 1, paramVal);
                break;
            }
            case 5: {
                short paramVal = this.reader.readShort(this.getByteOrder());
                this.trace("short parameter value is: " + paramVal);
                ps.setShort(i + 1, paramVal);
                break;
            }
            case 3: {
                int paramVal = this.reader.readInt(this.getByteOrder());
                this.trace("integer parameter value is: " + paramVal);
                ps.setInt(i + 1, paramVal);
                break;
            }
            case 23: {
                long paramVal = this.reader.readLong(this.getByteOrder());
                this.trace("parameter value is: " + paramVal);
                ps.setLong(i + 1, paramVal);
                break;
            }
            case 13: {
                float paramVal = this.reader.readFloat(this.getByteOrder());
                this.trace("parameter value is: " + paramVal);
                ps.setFloat(i + 1, paramVal);
                break;
            }
            case 11: {
                double paramVal = this.reader.readDouble(this.getByteOrder());
                this.trace("nfloat8 parameter value is: " + paramVal);
                ps.setDouble(i + 1, paramVal);
                break;
            }
            case 15: {
                int precision = paramLenNumBytes >> 8 & 0xFF;
                int scale = paramLenNumBytes & 0xFF;
                BigDecimal paramVal = this.reader.readBigDecimal(precision, scale);
                this.trace("ndecimal parameter value is: " + String.valueOf(paramVal));
                ps.setBigDecimal(i + 1, paramVal);
                break;
            }
            case 33: {
                Object paramVal = this.reader.readStringData(10).trim();
                this.trace("ndate parameter value is: \"" + (String)paramVal + "\"");
                try {
                    Calendar cal = this.getGMTCalendar();
                    ps.setDate(i + 1, this.parseDate((String)paramVal, cal), cal);
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new SQLException("22007.S.181", "22007.S.181".substring(0, 5));
                }
            }
            case 35: {
                Object paramVal = this.reader.readStringData(8).trim();
                this.trace("ntime parameter value is: " + (String)paramVal);
                try {
                    Calendar cal = this.getGMTCalendar();
                    ps.setTime(i + 1, this.parseTime((String)paramVal, cal), cal);
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new SQLException("22007.S.181", "22007.S.181".substring(0, 5));
                }
            }
            case 37: {
                int timestampLength = this.appRequester.getTimestampLength();
                String paramVal = this.reader.readStringData(timestampLength).trim();
                this.trace("ntimestamp parameter value is: " + paramVal);
                try {
                    Calendar cal = this.getGMTCalendar();
                    ps.setTimestamp(i + 1, this.parseTimestamp(paramVal, cal), cal);
                    break;
                }
                catch (IllegalArgumentException e1) {
                    throw new SQLException("22007.S.181", "22007.S.181".substring(0, 5));
                }
            }
            case 49: 
            case 51: 
            case 53: 
            case 63: 
            case 65: {
                Object paramVal = this.reader.readLDStringData(stmt.ccsidMBCEncoding);
                this.trace("char/varchar parameter value is: " + (String)paramVal);
                ps.setString(i + 1, (String)paramVal);
                break;
            }
            case 39: {
                Object paramVal = this.reader.readBytes();
                this.trace("fix bytes parameter value is: " + this.convertToHexString((byte[])paramVal));
                ps.setBytes(i + 1, (byte[])paramVal);
                break;
            }
            case 41: 
            case 43: {
                int length = this.reader.readNetworkShort();
                this.trace("===== binary param length is: " + length);
                byte[] paramVal = this.reader.readBytes(length);
                ps.setBytes(i + 1, paramVal);
                break;
            }
            case 81: {
                Object paramVal = this.readUDT();
                ps.setObject(i + 1, paramVal);
                break;
            }
            case 201: 
            case 203: 
            case 205: 
            case 207: {
                long length = this.readLobLength(paramLenNumBytes);
                if (length != 0L) {
                    stmt.addExtPosition(i);
                    break;
                }
                if (drdaType == 201) {
                    ps.setBytes(i + 1, new byte[0]);
                    break;
                }
                ps.setString(i + 1, "");
                break;
            }
            case 25: {
                int paramVal = this.reader.readInt(this.getByteOrder());
                this.trace("locator value is: " + paramVal);
                Blob blobFromLocator = (Blob)this.database.getConnection().getLOBMapping(paramVal);
                ps.setBlob(i + 1, blobFromLocator);
                break;
            }
            case 27: {
                int paramVal = this.reader.readInt(this.getByteOrder());
                this.trace("locator value is: " + paramVal);
                Clob clobFromLocator = (Clob)this.database.getConnection().getLOBMapping(paramVal);
                ps.setClob(i + 1, clobFromLocator);
                break;
            }
            default: {
                Object paramVal = this.reader.readLDStringData(stmt.ccsidMBCEncoding);
                this.trace("default type parameter value is: " + (String)paramVal);
                ps.setObject(i + 1, paramVal);
            }
        }
    }

    private Object readUDT() throws DRDAProtocolException {
        int length = this.reader.readNetworkShort();
        this.trace("===== udt param length is: " + length);
        byte[] bytes = this.reader.readBytes(length);
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            return ois.readObject();
        }
        catch (Exception e) {
            this.markCommunicationsFailure(e, "DRDAConnThread.readUDT()", "", e.getMessage(), "*");
            return null;
        }
    }

    private long readLobLength(int extLenIndicator) throws DRDAProtocolException {
        switch (extLenIndicator) {
            case 32770: {
                return this.reader.readNetworkShort();
            }
            case 32772: {
                return this.reader.readNetworkInt();
            }
            case 32774: {
                return this.reader.readNetworkSixByteLong();
            }
            case 32776: {
                return this.reader.readNetworkLong();
            }
        }
        this.throwSyntaxrm(12, extLenIndicator);
        return 0L;
    }

    private java.sql.Date parseDate(String dateString, Calendar cal) {
        String[] components = dateString.split("-");
        if (components.length != 3) {
            throw new IllegalArgumentException();
        }
        cal.clear();
        cal.set(1, Integer.parseInt(components[0]));
        cal.set(2, Integer.parseInt(components[1]) - 1);
        cal.set(5, Integer.parseInt(components[2]));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new java.sql.Date(cal.getTimeInMillis());
    }

    private Time parseTime(String timeString, Calendar cal) {
        String[] components = timeString.split(":");
        if (components.length != 3) {
            throw new IllegalArgumentException();
        }
        cal.clear();
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, Integer.parseInt(components[0]));
        cal.set(12, Integer.parseInt(components[1]));
        cal.set(13, Integer.parseInt(components[2]));
        cal.set(14, 0);
        return new Time(cal.getTimeInMillis());
    }

    private Timestamp parseTimestamp(String timeString, Calendar cal) {
        String[] components = timeString.split("[-.]");
        if (components.length != 7) {
            throw new IllegalArgumentException();
        }
        cal.clear();
        cal.set(1, Integer.parseInt(components[0]));
        cal.set(2, Integer.parseInt(components[1]) - 1);
        cal.set(5, Integer.parseInt(components[2]));
        cal.set(11, Integer.parseInt(components[3]));
        cal.set(12, Integer.parseInt(components[4]));
        cal.set(13, Integer.parseInt(components[5]));
        int nanos = 0;
        int radix = 10;
        String nanoString = components[6];
        for (int i = 0; i < 9; ++i) {
            nanos *= 10;
            if (i >= nanoString.length()) continue;
            int digit = Character.digit(nanoString.charAt(i), 10);
            if (digit == -1) {
                throw new IllegalArgumentException();
            }
            nanos += digit;
        }
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        ts.setNanos(nanos);
        return ts;
    }

    private void readAndSetAllExtParams(DRDAStatement stmt, boolean streamLOB) throws SQLException, DRDAProtocolException {
        int numExt = stmt.getExtPositionCount();
        for (int i = 0; i < numExt; ++i) {
            int paramPos = stmt.getExtPosition(i);
            boolean doStreamLOB = streamLOB && i == numExt - 1;
            this.readAndSetExtParam(paramPos, stmt, stmt.getParamDRDAType(paramPos + 1), stmt.getParamLen(paramPos + 1), doStreamLOB);
            if (i >= numExt - 1) continue;
            this.correlationID = this.reader.readDssHeader();
            int n = this.reader.readLengthAndCodePoint(true);
        }
    }

    private void readAndSetExtParam(int i, DRDAStatement stmt, int drdaType, int extLen, boolean streamLOB) throws DRDAProtocolException, SQLException {
        boolean checkNullability = false;
        if (this.sqlamLevel >= 7 && FdocaConstants.isNullable(drdaType &= 0xFF)) {
            checkNullability = true;
        }
        EXTDTAReaderInputStream stream = this.reader.getEXTDTAReaderInputStream(checkNullability);
        String encoding = "na";
        switch (drdaType) {
            case 202: 
            case 203: {
                encoding = stmt.ccsidSBCEncoding;
                break;
            }
            case 204: 
            case 205: {
                encoding = stmt.ccsidDBCEncoding;
                break;
            }
            case 206: 
            case 207: {
                encoding = stmt.ccsidMBCEncoding;
            }
        }
        this.traceEXTDTARead(drdaType, i + 1, stream, streamLOB, encoding);
        try {
            switch (drdaType) {
                case 200: 
                case 201: {
                    DRDAConnThread.setAsBinaryStream(stmt, i + 1, stream, streamLOB);
                    break;
                }
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: {
                    DRDAConnThread.setAsCharacterStream(stmt, i + 1, stream, streamLOB, encoding);
                    break;
                }
                default: {
                    this.invalidValue(drdaType);
                    break;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException(e.getMessage());
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
    }

    private long parseEXCSQLIMM() throws DRDAProtocolException, SQLException {
        this.reader.markCollection();
        Pkgnamcsn pkgnamcsn = null;
        int codePoint = this.reader.getCodePoint();
        while (codePoint != -1) {
            switch (codePoint) {
                case 8464: {
                    this.setDatabase(8202);
                    break;
                }
                case 8467: {
                    pkgnamcsn = this.parsePKGNAMCSN();
                    break;
                }
                case 8453: {
                    this.parseRDBCMTOK();
                    break;
                }
                case 6400: {
                    this.parseMONITOR();
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
        DRDAStatement drdaStmt = this.database.getDefaultStatement(pkgnamcsn);
        drdaStmt.initialize();
        String sqlStmt = this.parseEXECSQLIMMobjects();
        EngineStatement statement = drdaStmt.getStatement();
        statement.clearWarnings();
        if (this.pendingStatementTimeout >= 0) {
            statement.setQueryTimeout(this.pendingStatementTimeout);
            this.pendingStatementTimeout = -1;
        }
        long updCount = statement.executeLargeUpdate(sqlStmt);
        return updCount;
    }

    private boolean parseEXCSQLSET() throws DRDAProtocolException, SQLException {
        this.reader.markCollection();
        int codePoint = this.reader.getCodePoint();
        while (codePoint != -1) {
            switch (codePoint) {
                case 8464: {
                    this.setDatabase(8212);
                    break;
                }
                case 8466: {
                    String pkgnamct = this.parsePKGNAMCT();
                    break;
                }
                case 6400: {
                    this.parseMONITOR();
                    break;
                }
                case 8467: {
                    Pkgnamcsn pkgnamcsn = this.parsePKGNAMCSN();
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
        this.parseEXCSQLSETobjects();
        return true;
    }

    private String parseEXECSQLIMMobjects() throws DRDAProtocolException, SQLException {
        String sqlStmt = null;
        DRDAStatement stmt = this.database.getDefaultStatement();
        do {
            this.correlationID = this.reader.readDssHeader();
            block6: while (this.reader.moreDssData()) {
                int codePoint = this.reader.readLengthAndCodePoint(false);
                switch (codePoint) {
                    case 47: {
                        this.setStmtOrDbByteOrder(false, stmt, this.parseTYPDEFNAM());
                        continue block6;
                    }
                    case 53: {
                        this.parseTYPDEFOVR(stmt);
                        continue block6;
                    }
                    case 9236: {
                        sqlStmt = this.parseEncodedString();
                        this.trace("sqlStmt = " + sqlStmt);
                        continue block6;
                    }
                }
                this.invalidCodePoint(codePoint);
            }
        } while (this.reader.isChainedWithSameID());
        if (sqlStmt == null) {
            this.missingCodePoint(9236);
        }
        return sqlStmt;
    }

    private void parseEXCSQLSETobjects() throws DRDAProtocolException, SQLException {
        boolean gotSqlStt = false;
        boolean hadUnrecognizedStmt = false;
        DRDAStatement drdaStmt = this.database.getDefaultStatement();
        drdaStmt.initialize();
        do {
            this.correlationID = this.reader.readDssHeader();
            while (this.reader.moreDssData()) {
                int codePoint = this.reader.readLengthAndCodePoint(false);
                switch (codePoint) {
                    case 47: {
                        this.setStmtOrDbByteOrder(false, drdaStmt, this.parseTYPDEFNAM());
                        break;
                    }
                    case 53: {
                        this.parseTYPDEFOVR(drdaStmt);
                        break;
                    }
                    case 9236: {
                        String sqlStmt = this.parseEncodedString();
                        if (sqlStmt != null) {
                            gotSqlStt = true;
                        }
                        if (sqlStmt.startsWith(TIMEOUT_STATEMENT)) {
                            String timeoutString = sqlStmt.substring(TIMEOUT_STATEMENT.length());
                            this.pendingStatementTimeout = Integer.parseInt(timeoutString);
                            break;
                        }
                        if (this.canIgnoreStmt(sqlStmt)) break;
                        this.trace("sqlStmt = " + sqlStmt);
                        drdaStmt.initialize();
                        drdaStmt.getStatement().clearWarnings();
                        try {
                            drdaStmt.getStatement().executeUpdate(sqlStmt);
                            break;
                        }
                        catch (SQLException e) {
                            if (e.getSQLState().equals(SYNTAX_ERR)) {
                                hadUnrecognizedStmt = true;
                                break;
                            }
                            throw e;
                        }
                    }
                    default: {
                        this.invalidCodePoint(codePoint);
                    }
                }
            }
        } while (this.reader.isChainedWithSameID());
        if (!gotSqlStt) {
            this.missingCodePoint(9236);
        }
        if (hadUnrecognizedStmt) {
            SQLWarning warn = new SQLWarning("One or more SET statements not recognized.", "01000");
            throw warn;
        }
    }

    private boolean canIgnoreStmt(String stmt) {
        return stmt.indexOf("SET CLIENT") != -1;
    }

    private void writeRDBUPDRM() throws DRDAProtocolException {
        this.database.RDBUPDRM_sent = true;
        this.writer.createDssReply();
        this.writer.startDdm(8728);
        this.writer.writeScalar2Bytes(4425, 0);
        this.writeRDBNAM(this.database.getDatabaseName());
        this.writer.endDdmAndDss();
    }

    private String parsePKGNAMCT() throws DRDAProtocolException {
        this.reader.skipBytes();
        return null;
    }

    private Pkgnamcsn parsePKGNAMCSN() throws DRDAProtocolException {
        if (this.reader.getDdmLength() == 64L) {
            this.reader.readString(this.rdbnam, 18, true);
            this.trace("rdbnam = " + String.valueOf(this.rdbnam));
            if (this.appRequester.greaterThanOrEqualTo(10, 3, 0) && !this.rdbnam.toString().equals(this.database.getDatabaseName())) {
                this.rdbnamMismatch(8467);
            }
            this.reader.readString(this.rdbcolid, 18, true);
            this.trace("rdbcolid = " + String.valueOf(this.rdbcolid));
            this.reader.readString(this.pkgid, 18, true);
            this.trace("pkgid = " + String.valueOf(this.pkgid));
            this.reader.readString(this.pkgcnstkn, 8, false);
            this.trace("pkgcnstkn = " + String.valueOf(this.pkgcnstkn));
            this.pkgsn = this.reader.readNetworkShort();
            this.trace("pkgsn = " + this.pkgsn);
        } else {
            int length = this.reader.readNetworkShort();
            if (length < 18 || length > 1024) {
                this.badObjectLength(8464);
            }
            this.reader.readString(this.rdbnam, length, true);
            this.trace("rdbnam = " + String.valueOf(this.rdbnam));
            if ((this.appRequester.getClientType() != 3 || this.appRequester.greaterThanOrEqualTo(10, 3, 0)) && !this.rdbnam.toString().equals(this.database.getDatabaseName())) {
                this.rdbnamMismatch(8467);
            }
            length = this.reader.readNetworkShort();
            this.reader.readString(this.rdbcolid, length, true);
            this.trace("rdbcolid = " + String.valueOf(this.rdbcolid));
            length = this.reader.readNetworkShort();
            if (length != 18) {
                this.badObjectLength(8457);
            }
            this.reader.readString(this.pkgid, 18, true);
            this.trace("pkgid = " + String.valueOf(this.pkgid));
            this.reader.readString(this.pkgcnstkn, 8, false);
            this.trace("pkgcnstkn = " + String.valueOf(this.pkgcnstkn));
            this.pkgsn = this.reader.readNetworkShort();
            this.trace("pkgsn = " + this.pkgsn);
        }
        if (this.prevPkgnamcsn == null || this.rdbnam.wasModified() || this.rdbcolid.wasModified() || this.pkgid.wasModified() || this.pkgcnstkn.wasModified() || this.prevPkgnamcsn.getPkgsn() != this.pkgsn) {
            byte[] token = new byte[this.pkgcnstkn.length()];
            System.arraycopy(this.pkgcnstkn.getBytes(), 0, token, 0, token.length);
            this.prevPkgnamcsn = new Pkgnamcsn(this.rdbnam.toString(), this.rdbcolid.toString(), this.pkgid.toString(), this.pkgsn, new ConsistencyToken(token));
        }
        return this.prevPkgnamcsn;
    }

    private String parseSQLSTTDss() throws DRDAProtocolException {
        this.correlationID = this.reader.readDssHeader();
        int codePoint = this.reader.readLengthAndCodePoint(false);
        String strVal = this.parseEncodedString();
        this.trace("SQL Statement = " + strVal);
        return strVal;
    }

    private String parseEncodedString() throws DRDAProtocolException {
        return this.sqlamLevel < 7 ? this.parseVCMorVCS() : this.parseNOCMorNOCS();
    }

    private String parseVCMorVCS() throws DRDAProtocolException {
        int vcs_length;
        String strVal = null;
        int vcm_length = this.reader.readNetworkShort();
        if (vcm_length > 0) {
            strVal = this.parseCcsidMBC(vcm_length);
        }
        if ((vcs_length = this.reader.readNetworkShort()) > 0) {
            if (strVal != null) {
                this.agentError("Both VCM and VCS have lengths > 0");
            }
            strVal = this.parseCcsidSBC(vcs_length);
        }
        return strVal;
    }

    private String parseNOCMorNOCS() throws DRDAProtocolException {
        byte nocs_nullByte;
        int length;
        byte nocm_nullByte = this.reader.readByte();
        String strVal = null;
        if (nocm_nullByte != -1) {
            length = this.reader.readNetworkInt();
            strVal = this.parseCcsidMBC(length);
        }
        if ((nocs_nullByte = this.reader.readByte()) != -1) {
            if (strVal != null) {
                this.agentError("Both CM and CS are non null");
            }
            length = this.reader.readNetworkInt();
            strVal = this.parseCcsidSBC(length);
        }
        return strVal;
    }

    private String parseCcsidMBC(int length) throws DRDAProtocolException {
        String strVal = null;
        DRDAStatement currentStatement = this.database.getCurrentStatement();
        if (currentStatement == null) {
            currentStatement = this.database.getDefaultStatement();
            currentStatement.initialize();
        }
        String ccsidMBCEncoding = currentStatement.ccsidMBCEncoding;
        if (length == 0) {
            return "";
        }
        byte[] byteStr = this.reader.readBytes(length);
        if (ccsidMBCEncoding != null) {
            try {
                strVal = new String(byteStr, 0, length, ccsidMBCEncoding);
            }
            catch (UnsupportedEncodingException e) {
                this.agentError("Unsupported encoding " + ccsidMBCEncoding + "in parseCcsidMBC");
            }
        } else {
            this.agentError("Attempt to decode mixed byte string without CCSID being set");
        }
        return strVal;
    }

    private String parseCcsidSBC(int length) throws DRDAProtocolException {
        String strVal = null;
        DRDAStatement currentStatement = this.database.getCurrentStatement();
        if (currentStatement == null) {
            currentStatement = this.database.getDefaultStatement();
            currentStatement.initialize();
        }
        String ccsidSBCEncoding = currentStatement.ccsidSBCEncoding;
        System.out.println("ccsidSBCEncoding - " + ccsidSBCEncoding);
        if (length == 0) {
            return null;
        }
        byte[] byteStr = this.reader.readBytes(length);
        if (ccsidSBCEncoding != null) {
            try {
                strVal = new String(byteStr, 0, length, ccsidSBCEncoding);
            }
            catch (UnsupportedEncodingException e) {
                this.agentError("Unsupported encoding " + ccsidSBCEncoding + "in parseCcsidSBC");
            }
        } else {
            this.agentError("Attempt to decode single byte string without CCSID being set");
        }
        return strVal;
    }

    private DRDAStatement parseCLSQRY() throws DRDAProtocolException, SQLException {
        DRDAStatement stmt;
        Pkgnamcsn pkgnamcsn = null;
        this.reader.markCollection();
        long qryinsid = 0L;
        boolean gotQryinsid = false;
        int codePoint = this.reader.getCodePoint();
        while (codePoint != -1) {
            switch (codePoint) {
                case 8464: {
                    this.setDatabase(8197);
                    break;
                }
                case 8467: {
                    pkgnamcsn = this.parsePKGNAMCSN();
                    break;
                }
                case 8539: {
                    qryinsid = this.reader.readNetworkLong();
                    gotQryinsid = true;
                    break;
                }
                case 6400: {
                    this.parseMONITOR();
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
        if (pkgnamcsn == null) {
            this.missingCodePoint(8467);
        }
        if (this.sqlamLevel >= 7 && !gotQryinsid) {
            this.missingCodePoint(8539);
        }
        if ((stmt = this.database.getDRDAStatement(pkgnamcsn)) == null) {
            this.invalidValue(8467);
        }
        if (stmt.wasExplicitlyClosed()) {
            // empty if block
        }
        stmt.CLSQRY();
        return stmt;
    }

    private void parseMONITOR() throws DRDAProtocolException {
        this.reader.skipBytes();
    }

    private void writeSQLCARDs(SQLException e, long updateCount) throws DRDAProtocolException {
        this.writeSQLCARDs(e, updateCount, false);
    }

    private void writeSQLCARDs(SQLException e, long updateCount, boolean sendSQLERRRM) throws DRDAProtocolException {
        if (e == null) {
            this.writeSQLCARD(e, updateCount, 0L);
            return;
        }
        int severity = this.getExceptionSeverity(e);
        if (severity > 8) {
            this.writeCMDCHKRM(severity);
        } else if (sendSQLERRRM) {
            this.writeSQLERRRM(severity);
        }
        this.writeSQLCARD(e, updateCount, 0L);
    }

    private int getSqlCode(SQLException e) {
        if (e == null) {
            return 0;
        }
        if (e instanceof SQLWarning && !"22001".equals(e.getSQLState())) {
            return 10000;
        }
        int severity = Math.max(0, e.getErrorCode());
        return -severity - 1;
    }

    private void writeSQLCARD(SQLException e, long updateCount, long rowCount) throws DRDAProtocolException {
        String sqlState;
        this.writer.createDssObject();
        this.writer.startDdm(9224);
        this.writeSQLCAGRP(e, updateCount, rowCount);
        this.writer.endDdmAndDss();
        if (e != null && (sqlState = e.getSQLState()).regionMatches(0, "XJ015.M", 0, 5)) {
            try {
                this.server.startNetworkServer();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void writeNullSQLCARDobject() throws DRDAProtocolException {
        this.writer.createDssObject();
        this.writer.startDdm(9224);
        this.writeSQLCAGRP(nullSQLState, 0, 0L, 0L);
        this.writer.endDdmAndDss();
    }

    private void writeSQLERRRM(int severity) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(8723);
        this.writer.writeScalar2Bytes(4425, severity);
        this.writer.endDdmAndDss();
    }

    private void writeCMDCHKRM(int severity) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(4692);
        this.writer.writeScalar2Bytes(4425, severity);
        this.writer.endDdmAndDss();
    }

    private int getExceptionSeverity(SQLException e) {
        int severity = 0;
        if (e == null) {
            return severity;
        }
        int ec = e.getErrorCode();
        switch (ec) {
            case 20000: 
            case 30000: {
                severity = 8;
                break;
            }
            case 10000: {
                severity = 4;
                break;
            }
            case 40000: 
            case 45000: 
            case 50000: {
                severity = 128;
                break;
            }
            default: {
                String sqlState = e.getSQLState();
                severity = sqlState != null && sqlState.startsWith("01") ? 4 : 8;
            }
        }
        return severity;
    }

    private void writeSQLCAGRP(SQLException e, long updateCount, long rowCount) throws DRDAProtocolException {
        int sqlcode = this.getSqlCode(e);
        if (e == null) {
            this.writeSQLCAGRP(nullSQLState, sqlcode, updateCount, rowCount);
            return;
        }
        if (rowCount < 0L && updateCount < 0L) {
            this.writer.writeByte(255);
            return;
        }
        if (this.server.debugOutput() && sqlcode < 0) {
            this.trace("handle SQLException here");
            this.trace("reason is: " + e.getMessage());
            this.trace("SQLState is: " + e.getSQLState());
            this.trace("vendorCode is: " + e.getErrorCode());
            this.trace("nextException is: " + String.valueOf(e.getNextException()));
            this.server.consoleExceptionPrint(e);
            this.trace("wrapping SQLException into SQLCARD...");
        }
        this.writer.writeByte(0);
        this.writer.writeInt(sqlcode);
        this.writer.writeString(e.getSQLState());
        this.writer.writeBytes(DRDAConnThread.getProductIDBytes());
        this.writeSQLCAXGRP(updateCount, rowCount, this.buildSqlerrmc(e), e.getNextException());
    }

    private void writeSQLCAGRP(byte[] sqlState, int sqlcode, long updateCount, long rowCount) throws DRDAProtocolException {
        if (rowCount < 0L && updateCount < 0L) {
            this.writer.writeByte(255);
            return;
        }
        this.writer.writeByte(0);
        this.writer.writeInt(sqlcode);
        this.writer.writeBytes(sqlState);
        this.writer.writeBytes(DRDAConnThread.getProductIDBytes());
        this.writeSQLCAXGRP(updateCount, rowCount, null, null);
    }

    private String buildSqlerrmc(SQLException se) {
        int maxlen;
        boolean severe = se.getErrorCode() >= 40000;
        StandardException ferry = StandardException.getArgumentFerry(se);
        String sqlerrmc = se instanceof DataTruncation ? this.buildDataTruncationSqlerrmc((DataTruncation)se) : (ferry != null && !severe ? this.buildTokenizedSqlerrmc(se) : this.buildPreformattedSqlerrmc(se));
        int n = maxlen = sqlerrmc == null ? -1 : Math.min(sqlerrmc.length(), this.appRequester.supportedMessageParamLength());
        if (maxlen >= 0 && sqlerrmc.length() > maxlen) {
            sqlerrmc = sqlerrmc.substring(0, maxlen);
        }
        return sqlerrmc;
    }

    private String buildPreformattedSqlerrmc(SQLException se) {
        if (se == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(se.getLocalizedMessage());
        while ((se = se.getNextException()) != null) {
            sb.append(SQLERRMC_PREFORMATTED_MESSAGE_DELIMITER);
            sb.append("SQLSTATE: ");
            sb.append(se.getSQLState());
        }
        return sb.toString();
    }

    private String buildTokenizedSqlerrmc(SQLException se) {
        Object sqlerrmc = "";
        do {
            StandardException ferry;
            if ((ferry = StandardException.getArgumentFerry(se)) != null) {
                sqlerrmc = (String)sqlerrmc + MessageUtils.encodeMessageAndArgumentsAsSqlerrmc(ferry.getMessageId(), ferry.getArguments());
                se = se.getNextException();
            } else {
                sqlerrmc = (String)sqlerrmc + MessageUtils.encodeExceptionAsSqlerrmc(se);
                se = se.getNextException();
            }
            if (se == null) continue;
            sqlerrmc = (String)sqlerrmc + MessageUtils.SQLERRMC_MESSAGE_DELIMITER + se.getSQLState() + ":";
        } while (se != null);
        return sqlerrmc;
    }

    private String buildDataTruncationSqlerrmc(DataTruncation dt) {
        return dt.getIndex() + SQLERRMC_TOKEN_DELIMITER + dt.getParameter() + SQLERRMC_TOKEN_DELIMITER + dt.getRead() + SQLERRMC_TOKEN_DELIMITER + dt.getDataSize() + SQLERRMC_TOKEN_DELIMITER + dt.getTransferSize();
    }

    private void writeSQLCAXGRP(long updateCount, long rowCount, String sqlerrmc, SQLException nextException) throws DRDAProtocolException {
        this.writer.writeByte(0);
        if (this.sqlamLevel < 7) {
            this.writeRDBNAM(this.database.getDatabaseName());
            this.writeSQLCAERRWARN(updateCount, rowCount);
        } else {
            this.writeSQLCAERRWARN(updateCount, rowCount);
            this.writer.writeShort(0);
        }
        this.writeVCMorVCS(sqlerrmc);
        if (this.sqlamLevel >= 7) {
            this.writeSQLDIAGGRP(nextException);
        }
    }

    private void writeSQLCAERRWARN(long updateCount, long rowCount) {
        this.writer.writeInt((int)(rowCount >>> 32));
        this.writer.writeInt((int)(rowCount & 0xFFFFFFFFL));
        this.writer.writeInt((int)(updateCount & 0xFFFFFFFFL));
        this.writer.writeInt((int)(updateCount >>> 32));
        this.writer.writeBytes(errD5_D6);
        this.writer.writeBytes(warn0_warnA);
    }

    private void writeSQLDIAGGRP(SQLException nextException) throws DRDAProtocolException {
        while (nextException != null && !"rwupd".equals(nextException.getSQLState()) && !"02502".equals(nextException.getSQLState())) {
            nextException = nextException.getNextException();
        }
        if (nextException == null || this.diagnosticLevel == -16) {
            this.writer.writeByte(255);
            return;
        }
        this.writer.writeByte(0);
        this.writeSQLDIAGSTT();
        this.writeSQLDIAGCI(nextException);
        this.writeSQLDIAGCN();
    }

    private void writeSQLDIAGSTT() throws DRDAProtocolException {
        this.writer.writeByte(255);
    }

    private void writeSQLDIAGCI(SQLException nextException) throws DRDAProtocolException {
        SQLException se;
        long rowNum = 1L;
        this.writeSQLNUMROW(se);
        for (se = nextException; se != null; se = se.getNextException()) {
            StandardException ferry;
            String sqlState = se.getSQLState();
            int severity = this.getExceptionSeverity(se);
            int sqlCode = -1;
            if (severity == 4) {
                sqlCode = 1;
            } else if (severity == 0) {
                sqlCode = 0;
            }
            Object sqlerrmc = "";
            if (this.diagnosticLevel == -15) {
                sqlerrmc = se.getLocalizedMessage();
            }
            if (this.diagnosticLevel == -16 && (ferry = StandardException.getArgumentFerry(se)) != null) {
                Object[] args = ferry.getArguments();
                for (int i = 0; args != null && i < args.length; ++i) {
                    sqlerrmc = (String)sqlerrmc + args[i].toString() + SQLERRMC_TOKEN_DELIMITER;
                }
            }
            this.writeSQLDCROW(rowNum++, sqlCode, sqlState, this.getDbName(), (String)sqlerrmc);
        }
    }

    private void writeSQLNUMROW(SQLException nextException) throws DRDAProtocolException {
        this.writeSQLNUMGRP(nextException);
    }

    private void writeSQLNUMGRP(SQLException nextException) throws DRDAProtocolException {
        int i = 0;
        for (SQLException se = nextException; se != null; se = se.getNextException()) {
            ++i;
        }
        this.writer.writeShort(i);
    }

    private void writeSQLDCROW(long rowNum, int sqlCode, String sqlState, String dbname, String sqlerrmc) throws DRDAProtocolException {
        this.writeSQLDCGRP(rowNum, sqlCode, sqlState, dbname, sqlerrmc);
    }

    private void writeSQLDCGRP(long rowNum, int sqlCode, String sqlState, String dbname, String sqlerrmc) throws DRDAProtocolException {
        this.writer.writeInt(sqlCode);
        this.writer.writeString(sqlState);
        this.writer.writeInt(0);
        this.writer.writeInt(0);
        this.writer.writeLong(rowNum);
        byte[] byteArray = new byte[1];
        this.writer.writeScalarPaddedBytes(byteArray, 47, (byte)0);
        this.writer.writeShort(0);
        this.writer.writeByte(255);
        this.writer.writeLDString(sqlerrmc);
        this.writeVCMorVCS(null);
        this.writeVCMorVCS(null);
        this.writeVCMorVCS(null);
        this.writer.writeByte(255);
    }

    private void writeSQLDIAGCN() throws DRDAProtocolException {
        this.writer.writeByte(255);
    }

    private void writeSQLDARD(DRDAStatement stmt, boolean rtnOutput, SQLException e) throws DRDAProtocolException, SQLException {
        EnginePreparedStatement ps = stmt.getPreparedStatement();
        ResultSetMetaData rsmeta = ps.getMetaData();
        ParameterMetaData pmeta = stmt.getParameterMetaData();
        int numElems = 0;
        if (e == null || e instanceof SQLWarning) {
            if (rtnOutput && rsmeta != null) {
                numElems = rsmeta.getColumnCount();
            } else if (!rtnOutput && pmeta != null) {
                numElems = pmeta.getParameterCount();
            }
        }
        this.writer.createDssObject();
        this.writer.startDdm(9233);
        this.writeSQLCAGRP(e, 0L, 0L);
        if (this.sqlamLevel >= 7) {
            this.writeSQLDHROW(ps.getResultSetHoldability());
        }
        this.trace("num Elements = " + numElems);
        this.writer.writeShort(numElems);
        for (int i = 0; i < numElems; ++i) {
            this.writeSQLDAGRP(rsmeta, pmeta, i, rtnOutput);
        }
        this.writer.endDdmAndDss();
    }

    private void writeQRYDSC(DRDAStatement stmt, boolean FDODSConly) throws DRDAProtocolException, SQLException {
        ResultSet rs = null;
        ResultSetMetaData rsmeta = null;
        ParameterMetaData pmeta = null;
        if (!stmt.needsToSendParamData) {
            rs = stmt.getResultSet();
        }
        if (rs == null) {
            pmeta = stmt.getParameterMetaData();
        } else {
            rsmeta = rs.getMetaData();
        }
        int numCols = rsmeta != null ? rsmeta.getColumnCount() : pmeta.getParameterCount();
        int numGroups = 1;
        int colStart = 1;
        int colEnd = numCols;
        int blksize = stmt.getBlksize() > 0 ? stmt.getBlksize() : 0xA00000;
        int remaining = blksize - this.writer.getDSSLength() % blksize - (3 + FdocaConstants.SQLCADTA_SQLDTARD_RLO_SIZE);
        int firstcols = remaining / 3;
        if (firstcols < numCols || numCols > 84) {
            if (firstcols > 84) {
                SanityManager.ASSERT(numCols > 84, "Number of columns " + numCols + " is less than MAX_VARS_IN_NGDA");
                numGroups = numCols / 84;
                if (84 * numGroups < numCols) {
                    ++numGroups;
                }
                colEnd = 84;
            } else {
                colEnd = firstcols;
                if (84 * (numGroups += (numCols - firstcols) / 84) < numCols) {
                    ++numGroups;
                }
            }
        }
        if (!FDODSConly) {
            this.writer.createDssObject();
            this.writer.startDdm(9242);
        }
        for (int i = 0; i < numGroups; ++i) {
            this.writeSQLDTAGRP(stmt, rsmeta, pmeta, colStart, colEnd, i == 0);
            colStart = colEnd + 1;
            colEnd = Math.min(colEnd + 84, numCols);
        }
        this.writer.writeBytes(FdocaConstants.SQLCADTA_SQLDTARD_RLO);
        if (!FDODSConly) {
            this.writer.endDdmAndDss();
        }
    }

    private void writeSQLDTAGRP(DRDAStatement stmt, ResultSetMetaData rsmeta, ParameterMetaData pmeta, int colStart, int colEnd, boolean first) throws DRDAProtocolException, SQLException {
        int length = 3 * (colEnd + 1 - colStart) + 3;
        this.writer.writeByte(length);
        if (first) {
            this.writer.writeByte(118);
            this.writer.writeByte(208);
        } else {
            this.writer.writeByte(127);
            this.writer.writeByte(0);
        }
        boolean hasRs = rsmeta != null;
        for (int i = colStart; i <= colEnd; ++i) {
            boolean nullable = hasRs ? rsmeta.isNullable(i) == 1 : pmeta.isNullable(i) == 1;
            int colType = hasRs ? rsmeta.getColumnType(i) : pmeta.getParameterType(i);
            int[] outlen = new int[]{-1};
            int drdaType = FdocaConstants.mapJdbcTypeToDrdaType(colType, nullable, this.appRequester, outlen);
            boolean isDecimal = (drdaType | 1) == 15;
            int precision = 0;
            int scale = 0;
            if (hasRs) {
                precision = rsmeta.getPrecision(i);
                scale = rsmeta.getScale(i);
                stmt.setRsDRDAType(i, drdaType);
                stmt.setRsPrecision(i, precision);
                stmt.setRsScale(i, scale);
            } else if (isDecimal && stmt.isOutputParam(i)) {
                precision = pmeta.getPrecision(i);
                scale = pmeta.getScale(i);
                ((CallableStatement)((Object)stmt.ps)).registerOutParameter(i, 3, scale);
            }
            this.trace("jdbcType=" + colType + "  \tdrdaType=" + Integer.toHexString(drdaType));
            this.writer.writeByte(drdaType);
            if (isDecimal) {
                this.writer.writeByte(precision);
                this.writer.writeByte(scale);
                continue;
            }
            if (outlen[0] != -1) {
                this.writer.writeShort(outlen[0]);
                continue;
            }
            if (hasRs) {
                this.writer.writeShort(rsmeta.getColumnDisplaySize(i));
                continue;
            }
            this.writer.writeShort(stmt.getParamLen(i));
        }
    }

    private void writeSQLDHROW(int holdability) throws DRDAProtocolException, SQLException {
        if (JVMInfo.JDK_ID < 2) {
            this.writer.writeByte(255);
            return;
        }
        this.writer.writeByte(0);
        this.writer.writeShort(holdability);
        this.writer.writeShort(0);
        this.writer.writeShort(0);
        this.writer.writeShort(0);
        this.writer.writeShort(0);
        this.writer.writeShort(0);
        this.writer.writeShort(0);
        this.writeVCMorVCS(null);
    }

    private void writeQRYDTA(DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        boolean qryclsOnLmtblkprc;
        boolean getMoreData = true;
        boolean sentExtData = false;
        int startLength = 0;
        this.writer.createDssObject();
        this.trace("Write QRYDTA");
        this.writer.startDdm(9243);
        if (this.processLeftoverQRYDTA(stmt)) {
            if (stmt.getSplitQRYDTA() == null) {
                ++stmt.rowCount;
                if (stmt.getExtDtaObjects() != null) {
                    this.writeEXTDTA(stmt);
                }
            }
            return;
        }
        while (getMoreData) {
            sentExtData = false;
            getMoreData = this.writeFDODTA(stmt);
            if (stmt.getExtDtaObjects() != null && stmt.getSplitQRYDTA() == null) {
                this.writer.endDdmAndDss();
                this.writeEXTDTA(stmt);
                getMoreData = false;
                sentExtData = true;
            }
            if (!getMoreData) continue;
            int endLength = this.writer.getDSSLength();
            int rowsize = endLength - startLength;
            if (stmt.getBlksize() - endLength < rowsize) {
                getMoreData = false;
            }
            startLength = endLength;
        }
        if (!sentExtData) {
            this.writer.endDdmAndDss();
        }
        if (!stmt.hasdata() && stmt.isRSCloseImplicit(qryclsOnLmtblkprc = this.appRequester.supportsQryclsimpForLmtblkprc())) {
            stmt.rsClose();
        }
    }

    private boolean writeFDODTA(DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        boolean hasdata;
        int numCols;
        boolean moreData;
        int blksize = stmt.getBlksize() > 0 ? stmt.getBlksize() : 0xA00000;
        long rowCount = 0L;
        ResultSet rs = null;
        boolean bl = moreData = stmt.getQryprctyp() == 9239;
        if (!stmt.needsToSendParamData) {
            rs = stmt.getResultSet();
        }
        if (rs != null) {
            numCols = stmt.getNumRsCols();
            hasdata = stmt.isScrollable() ? this.positionCursor(stmt, rs) : rs.next();
        } else {
            hasdata = stmt.hasOutputParams();
            numCols = stmt.getDrdaParamCount();
        }
        do {
            boolean noRetrieveRS;
            SQLWarning w;
            SQLWarning sqlw;
            if (!hasdata) {
                this.doneData(stmt, rs);
                moreData = false;
                return moreData;
            }
            SQLWarning sQLWarning = sqlw = rs != null ? rs.getWarnings() : null;
            if (rs != null) {
                rs.clearWarnings();
            }
            if (rs != null && rs.rowUpdated()) {
                w = new SQLWarning("", "rwupd", 10000);
                if (sqlw != null) {
                    sqlw.setNextWarning(w);
                } else {
                    sqlw = w;
                }
            }
            if (rs != null && rs.rowDeleted()) {
                w = new SQLWarning("", "02502", 10000);
                if (sqlw != null) {
                    sqlw.setNextWarning(w);
                } else {
                    sqlw = w;
                }
            }
            int sqlcagrpStart = this.writer.getBufferPosition();
            if (sqlw == null) {
                this.writeSQLCAGRP(nullSQLState, 0, -1L, -1L);
            } else {
                this.writeSQLCAGRP(sqlw, 1L, -1L);
            }
            int sqlcagrpEnd = this.writer.getBufferPosition();
            boolean bl2 = noRetrieveRS = rs != null && (!stmt.getQryrtndta() || rs.rowDeleted());
            if (noRetrieveRS) {
                this.writer.writeByte(255);
            } else {
                this.writer.writeByte(0);
            }
            block10: for (int i = 1; i <= numCols && !noRetrieveRS; ++i) {
                boolean valNull;
                int scale;
                int precision;
                int drdaType;
                if (rs != null) {
                    drdaType = stmt.getRsDRDAType(i) & 0xFF;
                    precision = stmt.getRsPrecision(i);
                    scale = stmt.getRsScale(i);
                    int ndrdaType = drdaType | 1;
                    this.trace("!!drdaType = " + Integer.toHexString(drdaType) + " precision=" + precision + " scale = " + scale);
                    switch (ndrdaType) {
                        case 201: 
                        case 207: {
                            EXTDTAInputStream extdtaStream = EXTDTAInputStream.getEXTDTAStream(rs, i, drdaType);
                            this.writeFdocaVal(i, extdtaStream, drdaType, precision, scale, extdtaStream.isNull(), stmt, false);
                            break;
                        }
                        case 3: {
                            int ival = rs.getInt(i);
                            valNull = rs.wasNull();
                            this.trace("====== writing int: " + ival + " is null: " + valNull);
                            this.writeNullability(drdaType, valNull);
                            if (valNull) continue block10;
                            this.writer.writeInt(ival);
                            break;
                        }
                        case 5: {
                            short sval = rs.getShort(i);
                            valNull = rs.wasNull();
                            this.trace("====== writing small: " + sval + " is null: " + valNull);
                            this.writeNullability(drdaType, valNull);
                            if (valNull) continue block10;
                            this.writer.writeShort(sval);
                            break;
                        }
                        case 23: {
                            long lval = rs.getLong(i);
                            valNull = rs.wasNull();
                            this.trace("====== writing long: " + lval + " is null: " + valNull);
                            this.writeNullability(drdaType, valNull);
                            if (valNull) continue block10;
                            this.writer.writeLong(lval);
                            break;
                        }
                        case 13: {
                            float fval = rs.getFloat(i);
                            valNull = rs.wasNull();
                            this.trace("====== writing float: " + fval + " is null: " + valNull);
                            this.writeNullability(drdaType, valNull);
                            if (valNull) continue block10;
                            this.writer.writeFloat(fval);
                            break;
                        }
                        case 11: {
                            double dval = rs.getDouble(i);
                            valNull = rs.wasNull();
                            this.trace("====== writing double: " + dval + " is null: " + valNull);
                            this.writeNullability(drdaType, valNull);
                            if (valNull) continue block10;
                            this.writer.writeDouble(dval);
                            break;
                        }
                        case 49: 
                        case 51: 
                        case 53: 
                        case 63: 
                        case 65: {
                            String valStr = rs.getString(i);
                            this.trace("====== writing char/varchar/mix :" + valStr + ":");
                            this.writeFdocaVal(i, valStr, drdaType, precision, scale, rs.wasNull(), stmt, false);
                            break;
                        }
                        default: {
                            Object val = this.getObjectForWriteFdoca(rs, i, drdaType);
                            this.writeFdocaVal(i, val, drdaType, precision, scale, rs.wasNull(), stmt, false);
                            break;
                        }
                    }
                    continue;
                }
                drdaType = stmt.getParamDRDAType(i) & 0xFF;
                precision = stmt.getParamPrecision(i);
                scale = stmt.getParamScale(i);
                if (stmt.isOutputParam(i)) {
                    int[] outlen = new int[1];
                    drdaType = FdocaConstants.mapJdbcTypeToDrdaType(stmt.getOutputParamType(i), true, this.appRequester, outlen);
                    precision = stmt.getOutputParamPrecision(i);
                    scale = stmt.getOutputParamScale(i);
                    this.trace("***getting Object " + i);
                    Object val = this.getObjectForWriteFdoca((CallableStatement)((Object)stmt.ps), i, drdaType);
                    valNull = val == null;
                    this.writeFdocaVal(i, val, drdaType, precision, scale, valNull, stmt, true);
                    continue;
                }
                this.writeFdocaVal(i, null, drdaType, precision, scale, true, stmt, true);
            }
            DataTruncation truncated = stmt.getTruncationWarnings();
            if (truncated != null) {
                byte[] data = this.writer.getBufferContents(sqlcagrpEnd);
                this.writer.setBufferPosition(sqlcagrpStart);
                if (sqlw != null) {
                    truncated.setNextWarning(sqlw);
                }
                this.writeSQLCAGRP(truncated, 1L, -1L);
                this.writer.writeBytes(data);
                stmt.clearTruncationWarnings();
            }
            if (this.writer.getDSSLength() > blksize) {
                this.splitQRYDTA(stmt, blksize);
                return false;
            }
            if (rs == null) {
                return moreData;
            }
            if (++rowCount < (long)stmt.getQryrowset()) {
                hasdata = rs.next();
                continue;
            }
            if (!stmt.isScrollable() && !noRetrieveRS) continue;
            moreData = false;
        } while (hasdata && rowCount < (long)stmt.getQryrowset());
        if (!stmt.isScrollable()) {
            stmt.rowCount += rowCount;
        }
        if (!hasdata) {
            this.doneData(stmt, rs);
            moreData = false;
        }
        if (!stmt.isScrollable()) {
            stmt.setHasdata(hasdata);
        }
        return moreData;
    }

    private Object getObjectForWriteFdoca(ResultSet rs, int index, int drdaType) throws SQLException {
        int ndrdaType = drdaType | 1;
        switch (ndrdaType) {
            case 33: {
                return rs.getDate(index, this.getGMTCalendar());
            }
            case 35: {
                return rs.getTime(index, this.getGMTCalendar());
            }
            case 37: {
                return rs.getTimestamp(index, this.getGMTCalendar());
            }
        }
        return rs.getObject(index);
    }

    private Object getObjectForWriteFdoca(CallableStatement cs, int index, int drdaType) throws SQLException {
        int ndrdaType = drdaType | 1;
        switch (ndrdaType) {
            case 33: {
                return cs.getDate(index, this.getGMTCalendar());
            }
            case 35: {
                return cs.getTime(index, this.getGMTCalendar());
            }
            case 37: {
                return cs.getTimestamp(index, this.getGMTCalendar());
            }
            case 201: 
            case 207: {
                return EXTDTAInputStream.getEXTDTAStream(cs, index, drdaType);
            }
        }
        return cs.getObject(index);
    }

    private void splitQRYDTA(DRDAStatement stmt, int blksize) throws SQLException, DRDAProtocolException {
        byte[] temp = this.writer.copyDSSDataToEnd(blksize);
        this.writer.truncateDSS(blksize);
        if (temp.length == 0) {
            this.agentError("LMTBLKPRC violation: splitQRYDTA was called to split a QRYDTA block, but the entire row fit successfully into the current block. Server rowsize computation was probably incorrect (perhaps an off-by-one bug?). QRYDTA blocksize: " + blksize);
        }
        stmt.setSplitQRYDTA(temp);
    }

    private boolean processLeftoverQRYDTA(DRDAStatement stmt) throws SQLException, DRDAProtocolException {
        int blksize;
        byte[] leftovers = stmt.getSplitQRYDTA();
        if (leftovers == null) {
            return false;
        }
        int n = blksize = stmt.getBlksize() > 0 ? stmt.getBlksize() : 0xA00000;
        if (leftovers.length < (blksize -= 10)) {
            this.writer.writeBytes(leftovers, 0, leftovers.length);
            stmt.setSplitQRYDTA(null);
        } else {
            this.writer.writeBytes(leftovers, 0, blksize);
            byte[] newLeftovers = new byte[leftovers.length - blksize];
            System.arraycopy(leftovers, blksize, newLeftovers, 0, newLeftovers.length);
            stmt.setSplitQRYDTA(newLeftovers);
        }
        this.writer.endDdmAndDss();
        return true;
    }

    private void doneData(DRDAStatement stmt, ResultSet rs) throws DRDAProtocolException, SQLException {
        int blksize;
        this.trace("*****NO MORE DATA!!");
        int n = blksize = stmt.getBlksize() > 0 ? stmt.getBlksize() : 0xA00000;
        if (rs != null) {
            if (stmt.isScrollable()) {
                boolean isAfterLast = rs.isAfterLast();
                boolean isBeforeFirst = rs.isBeforeFirst();
                rs.last();
                stmt.rowCount = rs.getRow();
                if (isAfterLast) {
                    rs.afterLast();
                }
                if (isBeforeFirst) {
                    rs.beforeFirst();
                }
            } else {
                boolean qryclsOnLmtblkprc = this.appRequester.supportsQryclsimpForLmtblkprc();
                if (stmt.isRSCloseImplicit(qryclsOnLmtblkprc)) {
                    stmt.rsClose();
                    stmt.rsSuspend();
                }
            }
        }
        boolean isQRYSCRAFT = stmt.getQryscrorn() == 3;
        this.writeSQLCAGRP(isQRYSCRAFT ? eod00000 : eod02000, isQRYSCRAFT ? 0 : 100, 0L, stmt.rowCount);
        this.writer.writeByte(255);
        if (this.writer.getDSSLength() > blksize) {
            this.splitQRYDTA(stmt, blksize);
        }
    }

    private boolean positionCursor(DRDAStatement stmt, ResultSet rs) throws SQLException, DRDAProtocolException {
        boolean retval = false;
        switch (stmt.getQryscrorn()) {
            case 1: {
                int rows = (int)stmt.getQryrownbr();
                if (rs.isAfterLast() && rows > 0 || rs.isBeforeFirst() && rows < 0) {
                    retval = false;
                    break;
                }
                retval = rs.relative(rows);
                break;
            }
            case 2: {
                if (stmt.getQryrownbr() == 0L) {
                    rs.beforeFirst();
                    retval = false;
                    break;
                }
                retval = rs.absolute((int)stmt.getQryrownbr());
                break;
            }
            case 3: {
                rs.afterLast();
                retval = false;
                break;
            }
            case 4: {
                rs.beforeFirst();
                retval = false;
                break;
            }
            default: {
                this.agentError("Invalid value for cursor orientation " + stmt.getQryscrorn());
            }
        }
        return retval;
    }

    private void writeSQLDAGRP(ResultSetMetaData rsmeta, ParameterMetaData pmeta, int elemNum, boolean rtnOutput) throws DRDAProtocolException, SQLException {
        int jdbcElemNum = elemNum + 1;
        int[] outlen = new int[]{-1};
        int elemType = rtnOutput ? rsmeta.getColumnType(jdbcElemNum) : pmeta.getParameterType(jdbcElemNum);
        int precision = Math.min(FdocaConstants.NUMERIC_MAX_PRECISION, rtnOutput ? rsmeta.getPrecision(jdbcElemNum) : pmeta.getPrecision(jdbcElemNum));
        this.writer.writeShort(precision);
        int scale = rtnOutput ? rsmeta.getScale(jdbcElemNum) : pmeta.getScale(jdbcElemNum);
        this.writer.writeShort(scale);
        boolean nullable = rtnOutput ? rsmeta.isNullable(jdbcElemNum) == 1 : pmeta.isNullable(jdbcElemNum) == 1;
        int sqlType = SQLTypes.mapJdbcTypeToDB2SqlType(elemType, nullable, this.appRequester, outlen);
        if (outlen[0] == -1) {
            switch (elemType) {
                case 2: 
                case 3: {
                    scale = rtnOutput ? rsmeta.getScale(jdbcElemNum) : pmeta.getScale(jdbcElemNum);
                    outlen[0] = precision << 8 | scale;
                    this.trace("\n\nprecision =" + precision + " scale =" + scale);
                    break;
                }
                default: {
                    outlen[0] = Math.min(FdocaConstants.LONGVARCHAR_MAX_LEN, rtnOutput ? rsmeta.getColumnDisplaySize(jdbcElemNum) : pmeta.getPrecision(jdbcElemNum));
                }
            }
        }
        switch (elemType) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: 
            case 2005: {
                outlen[0] = rtnOutput ? rsmeta.getPrecision(jdbcElemNum) : pmeta.getPrecision(jdbcElemNum);
            }
        }
        this.trace("SQLDAGRP len =" + Integer.toHexString(outlen[0]) + "for type:" + elemType);
        if (this.sqlamLevel >= 6) {
            this.writer.writeLong(outlen[0]);
        } else {
            this.writer.writeInt(outlen[0]);
        }
        String typeName = rtnOutput ? rsmeta.getColumnTypeName(jdbcElemNum) : pmeta.getParameterTypeName(jdbcElemNum);
        this.trace("jdbcType =" + typeName + "  sqlType =" + sqlType + "len =" + outlen[0]);
        this.writer.writeShort(sqlType);
        if (elemType == 1 || elemType == 12 || elemType == -1 || elemType == 2005) {
            this.writer.writeScalar2Bytes(1208);
        } else {
            this.writer.writeScalar2Bytes(0);
        }
        if (this.sqlamLevel < 7) {
            this.writeVCMorVCS(rtnOutput ? rsmeta.getColumnName(jdbcElemNum) : null);
            this.writeVCMorVCS(null);
            this.writeVCMorVCS(null);
            if (this.sqlamLevel == 6) {
                this.writeSQLUDTGRP(rsmeta, pmeta, jdbcElemNum, rtnOutput);
            }
        } else {
            this.writeSQLDOPTGRP(rsmeta, pmeta, jdbcElemNum, rtnOutput);
        }
    }

    private void writeVCMorVCS(String s) throws DRDAProtocolException {
        if (s == null) {
            this.writer.writeShort(0);
            this.writer.writeShort(0);
            return;
        }
        this.writer.writeLDString(s);
        this.writer.writeShort(0);
    }

    private void writeSQLUDTGRP(ResultSetMetaData rsmeta, ParameterMetaData pmeta, int jdbcElemNum, boolean rtnOutput) throws DRDAProtocolException, SQLException {
        int jdbcType;
        int n = jdbcType = rtnOutput ? rsmeta.getColumnType(jdbcElemNum) : pmeta.getParameterType(jdbcElemNum);
        if (jdbcType != 2000 || !this.appRequester.supportsUDTs()) {
            this.writer.writeByte(255);
            return;
        }
        String typeName = rtnOutput ? rsmeta.getColumnTypeName(jdbcElemNum) : pmeta.getParameterTypeName(jdbcElemNum);
        String className = rtnOutput ? rsmeta.getColumnClassName(jdbcElemNum) : pmeta.getParameterClassName(jdbcElemNum);
        this.writeVCMorVCS(typeName);
        this.writeVCMorVCS(className);
    }

    private void writeSQLDOPTGRP(ResultSetMetaData rsmeta, ParameterMetaData pmeta, int jdbcElemNum, boolean rtnOutput) throws DRDAProtocolException, SQLException {
        this.writer.writeByte(0);
        this.writer.writeShort(0);
        this.writeVCMorVCS(rtnOutput ? rsmeta.getColumnName(jdbcElemNum) : null);
        this.writeVCMorVCS(null);
        this.writeVCMorVCS(null);
        this.writeSQLUDTGRP(rsmeta, pmeta, jdbcElemNum, rtnOutput);
        this.writeSQLDXGRP(rsmeta, pmeta, jdbcElemNum, rtnOutput);
    }

    private void writeSQLDXGRP(ResultSetMetaData rsmeta, ParameterMetaData pmeta, int jdbcElemNum, boolean rtnOutput) throws DRDAProtocolException, SQLException {
        this.writer.writeByte(0);
        this.writer.writeShort(0);
        this.writer.writeShort(rtnOutput ? rsmeta.isWritable(jdbcElemNum) : false);
        if (rtnOutput && rsmeta.isAutoIncrement(jdbcElemNum)) {
            this.writer.writeShort(2);
        } else {
            this.writer.writeShort(0);
        }
        if (pmeta != null && !rtnOutput) {
            int type;
            int mode = pmeta.getParameterMode(jdbcElemNum);
            if (mode == 0 && (type = DRDAStatement.getOutputParameterTypeFromClassName(pmeta.getParameterClassName(jdbcElemNum))) != DRDAStatement.NOT_OUTPUT_PARAM) {
                mode = 2;
            }
            this.writer.writeShort(mode);
        } else {
            this.writer.writeShort(0);
        }
        this.writer.writeShort(0);
        this.writeVCMorVCS(null);
        this.writeVCMorVCS(rtnOutput ? rsmeta.getTableName(jdbcElemNum) : null);
        this.writeVCMorVCS(rtnOutput ? rsmeta.getSchemaName(jdbcElemNum) : null);
        this.writeVCMorVCS(rtnOutput ? rsmeta.getColumnName(jdbcElemNum) : null);
    }

    protected void writeFdocaVal(int index, Object val, int drdaType, int precision, int scale, boolean valNull, DRDAStatement stmt, boolean isParam) throws DRDAProtocolException, SQLException {
        this.writeNullability(drdaType, valNull);
        if (!valNull) {
            int ndrdaType = drdaType | 1;
            long valLength = 0L;
            switch (ndrdaType) {
                case 191: {
                    this.writer.writeBoolean((Boolean)val);
                    break;
                }
                case 5: {
                    if (val instanceof Boolean) {
                        this.writer.writeShort((Boolean)val);
                        break;
                    }
                    this.writer.writeShort(((Number)val).shortValue());
                    break;
                }
                case 3: {
                    this.writer.writeInt((Integer)val);
                    break;
                }
                case 23: {
                    this.writer.writeLong((Long)val);
                    break;
                }
                case 13: {
                    this.writer.writeFloat(((Float)val).floatValue());
                    break;
                }
                case 11: {
                    this.writer.writeDouble((Double)val);
                    break;
                }
                case 15: {
                    if (precision == 0) {
                        precision = FdocaConstants.NUMERIC_DEFAULT_PRECISION;
                    }
                    BigDecimal bd = (BigDecimal)val;
                    this.writer.writeBigDecimal(bd, precision, scale);
                    break;
                }
                case 33: {
                    this.writer.writeString(this.formatDate((java.sql.Date)val));
                    break;
                }
                case 35: {
                    this.writer.writeString(this.formatTime((Time)val));
                    break;
                }
                case 37: {
                    this.writer.writeString(this.formatTimestamp((Timestamp)val));
                    break;
                }
                case 49: {
                    this.writer.writeString(((String)val).toString());
                    break;
                }
                case 51: 
                case 53: 
                case 63: 
                case 65: {
                    this.writer.writeLDString(val.toString(), index, stmt, isParam);
                    break;
                }
                case 201: 
                case 207: {
                    if (!((EXTDTAInputStream)val).isEmptyStream()) {
                        stmt.addExtDtaObject(val, index);
                        this.writer.writeExtendedLength(32768L);
                        break;
                    }
                    this.writer.writeExtendedLength(0L);
                    break;
                }
                case 39: {
                    this.writer.writeBytes((byte[])val);
                    break;
                }
                case 41: 
                case 43: {
                    this.writer.writeLDBytes((byte[])val, index);
                    break;
                }
                case 25: 
                case 27: {
                    this.writer.writeInt(((EngineLOB)val).getLocator());
                    break;
                }
                case 81: {
                    this.writer.writeUDT(val, index);
                    break;
                }
                default: {
                    this.trace("ndrdaType is: " + ndrdaType);
                    this.writer.writeLDString(val.toString(), index, stmt, isParam);
                }
            }
        }
    }

    private void writeNullability(int drdaType, boolean valNull) {
        if (FdocaConstants.isNullable(drdaType)) {
            if (valNull) {
                this.writer.writeByte(255);
            } else {
                this.writer.writeByte(0);
            }
        }
    }

    private String formatDate(java.sql.Date date) {
        Calendar cal = this.getGMTCalendar();
        cal.clear();
        cal.setTime(date);
        char[] buf = "YYYY-MM-DD".toCharArray();
        this.padInt(buf, 0, 4, cal.get(1));
        this.padInt(buf, 5, 2, cal.get(2) + 1);
        this.padInt(buf, 8, 2, cal.get(5));
        return new String(buf);
    }

    private String formatTime(Time time) {
        Calendar cal = this.getGMTCalendar();
        cal.clear();
        cal.setTime(time);
        char[] buf = "HH:MM:SS".toCharArray();
        this.padInt(buf, 0, 2, cal.get(11));
        this.padInt(buf, 3, 2, cal.get(12));
        this.padInt(buf, 6, 2, cal.get(13));
        return new String(buf);
    }

    private String formatTimestamp(Timestamp ts) {
        Calendar cal = this.getGMTCalendar();
        cal.clear();
        cal.setTime(ts);
        char[] buf = new char[this.appRequester.getTimestampLength()];
        this.padInt(buf, 0, 4, cal.get(1));
        buf[4] = 45;
        this.padInt(buf, 5, 2, cal.get(2) + 1);
        buf[7] = 45;
        this.padInt(buf, 8, 2, cal.get(5));
        buf[10] = 45;
        this.padInt(buf, 11, 2, cal.get(11));
        buf[13] = 46;
        this.padInt(buf, 14, 2, cal.get(12));
        buf[16] = 46;
        this.padInt(buf, 17, 2, cal.get(13));
        buf[19] = 46;
        int nanos = ts.getNanos();
        if (this.appRequester.supportsTimestampNanoseconds()) {
            this.padInt(buf, 20, 9, nanos);
        } else {
            this.padInt(buf, 20, 6, nanos / 1000);
        }
        return new String(buf);
    }

    private void padInt(char[] buf, int offset, int length, int value) {
        int radix = 10;
        for (int i = offset + length - 1; i >= offset; --i) {
            buf[i] = Character.forDigit(value % 10, 10);
            value /= 10;
        }
    }

    private void copyToRequired(int[] req) {
        this.currentRequiredLength = req.length;
        if (this.currentRequiredLength > this.required.length) {
            this.required = new int[this.currentRequiredLength];
        }
        System.arraycopy(req, 0, this.required, 0, req.length);
    }

    private void removeFromRequired(int codePoint) {
        for (int i = 0; i < this.currentRequiredLength; ++i) {
            if (this.required[i] != codePoint) continue;
            this.required[i] = 0;
        }
    }

    private void checkRequired(int codePoint) throws DRDAProtocolException {
        int firstMissing = 0;
        for (int i = 0; i < this.currentRequiredLength; ++i) {
            if (this.required[i] == 0) continue;
            firstMissing = this.required[i];
            break;
        }
        if (firstMissing != 0) {
            this.missingCodePoint(firstMissing);
        }
    }

    private void tooMany(int codePoint) throws DRDAProtocolException {
        this.throwSyntaxrm(15, codePoint);
    }

    private void tooBig(int codePoint) throws DRDAProtocolException {
        this.throwSyntaxrm(9, codePoint);
    }

    private void invalidClient(String prdid) throws DRDAProtocolException {
        Monitor.logMessage(String.valueOf(new Date()) + " : " + this.server.localizeMessage("DRDA_InvalidClient.S", new String[]{prdid}));
        this.requiredValueNotFound(4398);
    }

    private void requiredValueNotFound(int codePoint) throws DRDAProtocolException {
        this.throwSyntaxrm(20, codePoint);
    }

    private void badObjectLength(int codePoint) throws DRDAProtocolException {
        this.throwSyntaxrm(11, codePoint);
    }

    private void rdbNotFound(String rdbnam) throws DRDAProtocolException {
        Object[] oa = new Object[]{rdbnam};
        throw new DRDAProtocolException(DRDAProtocolException.DRDA_Proto_RDBNFNRM, this, 0, 0, oa);
    }

    private void invalidValue(int codePoint) throws DRDAProtocolException {
        this.throwSyntaxrm(20, codePoint);
    }

    protected void invalidCodePoint(int codePoint) throws DRDAProtocolException {
        this.throwSyntaxrm(29, codePoint);
    }

    protected void codePointNotSupported(int codePoint) throws DRDAProtocolException {
        throw new DRDAProtocolException(DRDAProtocolException.DRDA_Proto_CMDNSPRM, this, codePoint, 0);
    }

    private void valueNotSupported(int codePoint) throws DRDAProtocolException {
        throw new DRDAProtocolException(DRDAProtocolException.DRDA_Proto_VALNSPRM, this, codePoint, 0);
    }

    private void verifyRequiredObject(int codePoint, int reqCodePoint) throws DRDAProtocolException {
        if (codePoint != reqCodePoint) {
            this.throwSyntaxrm(14, codePoint);
        }
    }

    private void verifyInOrderACCSEC_SECCHK(int codePoint, int reqCodePoint) throws DRDAProtocolException {
        if (codePoint != reqCodePoint) {
            throw new DRDAProtocolException(DRDAProtocolException.DRDA_Proto_PRCCNVRM, this, codePoint, 17);
        }
    }

    private void rdbnamMismatch(int codePoint) throws DRDAProtocolException {
        throw new DRDAProtocolException(DRDAProtocolException.DRDA_Proto_PRCCNVRM, this, codePoint, 18);
    }

    private void closeSession() {
        if (this.session == null) {
            return;
        }
        if (this.xaProto != null) {
            this.xaProto.rollbackCurrentTransaction();
        }
        this.server.removeFromSessionTable(this.session.connNum);
        try {
            this.session.close();
        }
        catch (SQLException se) {
            this.sendUnexpectedException(se);
            this.close();
        }
        finally {
            this.session = null;
            this.database = null;
            this.appRequester = null;
            this.sockis = null;
            this.sockos = null;
            this.databaseAccessException = null;
        }
    }

    private void handleException(Exception e) {
        try {
            if (e instanceof DRDAProtocolException) {
                this.sendProtocolException((DRDAProtocolException)e);
            } else {
                this.sendUnexpectedException(e);
                this.server.consoleExceptionPrintTrace(e);
            }
        }
        finally {
            this.closeSession();
            this.close();
        }
    }

    private void sendProtocolException(DRDAProtocolException de) {
        String dbname = this.getDbName();
        try {
            DRDAConnThread.println2Log(dbname, this.session.drdaID, de.getMessage());
            this.server.consoleExceptionPrintTrace(de);
            this.reader.clearBuffer();
            de.write(this.writer);
            this.finalizeChain();
        }
        catch (DRDAProtocolException ioe) {
            DRDAConnThread.println2Log(dbname, this.session.drdaID, de.getMessage());
            this.server.consoleExceptionPrintTrace(ioe);
        }
    }

    private void sendUnexpectedException(Exception e) {
        try {
            String dbname = this.getDbName();
            DRDAConnThread.println2Log(dbname, this.session.drdaID, e.getMessage());
            this.server.consoleExceptionPrintTrace(e);
            DRDAProtocolException unExpDe = DRDAProtocolException.newAgentError(this, 64, dbname, e.getMessage());
            this.reader.clearBuffer();
            unExpDe.write(this.writer);
            this.finalizeChain();
        }
        catch (DRDAProtocolException dRDAProtocolException) {
            // empty catch block
        }
    }

    private boolean closed() {
        return this.close;
    }

    private boolean getLogConnections() {
        return this.logConnections;
    }

    private long getTimeSlice() {
        return this.timeSlice;
    }

    protected void trace(String value) {
        if (this.server.debugOutput()) {
            this.server.consoleMessage(value, true);
        }
    }

    private void traceEXTDTARead(int drdaType, int index, EXTDTAReaderInputStream stream, boolean streamLOB, String encoding) {
        if (this.server.debugOutput()) {
            StringBuilder sb = new StringBuilder("Reading/setting EXTDTA: ");
            sb.append("t").append(drdaType).append("/i").append(index).append("/").append(streamLOB).append("/").append(encoding).append("/").append(stream.readStatusByte).append("/b");
            if (stream == null) {
                sb.append("NULL");
            } else if (stream.isLayerBStream()) {
                sb.append("UNKNOWN_LENGTH");
            } else {
                sb.append(((StandardEXTDTAReaderInputStream)stream).getLength());
            }
            this.trace(sb.toString());
        }
    }

    public static void showmem() {
        Runtime rt = Runtime.getRuntime();
        Date d = new Date();
        rt.gc();
        System.out.println("total memory: " + rt.totalMemory() + " free: " + rt.freeMemory() + " " + d.toString());
    }

    private String convertToHexString(byte[] buf) {
        return "0x" + StringUtil.toHexString(buf, 0, buf.length);
    }

    private void checkValidTypDefNam(String typdefnam) throws DRDAProtocolException {
        if (!(typdefnam.equals("QTDSQL370") || typdefnam.equals("QTDSQL400") || typdefnam.equals("QTDSQLX86") || typdefnam.equals("QTDSQLASC") || typdefnam.equals("QTDSQLVAX") || typdefnam.equals("QTDSQLJVM"))) {
            this.invalidValue(47);
        }
    }

    private void checkLength(int codepoint, int reqlen) throws DRDAProtocolException {
        long len = this.reader.getDdmLength();
        if (len < (long)reqlen) {
            this.badObjectLength(codepoint);
        } else if (len > (long)reqlen) {
            this.tooBig(codepoint);
        }
    }

    private boolean readBoolean(int codepoint) throws DRDAProtocolException {
        this.checkLength(codepoint, 1);
        byte val = this.reader.readByte();
        if (val == -15) {
            return true;
        }
        if (val == -16) {
            return false;
        }
        this.invalidValue(codepoint);
        return false;
    }

    private void initializeDatabase(String dbname) {
        Database db = this.appRequester.isXARequester() ? new XADatabase(dbname) : new Database(dbname);
        if (dbname != null) {
            this.session.addDatabase(db);
            this.session.database = db;
        }
        this.database = db;
    }

    private void setDatabase(int codePoint) throws DRDAProtocolException {
        String dbname = this.parseRDBNAM();
        if (this.database != null && this.database.getDatabaseName().equals(dbname)) {
            return;
        }
        Database d = this.session.getDatabase(dbname);
        if (d == null) {
            this.rdbnamMismatch(codePoint);
        } else {
            this.database = d;
        }
        this.session.database = d;
    }

    private void writeENDUOWRM(int opType) {
        this.writer.createDssReply();
        this.writer.startDdm(8716);
        this.writer.writeScalar2Bytes(4425, 4);
        this.writer.writeScalar1Byte(8469, opType);
        this.writer.endDdmAndDss();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeEXTDTA(DRDAStatement stmt) throws SQLException, DRDAProtocolException {
        ArrayList<Object> extdtaValues = stmt.getExtDtaObjects();
        if (extdtaValues == null) {
            return;
        }
        boolean writeNullByte = false;
        for (int i = 0; i < extdtaValues.size(); ++i) {
            Object o;
            boolean chainedWithSameCorrelator;
            if (i != extdtaValues.size() - 1) {
                chainFlag = true;
                chainedWithSameCorrelator = true;
            } else {
                chainFlag = false;
                chainedWithSameCorrelator = false;
            }
            if (this.sqlamLevel >= 7 && stmt.isExtDtaValueNullable(i)) {
                writeNullByte = true;
            }
            if (!((o = extdtaValues.get(i)) instanceof EXTDTAInputStream)) continue;
            EXTDTAInputStream stream = (EXTDTAInputStream)o;
            try {
                stream.initInputStream();
                this.writer.writeScalarStream(chainedWithSameCorrelator, 5228, stream, writeNullByte);
                continue;
            }
            finally {
                DRDAConnThread.closeStream(stream);
            }
        }
        stmt.clearExtDtaObjects();
    }

    private void checkWarning(Connection conn, Statement stmt, ResultSet rs, long updateCount, boolean alwaysSend, boolean sendWarn) throws DRDAProtocolException, SQLException {
        SQLWarning reportWarning = null;
        try {
            SQLWarning warning;
            if (stmt != null && (warning = stmt.getWarnings()) != null) {
                stmt.clearWarnings();
                reportWarning = warning;
            }
            if (rs != null && (warning = rs.getWarnings()) != null) {
                rs.clearWarnings();
                if (reportWarning == null) {
                    reportWarning = warning;
                }
            }
            if (conn != null && (warning = conn.getWarnings()) != null) {
                conn.clearWarnings();
                if (reportWarning == null) {
                    reportWarning = warning;
                }
            }
        }
        catch (SQLException se) {
            this.trace("got SQLException while trying to get warnings.");
        }
        if ((alwaysSend || reportWarning != null) && sendWarn) {
            this.writeSQLCARDs(reportWarning, updateCount);
        }
    }

    boolean hasSession() {
        return this.session != null;
    }

    long getBytesRead() {
        return this.reader.totalByteCount;
    }

    long getBytesWritten() {
        return this.writer.totalByteCount;
    }

    protected String buildRuntimeInfo(String indent, LocalizedResource localLangUtil) {
        Session s = this.session;
        if (s == null) {
            return "";
        }
        return s.buildRuntimeInfo("", localLangUtil) + "\n";
    }

    private void finalizeChain() throws DRDAProtocolException {
        this.writer.finalizeChain(this.reader.getCurrChainState(), this.getOutputStream());
    }

    private int validateSecMecUSRSSBPWD() throws DRDAProtocolException {
        String authClassName;
        AuthenticationService authenticationService = null;
        org.apache.derby.iapi.db.Database databaseObj = null;
        String srvrlslv = this.appRequester.srvrlslv;
        if (srvrlslv == null || srvrlslv.length() == 0 || srvrlslv.length() < 8 || srvrlslv.indexOf("DNC") == -1) {
            return 1;
        }
        this.appRequester.setClientVersion(srvrlslv.substring(0, 8));
        if (!this.appRequester.supportsSecMecUSRSSBPWD()) {
            return 1;
        }
        String dbName = this.database.getShortDbName();
        if (dbName == null || dbName.length() == 0) {
            authenticationService = ((InternalDriver)NetworkServerControlImpl.getDriver()).getAuthenticationService();
        } else {
            if (DRDAConnThread.getMonitor() != null) {
                databaseObj = (org.apache.derby.iapi.db.Database)DRDAConnThread.findService("org.apache.derby.database.Database", dbName);
            }
            if (databaseObj == null) {
                this.database.makeDummyConnection();
                databaseObj = (org.apache.derby.iapi.db.Database)DRDAConnThread.findService("org.apache.derby.database.Database", dbName);
            }
            try {
                if (databaseObj != null) {
                    authenticationService = databaseObj.getAuthenticationService();
                }
            }
            catch (StandardException se) {
                DRDAConnThread.println2Log(null, this.session.drdaID, se.getMessage());
                return 10;
            }
        }
        if (authenticationService != null && !(authClassName = authenticationService.getClass().getName()).equals(AUTHENTICATION_PROVIDER_BUILTIN_CLASS) && !authClassName.equals(AUTHENTICATION_PROVIDER_NONE_CLASS)) {
            return 1;
        }
        try {
            this.myTargetSeed = DecryptionManager.generateSeed();
            this.database.secTokenOut = this.myTargetSeed;
        }
        catch (SQLException se) {
            DRDAConnThread.println2Log(null, this.session.drdaID, se.getMessage());
            return 10;
        }
        return 0;
    }

    private static void closeStream(InputStream stream) throws SQLException {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            throw Util.javaException(e);
        }
    }

    private static InputStream convertAsByteArrayInputStream(EXTDTAReaderInputStream stream) throws IOException {
        int c;
        stream.setSuppressException(true);
        int byteArrayLength = stream instanceof StandardEXTDTAReaderInputStream ? (int)((StandardEXTDTAReaderInputStream)stream).getLength() : 1 + stream.available();
        PublicBufferOutputStream pbos = new PublicBufferOutputStream(byteArrayLength);
        byte[] buffer = new byte[Math.min(byteArrayLength, 32768)];
        while ((c = stream.read(buffer, 0, buffer.length)) > -1) {
            pbos.write(buffer, 0, c);
        }
        if (stream.isStatusSet() && stream.getStatus() != 127) {
            return new FailingEXTDTAInputStream(stream.getStatus());
        }
        return new ByteArrayInputStream(pbos.getBuffer(), 0, pbos.getCount());
    }

    private static void setAsCharacterStream(DRDAStatement stmt, int i, EXTDTAReaderInputStream extdtaStream, boolean streamLOB, String encoding) throws IOException, SQLException {
        EnginePreparedStatement ps = stmt.getPreparedStatement();
        if (streamLOB) {
            stmt.setStreamedParameter(extdtaStream);
        }
        InputStream is = streamLOB ? extdtaStream : DRDAConnThread.convertAsByteArrayInputStream(extdtaStream);
        InputStreamReader streamReader = new InputStreamReader(is, encoding);
        ps.setCharacterStream(i, streamReader);
    }

    private static void setAsBinaryStream(DRDAStatement stmt, int index, EXTDTAReaderInputStream stream, boolean streamLOB) throws IOException, SQLException {
        int type = stmt.getParameterMetaData().getParameterType(index);
        boolean useSetBinaryStream = type == 2004;
        EnginePreparedStatement ps = stmt.getPreparedStatement();
        if (streamLOB && useSetBinaryStream) {
            stmt.setStreamedParameter(stream);
            if (stream == null) {
                ps.setBytes(index, null);
            } else if (!stream.isLayerBStream()) {
                int length = (int)((StandardEXTDTAReaderInputStream)stream).getLength();
                ps.setBinaryStream(index, (InputStream)stream, length);
            } else {
                ps.setBinaryStream(index, stream);
            }
        } else if (stream == null) {
            ps.setBytes(index, null);
        } else {
            InputStream bais = DRDAConnThread.convertAsByteArrayInputStream(stream);
            ps.setBinaryStream(index, bais, bais.available());
        }
    }

    private static ModuleFactory getMonitor() {
        return Monitor.getMonitor();
    }

    private static Object findService(String factoryInterface, String serviceName) {
        return Monitor.findService(factoryInterface, serviceName);
    }

    static {
        eod00000 = new byte[]{48, 48, 48, 48, 48};
        eod02000 = new byte[]{48, 50, 48, 48, 48};
        nullSQLState = new byte[]{32, 32, 32, 32, 32};
        errD5_D6 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        warn0_warnA = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
        dummy = new DRDAProtocolExceptionInfo(0, 0, 0, false);
        SQLERRMC_TOKEN_DELIMITER = new String(new char[]{'\u0014'});
        SQLERRMC_PREFORMATTED_MESSAGE_DELIMITER = "::";
    }

    private static class PublicBufferOutputStream
    extends ByteArrayOutputStream {
        PublicBufferOutputStream(int size) {
            super(size);
        }

        public byte[] getBuffer() {
            return this.buf;
        }

        public int getCount() {
            return this.count;
        }
    }
}

