/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.Limit;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.locks.LockOwner;
import org.apache.derby.iapi.services.property.PersistentSet;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.raw.Compensation;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.GlobalTransactionId;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.StreamContainerHandle;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.log.LogFactory;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.log.Logger;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.store.raw.xact.TransactionId;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.xact.BeginXact;
import org.apache.derby.impl.store.raw.xact.EndXact;
import org.apache.derby.impl.store.raw.xact.GlobalXactId;
import org.apache.derby.impl.store.raw.xact.LockCount;
import org.apache.derby.impl.store.raw.xact.RowLocking3Escalate;
import org.apache.derby.impl.store.raw.xact.SavePoint;
import org.apache.derby.impl.store.raw.xact.TransactionTable;
import org.apache.derby.impl.store.raw.xact.TransactionTableEntry;
import org.apache.derby.impl.store.raw.xact.XactContext;
import org.apache.derby.impl.store.raw.xact.XactFactory;
import org.apache.derby.impl.store.raw.xact.XactId;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class Xact
extends RawTransaction
implements Limit,
LockOwner {
    protected static final int CLOSED = 0;
    protected static final int IDLE = 1;
    protected static final int ACTIVE = 2;
    protected static final int UPDATE = 3;
    protected static final int PREPARED = 4;
    public static final int END_ABORTED = 1;
    public static final int END_PREPARED = 2;
    public static final int END_COMMITTED = 4;
    public static final int RECOVERY_ROLLBACK_FIRST = 16;
    public static final int INTERNAL_TRANSACTION = 32;
    public static final int NESTED_TOP_TRANSACTION = 64;
    private static final int COMMIT_SYNC = 65536;
    private static final int COMMIT_NO_SYNC = 131072;
    private static final int COMMIT_PREPARE = 262144;
    private int savedEndStatus;
    private boolean needSync;
    private boolean justCreated = true;
    protected XactContext xc;
    protected final XactFactory xactFactory;
    protected final DataFactory dataFactory;
    protected final LogFactory logFactory;
    protected final DataValueFactory dataValueFactory;
    private final CompatibilitySpace compatibilitySpace;
    private LockingPolicy defaultLocking;
    private GlobalTransactionId myGlobalId;
    private volatile TransactionId myId;
    private volatile TransactionId parentTransactionId;
    protected Logger logger;
    protected volatile int state;
    private Integer inComplete = null;
    private boolean seenUpdates;
    private boolean inPostCommitProcessing;
    private LogInstant logStart;
    private LogInstant logLast;
    private Stack<SavePoint> savePoints;
    protected List<Serviceable> postCommitWorks;
    protected List<Serviceable> postAbortWorks;
    protected List<Serviceable> postTerminationWorks;
    private boolean recoveryTransaction;
    DynamicByteArrayOutputStream logBuffer;
    private boolean postCompleteMode;
    private boolean sanityCheck_xaclosed;
    private String transName;
    private boolean readOnly;
    private boolean flush_log_on_xact_end;
    private boolean backupBlocked;
    private boolean dontWaitForLocks;

    protected Xact(XactFactory xactFactory, Xact parentTransaction, LogFactory logFactory, DataFactory dataFactory, DataValueFactory dataValueFactory, boolean readOnly, CompatibilitySpace compatibilitySpace, boolean flush_log_on_xact_end) {
        this.xactFactory = xactFactory;
        if (parentTransaction != null) {
            this.parentTransactionId = parentTransaction.getId();
        }
        this.logFactory = logFactory;
        this.dataFactory = dataFactory;
        this.dataValueFactory = dataValueFactory;
        this.readOnly = readOnly;
        this.flush_log_on_xact_end = flush_log_on_xact_end;
        this.compatibilitySpace = compatibilitySpace == null ? this.getLockFactory().createCompatibilitySpace(this) : compatibilitySpace;
        SanityManager.ASSERT(dataFactory != null, "datafactory is null");
        SanityManager.ASSERT(xactFactory != null, "xactfactory is null");
        SanityManager.ASSERT(logFactory != null, "logfactory is null");
        this.resetDefaultLocking();
        xactFactory.setNewTransactionId(null, this);
        this.setIdleState();
        this.backupBlocked = false;
    }

    @Override
    public final LockFactory getLockFactory() {
        return this.xactFactory.getLockFactory();
    }

    @Override
    public final DataFactory getDataFactory() {
        return this.dataFactory;
    }

    @Override
    public final LogFactory getLogFactory() {
        return this.logFactory;
    }

    @Override
    public boolean anyoneBlocked() {
        return this.getLockFactory().anyoneBlocked();
    }

    @Override
    public DynamicByteArrayOutputStream getLogBuffer() {
        if (this.logBuffer == null) {
            this.logBuffer = new DynamicByteArrayOutputStream(1024);
        } else {
            this.logBuffer.reset();
        }
        return this.logBuffer;
    }

    @Override
    public void logAndUndo(Compensation compensation, LogInstant undoInstant, LimitObjectInput in) throws StandardException {
        SavePoint sp;
        SanityManager.ASSERT(this.logStart != null);
        this.setActiveState();
        if (this.state == 2) {
            this.setUpdateState();
        }
        this.seenUpdates = true;
        LogInstant clrInstant = this.logger.logAndUndo(this, compensation, undoInstant, in);
        this.setLastLogInstant(clrInstant);
        if (this.savePoints != null && !this.savePoints.empty() && (sp = this.savePoints.peek()).getSavePoint() == null) {
            sp.setSavePoint(clrInstant);
        }
    }

    @Override
    public void addUpdateTransaction(int transactionStatus) {
        if (this.myId != null) {
            this.xactFactory.addUpdateTransaction(this.myId, this, transactionStatus);
        }
    }

    @Override
    public void removeUpdateTransaction() {
        if (this.myId != null) {
            this.xactFactory.removeUpdateTransaction(this.myId);
        }
    }

    @Override
    public void prepareTransaction() {
        if (this.myId != null) {
            this.xactFactory.prepareTransaction(this.myId);
        }
    }

    @Override
    public void setFirstLogInstant(LogInstant instant) {
        SanityManager.ASSERT(instant != null);
        SanityManager.ASSERT(this.logStart == null);
        this.logStart = instant;
    }

    @Override
    public LogInstant getFirstLogInstant() {
        return this.logStart;
    }

    @Override
    public void setLastLogInstant(LogInstant instant) {
        SanityManager.ASSERT(instant != null);
        this.logLast = instant;
    }

    @Override
    public LogInstant getLastLogInstant() {
        return this.logLast;
    }

    void setTransactionId(GlobalTransactionId extid, TransactionId localid) {
        if (!(this.state == 1 || this.state == 2 || this.state == 0 && this.justCreated)) {
            SanityManager.THROWASSERT("my state is not idle nor active " + this.state);
        }
        this.myGlobalId = extid;
        this.myId = localid;
        if (SanityManager.DEBUG_ON("XATrace") && extid != null) {
            SanityManager.DEBUG("XATrace", "setting xid: " + String.valueOf(this.myId) + " " + String.valueOf(this.myGlobalId) + " state " + this.state + " " + String.valueOf(this));
            SanityManager.showTrace(new Throwable());
        }
    }

    @Override
    public void setTransactionId(Loggable beginXact, TransactionId localId) {
        SanityManager.ASSERT(this.state == 1 || this.state == 2);
        SanityManager.ASSERT(beginXact instanceof BeginXact);
        this.myId = localId;
        this.myGlobalId = ((BeginXact)beginXact).getGlobalId();
    }

    @Override
    public void setup(PersistentSet set) throws StandardException {
        int escalationThreshold = PropertyUtil.getServiceInt(set, "derby.locks.escalationThreshold", 100, Integer.MAX_VALUE, 5000);
        this.getLockFactory().setLimit(this.compatibilitySpace, this, escalationThreshold, this);
    }

    @Override
    public final GlobalTransactionId getGlobalId() {
        return this.myGlobalId;
    }

    @Override
    public final ContextManager getContextManager() {
        return this.xc.getContextManager();
    }

    @Override
    public final CompatibilitySpace getCompatibilitySpace() {
        SanityManager.ASSERT(this.compatibilitySpace != null, "cannot have a null compatibilitySpace.");
        return this.compatibilitySpace;
    }

    @Override
    public boolean noWait() {
        return this.dontWaitForLocks;
    }

    @Override
    public void setNoLockWait(boolean noWait) {
        SanityManager.ASSERT(this.compatibilitySpace.getOwner() == this, "Trying to set no-wait mode on transaction that shares compatibility space with its parent");
        this.dontWaitForLocks = noWait;
    }

    @Override
    public final TransactionId getId() {
        SanityManager.ASSERT(this.myId != null, "cannot have a transaction with null id");
        return this.myId;
    }

    protected final TransactionId getIdNoCheck() {
        return this.myId;
    }

    public final String getContextId() {
        XactContext tempxc = this.xc;
        return tempxc == null ? null : tempxc.getIdName();
    }

    @Override
    public LockingPolicy getDefaultLockingPolicy() {
        return this.defaultLocking;
    }

    @Override
    public final LockingPolicy newLockingPolicy(int mode, int isolation, boolean stricterOk) {
        return this.xactFactory.getLockingPolicy(mode, isolation, stricterOk);
    }

    @Override
    public final void setDefaultLockingPolicy(LockingPolicy policy) {
        if (policy == null) {
            policy = this.xactFactory.getLockingPolicy(0, 0, false);
        }
        this.defaultLocking = policy;
    }

    @Override
    public LogInstant commit() throws StandardException {
        return this.commit(65536);
    }

    @Override
    public LogInstant commitNoSync(int commitflag) throws StandardException {
        int checkflag = 3;
        SanityManager.ASSERT((commitflag & checkflag) != 0, "commitNoSync must specify whether to keep or release locks");
        SanityManager.ASSERT((commitflag & checkflag) != checkflag, "cannot set both RELEASE and KEEP LOCKS flag");
        if ((commitflag & 4) != 0) {
            SanityManager.ASSERT(this.state == 1 || this.state == 2);
        }
        if (this.state == 1 && this.savePoints == null && (commitflag & 4) != 0) {
            return null;
        }
        return this.commit(0x20000 | commitflag);
    }

    private LogInstant prepareCommit(int commitflag) throws StandardException {
        LogInstant flushTo = null;
        if (this.state == 0) {
            throw StandardException.newException("40XT8", this.toInternalDetailString());
        }
        if ((commitflag & 2) != 0) {
            SanityManager.ASSERT((commitflag & 0x20000) != 0 || (commitflag & 0x40000) != 0, "can keep locks around only in commitNoSync or prepare");
            SanityManager.ASSERT(this.isUserTransaction(), "KEEP_LOCKS can only be set on user transaction commits");
        }
        try {
            this.preComplete(COMMIT);
            if (this.seenUpdates) {
                EndXact ex = new EndXact(this.getGlobalId(), ((commitflag & 0x40000) == 0 ? 4 : 2) | this.statusForEndXactLog());
                flushTo = this.logger.logAndDo(this, ex);
                if (this.flush_log_on_xact_end) {
                    if ((commitflag & 0x10000) == 0) {
                        this.needSync = true;
                    } else {
                        this.logger.flush(flushTo);
                        this.needSync = false;
                    }
                }
            } else if (this.needSync && (commitflag & 0x10000) != 0) {
                this.logger.flushAll();
                this.needSync = false;
            }
        }
        catch (StandardException se) {
            if (se.getSeverity() < 30000) {
                throw StandardException.newException("40XT1", se, new Object[0]);
            }
            throw se;
        }
        return flushTo;
    }

    private void completeCommit(int commitflag) throws StandardException {
        this.postComplete(commitflag, COMMIT);
        if ((commitflag & 2) == 0) {
            this.postTermination();
        } else {
            SanityManager.ASSERT(this.myGlobalId == null, "calling commit with KEEP_LOCKS on a global transaction");
            this.setActiveState();
        }
        this.myGlobalId = null;
    }

    private LogInstant commit(int commitflag) throws StandardException {
        if (SanityManager.DEBUG_ON("XATrace")) {
            SanityManager.DEBUG("XATrace", "commiting ");
        }
        LogInstant flushTo = this.prepareCommit(commitflag);
        this.completeCommit(commitflag);
        return flushTo;
    }

    @Override
    public void abort() throws StandardException {
        if (SanityManager.DEBUG_ON("XATrace")) {
            SanityManager.DEBUG("XATrace", "aborting ");
        }
        if (this.state == 0) {
            if (!this.sanityCheck_xaclosed) {
                throw StandardException.newException("40XT8", this.toInternalDetailString());
            }
            return;
        }
        try {
            this.preComplete(ABORT);
            if (this.getFirstLogInstant() != null) {
                if (this.logger == null) {
                    throw StandardException.newException("XSTB3.M", new Object[0]);
                }
                this.logger.undo(this, this.getId(), this.getFirstLogInstant(), this.getLastLogInstant());
                EndXact ex = new EndXact(this.getGlobalId(), 1 | this.statusForEndXactLog());
                this.logger.flush(this.logger.logAndDo(this, ex));
            } else if (this.needSync) {
                this.logger.flushAll();
            }
            this.needSync = false;
        }
        catch (StandardException se) {
            if (se.getSeverity() < 50000) {
                throw this.logFactory.markCorrupt(StandardException.newException("XSTB0.M", se, new Object[0]));
            }
            throw se;
        }
        this.postComplete(0, ABORT);
        if (this.postCommitWorks != null && !this.postCommitWorks.isEmpty()) {
            this.postCommitWorks.clear();
        }
        this.postTermination();
        this.myGlobalId = null;
    }

    @Override
    public void reprepare() throws StandardException {
        if (this.state == 0) {
            throw StandardException.newException("40XT8", this.toInternalDetailString());
        }
        SanityManager.ASSERT(this.myGlobalId != null);
        SanityManager.ASSERT(this.state == 4);
        try {
            if (this.logger == null) {
                throw StandardException.newException("XSTB3.M", new Object[0]);
            }
            this.state = 3;
            this.logger.reprepare(this, this.getId(), this.getFirstLogInstant(), this.getLastLogInstant());
            this.state = 4;
            this.seenUpdates = true;
        }
        catch (StandardException se) {
            if (se.getSeverity() < 50000) {
                throw this.logFactory.markCorrupt(StandardException.newException("XSTB0.M", se, new Object[0]));
            }
            throw se;
        }
    }

    @Override
    public void destroy() throws StandardException {
        if (this.state != 0) {
            this.abort();
        }
        this.close();
    }

    @Override
    public void close() throws StandardException {
        switch (this.state) {
            case 0: {
                return;
            }
            case 1: {
                break;
            }
            default: {
                throw StandardException.newException("40XT4", new Object[0]);
            }
        }
        SanityManager.ASSERT(this.xc.getTransaction() == this);
        SanityManager.ASSERT(this.postCommitWorks == null || this.postCommitWorks.isEmpty(), "cannot close a transaction with post commit work pending");
        if (this.myGlobalId != null) {
            this.sanityCheck_xaclosed = true;
        }
        this.getLockFactory().clearLimit(this.compatibilitySpace, this);
        if (SanityManager.DEBUG_ON("XATrace")) {
            SanityManager.DEBUG("XATrace", "closing " + String.valueOf(this.myId) + " " + String.valueOf(this.myGlobalId));
        }
        if (this.myId != null) {
            this.xactFactory.remove((XactId)this.myId);
        }
        this.xc.popMe();
        this.xc = null;
        this.myGlobalId = null;
        this.myId = null;
        this.logStart = null;
        this.logLast = null;
        this.state = 0;
    }

    @Override
    public void logAndDo(Loggable operation) throws StandardException {
        LogInstant instant = null;
        if (this.logger == null) {
            this.getLogger();
        }
        if (this.logger == null) {
            throw StandardException.newException("XSTB2.M", new Object[0]);
        }
        this.setActiveState();
        if (this.state == 2) {
            instant = this.logger.logAndDo(this, new BeginXact(this.getGlobalId(), this.statusForBeginXactLog()));
            this.setUpdateState();
        }
        this.seenUpdates = true;
        if (operation != null) {
            instant = this.logger.logAndDo(this, operation);
            if (instant != null) {
                this.setLastLogInstant(instant);
                if (this.savePoints != null && !this.savePoints.empty()) {
                    SavePoint sp;
                    for (int i = this.savePoints.size() - 1; i >= 0 && (sp = (SavePoint)this.savePoints.elementAt(i)).getSavePoint() == null; --i) {
                        sp.setSavePoint(instant);
                    }
                }
            }
        } else if (instant != null) {
            this.setLastLogInstant(instant);
        }
    }

    @Override
    public void addPostCommitWork(Serviceable work) {
        if (this.recoveryTransaction) {
            return;
        }
        if (this.postCommitWorks == null) {
            this.postCommitWorks = new ArrayList<Serviceable>(1);
        }
        this.postCommitWorks.add(work);
    }

    @Override
    public void addPostAbortWork(Serviceable work) {
        if (this.recoveryTransaction) {
            return;
        }
        if (this.postAbortWorks == null) {
            this.postAbortWorks = new ArrayList<Serviceable>(1);
        }
        this.postAbortWorks.add(work);
    }

    @Override
    public void addPostTerminationWork(Serviceable work) {
        if (this.recoveryTransaction) {
            return;
        }
        if (this.postTerminationWorks == null) {
            this.postTerminationWorks = new ArrayList<Serviceable>(2);
        }
        this.postTerminationWorks.add(work);
    }

    @Override
    public ContainerHandle openContainer(ContainerKey containerId, int mode) throws StandardException {
        return this.openContainer(containerId, this.defaultLockingPolicy(), mode);
    }

    @Override
    public ContainerHandle openContainer(ContainerKey containerId, LockingPolicy locking, int mode) throws StandardException {
        this.setActiveState();
        if (locking == null) {
            locking = this.xactFactory.getLockingPolicy(0, 0, false);
        }
        return this.dataFactory.openContainer(this, containerId, locking, mode);
    }

    @Override
    public RawContainerHandle openDroppedContainer(ContainerKey containerId, LockingPolicy locking) throws StandardException {
        this.setActiveState();
        if (locking == null) {
            locking = this.xactFactory.getLockingPolicy(0, 0, false);
        }
        RawContainerHandle hdl = null;
        try {
            hdl = this.dataFactory.openDroppedContainer(this, containerId, locking, 4);
        }
        catch (StandardException se) {
            hdl = this.dataFactory.openDroppedContainer(this, containerId, locking, 8);
        }
        return hdl;
    }

    @Override
    public long addContainer(long segmentId, long containerid, int mode, Properties tableProperties, int temporaryFlag) throws StandardException {
        this.setActiveState();
        return this.dataFactory.addContainer(this, segmentId, containerid, mode, tableProperties, temporaryFlag);
    }

    @Override
    public long addAndLoadStreamContainer(long segmentId, Properties tableProperties, RowSource rowSource) throws StandardException {
        this.setActiveState();
        return this.dataFactory.addAndLoadStreamContainer(this, segmentId, tableProperties, rowSource);
    }

    @Override
    public StreamContainerHandle openStreamContainer(long segmentId, long containerId, boolean hold) throws StandardException {
        this.setActiveState();
        return this.dataFactory.openStreamContainer(this, segmentId, containerId, hold);
    }

    @Override
    public void dropStreamContainer(long segmentId, long containerId) throws StandardException {
        this.setActiveState();
        this.dataFactory.dropStreamContainer(this, segmentId, containerId);
    }

    @Override
    public void reCreateContainerForRedoRecovery(long segmentId, long containerId, ByteArray containerInfo) throws StandardException {
        this.setActiveState();
        this.dataFactory.reCreateContainerForRedoRecovery(this, segmentId, containerId, containerInfo);
    }

    @Override
    public void dropContainer(ContainerKey containerId) throws StandardException {
        this.setActiveState();
        this.dataFactory.dropContainer(this, containerId);
    }

    @Override
    public int setSavePoint(String name, Object kindOfSavepoint) throws StandardException {
        if (kindOfSavepoint != null && kindOfSavepoint instanceof String) {
            this.throwExceptionIfSQLSavepointNotAllowed(kindOfSavepoint);
        }
        if (this.getSavePointPosition(name, kindOfSavepoint, false) != -1) {
            throw StandardException.newException("3B501.S", new Object[0]);
        }
        if (this.savePoints == null) {
            this.savePoints = new Stack();
        }
        this.savePoints.push(new SavePoint(name, kindOfSavepoint));
        if (SanityManager.DEBUG_ON("memoryLeakTrace") && this.savePoints.size() > 20) {
            System.out.println("memoryLeakTrace:Xact:savepoints " + this.savePoints.size());
        }
        return this.savePoints.size();
    }

    private void throwExceptionIfSQLSavepointNotAllowed(Object kindOfSavepoint) throws StandardException {
        boolean foundUserSavepoint = false;
        if (this.savePoints != null && !this.savePoints.empty()) {
            for (int i = this.savePoints.size() - 1; i >= 0; --i) {
                SavePoint sp = (SavePoint)this.savePoints.elementAt(i);
                if (!sp.isThisUserDefinedsavepoint()) continue;
                foundUserSavepoint = true;
                break;
            }
        }
        if (foundUserSavepoint) {
            throw StandardException.newException("3B002.S", new Object[0]);
        }
    }

    @Override
    public int releaseSavePoint(String name, Object kindOfSavepoint) throws StandardException {
        int position = this.getSavePointPosition(name, kindOfSavepoint, true);
        if (position == -1) {
            if (kindOfSavepoint != null && !(kindOfSavepoint instanceof String)) {
                name = name.substring(2);
            }
            throw StandardException.newException("3B001.S", name);
        }
        this.popSavePoints(position, true);
        return this.savePoints.size();
    }

    @Override
    public int rollbackToSavePoint(String name, Object kindOfSavepoint) throws StandardException {
        int position = this.getSavePointPosition(name, kindOfSavepoint, true);
        if (position == -1) {
            if (kindOfSavepoint != null && !(kindOfSavepoint instanceof String)) {
                name = name.substring(2);
            }
            throw StandardException.newException("3B001.S", name);
        }
        this.notifyObservers(SAVEPOINT_ROLLBACK);
        this.popSavePoints(position, false);
        return this.savePoints.size();
    }

    private void getLogger() {
        this.logger = this.logFactory.getLogger();
    }

    protected void assumeIdentity(TransactionTableEntry ent) {
        if (ent != null) {
            SanityManager.ASSERT(ent.getXid() != null, "TTE.xid is null");
            SanityManager.ASSERT(ent.getFirstLog() != null, "TTE.firstLog is null");
            ent.setXact(this);
            this.myId = ent.getXid();
            this.logStart = ent.getFirstLog();
            this.logLast = ent.getLastLog();
            this.myGlobalId = null;
            if (this.state == 1) {
                this.state = 2;
            }
            if (this.state != 2 && this.state != 3 && this.state != 4) {
                SanityManager.THROWASSERT("recovery transaction have illegal state " + this.state + "xact = " + String.valueOf(this));
            }
            if (this.logger == null) {
                this.getLogger();
            }
            this.savedEndStatus = 0;
        } else {
            this.myGlobalId = null;
            this.myId = null;
            this.logStart = null;
            this.logLast = null;
            this.state = 1;
        }
    }

    protected void assumeGlobalXactIdentity(TransactionTableEntry ent) {
        SanityManager.ASSERT(ent != null);
        SanityManager.ASSERT(ent.getXid() != null, "TTE.xid is null");
        SanityManager.ASSERT(ent.getFirstLog() != null, "TTE.firstLog is null");
        SanityManager.ASSERT(ent.isPrepared());
        this.myId = ent.getXid();
        this.myGlobalId = ent.getGid();
        this.logStart = ent.getFirstLog();
        this.logLast = ent.getLastLog();
        if (this.state == 1) {
            if (SanityManager.DEBUG_ON("XATrace")) {
                SanityManager.DEBUG("XATrace", "set active state in assume Global XactIdentity");
            }
            this.state = 2;
        }
        if (ent.isPrepared()) {
            this.state = 4;
        }
        ent.setXact(this);
        if (this.state != 2 && this.state != 3 && this.state != 4) {
            SanityManager.THROWASSERT("recovery transaction have illegal state " + this.state + "xact = " + String.valueOf(this));
        }
        if (this.logger == null) {
            this.getLogger();
        }
        this.savedEndStatus = 0;
        SanityManager.ASSERT(this.myGlobalId != null);
        SanityManager.ASSERT(this.state == 4);
    }

    private final void setUpdateState() throws StandardException {
        SanityManager.ASSERT(this.state == 2, "setting update state without first going thru ACTIVE state");
        SanityManager.ASSERT(this.myId != null, "setting update state to a trasnaction with Null ID");
        if (SanityManager.DEBUG_ON("XATrace")) {
            SanityManager.DEBUG("XATrace", "set update state");
            SanityManager.showTrace(new Throwable());
        }
        if (this.readOnly) {
            throw StandardException.newException("40XT8", this.toInternalDetailString());
        }
        this.state = 3;
    }

    protected void setIdleState() {
        SanityManager.ASSERT(this.myId != null, "setIdleState got null ID");
        if (SanityManager.DEBUG_ON("TranTrace")) {
            SanityManager.DEBUG("TranTrace", "transaction going idle " + String.valueOf(this.myId));
            SanityManager.showTrace(new Throwable("TranTrace"));
        }
        this.state = 1;
        this.seenUpdates = false;
        this.logStart = null;
        this.logLast = null;
        if (SanityManager.DEBUG_ON("XATrace")) {
            SanityManager.DEBUG("XATrace", "set idle state : " + this.state + " " + String.valueOf(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setActiveState() throws StandardException {
        if (this.state == 0 || !this.inAbort() && this.state == 4) {
            throw StandardException.newException("40XT8", this.toInternalDetailString());
        }
        SanityManager.ASSERT(this.myId != null, "setActiveState got null ID");
        if (this.state == 1) {
            Xact xact = this;
            synchronized (xact) {
                this.state = 2;
            }
            if (SanityManager.DEBUG_ON("XATrace")) {
                SanityManager.DEBUG("XATrace", "set active state " + String.valueOf(this));
                SanityManager.showTrace(new Throwable("XATrace"));
            }
            if (!this.justCreated) {
                this.xactFactory.setNewTransactionId(this.myId, this);
            }
            this.justCreated = false;
            if (SanityManager.DEBUG_ON("TranTrace")) {
                SanityManager.DEBUG("TranTrace", "transaction going active " + String.valueOf(this.myId));
                SanityManager.showTrace(new Throwable("TranTrace"));
            }
        }
    }

    protected final void setPrepareState() throws StandardException {
        if (this.state == 4 || this.state == 0) {
            throw StandardException.newException("40XT8", this.toInternalDetailString());
        }
        SanityManager.ASSERT(this.state == 3, "setting PREPARED state without first going thru UPDATE state");
        SanityManager.ASSERT(this.myId != null, "setting PREPARED state to a transaction with Null ID");
        this.state = 4;
    }

    public final LockingPolicy defaultLockingPolicy() {
        return this.defaultLocking;
    }

    private final void releaseAllLocks() {
        this.getLockFactory().unlockGroup(this.getCompatibilitySpace(), this);
    }

    void resetDefaultLocking() {
        this.setDefaultLockingPolicy(this.newLockingPolicy(1, 5, true));
        SanityManager.ASSERT(this.defaultLocking != null);
    }

    protected void preComplete(Integer commitOrAbort) throws StandardException {
        if (this.inComplete != null) {
            if (commitOrAbort.equals(COMMIT)) {
                throw this.logFactory.markCorrupt(StandardException.newException("40XT1", new Object[0]));
            }
            throw this.logFactory.markCorrupt(StandardException.newException("XSTB0.M", new Object[0]));
        }
        this.inComplete = commitOrAbort;
        if (!this.postCompleteMode) {
            this.doComplete(commitOrAbort);
        }
    }

    protected void postComplete(int commitflag, Integer commitOrAbort) throws StandardException {
        if (this.postCompleteMode) {
            this.doComplete(commitOrAbort);
        }
        if ((commitflag & 2) == 0) {
            this.releaseAllLocks();
        } else {
            SanityManager.ASSERT(commitOrAbort.equals(COMMIT), "cannot keep locks around after an ABORT");
        }
        this.setIdleState();
        this.inComplete = null;
    }

    protected void doComplete(Integer commitOrAbort) throws StandardException {
        if (this.savePoints != null) {
            this.savePoints.removeAllElements();
        }
        do {
            this.notifyObservers(commitOrAbort);
            this.checkObserverException();
        } while (this.countObservers() > 0);
    }

    private void checkObserverException() throws StandardException {
        if (this.observerException != null) {
            StandardException se = this.observerException;
            this.observerException = null;
            throw se;
        }
    }

    protected boolean doPostCommitWorkInTran() {
        return !this.inPostCommitProcessing && !this.recoveryTransaction && this.isUserTransaction() && this.myGlobalId == null;
    }

    @Override
    public boolean handlesPostTerminationWork() {
        return !this.recoveryTransaction;
    }

    @Override
    public void recoveryTransaction() {
        this.recoveryTransaction = true;
        this.xactFactory.remove(this.myId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferPostCommitorAbortWork(List<Serviceable> work_list) throws StandardException {
        if (work_list != null && !work_list.isEmpty()) {
            int pcsize = work_list.size();
            if (this.doPostCommitWorkInTran()) {
                try {
                    this.inPostCommitProcessing = true;
                    Serviceable[] work = new Serviceable[pcsize];
                    work = work_list.toArray(work);
                    work_list.clear();
                    boolean doWorkInThisThread = this.xactFactory.inDatabaseCreation();
                    for (int i = 0; i < pcsize; ++i) {
                        if (doWorkInThisThread || work[i].serviceImmediately()) {
                            try {
                                if (work[i].performWork(this.xc.getContextManager()) == 1) {
                                    work[i] = null;
                                }
                            }
                            catch (StandardException se) {
                                work[i] = null;
                                this.xc.cleanupOnError(se);
                            }
                        }
                        if (work[i] == null) continue;
                        boolean needHelp = this.xactFactory.submitPostCommitWork(work[i]);
                        work[i] = null;
                        if (!needHelp) continue;
                        doWorkInThisThread = true;
                    }
                }
                finally {
                    this.inPostCommitProcessing = false;
                    if (work_list != null) {
                        work_list.clear();
                    }
                }
            }
            for (int i = 0; i < pcsize; ++i) {
                this.xactFactory.submitPostCommitWork(work_list.get(i));
            }
            work_list.clear();
        }
    }

    private final void postTermination() throws StandardException {
        int count = this.postTerminationWorks == null ? 0 : this.postTerminationWorks.size();
        for (int i = 0; i < count; ++i) {
            this.addPostCommitWork(this.postTerminationWorks.get(i));
        }
        if (count > 0) {
            this.postTerminationWorks.clear();
        }
        this.transferPostCommitorAbortWork(this.postCommitWorks);
        this.transferPostCommitorAbortWork(this.postAbortWorks);
        this.unblockBackup();
    }

    private int getSavePointPosition(String name, Object kindOfSavepoint, boolean forRollbackOrRelease) {
        if (this.savePoints == null || this.savePoints.empty()) {
            return -1;
        }
        for (int i = this.savePoints.size() - 1; i >= 0; --i) {
            SavePoint savepoint = (SavePoint)this.savePoints.elementAt(i);
            if (!savepoint.getName().equals(name)) continue;
            if (forRollbackOrRelease && savepoint.getKindOfSavepoint() != null) {
                if (!savepoint.getKindOfSavepoint().equals(kindOfSavepoint)) continue;
                return i;
            }
            return i;
        }
        return -1;
    }

    protected boolean popSavePoints(int position, boolean release) throws StandardException {
        if (release) {
            this.savePoints.setSize(position);
            return false;
        }
        LogInstant rollbackTo = null;
        int size = this.savePoints.size();
        for (int i = position; i < size; ++i) {
            SavePoint rollbackSavePoint = (SavePoint)this.savePoints.elementAt(i);
            LogInstant li = rollbackSavePoint.getSavePoint();
            if (li == null) continue;
            rollbackTo = li;
            break;
        }
        this.savePoints.setSize(position + 1);
        if (rollbackTo == null) {
            return false;
        }
        try {
            this.logger.undo(this, this.getId(), rollbackTo, this.getLastLogInstant());
        }
        catch (StandardException se) {
            if (se.getSeverity() < 30000) {
                throw StandardException.newException("40XT2", se, new Object[0]);
            }
            throw se;
        }
        return true;
    }

    @Override
    public RawTransaction startNestedTopTransaction() throws StandardException {
        return this.xactFactory.startNestedTopTransaction(this.xc.getFactory(), this.xc.getContextManager());
    }

    private boolean isUserTransaction() {
        String context_id = this.getContextId();
        return context_id == "UserTransaction" || context_id.equals("UserTransaction");
    }

    public final boolean isActive() {
        int localState = this.state;
        return localState != 0 && localState != 1;
    }

    public final boolean isPrepared() {
        return this.state == 4;
    }

    @Override
    public boolean isIdle() {
        if (SanityManager.DEBUG_ON("XATrace")) {
            SanityManager.DEBUG("XATrace", "RawTran, isIdle, state = " + this.state);
        }
        return this.state == 1;
    }

    @Override
    public boolean isPristine() {
        return this.state == 1 || this.state == 2;
    }

    @Override
    public boolean inAbort() {
        return ABORT.equals(this.inComplete);
    }

    @Override
    public FileResource getFileHandler() {
        return this.dataFactory.getFileHandler();
    }

    @Override
    protected int statusForBeginXactLog() {
        return this.recoveryRollbackFirst() ? 16 : 0;
    }

    @Override
    protected int statusForEndXactLog() {
        return this.savedEndStatus;
    }

    void setPostComplete() {
        this.postCompleteMode = true;
    }

    @Override
    public boolean blockBackup(boolean wait) throws StandardException {
        if (!this.backupBlocked) {
            this.backupBlocked = this.xactFactory.blockBackup(wait);
        }
        return this.backupBlocked;
    }

    private void unblockBackup() {
        if (this.backupBlocked) {
            this.xactFactory.unblockBackup();
        }
        this.backupBlocked = false;
    }

    @Override
    public boolean isBlockingBackup() {
        return this.backupBlocked;
    }

    @Override
    public void reached(CompatibilitySpace compatibilitySpace, Object group, int limit, Enumeration lockList, int lockCount) throws StandardException {
        Hashtable<ContainerKey, LockCount> containers = new Hashtable<ContainerKey, LockCount>();
        while (lockList.hasMoreElements()) {
            Object plainLock = lockList.nextElement();
            if (!(plainLock instanceof RecordHandle)) continue;
            ContainerKey ckey = ((RecordHandle)plainLock).getContainerId();
            LockCount lc = (LockCount)((Dictionary)containers).get(ckey);
            if (lc == null) {
                lc = new LockCount();
                ((Dictionary)containers).put(ckey, lc);
            }
            ++lc.count;
        }
        int threshold = limit / (((Dictionary)containers).size() + 1);
        if (threshold < limit / 4) {
            threshold = limit / 4;
        }
        boolean didEscalate = false;
        Enumeration e = ((Dictionary)containers).keys();
        while (e.hasMoreElements()) {
            ContainerKey ckey = (ContainerKey)e.nextElement();
            LockCount lc = (LockCount)((Dictionary)containers).get(ckey);
            if (lc.count < threshold) continue;
            try {
                if (this.openContainer(ckey, new RowLocking3Escalate(this.getLockFactory()), 196) == null) continue;
                didEscalate = true;
            }
            catch (StandardException se) {
                if (se.isLockTimeout()) continue;
                throw se;
            }
        }
        if (didEscalate) {
            this.notifyObservers(LOCK_ESCALATE);
            this.checkObserverException();
        }
    }

    @Override
    public void createXATransactionFromLocalTransaction(int format_id, byte[] global_id, byte[] branch_id) throws StandardException {
        GlobalXactId gid = new GlobalXactId(format_id, global_id, branch_id);
        if (((TransactionTable)this.xactFactory.getTransactionTable()).findTransactionContextByGlobalId(gid) != null) {
            throw StandardException.newException("XSAX1.S", new Object[0]);
        }
        this.setTransactionId(gid, this.getId());
        SanityManager.ASSERT(this.myGlobalId != null);
    }

    @Override
    public void xa_commit(boolean onePhase) throws StandardException {
        SanityManager.ASSERT(this.state != 0);
        if (onePhase) {
            if (this.state == 4) {
                throw StandardException.newException("40XT8", this.toInternalDetailString());
            }
            this.prepareCommit(65536);
            this.completeCommit(65536);
        } else {
            if (this.state != 4) {
                throw StandardException.newException("40XT8", this.toInternalDetailString());
            }
            this.prepareCommit(65536);
            this.completeCommit(65536);
        }
    }

    @Override
    public int xa_prepare() throws StandardException {
        if (this.state == 0) {
            SanityManager.THROWASSERT("state = " + this.state + ";myGlobalId = " + String.valueOf(this.myGlobalId));
        }
        if (SanityManager.DEBUG_ON("XATrace")) {
            SanityManager.DEBUG("XATrace", "in xa_prepare, state is " + this.state);
        }
        if (this.state == 1 || this.state == 2) {
            this.abort();
            return 1;
        }
        this.prepareCommit(327682);
        this.inComplete = null;
        this.setPrepareState();
        return 2;
    }

    @Override
    public void xa_rollback() throws StandardException {
        SanityManager.ASSERT(this.state != 0);
        this.abort();
    }

    public String toString() {
        try {
            return this.myId.toString();
        }
        catch (Throwable t) {
            return "null";
        }
    }

    public String toInternalDetailString() {
        return "savedEndStatus = " + this.savedEndStatus + "\nneedSync = " + this.needSync + "\njustCreated = " + this.justCreated + "\nmyGlobalId = " + String.valueOf(this.myGlobalId) + "\nmyId = " + String.valueOf(this.myId) + "\nstate = " + this.state + "\ninComplete = " + this.inComplete + "\nseenUpdates = " + this.seenUpdates + "\ninPostCommitProcessing = " + this.inPostCommitProcessing + "\nlogStart = " + String.valueOf(this.logStart) + "\nlogLast = " + String.valueOf(this.logLast) + "\nrecoveryTransaction = " + this.recoveryTransaction + "\npostCompleteMode = " + this.postCompleteMode + "\nsanityCheck_xaclosed = " + this.sanityCheck_xaclosed + "\ntransName = " + this.transName + "\nreadOnly = " + this.readOnly + "\nflush_log_on_xact_end = " + this.flush_log_on_xact_end + "\nbackupBlocked = " + this.backupBlocked + "\ndontWaitForLocks = " + this.dontWaitForLocks + "\n";
    }

    @Override
    public String getActiveStateTxIdString() {
        if (!this.justCreated && this.state == 1) {
            this.xactFactory.setNewTransactionId(this.myId, this);
            this.justCreated = true;
        }
        return this.toString();
    }

    @Override
    public DataValueFactory getDataValueFactory() throws StandardException {
        return this.dataValueFactory;
    }

    String getState() {
        int localState = this.state;
        switch (localState) {
            case 0: {
                return "CLOSED";
            }
            case 1: {
                return "IDLE";
            }
            case 2: 
            case 3: {
                return "ACTIVE";
            }
            case 4: {
                return "PREPARED";
            }
        }
        return null;
    }

    public String getTransName() {
        return this.transName;
    }

    public void setTransName(String name) {
        this.transName = name;
    }

    @Override
    public boolean inRollForwardRecovery() {
        return this.logFactory.inRFR();
    }

    @Override
    public void checkpointInRollForwardRecovery(LogInstant cinstant, long redoLWM, long undoLWM) throws StandardException {
        this.logFactory.checkpointInRFR(cinstant, redoLWM, undoLWM, this.dataFactory);
    }

    @Override
    public boolean isNestedOwner() {
        return this.parentTransactionId != null;
    }

    @Override
    public boolean nestsUnder(LockOwner other) {
        if (this.parentTransactionId == null) {
            return false;
        }
        if (!(other instanceof Xact)) {
            return false;
        }
        return this.parentTransactionId.equals(((Xact)other).getId());
    }
}

