/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.sql.Connection;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import javax.sql.XADataSource;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class JDBC4FromJDBC3DataSourceTest
extends BaseJDBCTestCase {
    public JDBC4FromJDBC3DataSourceTest(String name) {
        super(name);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJDBC4() && JDBC.vmSupportsJNDI()) {
            return TestConfiguration.forceJDBC3Suite(JDBC4FromJDBC3DataSourceTest.class);
        }
        return new BaseTestSuite("JDBC 4 from JDBC 3 Data Sources");
    }

    public void testPooledConnection() throws Exception {
        ConnectionPoolDataSource ds = J2EEDataSource.getConnectionPoolDataSource();
        this.checkJDBC4Interface(ds.getPooledConnection());
    }

    public void testXAConnection() throws Exception {
        XADataSource ds = J2EEDataSource.getXADataSource();
        this.checkJDBC4Interface(ds.getXAConnection());
    }

    private void checkJDBC4Interface(PooledConnection pc) throws Exception {
        StatementEventListener listener = new StatementEventListener(this){

            @Override
            public void statementClosed(StatementEvent event) {
            }

            @Override
            public void statementErrorOccurred(StatementEvent event) {
            }
        };
        Connection conn = pc.getConnection();
        JDBC4FromJDBC3DataSourceTest.assertEquals((int)4, (int)conn.getMetaData().getJDBCMajorVersion());
        conn.close();
        conn = null;
        pc.addStatementEventListener(listener);
        pc.removeStatementEventListener(listener);
        pc.close();
    }
}

