/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.sql.DataSource;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.OldVersions;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Version;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.ClassLoaderTestSetup;
import org.apache.derbyTesting.junit.JDBCClient;
import org.apache.derbyTesting.junit.JDBCClientSetup;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UpgradeTrajectoryTest
extends BaseJDBCTestCase {
    public static final String ALL_TRAJECTORIES_PROPERTY = "derbyTesting.allTrajectories";
    public static Version VERSION_10_0_2_1 = new Version(10, 0, 2, 1);
    public static Version VERSION_10_1_3_1 = new Version(10, 1, 3, 1);
    public static Version VERSION_10_2_2_0 = new Version(10, 2, 2, 0);
    public static Version VERSION_10_5_1_1 = new Version(10, 5, 1, 1);
    public static Version VERSION_10_6_0_0 = new Version(10, 6, 0, 0);
    public static Version.Trajectory TRAJECTORY_10_0_2_1_TO_10_1_3_1 = new Version.Trajectory(new Version[]{VERSION_10_0_2_1, VERSION_10_1_3_1});
    public static String BRANCH_10_0 = "10.0";
    public static String BRANCH_10_1 = "10.1";
    public static String BRANCH_10_2 = "10.2";
    public static String BRANCH_10_3 = "10.3";
    public static String BRANCH_10_4 = "10.4";
    public static String BRANCH_10_5 = "10.5";
    public static final String UPGRADED_DATABASE = "old_database";
    public static final String VIRGIN_DATABASE = "new_database";
    public static final String COMPARISON_DATABASE = "comparison_database";
    private static final String DUMMY_NUMBER = "123";
    private static final String DUMMY_STRING = "BLAHBLAH";
    private static final String DUMMY_TIMESTAMP = "123456";
    private static final String DERBY_4214_1 = "RETURNS VARCHAR(32672)";
    private static final String DERBY_4214_2 = "RETURNS VARCHAR(10890)";
    private static final String DERBY_4215 = "SYSCS_INPLACE_COMPRESS_TABLE";
    private static final boolean TRJ_IGNORE_SOFT_UPGRADE = true;
    private static final boolean TRJ_SAME_BRANCH_NEIGHBORS = false;
    private static final String SYSALIASES = "SYSALIASES";
    private static final String SYSCONGLOMERATES = "SYSCONGLOMERATES";
    private static final String SYSSTATEMENTS = "SYSSTATEMENTS";
    private static final String SYSROUTINEPERMS = "SYSROUTINEPERMS";
    private static final String CONGLOMERATENUMBER = "CONGLOMERATENUMBER";
    private static final String ALIAS = "ALIAS";
    private static final String ALIASID = "ALIASID";
    private static final String SPECIFICNAME = "SPECIFICNAME";
    private static final String STMTID = "STMTID";
    private static final String STMTNAME = "STMTNAME";
    private static final String TEXT = "TEXT";
    private static final String ROUTINEPERMSID = "ROUTINEPERMSID";
    private static final String LASTCOMPILED = "LASTCOMPILED";
    private static final boolean LOQUACIOUS = false;
    private Version.Trajectory _trajectory;
    private String _trajectoryName;
    private boolean[] _hardUpgradeRequests;
    private HashMap<String, String> _unstableColumnValues = new HashMap();
    private static ThreadLocal<ClassLoader> _originalClassLoader = new ThreadLocal();
    private static String[] INITIAL_TABLES = new String[]{"SYSALIASES"};

    public UpgradeTrajectoryTest(Version.Trajectory trajectory, boolean[] hardUpgradeRequests) {
        super("testTrajectory");
        this._trajectory = trajectory;
        this._hardUpgradeRequests = hardUpgradeRequests;
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("Upgrade trajectory test");
        UpgradeTrajectoryTest.addTrajectories(suite);
        SupportFilesSetup sfs = new SupportFilesSetup((Test)suite);
        return sfs;
    }

    private static void addTrajectories(BaseTestSuite suite) {
        Version.Trajectory[] trajectories = UpgradeTrajectoryTest.makeTrajectories();
        int count = trajectories.length;
        UpgradeTrajectoryTest.println("Found " + count + " trajectories.");
        for (int i = 0; i < count; ++i) {
            UpgradeTrajectoryTest.addHardUpgradeOnlyTrajectory(suite, trajectories[i]);
        }
    }

    private static Version.Trajectory[] makeTrajectories() {
        Version[] supportedVersions = UpgradeTrajectoryTest.getSupportedVersions();
        Version.Trajectory[] result = UpgradeTrajectoryTest.shouldBuildAllTrajectories() ? UpgradeTrajectoryTest.buildPowerSet(supportedVersions) : UpgradeTrajectoryTest.buildMinimalSet(supportedVersions);
        return result;
    }

    private static boolean shouldBuildAllTrajectories() {
        Boolean bool = Boolean.valueOf(UpgradeTrajectoryTest.getSystemProperty(ALL_TRAJECTORIES_PROPERTY));
        return bool;
    }

    private static Version.Trajectory[] makeSampleTrajectories() {
        return new Version.Trajectory[]{new Version.Trajectory(new Version[]{new Version(10, 0, 2, 1), new Version(10, 1, 3, 1)}), new Version.Trajectory(new Version[]{new Version(10, 0, 2, 1), new Version(10, 3, 3, 0)}), new Version.Trajectory(new Version[]{new Version(10, 0, 2, 1), new Version(10, 3, 3, 0), new Version(10, 5, 1, 1)}), new Version.Trajectory(new Version[]{new Version(10, 0, 2, 1), new Version(10, 3, 3, 0), new Version(10, 6, 0, 0)}), new Version.Trajectory(new Version[]{new Version(10, 0, 2, 1), new Version(10, 5, 1, 1)}), new Version.Trajectory(new Version[]{new Version(10, 4, 2, 1), new Version(10, 5, 1, 1)})};
    }

    private static Version[] getSupportedVersions() {
        int[][] raw = OldVersions.getSupportedVersions();
        int count = raw.length;
        Version[] result = new Version[count];
        for (int i = 0; i < count; ++i) {
            result[i] = new Version(raw[i]);
        }
        return result;
    }

    private static void addHardUpgradeOnlyTrajectory(BaseTestSuite suite, Version.Trajectory trajectory) {
        int versionCount = trajectory.getVersionCount();
        if (versionCount < 2) {
            return;
        }
        boolean[] hardUpgradeRequests = new boolean[versionCount];
        for (int i = 0; i < versionCount; ++i) {
            hardUpgradeRequests[i] = true;
        }
        UpgradeTrajectoryTest.addTrajectory(suite, trajectory, hardUpgradeRequests);
    }

    private static void addTrajectory(BaseTestSuite suite, Version.Trajectory trajectory) {
        int versionCount = trajectory.getVersionCount();
        if (versionCount < 2) {
            return;
        }
        boolean[] hardUpgradeRequests = new boolean[versionCount];
        hardUpgradeRequests[0] = true;
        UpgradeTrajectoryTest.addTrajectory(suite, trajectory, hardUpgradeRequests, 1);
    }

    private static void addTrajectory(BaseTestSuite suite, Version.Trajectory trajectory, boolean[] hardUpgradeRequests, int idx) {
        if (idx >= trajectory.getVersionCount()) {
            UpgradeTrajectoryTest.addTrajectory(suite, trajectory, hardUpgradeRequests);
        } else {
            boolean[] hard = UpgradeTrajectoryTest.clone(hardUpgradeRequests);
            boolean[] soft = UpgradeTrajectoryTest.clone(hardUpgradeRequests);
            hard[idx] = true;
            UpgradeTrajectoryTest.addTrajectory(suite, trajectory, hard, idx + 1);
            soft[idx] = false;
            UpgradeTrajectoryTest.addTrajectory(suite, trajectory, soft, idx + 1);
        }
    }

    private static boolean[] clone(boolean[] input) {
        int count = input.length;
        boolean[] output = new boolean[count];
        for (int i = 0; i < count; ++i) {
            output[i] = input[i];
        }
        return output;
    }

    private static void addTrajectory(BaseTestSuite suite, Version.Trajectory trajectory, boolean[] hardUpgradeRequests) {
        UpgradeTrajectoryTest utt = new UpgradeTrajectoryTest(trajectory, hardUpgradeRequests);
        TestSetup setup = TestConfiguration.additionalDatabaseDecorator((Test)utt, UPGRADED_DATABASE);
        setup = TestConfiguration.additionalDatabaseDecorator((Test)setup, VIRGIN_DATABASE);
        setup = TestConfiguration.additionalDatabaseDecorator((Test)setup, COMPARISON_DATABASE);
        Properties preReleaseUpgrade = new Properties();
        preReleaseUpgrade.setProperty("derby.database.allowPreReleaseUpgrade", "true");
        setup = new SystemPropertyTestSetup((Test)setup, preReleaseUpgrade);
        if (trajectory.getVersion(0).compareTo(VERSION_10_2_2_0) < 0) {
            setup = new JDBCClientSetup((Test)setup, JDBCClient.EMBEDDED_30);
        }
        suite.addTest((Test)setup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTrajectory() throws Exception {
        this._trajectoryName = this._trajectory.toString() + " " + this.stringifyUpgradeRequests();
        UpgradeTrajectoryTest.println("Testing trajectory: " + this._trajectoryName);
        int versionCount = this._trajectory.getVersionCount();
        UpgradeTrajectoryTest.assertTrue((String)this._trajectoryName, (versionCount > 1 ? 1 : 0) != 0);
        this.saveOriginalClassLoader();
        try {
            Version startDataVersion;
            Version endDataVersion = startDataVersion = this._trajectory.getVersion(0);
            this.createDatabase(startDataVersion, UPGRADED_DATABASE);
            for (int i = 1; i < versionCount; ++i) {
                Version nextSoftwareVersion = this._trajectory.getVersion(i);
                boolean hardUpgrade = this._hardUpgradeRequests[i];
                if (hardUpgrade) {
                    endDataVersion = nextSoftwareVersion;
                }
                this.upgradeDatabase(nextSoftwareVersion, endDataVersion, hardUpgrade, UPGRADED_DATABASE);
            }
            this.createDatabase(endDataVersion, VIRGIN_DATABASE);
            this.compareDatabases(endDataVersion, UPGRADED_DATABASE, VIRGIN_DATABASE);
        }
        finally {
            this.restoreOriginalClassLoader();
            this.bootDatabase(UPGRADED_DATABASE);
            this.bootDatabase(VIRGIN_DATABASE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compareDatabases(Version version, String leftDatabaseName, String rightDatabaseName) throws Exception {
        ClassLoaderTestSetup.setThreadLoader(version.getClassLoader());
        DataSource leftDS = this.makeDataSource(leftDatabaseName);
        DataSource rightDS = this.makeDataSource(rightDatabaseName);
        DataSource comparisonDS = this.bootDatabase(COMPARISON_DATABASE);
        Connection leftConn = leftDS.getConnection();
        Connection rightConn = rightDS.getConnection();
        Connection comparisonConn = comparisonDS.getConnection();
        try {
            this.goodStatement(comparisonConn, "create schema " + leftDatabaseName);
            this.goodStatement(comparisonConn, "create schema " + rightDatabaseName);
            this.compareResults(leftConn, rightConn, comparisonConn, leftDatabaseName, rightDatabaseName, "first_table", "select tablename from sys.systables where tabletype = 'S'");
            for (String systemTableName : INITIAL_TABLES) {
                this.compareResults(leftConn, rightConn, comparisonConn, leftDatabaseName, rightDatabaseName, systemTableName, "select * from sys." + systemTableName);
            }
            ArrayList<String> systemTables = this.listSystemTables(comparisonConn);
            int count = systemTables.size();
            for (int i = 0; i < count; ++i) {
                String systemTableName = systemTables.get(i);
                this.compareResults(leftConn, rightConn, comparisonConn, leftDatabaseName, rightDatabaseName, systemTableName, "select * from sys." + systemTableName);
            }
        }
        finally {
            this.shutdownDatabase(leftDS);
            this.shutdownDatabase(rightDS);
            this.shutdownDatabase(comparisonDS);
        }
    }

    private ArrayList<String> listSystemTables(Connection conn) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        buffer.append("select tablename from sys.systables where tabletype = 'S' and tablename != 'SYSDUMMY1'");
        int initialTableCount = INITIAL_TABLES.length;
        for (int i = 0; i < initialTableCount; ++i) {
            buffer.append(" and tablename != '");
            buffer.append(INITIAL_TABLES[i]);
            buffer.append("'");
        }
        buffer.append(" order by tablename");
        PreparedStatement ps = this.chattyPrepare(conn, buffer.toString());
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.add(rs.getString(1));
        }
        rs.close();
        ps.close();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compareResults(Connection leftConn, Connection rightConn, Connection comparisonConn, String leftSchema, String rightSchema, String tableName, String query) throws Exception {
        String leftTableName = leftSchema + "." + tableName;
        String rightTableName = rightSchema + "." + tableName;
        StringBuffer columnList = new StringBuffer();
        StringBuffer insertList = new StringBuffer();
        ArrayList<String> columnNames = new ArrayList<String>();
        PreparedStatement leftPS = this.chattyPrepare(leftConn, query);
        PreparedStatement rightPS = this.chattyPrepare(rightConn, query);
        ResultSet leftSelect = leftPS.executeQuery();
        ResultSet rightSelect = rightPS.executeQuery();
        Statement leftInsert = null;
        Statement rightInsert = null;
        try {
            ResultSetMetaData leftRSMD = leftSelect.getMetaData();
            ResultSetMetaData rightRSMD = rightSelect.getMetaData();
            int columnCount = leftRSMD.getColumnCount();
            String sampleColumnName = null;
            UpgradeTrajectoryTest.assertEquals((String)this._trajectoryName, (int)leftRSMD.getColumnCount(), (int)rightRSMD.getColumnCount());
            columnList.append("\n( ");
            insertList.append("\n( ");
            for (int i = 1; i <= columnCount; ++i) {
                if (i > 1) {
                    columnList.append(", ");
                    insertList.append(", ");
                }
                String columnName = leftRSMD.getColumnName(i);
                if (i == 1) {
                    sampleColumnName = columnName;
                }
                columnNames.add(columnName);
                UpgradeTrajectoryTest.assertEquals((String)this._trajectoryName, (String)leftRSMD.getColumnName(i), (String)rightRSMD.getColumnName(i));
                UpgradeTrajectoryTest.assertEquals((String)this._trajectoryName, (int)leftRSMD.getColumnType(i), (int)rightRSMD.getColumnType(i));
                columnList.append(columnName);
                columnList.append(" varchar( 10000 )");
                insertList.append("?");
            }
            columnList.append("\n)");
            insertList.append("\n)");
            String colList = columnList.toString();
            String insList = insertList.toString();
            this.goodStatement(comparisonConn, "create table " + leftTableName + colList);
            this.goodStatement(comparisonConn, "create table " + rightTableName + colList);
            leftInsert = this.chattyPrepare(comparisonConn, "insert into " + leftTableName + " values " + insList);
            rightInsert = this.chattyPrepare(comparisonConn, "insert into " + rightTableName + " values " + insList);
            int leftCount = this.stuffTable(tableName, leftSelect, (PreparedStatement)leftInsert);
            int rightCount = this.stuffTable(tableName, rightSelect, (PreparedStatement)rightInsert);
            if (!this.suffersDERBY_4215(tableName) && !this.suffersDERBY_4216(tableName)) {
                UpgradeTrajectoryTest.assertEquals((String)(this._trajectoryName + ": " + tableName), (int)leftCount, (int)rightCount);
            } else {
                UpgradeTrajectoryTest.assertTrue((String)(this._trajectoryName + ": " + tableName), (leftCount != rightCount ? 1 : 0) != 0);
            }
            this.leftJoin(comparisonConn, columnNames, tableName, leftTableName, rightTableName);
            if (!this.suffersDERBY_4216(tableName)) {
                this.leftJoin(comparisonConn, columnNames, tableName, rightTableName, leftTableName);
            }
        }
        finally {
            leftSelect.close();
            rightSelect.close();
            leftPS.close();
            rightPS.close();
            if (leftInsert != null) {
                leftInsert.close();
            }
            if (rightInsert != null) {
                rightInsert.close();
            }
        }
    }

    private int stuffTable(String tableName, ResultSet select, PreparedStatement insert) throws Exception {
        ResultSetMetaData rsmd = select.getMetaData();
        int columnCount = rsmd.getColumnCount();
        int rowCount = 0;
        String[] columnNames = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            columnNames[i] = rsmd.getColumnName(i + 1);
        }
        String[] row = new String[columnCount];
        while (select.next()) {
            int i;
            for (i = 0; i < columnCount; ++i) {
                row[i] = select.getString(i + 1);
            }
            this.normalizeRow(tableName, columnNames, row);
            for (i = 0; i < columnCount; ++i) {
                insert.setString(i + 1, row[i]);
            }
            insert.executeUpdate();
            ++rowCount;
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leftJoin(Connection conn, ArrayList columnNames, String tableName, String leftTableName, String rightTableName) throws Exception {
        PreparedStatement selectPS = null;
        ResultSet select = null;
        String sampleColumn = (String)columnNames.get(0);
        StringBuffer buffer = new StringBuffer();
        buffer.append("select *\nfrom ");
        buffer.append(leftTableName);
        buffer.append(" l left join ");
        buffer.append(rightTableName);
        buffer.append(" r\non ");
        int count = columnNames.size();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append("and ");
            }
            String columnName = (String)columnNames.get(i);
            buffer.append("( ( l.");
            buffer.append(columnName);
            buffer.append(" = r.");
            buffer.append(columnName);
            buffer.append(" ) or ( l.");
            buffer.append(columnName);
            buffer.append(" is null and r.");
            buffer.append(columnName);
            buffer.append(" is null ) )\n");
        }
        buffer.append("where r.");
        buffer.append(sampleColumn);
        buffer.append(" is null");
        try {
            selectPS = this.chattyPrepare(conn, buffer.toString());
            select = selectPS.executeQuery();
            String expected = "";
            String actual = this.filterKnownProblems(tableName, this.printResultSet(select));
            UpgradeTrajectoryTest.assertEquals((String)(this._trajectoryName + ": " + leftTableName + " vs. " + rightTableName), (String)expected, (String)actual);
        }
        finally {
            if (select != null) {
                select.close();
            }
            if (selectPS != null) {
                selectPS.close();
            }
        }
    }

    private void createDatabase(Version version, String logicalDatabaseName) throws Exception {
        ClassLoaderTestSetup.setThreadLoader(version.getClassLoader());
        DataSource ds = this.bootDatabase(logicalDatabaseName);
        Connection conn = ds.getConnection();
        this.vetDBVersion(version, version, conn);
        this.shutdownDatabase(ds);
    }

    private void upgradeDatabase(Version softwareVersion, Version dataVersion, boolean hardUpgrade, String logicalDatabaseName) throws Exception {
        ClassLoaderTestSetup.setThreadLoader(softwareVersion.getClassLoader());
        DataSource ds = this.upgradeDatabase(logicalDatabaseName, hardUpgrade);
        Connection conn = ds.getConnection();
        this.vetDBVersion(softwareVersion, dataVersion, conn);
        this.shutdownDatabase(ds);
    }

    private DataSource bootDatabase(String logicalDatabaseName) throws Exception {
        DataSource ds = this.makeDataSource(logicalDatabaseName);
        Method setMethod = ds.getClass().getMethod("setCreateDatabase", String.class);
        setMethod.invoke((Object)ds, "create");
        Connection conn = ds.getConnection();
        return ds;
    }

    private DataSource upgradeDatabase(String logicalDatabaseName, boolean hardUpgrade) throws Exception {
        DataSource ds = this.makeDataSource(logicalDatabaseName);
        if (hardUpgrade) {
            Method setMethod = ds.getClass().getMethod("setConnectionAttributes", String.class);
            setMethod.invoke((Object)ds, "upgrade=true");
        }
        Connection conn = ds.getConnection();
        return ds;
    }

    private DataSource makeDataSource(String logicalDatabaseName) throws Exception {
        return JDBCDataSource.getDataSourceLogical(logicalDatabaseName);
    }

    private void shutdownDatabase(DataSource ds) {
        JDBCDataSource.shutdownDatabase(ds);
    }

    private void vetDBVersion(Version softwareVersion, Version dataVersion, Connection conn) throws Exception {
        String expectedSoftwareVersion = softwareVersion.toString();
        String expectedDataVersion = dataVersion.getBranchID();
        String actualSoftwareVersion = this.trimDriverVersion(conn.getMetaData().getDriverVersion());
        String actualDataVersion = this.getDataVersion(conn);
        UpgradeTrajectoryTest.assertEquals((String)this._trajectoryName, (String)expectedSoftwareVersion, (String)actualSoftwareVersion);
        UpgradeTrajectoryTest.assertEquals((String)this._trajectoryName, (String)expectedDataVersion, (String)actualDataVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDataVersion(Connection conn) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement("values syscs_util.syscs_get_database_property('DataDictionaryVersion')");
            rs = ps.executeQuery();
            rs.next();
            String string = rs.getString(1);
            return string;
        }
        catch (SQLException se) {
            UpgradeTrajectoryTest.printStackTrace(se);
            String string = null;
            return string;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    private String trimDriverVersion(String driverVersion) {
        int idx = driverVersion.indexOf(32);
        if (idx > 0) {
            return driverVersion.substring(0, idx);
        }
        return driverVersion;
    }

    private void saveOriginalClassLoader() {
        if (_originalClassLoader.get() == null) {
            _originalClassLoader.set(ClassLoaderTestSetup.getThreadLoader());
        }
    }

    private void restoreOriginalClassLoader() {
        ClassLoaderTestSetup.setThreadLoader(_originalClassLoader.get());
    }

    private String stringifyUpgradeRequests() {
        StringBuffer buffer = new StringBuffer();
        int count = this._hardUpgradeRequests.length;
        buffer.append("( ");
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            if (this._hardUpgradeRequests[i]) {
                buffer.append("hard");
                continue;
            }
            buffer.append("soft");
        }
        buffer.append(" )");
        return buffer.toString();
    }

    @Override
    protected void goodStatement(Connection conn, String ddl) throws SQLException {
        PreparedStatement ps = this.chattyPrepare(conn, ddl);
        ps.execute();
        ps.close();
    }

    @Override
    protected PreparedStatement chattyPrepare(Connection conn, String text) throws SQLException {
        return conn.prepareStatement(text);
    }

    private String printResultSet(ResultSet rs) throws SQLException {
        if (rs == null) {
            return "Null ResultSet!";
        }
        ResultSetMetaData rsmd = rs.getMetaData();
        int count = rsmd.getColumnCount();
        StringBuffer buffer = new StringBuffer();
        while (rs.next()) {
            for (int i = 1; i <= count; ++i) {
                if (i > 1) {
                    buffer.append(" | ");
                }
                buffer.append(rs.getString(i));
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    private void normalizeRow(String tableName, String[] columnNames, String[] row) {
        int count = row.length;
        for (int i = 0; i < count; ++i) {
            String value = row[i];
            if (this.isColumn(SYSCONGLOMERATES, CONGLOMERATENUMBER, tableName, columnNames[i])) {
                value = DUMMY_NUMBER;
            } else if (this.isColumn(SYSALIASES, ALIASID, tableName, columnNames[i])) {
                original = value;
                value = this.getColumnValue(ALIAS, columnNames, row);
                this._unstableColumnValues.put(original, value);
            } else if (this.isColumn(SYSALIASES, SPECIFICNAME, tableName, columnNames[i])) {
                original = value;
                value = this.getColumnValue(ALIAS, columnNames, row);
                this._unstableColumnValues.put(original, value);
            } else if (this.isColumn(SYSSTATEMENTS, STMTID, tableName, columnNames[i])) {
                original = value;
                value = this.getColumnValue(STMTNAME, columnNames, row);
                this._unstableColumnValues.put(original, value);
            } else if (this.isColumn(SYSSTATEMENTS, LASTCOMPILED, tableName, columnNames[i])) {
                value = DUMMY_TIMESTAMP;
            } else if (this.isColumn(SYSSTATEMENTS, TEXT, tableName, columnNames[i]) && this.suffersDERBY_4216(tableName)) {
                value = DUMMY_STRING;
            } else if (this.isColumn(SYSROUTINEPERMS, ALIASID, tableName, columnNames[i])) {
                value = this._unstableColumnValues.get(value);
            } else if (this.isColumn(SYSROUTINEPERMS, ROUTINEPERMSID, tableName, columnNames[i])) {
                value = DUMMY_STRING;
            }
            row[i] = value;
        }
    }

    private boolean isColumn(String expectedTableName, String expectedColumnName, String actualTableName, String actualColumnName) {
        return expectedTableName.equals(actualTableName) && expectedColumnName.equals(actualColumnName);
    }

    private String getColumnValue(String columnName, String[] columnNames, String[] row) {
        int count = columnNames.length;
        for (int i = 0; i < count; ++i) {
            if (!columnName.equals(columnNames[i])) continue;
            return row[i];
        }
        return null;
    }

    private boolean isUUID(String raw) {
        return raw != null && raw.length() == 36 && raw.charAt(8) == '-' && raw.charAt(13) == '-' && raw.charAt(18) == '-';
    }

    private void printQueryResults(Connection conn, String query) throws Exception {
        PreparedStatement ps = this.chattyPrepare(conn, query);
        ResultSet rs = ps.executeQuery();
        rs.close();
        ps.close();
    }

    private void compareQueries(Connection leftConn, Connection rightConn, int colCount, String query) throws Exception {
        PreparedStatement leftPS = this.chattyPrepare(leftConn, query);
        PreparedStatement rightPS = this.chattyPrepare(rightConn, query);
        ResultSet leftRS = leftPS.executeQuery();
        ResultSet rightRS = rightPS.executeQuery();
        while (leftRS.next()) {
            rightRS.next();
            for (int i = 1; i <= colCount; ++i) {
                String leftValue = leftRS.getString(i);
                String rightValue = rightRS.getString(i);
                boolean unequal = false;
                if (leftValue == null) {
                    if (rightValue != null) {
                        unequal = true;
                    }
                } else if (!leftValue.equals(rightValue)) {
                    unequal = true;
                }
                if (!unequal) continue;
            }
        }
        leftRS.close();
        rightRS.close();
        leftPS.close();
        rightPS.close();
    }

    private static Version.Trajectory[] buildMinimalSet(Version[] supportedVersions) {
        int i;
        ArrayList<Version.Trajectory> trajectoryList = new ArrayList<Version.Trajectory>();
        int versionCount = supportedVersions.length;
        boolean[] include = new boolean[versionCount];
        for (i = 0; i < versionCount; ++i) {
            include[i] = true;
        }
        UpgradeTrajectoryTest.addSubset(supportedVersions, trajectoryList, include, false);
        for (i = 0; i < versionCount - 1; ++i) {
            include[i] = false;
            UpgradeTrajectoryTest.addSubset(supportedVersions, trajectoryList, include, false);
        }
        return UpgradeTrajectoryTest.squeezeArray(trajectoryList);
    }

    private static Version.Trajectory[] buildPowerSet(Version[] supportedVersions) {
        ArrayList<Version.Trajectory> trajectoryList = new ArrayList<Version.Trajectory>();
        int versionCount = supportedVersions.length;
        boolean[] include = new boolean[versionCount];
        UpgradeTrajectoryTest.buildPowerSetMinion(supportedVersions, trajectoryList, include, 0, false);
        return UpgradeTrajectoryTest.squeezeArray(trajectoryList);
    }

    private static Version.Trajectory[] squeezeArray(ArrayList<Version.Trajectory> trajectoryList) {
        Version.Trajectory[] result = new Version.Trajectory[trajectoryList.size()];
        trajectoryList.toArray(result);
        return result;
    }

    private static void buildPowerSetMinion(Version[] supportedVersions, ArrayList<Version.Trajectory> result, boolean[] include, int idx, boolean removeSameBranchNeighbors) {
        int versionCount = supportedVersions.length;
        if (idx >= versionCount) {
            UpgradeTrajectoryTest.addSubset(supportedVersions, result, include, removeSameBranchNeighbors);
        } else {
            include[idx] = true;
            UpgradeTrajectoryTest.buildPowerSetMinion(supportedVersions, result, include, idx + 1, removeSameBranchNeighbors);
            include[idx] = false;
            UpgradeTrajectoryTest.buildPowerSetMinion(supportedVersions, result, include, idx + 1, removeSameBranchNeighbors);
        }
    }

    private static void addSubset(Version[] supportedVersions, ArrayList<Version.Trajectory> result, boolean[] include, boolean removeSameBranchNeighbors) {
        int versionCount = supportedVersions.length;
        ArrayList<Version> seed = new ArrayList<Version>();
        Version previousVersion = null;
        for (int i = 0; i < versionCount; ++i) {
            Version thisVersion = supportedVersions[i];
            if (!include[i] || removeSameBranchNeighbors && previousVersion != null && previousVersion.getBranchID().equals(thisVersion.getBranchID())) continue;
            previousVersion = thisVersion;
            seed.add(thisVersion);
        }
        int seedSize = seed.size();
        if (seedSize > 1) {
            Version[] subset = new Version[seedSize];
            seed.toArray(subset);
            result.add(new Version.Trajectory(subset).sort());
        }
    }

    private String filterKnownProblems(String tableName, String actual) {
        if (this._trajectory.endsAt(BRANCH_10_5) && (this.contains(actual, DERBY_4214_1) || this.contains(actual, DERBY_4214_2))) {
            return "";
        }
        if (this.suffersDERBY_4215(tableName) && this.contains(actual, DERBY_4215)) {
            return "";
        }
        return actual;
    }

    private boolean suffersDERBY_4215(String tableName) {
        return SYSROUTINEPERMS.equals(tableName) && this._trajectory.startsAt(BRANCH_10_0) && !this._trajectory.contains(BRANCH_10_1) && (this._trajectory.contains(BRANCH_10_2) || this._trajectory.contains(BRANCH_10_3) || this._trajectory.contains(BRANCH_10_4)) && this._trajectory.getEndingVersion().compareTo(VERSION_10_6_0_0) < 0;
    }

    private boolean suffersDERBY_4216(String tableName) {
        return SYSSTATEMENTS.equals(tableName) && this._trajectory.startsAt(BRANCH_10_0) && this._trajectory.endsAt(BRANCH_10_1);
    }

    private boolean contains(String left, String right) {
        return left.indexOf(right) >= 0;
    }
}

