/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.derby.iapi.tools.i18n.LocalizedInput;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.ij.AsyncStatement;
import org.apache.derby.impl.tools.ij.CharStream;
import org.apache.derby.impl.tools.ij.ConnectionEnv;
import org.apache.derby.impl.tools.ij.ParseException;
import org.apache.derby.impl.tools.ij.QualifiedIdentifier;
import org.apache.derby.impl.tools.ij.Session;
import org.apache.derby.impl.tools.ij.Token;
import org.apache.derby.impl.tools.ij.URLCheck;
import org.apache.derby.impl.tools.ij.ijConnectionResult;
import org.apache.derby.impl.tools.ij.ijConstants;
import org.apache.derby.impl.tools.ij.ijException;
import org.apache.derby.impl.tools.ij.ijMultiResult;
import org.apache.derby.impl.tools.ij.ijMultipleResultSetResult;
import org.apache.derby.impl.tools.ij.ijResult;
import org.apache.derby.impl.tools.ij.ijResultSetResult;
import org.apache.derby.impl.tools.ij.ijRowResult;
import org.apache.derby.impl.tools.ij.ijStatementResult;
import org.apache.derby.impl.tools.ij.ijTokenManager;
import org.apache.derby.impl.tools.ij.ijVectorResult;
import org.apache.derby.impl.tools.ij.ijWarningResult;
import org.apache.derby.impl.tools.ij.util;
import org.apache.derby.impl.tools.ij.utilMain;
import org.apache.derby.impl.tools.ij.xaAbstractHelper;
import org.apache.derby.tools.JDBCDisplayUtil;

class ij
implements ijConstants {
    static final String PROTOCOL_PROPERTY = "ij.protocol";
    static final String URLCHECK_PROPERTY = "ij.URLCheck";
    static final String USER_PROPERTY = "ij.user";
    static final String PASSWORD_PROPERTY = "ij.password";
    static final String FRAMEWORK_PROPERTY = "framework";
    boolean elapsedTime = false;
    Connection theConnection = null;
    ConnectionEnv currentConnEnv = null;
    String urlCheck = null;
    xaAbstractHelper xahelper = null;
    boolean exit = false;
    utilMain utilInstance = null;
    Hashtable ignoreErrors = null;
    String protocol = null;
    Hashtable<String, String> namedProtocols;
    public ijTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[69];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector<int[]> jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    ij(ijTokenManager ijTokenManager2, utilMain utilMain2) {
        this(ijTokenManager2);
        this.utilInstance = utilMain2;
    }

    void initFromEnvironment() {
        Object object;
        Properties properties = AccessController.doPrivileged(new PrivilegedAction<Properties>(this){

            @Override
            public Properties run() {
                return System.getProperties();
            }
        });
        this.urlCheck = properties.getProperty(URLCHECK_PROPERTY);
        this.protocol = properties.getProperty(PROTOCOL_PROPERTY);
        String string = properties.getProperty(FRAMEWORK_PROPERTY);
        if (ij.JDBC20X() && ij.JTA()) {
            try {
                object = Class.forName("org.apache.derby.impl.tools.ij.xaHelper");
                this.xahelper = (xaAbstractHelper)((Class)object).getConstructor(new Class[0]).newInstance(new Object[0]);
                this.xahelper.setFramework(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.namedProtocols = new Hashtable();
        object = "ij.protocol.";
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith((String)object)) continue;
            String string3 = string2.substring(((String)object).length());
            this.installProtocol(string3.toUpperCase(Locale.ENGLISH), properties.getProperty(string2));
        }
    }

    private static boolean JDBC20X() {
        try {
            Class.forName("javax.sql.DataSource");
            Class.forName("javax.sql.ConnectionPoolDataSource");
            Class.forName("javax.sql.PooledConnection");
            Class.forName("javax.sql.XAConnection");
            Class.forName("javax.sql.XADataSource");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    private static boolean JTA() {
        try {
            Class.forName("javax.transaction.xa.Xid");
            Class.forName("javax.transaction.xa.XAResource");
            Class.forName("javax.transaction.xa.XAException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    public static boolean JNDI() {
        try {
            Class.forName("javax.naming.spi.Resolver");
            Class.forName("javax.naming.Referenceable");
            Class.forName("javax.naming.directory.Attribute");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    SQLWarning appendWarnings(SQLWarning sQLWarning, SQLWarning sQLWarning2) {
        if (sQLWarning == null) {
            return sQLWarning2;
        }
        if (sQLWarning.getNextException() == null) {
            sQLWarning.setNextException(sQLWarning2);
        } else {
            this.appendWarnings(sQLWarning.getNextWarning(), sQLWarning2);
        }
        return sQLWarning;
    }

    boolean getElapsedTimeState() {
        return this.elapsedTime;
    }

    String stringValue(String string) {
        Object object = string.substring(1, string.length() - 1);
        int n = 39;
        int n2 = ((String)object).indexOf(n);
        while (n2 != -1) {
            object = ((String)object).substring(0, n2 + 1) + ((String)object).substring(n2 + 2);
            n2 = ((String)object).indexOf(n, n2 + 1);
        }
        return object;
    }

    void installProtocol(String string, String string2) {
        try {
            util.loadDriverIfKnown(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ijException.classNotFoundForProtocol(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ijException.classNotFoundForProtocol(string2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw ijException.classNotFoundForProtocol(string2);
        }
        catch (InstantiationException instantiationException) {
            throw ijException.classNotFoundForProtocol(string2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw ijException.classNotFoundForProtocol(string2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw ijException.classNotFoundForProtocol(string2);
        }
        if (string == null) {
            this.protocol = string2;
        } else {
            this.namedProtocols.put(string, string2);
        }
    }

    private static Process execProcess(String string) throws IOException {
        return Runtime.getRuntime().exec(string);
    }

    void haveConnection() {
        JDBCDisplayUtil.checkNotNull(this.theConnection, "connection");
    }

    Session findSession(String string) {
        Session session = this.currentConnEnv.getSession(string);
        if (session == null) {
            throw ijException.noSuchConnection(string);
        }
        return session;
    }

    PreparedStatement findPreparedStatement(QualifiedIdentifier qualifiedIdentifier) {
        Session session = this.findSession(qualifiedIdentifier.getSessionName());
        PreparedStatement preparedStatement = session.getPreparedStatement(qualifiedIdentifier.getLocalName());
        JDBCDisplayUtil.checkNotNull(preparedStatement, "prepared statement " + String.valueOf(qualifiedIdentifier));
        return preparedStatement;
    }

    ResultSet findCursor(QualifiedIdentifier qualifiedIdentifier) {
        Session session = this.findSession(qualifiedIdentifier.getSessionName());
        ResultSet resultSet = session.getCursor(qualifiedIdentifier.getLocalName());
        JDBCDisplayUtil.checkNotNull(resultSet, "cursor " + String.valueOf(qualifiedIdentifier));
        return resultSet;
    }

    ijResult executeImmediate(String string) throws SQLException {
        Statement statement = null;
        try {
            long l = 0L;
            long l2 = 0L;
            boolean bl = false;
            this.haveConnection();
            statement = this.theConnection.createStatement();
            if (this.currentConnEnv != null) {
                DatabaseMetaData databaseMetaData;
                int n;
                boolean bl2 = this.currentConnEnv.getSession().getIsDNC();
                if (bl2 && ((n = (databaseMetaData = this.theConnection.getMetaData()).getDriverMajorVersion()) > 10 || n == 10 && databaseMetaData.getDriverMinorVersion() > 1)) {
                    bl2 = false;
                }
                if (this.currentConnEnv.getSession().getIsJCC() || bl2) {
                    while (string.startsWith("--")) {
                        int n2 = string.indexOf(10) + 1;
                        string = string.substring(n2);
                    }
                    string = string.trim();
                }
            }
            statement.execute(string);
            return new ijStatementResult(statement, true);
        }
        catch (SQLException sQLException) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw sQLException;
        }
    }

    ijResult quit() throws SQLException {
        this.exit = true;
        this.currentConnEnv.removeAllSessions();
        this.theConnection = null;
        return null;
    }

    ijResult executeAsync(String string, QualifiedIdentifier qualifiedIdentifier) {
        Session session = this.findSession(qualifiedIdentifier.getSessionName());
        AsyncStatement asyncStatement = new AsyncStatement(session.getConnection(), string);
        session.addAsyncStatement(qualifiedIdentifier.getLocalName(), asyncStatement);
        asyncStatement.start();
        return null;
    }

    void setConnection(ConnectionEnv connectionEnv, boolean bl) {
        Connection connection = connectionEnv.getConnection();
        if (connectionEnv != this.currentConnEnv) {
            this.currentConnEnv = connectionEnv;
        }
        if (this.theConnection == connection) {
            return;
        }
        if (this.theConnection != null && !bl) {
            throw ijException.needToDisconnect();
        }
        this.theConnection = connection;
    }

    private ijResult addSession(Connection connection, String string) throws SQLException {
        if (this.currentConnEnv.haveSession(string)) {
            throw ijException.alreadyHaveConnectionNamed(string);
        }
        this.currentConnEnv.addSession(connection, string);
        return new ijConnectionResult(connection);
    }

    private String[] sortConnectionNames() {
        int n = 100;
        int n2 = 0;
        Object[] objectArray = new String[n];
        Hashtable<String, Session> hashtable = this.currentConnEnv.getSessions();
        Enumeration<String> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            if (n2 == n) {
                String[] stringArray = new String[n *= 2];
                System.arraycopy(objectArray, 0, stringArray, 0, n2);
                objectArray = stringArray;
            }
            String string = enumeration.nextElement();
            objectArray[n2++] = string;
        }
        Arrays.sort(objectArray, 0, n2);
        return objectArray;
    }

    public ijResult showConnectionsMethod(boolean bl) throws SQLException {
        Hashtable<String, Session> hashtable = this.currentConnEnv.getSessions();
        Vector<Object> vector = new Vector<Object>();
        SQLWarning sQLWarning = null;
        if (hashtable == null || hashtable.size() == 0) {
            if (!bl) {
                vector.addElement(LocalizedResource.getMessage("IJ_NoConneAvail", new Object[0]));
            }
        } else {
            boolean bl2 = false;
            int n = 0;
            String[] stringArray = hashtable.keys();
            while (stringArray.hasMoreElements()) {
                ++n;
                stringArray.nextElement();
            }
            stringArray = this.sortConnectionNames();
            for (int i = 0; i < n; ++i) {
                String string;
                String string2 = stringArray[i];
                Session session = hashtable.get(string2);
                if (session.getConnection().isClosed()) {
                    if (this.currentConnEnv.getSession() != null && string2.equals(this.currentConnEnv.getSession().getName())) {
                        this.currentConnEnv.removeCurrentSession();
                        this.theConnection = null;
                        continue;
                    }
                    this.currentConnEnv.removeSession(string2);
                    continue;
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string2);
                if (this.currentConnEnv.getSession() != null && string2.equals(this.currentConnEnv.getSession().getName())) {
                    stringBuffer.append('*');
                    bl2 = true;
                }
                if ((string = util.getSystemProperty("ij.dataSource")) == null) {
                    stringBuffer.append(" - \t");
                    stringBuffer.append(session.getConnection().getMetaData().getURL());
                }
                sQLWarning = this.appendWarnings(sQLWarning, session.getConnection().getWarnings());
                session.getConnection().clearWarnings();
                vector.addElement(stringBuffer.toString());
            }
            if (bl2) {
                vector.addElement(LocalizedResource.getMessage("IJ_CurreConne", new Object[0]));
            } else {
                vector.addElement(LocalizedResource.getMessage("IJ_NoCurreConne", new Object[0]));
            }
        }
        return new ijVectorResult(vector, sQLWarning);
    }

    public static int[] intArraySubset(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[n2 - n];
        System.arraycopy(nArray, n, nArray2, 0, n2 - n);
        return nArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyTableExists(String string, String string2) throws SQLException {
        if (string == null) {
            return;
        }
        ResultSet resultSet = null;
        try {
            DatabaseMetaData databaseMetaData = this.theConnection.getMetaData();
            resultSet = databaseMetaData.getTables(null, string, string2, null);
            if (!resultSet.next()) {
                throw ijException.noSuchTable(string2);
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public ijResult showTables(String string, String[] stringArray) throws SQLException {
        ResultSet resultSet = null;
        try {
            this.haveConnection();
            DatabaseMetaData databaseMetaData = this.theConnection.getMetaData();
            resultSet = databaseMetaData.getTables(null, string, null, stringArray);
            int[] nArray = new int[]{resultSet.findColumn("TABLE_SCHEM"), resultSet.findColumn("TABLE_NAME"), resultSet.findColumn("REMARKS")};
            int[] nArray2 = new int[]{20, 30, 20};
            return new ijResultSetResult(resultSet, nArray, nArray2);
        }
        catch (SQLException sQLException) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw sQLException;
        }
    }

    private ResultSet getIndexInfoForTable(String string, String string2) throws SQLException {
        this.haveConnection();
        this.verifyTableExists(string, string2);
        DatabaseMetaData databaseMetaData = this.theConnection.getMetaData();
        return databaseMetaData.getIndexInfo(null, string, string2, false, true);
    }

    private int[] getDisplayColumnsForIndex(String string, ResultSet resultSet) throws SQLException {
        int[] nArray = new int[]{resultSet.findColumn("TABLE_SCHEM"), resultSet.findColumn("TABLE_NAME"), resultSet.findColumn("COLUMN_NAME"), resultSet.findColumn("NON_UNIQUE"), resultSet.findColumn("TYPE"), resultSet.findColumn("ASC_OR_DESC"), resultSet.findColumn("CARDINALITY"), resultSet.findColumn("PAGES")};
        if (string != null) {
            nArray = ij.intArraySubset(nArray, 1, nArray.length);
        }
        return nArray;
    }

    private int[] getColumnWidthsForIndex(String string) {
        int[] nArray = new int[]{20, 20, 20, 6, 4, 4, 8, 8};
        if (string != null) {
            nArray = ij.intArraySubset(nArray, 1, nArray.length);
        }
        return nArray;
    }

    public ijResult showIndexes(String string, String string2) throws SQLException {
        ijResult ijResult2 = null;
        int[] nArray = null;
        int[] nArray2 = null;
        try {
            if (string2 != null) {
                ResultSet resultSet = this.getIndexInfoForTable(string, string2);
                nArray = this.getDisplayColumnsForIndex(string, resultSet);
                nArray2 = this.getColumnWidthsForIndex(string);
                ijResult2 = new ijResultSetResult(resultSet, nArray, nArray2);
            } else {
                this.haveConnection();
                this.verifyTableExists(string, string2);
                DatabaseMetaData databaseMetaData = this.theConnection.getMetaData();
                ResultSet resultSet = databaseMetaData.getTables(null, string, null, null);
                ArrayList<ResultSet> arrayList = new ArrayList<ResultSet>();
                boolean bl = true;
                ResultSet resultSet2 = null;
                while (resultSet.next()) {
                    String string3 = resultSet.getString("TABLE_NAME");
                    resultSet2 = this.getIndexInfoForTable(string, string3);
                    arrayList.add(resultSet2);
                    if (!bl) continue;
                    nArray = this.getDisplayColumnsForIndex(string, resultSet2);
                    nArray2 = this.getColumnWidthsForIndex(string);
                    bl = false;
                }
                ijResult2 = new ijMultipleResultSetResult(arrayList, nArray, nArray2);
            }
            return ijResult2;
        }
        catch (SQLException sQLException) {
            try {
                if (ijResult2 != null) {
                    ijResult2.closeStatement();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw sQLException;
        }
    }

    public ijResult showProcedures(String string) throws SQLException {
        ResultSet resultSet = null;
        try {
            this.haveConnection();
            DatabaseMetaData databaseMetaData = this.theConnection.getMetaData();
            resultSet = databaseMetaData.getProcedures(null, string, null);
            int[] nArray = new int[]{resultSet.findColumn("PROCEDURE_SCHEM"), resultSet.findColumn("PROCEDURE_NAME"), resultSet.findColumn("REMARKS")};
            int[] nArray2 = new int[]{20, 30, 20};
            return new ijResultSetResult(resultSet, nArray, nArray2);
        }
        catch (SQLException sQLException) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw sQLException;
        }
    }

    public ijResult showFunctions(String string) throws SQLException {
        ResultSet resultSet = null;
        try {
            this.haveConnection();
            DatabaseMetaData databaseMetaData = this.theConnection.getMetaData();
            try {
                Method method = databaseMetaData.getClass().getMethod("getFunctions", String.class, String.class, String.class);
                resultSet = (ResultSet)method.invoke((Object)databaseMetaData, null, string, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw ijException.notAvailableForDriver(databaseMetaData.getDriverName());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw ijException.notAvailableForDriver(databaseMetaData.getDriverName());
            }
            catch (AbstractMethodError abstractMethodError) {
                throw ijException.notAvailableForDriver(databaseMetaData.getDriverName());
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof SQLException) {
                    throw (SQLException)throwable;
                }
                throw ijException.notAvailableForDriver(databaseMetaData.getDriverName());
            }
            int[] nArray = new int[]{resultSet.findColumn("FUNCTION_SCHEM"), resultSet.findColumn("FUNCTION_NAME"), resultSet.findColumn("REMARKS")};
            int[] nArray2 = new int[]{14, 28, 35};
            return new ijResultSetResult(resultSet, nArray, nArray2);
        }
        catch (SQLException sQLException) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw sQLException;
        }
    }

    public ijResult showSchemas() throws SQLException {
        ResultSet resultSet = null;
        try {
            this.haveConnection();
            DatabaseMetaData databaseMetaData = this.theConnection.getMetaData();
            resultSet = databaseMetaData.getSchemas();
            int[] nArray = new int[]{resultSet.findColumn("TABLE_SCHEM")};
            int[] nArray2 = new int[]{30};
            return new ijResultSetResult(resultSet, nArray, nArray2);
        }
        catch (SQLException sQLException) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw sQLException;
        }
    }

    public ijResult showRoles() throws SQLException {
        ResultSet resultSet = null;
        try {
            this.haveConnection();
            if (this.currentConnEnv.getSession().getIsDNC() || this.currentConnEnv.getSession().getIsEmbeddedDerby()) {
                resultSet = this.theConnection.createStatement().executeQuery("SELECT ROLEID FROM SYS.SYSROLES WHERE ISDEF='Y' ORDER BY ROLEID ASC");
                int[] nArray = new int[]{resultSet.findColumn("ROLEID")};
                int[] nArray2 = new int[]{30};
                return new ijResultSetResult(resultSet, nArray, nArray2);
            }
            throw ijException.notAvailableForDriver(this.theConnection.getMetaData().getDriverName());
        }
        catch (SQLException sQLException) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw sQLException;
        }
    }

    public ijResult showEnabledRoles() throws SQLException {
        ResultSet resultSet = null;
        try {
            this.haveConnection();
            if (this.currentConnEnv.getSession().getIsDNC() || this.currentConnEnv.getSession().getIsEmbeddedDerby()) {
                resultSet = this.theConnection.createStatement().executeQuery("SELECT * FROM\t TABLE(\t   SYSCS_DIAG.CONTAINED_ROLES(CURRENT_ROLE)) T ORDER BY ROLEID");
                int[] nArray = new int[]{resultSet.findColumn("ROLEID")};
                int[] nArray2 = new int[]{30};
                return new ijResultSetResult(resultSet, nArray, nArray2);
            }
            throw ijException.notAvailableForDriver(this.theConnection.getMetaData().getDriverName());
        }
        catch (SQLException sQLException) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw sQLException;
        }
    }

    public ijResult showSettableRoles() throws SQLException {
        ResultSet resultSet = null;
        try {
            this.haveConnection();
            if (this.currentConnEnv.getSession().getIsDNC() || this.currentConnEnv.getSession().getIsEmbeddedDerby()) {
                resultSet = this.theConnection.createStatement().executeQuery("select distinct * from (  select roleid from sys.sysroles s    where s.grantee = current_user or s.grantee = 'PUBLIC'  union  select roleid from sys.sysroles s    where s.isdef='Y' and current_user in        (select authorizationid from sys.sysschemas             where schemaname = 'SYS')) t order by roleid");
                int[] nArray = new int[]{resultSet.findColumn("ROLEID")};
                int[] nArray2 = new int[]{30};
                return new ijResultSetResult(resultSet, nArray, nArray2);
            }
            throw ijException.notAvailableForDriver(this.theConnection.getMetaData().getDriverName());
        }
        catch (SQLException sQLException) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw sQLException;
        }
    }

    public ijResult describeTable(String string, String string2) throws SQLException {
        ResultSet resultSet = null;
        try {
            this.haveConnection();
            this.verifyTableExists(string, string2);
            DatabaseMetaData databaseMetaData = this.theConnection.getMetaData();
            resultSet = databaseMetaData.getColumns(null, string, string2, null);
            int[] nArray = new int[]{resultSet.findColumn("TABLE_SCHEM"), resultSet.findColumn("TABLE_NAME"), resultSet.findColumn("COLUMN_NAME"), resultSet.findColumn("TYPE_NAME"), resultSet.findColumn("DECIMAL_DIGITS"), resultSet.findColumn("NUM_PREC_RADIX"), resultSet.findColumn("COLUMN_SIZE"), resultSet.findColumn("COLUMN_DEF"), resultSet.findColumn("CHAR_OCTET_LENGTH"), resultSet.findColumn("IS_NULLABLE")};
            int[] nArray2 = new int[]{20, 20, 20, 9, 4, 4, 6, 10, 10, 8};
            if (string != null && string2 != null) {
                nArray = ij.intArraySubset(nArray, 2, nArray.length);
                nArray2 = ij.intArraySubset(nArray2, 2, nArray2.length);
            }
            return new ijResultSetResult(resultSet, nArray, nArray2);
        }
        catch (SQLException sQLException) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw sQLException;
        }
    }

    private Object makeXid(int n) {
        return null;
    }

    public final ijResult ijStatement() throws ParseException, SQLException {
        ijResult ijResult2 = null;
        if (this.jj_2_1(1)) {
            if (this.getToken((int)1).kind == 77 && this.getToken((int)3).kind != 79 && this.getToken((int)3).kind != 80) {
                ijResult2 = this.RollbackStatement();
            } else {
                switch (this.jj_nt.kind) {
                    case 14: {
                        ijResult2 = this.AbsoluteStatement();
                        break;
                    }
                    case 15: {
                        ijResult2 = this.AfterLastStatement();
                        break;
                    }
                    case 21: {
                        ijResult2 = this.AutocommitStatement();
                        break;
                    }
                    case 19: {
                        ijResult2 = this.AsyncStatement();
                        break;
                    }
                    case 22: {
                        ijResult2 = this.Bang();
                        break;
                    }
                    case 23: {
                        ijResult2 = this.BeforeFirstStatement();
                        break;
                    }
                    case 24: {
                        ijResult2 = this.CloseStatement();
                        break;
                    }
                    case 25: {
                        ijResult2 = this.CommitStatement();
                        break;
                    }
                    case 26: {
                        ijResult2 = this.ConnectStatement();
                        break;
                    }
                    case 31: {
                        ijResult2 = this.DescTableStatement();
                        break;
                    }
                    case 32: {
                        ijResult2 = this.DisconnectStatement();
                        break;
                    }
                    case 33: {
                        ijResult2 = this.DriverStatement();
                        break;
                    }
                    case 34: {
                        ijResult2 = this.ElapsedTimeStatement();
                        break;
                    }
                    case 38: {
                        ijResult2 = this.ExecuteStatement();
                        break;
                    }
                    case 41: {
                        ijResult2 = this.FirstStatement();
                        break;
                    }
                    case 39: 
                    case 71: {
                        ijResult2 = this.ExitStatement();
                        break;
                    }
                    case 45: {
                        ijResult2 = this.GetCursorStatement();
                        break;
                    }
                    case 46: {
                        ijResult2 = this.GetCurrentRowNumber();
                        break;
                    }
                    case 49: {
                        ijResult2 = this.HelpStatement();
                        break;
                    }
                    case 48: {
                        ijResult2 = this.HoldForConnectionStatement();
                        break;
                    }
                    case 54: {
                        ijResult2 = this.LastStatement();
                        break;
                    }
                    case 55: {
                        ijResult2 = this.LocalizedDisplay();
                        break;
                    }
                    case 56: {
                        ijResult2 = this.MaximumDisplayWidthStatement();
                        break;
                    }
                    case 58: {
                        ijResult2 = this.NextStatement();
                        break;
                    }
                    case 60: {
                        ijResult2 = this.NoHoldForConnectionStatement();
                        break;
                    }
                    case 65: {
                        ijResult2 = this.PrepareStatement();
                        break;
                    }
                    case 66: {
                        ijResult2 = this.PreviousStatement();
                        break;
                    }
                    case 70: {
                        ijResult2 = this.ProtocolStatement();
                        break;
                    }
                    case 72: {
                        ijResult2 = this.ReadOnlyStatement();
                        break;
                    }
                    case 73: {
                        ijResult2 = this.RelativeStatement();
                        break;
                    }
                    case 74: {
                        ijResult2 = this.RemoveStatement();
                        break;
                    }
                    case 78: {
                        ijResult2 = this.RunStatement();
                        break;
                    }
                    case 84: {
                        ijResult2 = this.SetConnectionStatement();
                        break;
                    }
                    case 86: {
                        ijResult2 = this.ShowStatement();
                        break;
                    }
                    case 94: {
                        ijResult2 = this.WaitForStatement();
                        break;
                    }
                    case 98: {
                        ijResult2 = this.XA_DataSourceStatement();
                        break;
                    }
                    case 99: {
                        ijResult2 = this.XA_ConnectStatement();
                        break;
                    }
                    case 100: {
                        ijResult2 = this.XA_CommitStatement();
                        break;
                    }
                    case 101: {
                        ijResult2 = this.XA_DisconnectStatement();
                        break;
                    }
                    case 106: {
                        ijResult2 = this.XA_GetConnectionStatement();
                        break;
                    }
                    case 102: {
                        ijResult2 = this.XA_EndStatement();
                        break;
                    }
                    case 105: {
                        ijResult2 = this.XA_ForgetStatement();
                        break;
                    }
                    case 109: {
                        ijResult2 = this.XA_PrepareStatement();
                        break;
                    }
                    case 110: {
                        ijResult2 = this.XA_RecoverStatement();
                        break;
                    }
                    case 112: {
                        ijResult2 = this.XA_RollbackStatement();
                        break;
                    }
                    case 113: {
                        ijResult2 = this.XA_StartStatement();
                        break;
                    }
                    case 117: {
                        ijResult2 = this.DataSourceStatement();
                        break;
                    }
                    case 118: {
                        ijResult2 = this.CP_DataSourceStatement();
                        break;
                    }
                    case 119: {
                        ijResult2 = this.CP_ConnectStatement();
                        break;
                    }
                    case 120: {
                        ijResult2 = this.CP_GetConnectionStatement();
                        break;
                    }
                    case 121: {
                        ijResult2 = this.CP_DisconnectStatement();
                        break;
                    }
                    default: {
                        this.jj_la1[0] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
        }
        this.jj_consume_token(0);
        return ijResult2;
    }

    public final ijResult ProtocolStatement() throws ParseException, SQLException {
        String string = null;
        this.jj_consume_token(70);
        Token token = this.jj_consume_token(135);
        switch (this.jj_nt.kind) {
            case 18: {
                this.jj_consume_token(18);
                string = this.identifier();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        this.installProtocol(string, this.stringValue(token.image));
        return null;
    }

    public final ijResult DriverStatement() throws ParseException, SQLException {
        String string = null;
        this.jj_consume_token(33);
        Token token = this.jj_consume_token(135);
        try {
            string = this.stringValue(token.image);
            util.loadDriver(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ijException.classNotFound(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ijException.driverNotClassName(string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw ijException.classNotFound(string);
        }
        catch (InstantiationException instantiationException) {
            throw ijException.classNotFound(string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw ijException.classNotFound(string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw ijException.classNotFound(string);
        }
        return null;
    }

    public final ijResult ConnectStatement() throws ParseException, SQLException {
        this.jj_consume_token(26);
        return switch (this.jj_nt.kind) {
            case 79 -> {
                this.jj_consume_token(79);
                yield this.dynamicConnection(true);
            }
            case 131, 135 -> {
                switch (this.jj_nt.kind) {
                    case 135: {
                        yield this.dynamicConnection(false);
                    }
                    case 131: {
                        yield this.staticConnection();
                    }
                }
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default -> {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final ijResult dynamicConnection(boolean bl) throws ParseException, SQLException {
        Object object;
        String string;
        Token token = null;
        Token token2 = null;
        String string2 = null;
        String string3 = null;
        String string4 = util.getSystemProperty(USER_PROPERTY);
        String string5 = util.getSystemProperty(PASSWORD_PROPERTY);
        Properties properties = new Properties();
        Token token3 = this.jj_consume_token(135);
        switch (this.jj_nt.kind) {
            case 70: {
                this.jj_consume_token(70);
                string3 = this.identifier();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 91: {
                this.jj_consume_token(91);
                token = this.jj_consume_token(135);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 63: {
                this.jj_consume_token(63);
                token2 = this.jj_consume_token(135);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 20: {
                this.jj_consume_token(20);
                if (!this.jj_2_2(1)) break;
                this.attributeList(properties);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 18: {
                this.jj_consume_token(18);
                string2 = this.identifier();
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        if (token != null) {
            string4 = this.stringValue(token.image);
        }
        if (token2 != null) {
            string5 = this.stringValue(token2.image);
        }
        if ((string = util.getSystemProperty("ij.dataSource")) != null && !((String)(object = this.stringValue(token3.image))).startsWith("jdbc:")) {
            this.theConnection = util.getDataSourceConnection(string, string4, string5, (String)object, false);
            return this.addSession(this.theConnection, string2);
        }
        object = bl ? "jdbc:derby:" + this.stringValue(token3.image) : this.stringValue(token3.image);
        if (string3 != null) {
            String string6 = this.namedProtocols.get(string3);
            if (string6 == null) {
                throw ijException.noSuchProtocol(string3);
            }
            object = string6 + (String)object;
        }
        boolean bl2 = false;
        try {
            if (((String)object).startsWith("jdbc:")) {
                util.loadDriverIfKnown((String)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.urlCheck == null || Boolean.valueOf(this.urlCheck).booleanValue()) {
            URLCheck uRLCheck = new URLCheck((String)object);
        }
        if (!((String)object).startsWith("jdbc:") && string3 == null && this.protocol != null) {
            object = this.protocol + (String)object;
        }
        properties = util.updateConnInfo(string4, string5, properties);
        this.theConnection = DriverManager.getConnection((String)object, properties);
        return this.addSession(this.theConnection, string2);
    }

    public final ijResult DescTableStatement() throws ParseException, SQLException {
        String string;
        String string2 = null;
        String string3 = null;
        Token token = null;
        this.jj_consume_token(31);
        String string4 = switch (this.jj_nt.kind) {
            case 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 36, 38, 39, 40, 41, 42, 43, 45, 46, 47, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 77, 78, 79, 81, 82, 83, 84, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 131 -> {
                string2 = this.caIdentifier();
                switch (this.jj_nt.kind) {
                    case 64: {
                        this.jj_consume_token(64);
                        string3 = this.caIdentifier();
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                    }
                }
                if (string3 == null) {
                    string = null;
                    yield string2;
                }
                string = string2;
                yield string3;
            }
            case 135 -> {
                token = this.jj_consume_token(135);
                string3 = this.stringValue(token.image);
                if (string3.length() == 0) {
                    throw ijException.noSuchTable("(missing)");
                }
                int var6_6 = string3.indexOf(46);
                if (var6_6 != -1) {
                    string2 = string3.substring(0, var6_6);
                    string3 = string3.substring(var6_6 + 1);
                }
                if ("*".equals(string3)) {
                    string3 = null;
                }
                string = string2;
                yield string3;
            }
            default -> {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
        if (string == null) {
            string = util.getSelectedSchema(this.theConnection);
        }
        return this.describeTable(string, string4);
    }

    public final ijResult staticConnection() throws ParseException, SQLException {
        String string = null;
        int n = 0;
        int n2 = 0;
        ijResult ijResult2 = null;
        Vector<String> vector = this.staticMethodName();
        Object[] objectArray = this.staticMethodArgs();
        switch (this.jj_nt.kind) {
            case 18: {
                this.jj_consume_token(18);
                string = this.identifier();
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        n2 = vector.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        while (n < n2) {
            if (n > 0) {
                stringBuffer.append(".");
            }
            stringBuffer.append(vector.elementAt(n));
            ++n;
        }
        String string2 = vector.elementAt(n);
        String string3 = stringBuffer.toString();
        try {
            int n3 = objectArray.length;
            Class[] classArray = new Class[n3];
            Class<?> clazz = Class.forName("java.lang.String");
            for (n = 0; n < n3; ++n) {
                classArray[n] = clazz;
            }
            Class<?> clazz2 = Class.forName(string3);
            Method method = clazz2.getMethod(string2, classArray);
            this.theConnection = (Connection)method.invoke(null, objectArray);
            ijResult2 = this.addSession(this.theConnection, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof SQLException) {
                throw (SQLException)throwable;
            }
            throw new SQLException(throwable.toString());
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
        return ijResult2;
    }

    public final ijResult SetConnectionStatement() throws ParseException, SQLException {
        this.jj_consume_token(84);
        this.jj_consume_token(27);
        String string = this.identifier();
        if (!this.currentConnEnv.haveSession(string)) {
            throw ijException.noSuchConnection(string);
        }
        this.currentConnEnv.setCurrentSession(string);
        this.theConnection = this.currentConnEnv.getConnection();
        return new ijConnectionResult(this.theConnection);
    }

    public final ijResult ShowStatement() throws ParseException, SQLException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String[] stringArray = null;
        Token token = null;
        Token token2 = null;
        this.jj_consume_token(86);
        switch (this.jj_nt.kind) {
            case 28: {
                this.jj_consume_token(28);
                return this.showConnectionsMethod(false);
            }
            case 16: 
            case 89: 
            case 90: 
            case 93: {
                switch (this.jj_nt.kind) {
                    case 90: {
                        token = this.jj_consume_token(90);
                        break;
                    }
                    case 93: {
                        token2 = this.jj_consume_token(93);
                        break;
                    }
                    case 89: {
                        this.jj_consume_token(89);
                        break;
                    }
                    case 16: {
                        this.jj_consume_token(16);
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_nt.kind) {
                    case 50: {
                        this.jj_consume_token(50);
                        string = this.caIdentifier();
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                    }
                }
                stringArray = token != null ? new String[]{"TABLE", "SYSTEM TABLE"} : (token2 != null ? new String[]{"VIEW"} : new String[]{"SYNONYM"});
                return this.showTables(string, stringArray);
            }
            case 51: {
                this.jj_consume_token(51);
                block20 : switch (this.jj_nt.kind) {
                    case 43: 
                    case 50: {
                        switch (this.jj_nt.kind) {
                            case 50: {
                                this.jj_consume_token(50);
                                string = this.caIdentifier();
                                break block20;
                            }
                            case 43: {
                                this.jj_consume_token(43);
                                string2 = this.caIdentifier();
                                switch (this.jj_nt.kind) {
                                    case 64: {
                                        this.jj_consume_token(64);
                                        string3 = this.caIdentifier();
                                        break block20;
                                    }
                                }
                                this.jj_la1[14] = this.jj_gen;
                                break block20;
                            }
                        }
                        this.jj_la1[15] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                    }
                }
                if (string3 != null) {
                    string = string2;
                    string2 = string3;
                }
                if (string == null && string2 != null) {
                    string = util.getSelectedSchema(this.theConnection);
                }
                return this.showIndexes(string, string2);
            }
            case 68: {
                this.jj_consume_token(68);
                switch (this.jj_nt.kind) {
                    case 50: {
                        this.jj_consume_token(50);
                        string = this.caIdentifier();
                        break;
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                    }
                }
                return this.showProcedures(string);
            }
            case 44: {
                this.jj_consume_token(44);
                switch (this.jj_nt.kind) {
                    case 50: {
                        this.jj_consume_token(50);
                        string = this.caIdentifier();
                        break;
                    }
                    default: {
                        this.jj_la1[18] = this.jj_gen;
                    }
                }
                return this.showFunctions(string);
            }
            case 81: {
                this.jj_consume_token(81);
                return this.showSchemas();
            }
            case 76: {
                this.jj_consume_token(76);
                return this.showRoles();
            }
            case 35: {
                this.jj_consume_token(35);
                return this.showEnabledRoles();
            }
            case 85: {
                this.jj_consume_token(85);
                return this.showSettableRoles();
            }
        }
        this.jj_la1[19] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ijResult CommitStatement() throws ParseException, SQLException {
        this.jj_consume_token(25);
        switch (this.jj_nt.kind) {
            case 122: {
                this.jj_consume_token(122);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        this.haveConnection();
        this.theConnection.commit();
        return null;
    }

    public final ijResult RollbackStatement() throws ParseException, SQLException {
        this.jj_consume_token(77);
        switch (this.jj_nt.kind) {
            case 122: {
                this.jj_consume_token(122);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
            }
        }
        this.haveConnection();
        this.theConnection.rollback();
        return null;
    }

    public final ijResult DisconnectStatement() throws ParseException, SQLException {
        Token token = null;
        String string = null;
        this.jj_consume_token(32);
        block0 : switch (this.jj_nt.kind) {
            case 17: 
            case 29: 
            case 131: {
                switch (this.jj_nt.kind) {
                    case 29: {
                        this.jj_consume_token(29);
                        break block0;
                    }
                    case 17: {
                        token = this.jj_consume_token(17);
                        break block0;
                    }
                    case 131: {
                        string = this.identifier();
                        break block0;
                    }
                }
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
            }
        }
        if (token == null) {
            if (string == null) {
                this.haveConnection();
                this.currentConnEnv.removeCurrentSession();
                this.theConnection = null;
            } else {
                if (!this.currentConnEnv.haveSession(string)) {
                    throw ijException.noSuchConnection(string);
                }
                this.currentConnEnv.removeSession(string);
                if (this.currentConnEnv.getSession() == null) {
                    this.theConnection = null;
                }
            }
        } else {
            this.currentConnEnv.removeAllSessions();
            this.theConnection = null;
        }
        return null;
    }

    public final ijResult ExitStatement() throws ParseException, SQLException {
        switch (this.jj_nt.kind) {
            case 39: {
                this.jj_consume_token(39);
                return this.quit();
            }
            case 71: {
                this.jj_consume_token(71);
                return this.quit();
            }
        }
        this.jj_la1[24] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ijResult PrepareStatement() throws ParseException, SQLException {
        this.jj_consume_token(65);
        switch (this.jj_nt.kind) {
            case 67: {
                this.jj_consume_token(67);
                this.jj_consume_token(18);
                Token token = this.jj_consume_token(135);
                throw ijException.illegalStatementName("procedure");
            }
            case 131: {
                QualifiedIdentifier qualifiedIdentifier = this.qualifiedIdentifier();
                this.jj_consume_token(18);
                Token token = this.jj_consume_token(135);
                Session session = this.findSession(qualifiedIdentifier.getSessionName());
                String string = this.stringValue(token.image);
                PreparedStatement preparedStatement = session.getConnection().prepareStatement(string);
                JDBCDisplayUtil.checkNotNull(preparedStatement, "prepared statement");
                session.addPreparedStatement(qualifiedIdentifier.getLocalName(), preparedStatement);
                SQLWarning sQLWarning = preparedStatement.getWarnings();
                preparedStatement.clearWarnings();
                return new ijWarningResult(sQLWarning);
            }
        }
        this.jj_la1[25] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ijResult GetCursorStatement() throws ParseException, SQLException {
        Object object;
        this.haveConnection();
        int n = 1003;
        Token token = null;
        Token token2 = null;
        int n2 = this.theConnection.getHoldability();
        Statement statement = null;
        ResultSet resultSet = null;
        this.jj_consume_token(45);
        switch (this.jj_nt.kind) {
            case 82: {
                token = this.jj_consume_token(82);
                n = this.scrollType();
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 95: {
                token2 = this.jj_consume_token(95);
                n2 = this.holdType();
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        this.jj_consume_token(30);
        QualifiedIdentifier qualifiedIdentifier = this.qualifiedIdentifier();
        this.jj_consume_token(18);
        Token token3 = this.jj_consume_token(135);
        String string = this.stringValue(token3.image);
        try {
            object = this.findSession(qualifiedIdentifier.getSessionName());
            statement = ((Session)object).getConnection().createStatement(n, 1007, n2);
            JDBCDisplayUtil.checkNotNull(statement, "cursor");
            statement.setCursorName(qualifiedIdentifier.getLocalName());
            resultSet = statement.executeQuery(string);
            JDBCDisplayUtil.checkNotNull(resultSet, "cursor");
            ((Session)object).addCursorStatement(qualifiedIdentifier.getLocalName(), statement);
            ((Session)object).addCursor(qualifiedIdentifier.getLocalName(), resultSet);
        }
        catch (SQLException sQLException) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException3) {
                // empty catch block
            }
            throw sQLException;
        }
        object = this.theConnection.getWarnings();
        SQLWarning sQLWarning = statement.getWarnings();
        SQLWarning sQLWarning2 = resultSet.getWarnings();
        this.theConnection.clearWarnings();
        statement.clearWarnings();
        resultSet.clearWarnings();
        SQLWarning sQLWarning3 = this.appendWarnings((SQLWarning)object, sQLWarning);
        return new ijWarningResult(this.appendWarnings(sQLWarning3, sQLWarning2));
    }

    public final int scrollType() throws ParseException, SQLException {
        switch (this.jj_nt.kind) {
            case 52: {
                this.jj_consume_token(52);
                return 1004;
            }
            case 83: {
                this.jj_consume_token(83);
                return 1005;
            }
        }
        this.jj_la1[28] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int holdType() throws ParseException, SQLException {
        switch (this.jj_nt.kind) {
            case 47: {
                this.jj_consume_token(47);
                return 1;
            }
            case 59: {
                this.jj_consume_token(59);
                return 2;
            }
        }
        this.jj_la1[29] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ijResult AbsoluteStatement() throws ParseException, SQLException {
        this.jj_consume_token(14);
        int n = this.intLiteral();
        QualifiedIdentifier qualifiedIdentifier = this.qualifiedIdentifier();
        ResultSet resultSet = this.findCursor(qualifiedIdentifier);
        return this.utilInstance.absolute(resultSet, n);
    }

    public final ijResult RelativeStatement() throws ParseException, SQLException {
        this.jj_consume_token(73);
        int n = this.intLiteral();
        QualifiedIdentifier qualifiedIdentifier = this.qualifiedIdentifier();
        ResultSet resultSet = this.findCursor(qualifiedIdentifier);
        return this.utilInstance.relative(resultSet, n);
    }

    public final ijResult BeforeFirstStatement() throws ParseException, SQLException {
        this.jj_consume_token(23);
        this.jj_consume_token(41);
        QualifiedIdentifier qualifiedIdentifier = this.qualifiedIdentifier();
        ResultSet resultSet = this.findCursor(qualifiedIdentifier);
        return this.utilInstance.beforeFirst(resultSet);
    }

    public final ijResult FirstStatement() throws ParseException, SQLException {
        this.jj_consume_token(41);
        QualifiedIdentifier qualifiedIdentifier = this.qualifiedIdentifier();
        ResultSet resultSet = this.findCursor(qualifiedIdentifier);
        return this.utilInstance.first(resultSet);
    }

    public final ijResult NextStatement() throws ParseException, SQLException {
        this.jj_consume_token(58);
        QualifiedIdentifier qualifiedIdentifier = this.qualifiedIdentifier();
        ResultSet resultSet = this.findCursor(qualifiedIdentifier);
        return new ijRowResult(resultSet, resultSet.next());
    }

    public final ijResult AfterLastStatement() throws ParseException, SQLException {
        this.jj_consume_token(15);
        this.jj_consume_token(54);
        QualifiedIdentifier qualifiedIdentifier = this.qualifiedIdentifier();
        ResultSet resultSet = this.findCursor(qualifiedIdentifier);
        return this.utilInstance.afterLast(resultSet);
    }

    public final ijResult LastStatement() throws ParseException, SQLException {
        this.jj_consume_token(54);
        QualifiedIdentifier qualifiedIdentifier = this.qualifiedIdentifier();
        ResultSet resultSet = this.findCursor(qualifiedIdentifier);
        return this.utilInstance.last(resultSet);
    }

    public final ijResult PreviousStatement() throws ParseException, SQLException {
        this.jj_consume_token(66);
        QualifiedIdentifier qualifiedIdentifier = this.qualifiedIdentifier();
        ResultSet resultSet = this.findCursor(qualifiedIdentifier);
        return this.utilInstance.previous(resultSet);
    }

    public final ijResult GetCurrentRowNumber() throws ParseException, SQLException {
        this.jj_consume_token(46);
        QualifiedIdentifier qualifiedIdentifier = this.qualifiedIdentifier();
        ResultSet resultSet = this.findCursor(qualifiedIdentifier);
        return new ijVectorResult(this.utilInstance.getCurrentRowNumber(resultSet), null);
    }

    public final ijResult CloseStatement() throws ParseException, SQLException {
        this.jj_consume_token(24);
        QualifiedIdentifier qualifiedIdentifier = this.qualifiedIdentifier();
        Session session = this.findSession(qualifiedIdentifier.getSessionName());
        ResultSet resultSet = session.getCursor(qualifiedIdentifier.getLocalName());
        JDBCDisplayUtil.checkNotNull(resultSet, "cursor " + String.valueOf(qualifiedIdentifier));
        Statement statement = session.getCursorStatement(qualifiedIdentifier.getLocalName());
        JDBCDisplayUtil.checkNotNull(statement, "cursor" + String.valueOf(qualifiedIdentifier));
        resultSet.close();
        statement.close();
        session.removeCursor(qualifiedIdentifier.getLocalName());
        session.removeCursorStatement(qualifiedIdentifier.getLocalName());
        return null;
    }

    public final ijResult ExecuteStatement() throws ParseException, SQLException {
        QualifiedIdentifier qualifiedIdentifier = null;
        Token token = null;
        String string = null;
        QualifiedIdentifier qualifiedIdentifier2 = null;
        Token token2 = null;
        Object var7_6 = null;
        this.jj_consume_token(38);
        switch (this.jj_nt.kind) {
            case 88: {
                this.jj_consume_token(88);
                token = this.jj_consume_token(135);
                return this.executeImmediate(this.stringValue(token.image));
            }
            case 67: {
                this.jj_consume_token(67);
                token = this.jj_consume_token(135);
                this.haveConnection();
                Statement statement = this.theConnection.createStatement();
                String string2 = "execute procedure " + String.valueOf(token);
                statement.execute(string2);
                return new ijStatementResult(statement, true);
            }
            case 131: 
            case 135: {
                switch (this.jj_nt.kind) {
                    case 131: {
                        qualifiedIdentifier = this.qualifiedIdentifier();
                        break;
                    }
                    case 135: {
                        token = this.jj_consume_token(135);
                        break;
                    }
                    default: {
                        this.jj_la1[30] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block9 : switch (this.jj_nt.kind) {
                    case 92: {
                        this.jj_consume_token(92);
                        switch (this.jj_nt.kind) {
                            case 131: {
                                qualifiedIdentifier2 = this.qualifiedIdentifier();
                                break block9;
                            }
                            case 135: {
                                token2 = this.jj_consume_token(135);
                                break block9;
                            }
                        }
                        this.jj_la1[31] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[32] = this.jj_gen;
                    }
                }
                if (qualifiedIdentifier2 != null || token2 != null) {
                    PreparedStatement preparedStatement;
                    PreparedStatement preparedStatement2;
                    String string3 = null;
                    SQLWarning sQLWarning = null;
                    boolean bl = false;
                    if (qualifiedIdentifier != null) {
                        preparedStatement2 = this.findPreparedStatement(qualifiedIdentifier);
                    } else {
                        string = this.stringValue(token.image);
                        preparedStatement2 = this.theConnection.prepareStatement(string);
                        bl = true;
                        JDBCDisplayUtil.checkNotNull(preparedStatement2, "prepared statement");
                        sQLWarning = this.appendWarnings(sQLWarning, preparedStatement2.getWarnings());
                        preparedStatement2.clearWarnings();
                    }
                    if (qualifiedIdentifier2 != null) {
                        preparedStatement = this.findPreparedStatement(qualifiedIdentifier2);
                    } else {
                        string3 = this.stringValue(token2.image);
                        preparedStatement = this.theConnection.prepareStatement(string3);
                        JDBCDisplayUtil.checkNotNull(preparedStatement, "prepared statement");
                        sQLWarning = this.appendWarnings(sQLWarning, preparedStatement.getWarnings());
                        preparedStatement.clearWarnings();
                    }
                    if (preparedStatement.execute()) {
                        ResultSet resultSet = preparedStatement.getResultSet();
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        int n = resultSetMetaData.getColumnCount();
                        boolean bl2 = false;
                        boolean bl3 = false;
                        ijMultiResult ijMultiResult2 = new ijMultiResult(preparedStatement2, resultSet, bl);
                        return ijMultiResult2;
                    }
                    throw ijException.noUsingResults();
                }
                if (qualifiedIdentifier != null) {
                    this.haveConnection();
                    PreparedStatement preparedStatement = this.findPreparedStatement(qualifiedIdentifier);
                    preparedStatement.execute();
                    return new ijStatementResult(preparedStatement, false);
                }
                return this.executeImmediate(this.stringValue(token.image));
            }
        }
        this.jj_la1[33] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ijResult AsyncStatement() throws ParseException, SQLException {
        Token token = null;
        this.jj_consume_token(19);
        QualifiedIdentifier qualifiedIdentifier = this.qualifiedIdentifier();
        token = this.jj_consume_token(135);
        return this.executeAsync(this.stringValue(token.image), qualifiedIdentifier);
    }

    public final ijResult WaitForStatement() throws ParseException, SQLException {
        Object var1_1 = null;
        this.jj_consume_token(94);
        this.jj_consume_token(42);
        QualifiedIdentifier qualifiedIdentifier = this.qualifiedIdentifier();
        Session session = this.findSession(qualifiedIdentifier.getSessionName());
        AsyncStatement asyncStatement = session.getAsyncStatement(qualifiedIdentifier.getLocalName());
        if (asyncStatement == null) {
            throw ijException.noSuchAsyncStatement(qualifiedIdentifier.toString());
        }
        try {
            asyncStatement.join();
        }
        catch (InterruptedException interruptedException) {
            throw ijException.waitInterrupted(interruptedException);
        }
        return asyncStatement.getResult();
    }

    public final ijResult RemoveStatement() throws ParseException, SQLException {
        this.jj_consume_token(74);
        QualifiedIdentifier qualifiedIdentifier = this.qualifiedIdentifier();
        Session session = this.findSession(qualifiedIdentifier.getSessionName());
        PreparedStatement preparedStatement = session.getPreparedStatement(qualifiedIdentifier.getLocalName());
        JDBCDisplayUtil.checkNotNull(preparedStatement, "prepared statement " + String.valueOf(qualifiedIdentifier));
        preparedStatement.close();
        session.removePreparedStatement(qualifiedIdentifier.getLocalName());
        return null;
    }

    public final ijResult RunStatement() throws ParseException, SQLException {
        Token token = null;
        this.jj_consume_token(78);
        switch (this.jj_nt.kind) {
            case 75: {
                token = this.jj_consume_token(75);
                break;
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
            }
        }
        Token token2 = this.jj_consume_token(135);
        if (this.utilInstance == null) {
            return null;
        }
        if (token == null) {
            this.utilInstance.newInput(this.stringValue(token2.image));
        } else {
            this.utilInstance.newResourceInput(this.stringValue(token2.image));
        }
        return null;
    }

    public final ijResult AutocommitStatement() throws ParseException, SQLException {
        Token token = null;
        this.jj_consume_token(21);
        switch (this.jj_nt.kind) {
            case 62: {
                token = this.jj_consume_token(62);
                break;
            }
            case 61: {
                this.jj_consume_token(61);
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.haveConnection();
        this.theConnection.setAutoCommit(token != null);
        return null;
    }

    public final ijResult NoHoldForConnectionStatement() throws ParseException, SQLException {
        Object var1_1 = null;
        this.jj_consume_token(60);
        this.haveConnection();
        this.theConnection.setHoldability(2);
        return null;
    }

    public final ijResult HoldForConnectionStatement() throws ParseException, SQLException {
        Object var1_1 = null;
        this.jj_consume_token(48);
        this.haveConnection();
        this.theConnection.setHoldability(1);
        return null;
    }

    public final ijResult LocalizedDisplay() throws ParseException {
        Token token = null;
        this.jj_consume_token(55);
        switch (this.jj_nt.kind) {
            case 62: {
                token = this.jj_consume_token(62);
                break;
            }
            case 61: {
                this.jj_consume_token(61);
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        LocalizedResource.enableLocalization(token != null);
        return null;
    }

    public final ijResult ReadOnlyStatement() throws ParseException, SQLException {
        Token token = null;
        this.jj_consume_token(72);
        switch (this.jj_nt.kind) {
            case 62: {
                token = this.jj_consume_token(62);
                break;
            }
            case 61: {
                this.jj_consume_token(61);
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.haveConnection();
        this.theConnection.setReadOnly(token != null);
        return null;
    }

    public final ijResult ElapsedTimeStatement() throws ParseException {
        Token token = null;
        this.jj_consume_token(34);
        switch (this.jj_nt.kind) {
            case 62: {
                token = this.jj_consume_token(62);
                break;
            }
            case 61: {
                this.jj_consume_token(61);
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.elapsedTime = token != null;
        return null;
    }

    public final ijResult MaximumDisplayWidthStatement() throws ParseException {
        this.jj_consume_token(56);
        int n = this.intValue();
        JDBCDisplayUtil.setMaxDisplayWidth(n);
        return null;
    }

    public final int intValue() throws ParseException {
        Token token = this.jj_consume_token(134);
        return Integer.parseInt(token.image);
    }

    public final ijResult Bang() throws ParseException {
        Token token = null;
        this.jj_consume_token(22);
        token = this.jj_consume_token(135);
        ijVectorResult ijVectorResult2 = null;
        try {
            int n;
            Process process = ij.execProcess(this.stringValue(token.image));
            LocalizedInput localizedInput = new LocalizedInput(process.getInputStream());
            Vector<Object> vector = new Vector<Object>();
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = localizedInput.read()) != -1) {
                stringBuffer.append((char)n);
            }
            localizedInput.close();
            localizedInput = new LocalizedInput(process.getErrorStream());
            while ((n = localizedInput.read()) != -1) {
                stringBuffer.append((char)n);
            }
            localizedInput.close();
            vector.addElement(stringBuffer);
            ijVectorResult2 = new ijVectorResult(vector, null);
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                throw ijException.bangException(interruptedException);
            }
        }
        catch (IOException iOException) {
            throw ijException.bangException(iOException);
        }
        return ijVectorResult2;
    }

    public final void StringList(Vector<Token> vector) throws ParseException {
        this.StringItem(vector);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 135: {
                    break;
                }
                default: {
                    this.jj_la1[39] = this.jj_gen;
                    break block3;
                }
            }
            this.StringItem(vector);
        }
    }

    public final void StringItem(Vector<Token> vector) throws ParseException {
        Token token = this.jj_consume_token(135);
        vector.addElement(token);
    }

    public final ijResult HelpStatement() throws ParseException {
        this.jj_consume_token(49);
        Vector<Object> vector = new Vector<Object>();
        StringTokenizer stringTokenizer = new StringTokenizer(LocalizedResource.getMessage("IJ_HelpText", new Object[0]), "\n");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        return new ijVectorResult(vector, null);
    }

    public final String identifier() throws ParseException {
        Token token = this.jj_consume_token(131);
        return token.image.toUpperCase(Locale.ENGLISH);
    }

    public final QualifiedIdentifier qualifiedIdentifier() throws ParseException {
        String string = null;
        String string2 = null;
        string2 = this.identifier();
        switch (this.jj_nt.kind) {
            case 123: {
                this.jj_consume_token(123);
                string = this.identifier();
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
            }
        }
        if (string == null) {
            this.haveConnection();
            string = this.currentConnEnv.getSession().getName();
        }
        return new QualifiedIdentifier(string, string2);
    }

    public final String caIdentifier() throws ParseException, SQLException {
        Token token = null;
        String string = null;
        switch (this.jj_nt.kind) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                string = this.keyword();
                break;
            }
            case 131: {
                token = this.jj_consume_token(131);
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.haveConnection();
        DatabaseMetaData databaseMetaData = this.theConnection.getMetaData();
        String string2 = string;
        if (token != null) {
            string2 = token.image;
        }
        if (databaseMetaData.storesLowerCaseIdentifiers()) {
            string2 = string2.toLowerCase(Locale.ENGLISH);
        } else if (databaseMetaData.storesUpperCaseIdentifiers()) {
            string2 = string2.toUpperCase(Locale.ENGLISH);
        }
        return string2;
    }

    public final int intLiteral() throws ParseException, SQLException {
        String string = "";
        switch (this.jj_nt.kind) {
            case 129: 
            case 130: {
                string = this.sign();
                break;
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
            }
        }
        Token token = this.jj_consume_token(134);
        String string2 = token.image;
        if (string.equals("-")) {
            string2 = string.concat(string2);
        }
        return Integer.parseInt(string2);
    }

    public final Vector<String> staticMethodName() throws ParseException, SQLException {
        Vector<String> vector = new Vector<String>();
        this.methodLeg(vector);
        block3: while (true) {
            this.jj_consume_token(64);
            this.methodLeg(vector);
            switch (this.jj_nt.kind) {
                case 64: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[43] = this.jj_gen;
        return vector;
    }

    public final void methodLeg(Vector<String> vector) throws ParseException, SQLException {
        Token token = this.jj_consume_token(131);
        vector.addElement(token.image);
    }

    public final String[] staticMethodArgs() throws ParseException, SQLException {
        Vector<String> vector = new Vector<String>();
        this.jj_consume_token(125);
        block0 : switch (this.jj_nt.kind) {
            case 135: {
                this.oneStaticArg(vector);
                while (true) {
                    switch (this.jj_nt.kind) {
                        case 124: {
                            break;
                        }
                        default: {
                            this.jj_la1[44] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(124);
                    this.oneStaticArg(vector);
                }
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
            }
        }
        this.jj_consume_token(126);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public final void oneStaticArg(Vector<String> vector) throws ParseException, SQLException {
        Token token = this.jj_consume_token(135);
        vector.addElement(this.stringValue(token.image));
    }

    public final String sign() throws ParseException, SQLException {
        switch (this.jj_nt.kind) {
            case 130: {
                Token token = this.jj_consume_token(130);
                return token.image;
            }
            case 129: {
                Token token = this.jj_consume_token(129);
                return token.image;
            }
        }
        this.jj_la1[46] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ijResult XA_DataSourceStatement() throws ParseException, SQLException {
        Token token = null;
        Token token2 = null;
        String string = null;
        this.jj_consume_token(98);
        token = this.jj_consume_token(135);
        block0 : switch (this.jj_nt.kind) {
            case 87: 
            case 131: {
                switch (this.jj_nt.kind) {
                    case 87: {
                        token2 = this.jj_consume_token(87);
                        break block0;
                    }
                    case 131: {
                        string = this.identifier();
                        break block0;
                    }
                }
                this.jj_la1[47] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
            }
        }
        this.xahelper.XADataSourceStatement(this, token, token2, string);
        return null;
    }

    public final ijResult XA_ConnectStatement() throws ParseException, SQLException {
        Token token = null;
        Token token2 = null;
        String string = null;
        this.jj_consume_token(99);
        switch (this.jj_nt.kind) {
            case 91: {
                this.jj_consume_token(91);
                token = this.jj_consume_token(135);
                break;
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 63: {
                this.jj_consume_token(63);
                token2 = this.jj_consume_token(135);
                break;
            }
            default: {
                this.jj_la1[50] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 18: {
                this.jj_consume_token(18);
                string = this.identifier();
                break;
            }
            default: {
                this.jj_la1[51] = this.jj_gen;
            }
        }
        this.xahelper.XAConnectStatement(this, token, token2, string);
        return null;
    }

    public final ijResult XA_DisconnectStatement() throws ParseException, SQLException {
        String string = null;
        this.jj_consume_token(101);
        switch (this.jj_nt.kind) {
            case 131: {
                string = this.identifier();
                break;
            }
            default: {
                this.jj_la1[52] = this.jj_gen;
            }
        }
        this.xahelper.XADisconnectStatement(this, string);
        return null;
    }

    public final ijResult XA_CommitStatement() throws ParseException, SQLException {
        Token token = null;
        Token token2 = null;
        int n = 0;
        this.jj_consume_token(100);
        switch (this.jj_nt.kind) {
            case 96: {
                token = this.jj_consume_token(96);
                break;
            }
            case 97: {
                token2 = this.jj_consume_token(97);
                break;
            }
            default: {
                this.jj_la1[53] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        n = this.intValue();
        this.xahelper.CommitStatement(this, token, token2, n);
        return null;
    }

    public final ijResult XA_EndStatement() throws ParseException, SQLException {
        int n = 0;
        int n2 = 0;
        this.jj_consume_token(102);
        n = this.xatmflag();
        n2 = this.intValue();
        this.xahelper.EndStatement(this, n, n2);
        return null;
    }

    public final ijResult XA_ForgetStatement() throws ParseException, SQLException {
        int n = 0;
        this.jj_consume_token(105);
        n = this.intValue();
        this.xahelper.ForgetStatement(this, n);
        return null;
    }

    public final ijResult XA_GetConnectionStatement() throws ParseException, SQLException {
        String string = "XA";
        this.jj_consume_token(106);
        switch (this.jj_nt.kind) {
            case 18: {
                this.jj_consume_token(18);
                string = this.identifier();
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
            }
        }
        this.theConnection = this.xahelper.XAGetConnectionStatement(this, string);
        this.currentConnEnv.addSession(this.theConnection, string);
        return new ijConnectionResult(this.theConnection);
    }

    public final ijResult XA_PrepareStatement() throws ParseException, SQLException {
        int n = 0;
        this.jj_consume_token(109);
        n = this.intValue();
        this.xahelper.PrepareStatement(this, n);
        return null;
    }

    public final ijResult XA_RecoverStatement() throws ParseException, SQLException {
        int n = 0;
        this.jj_consume_token(110);
        n = this.xatmflag();
        return this.xahelper.RecoverStatement(this, n);
    }

    public final ijResult XA_RollbackStatement() throws ParseException, SQLException {
        int n = 0;
        this.jj_consume_token(112);
        n = this.intValue();
        this.xahelper.RollbackStatement(this, n);
        return null;
    }

    public final ijResult XA_StartStatement() throws ParseException, SQLException {
        int n = 0;
        int n2 = 0;
        this.jj_consume_token(113);
        n = this.xatmflag();
        n2 = this.intValue();
        this.xahelper.StartStatement(this, n, n2);
        return null;
    }

    public final int xatmflag() throws ParseException, SQLException {
        switch (this.jj_nt.kind) {
            case 103: {
                this.jj_consume_token(103);
                return 0x800000;
            }
            case 104: {
                this.jj_consume_token(104);
                return 0x20000000;
            }
            case 107: {
                this.jj_consume_token(107);
                return 0x200000;
            }
            case 108: {
                this.jj_consume_token(108);
                return 0;
            }
            case 111: {
                this.jj_consume_token(111);
                return 0x8000000;
            }
            case 114: {
                this.jj_consume_token(114);
                return 0x1000000;
            }
            case 115: {
                this.jj_consume_token(115);
                return 0x4000000;
            }
            case 116: {
                this.jj_consume_token(116);
                return 0x2000000;
            }
        }
        this.jj_la1[55] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ijResult DataSourceStatement() throws ParseException, SQLException {
        Token token = null;
        Token token2 = null;
        Token token3 = null;
        Token token4 = null;
        String string = null;
        this.jj_consume_token(117);
        token = this.jj_consume_token(135);
        switch (this.jj_nt.kind) {
            case 70: {
                this.jj_consume_token(70);
                token2 = this.jj_consume_token(135);
                break;
            }
            default: {
                this.jj_la1[56] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 91: {
                this.jj_consume_token(91);
                token3 = this.jj_consume_token(135);
                break;
            }
            default: {
                this.jj_la1[57] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 63: {
                this.jj_consume_token(63);
                token4 = this.jj_consume_token(135);
                break;
            }
            default: {
                this.jj_la1[58] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 18: {
                this.jj_consume_token(18);
                string = this.identifier();
                break;
            }
            default: {
                this.jj_la1[59] = this.jj_gen;
            }
        }
        this.theConnection = this.xahelper.DataSourceStatement(this, token, token2, token3, token4, string);
        return this.addSession(this.theConnection, string);
    }

    public final ijResult CP_DataSourceStatement() throws ParseException, SQLException {
        Token token = null;
        Token token2 = null;
        this.jj_consume_token(118);
        token = this.jj_consume_token(135);
        switch (this.jj_nt.kind) {
            case 70: {
                this.jj_consume_token(70);
                token2 = this.jj_consume_token(135);
                break;
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
            }
        }
        this.xahelper.CPDataSourceStatement(this, token, token2);
        return null;
    }

    public final ijResult CP_ConnectStatement() throws ParseException, SQLException {
        Token token = null;
        Token token2 = null;
        String string = null;
        this.jj_consume_token(119);
        switch (this.jj_nt.kind) {
            case 91: {
                this.jj_consume_token(91);
                token = this.jj_consume_token(135);
                break;
            }
            default: {
                this.jj_la1[61] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 63: {
                this.jj_consume_token(63);
                token2 = this.jj_consume_token(135);
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 18: {
                this.jj_consume_token(18);
                string = this.identifier();
                break;
            }
            default: {
                this.jj_la1[63] = this.jj_gen;
            }
        }
        this.xahelper.CPConnectStatement(this, token, token2, string);
        return null;
    }

    public final ijResult CP_GetConnectionStatement() throws ParseException, SQLException {
        String string = "Pooled";
        this.jj_consume_token(120);
        switch (this.jj_nt.kind) {
            case 18: {
                this.jj_consume_token(18);
                string = this.identifier();
                break;
            }
            default: {
                this.jj_la1[64] = this.jj_gen;
            }
        }
        this.theConnection = this.xahelper.CPGetConnectionStatement(this, string);
        this.currentConnEnv.addSession(this.theConnection, string);
        return new ijConnectionResult(this.theConnection);
    }

    public final ijResult CP_DisconnectStatement() throws ParseException, SQLException {
        String string = null;
        this.jj_consume_token(121);
        switch (this.jj_nt.kind) {
            case 131: {
                string = this.identifier();
                break;
            }
            default: {
                this.jj_la1[65] = this.jj_gen;
            }
        }
        this.xahelper.CPDisconnectStatement(this, string);
        return null;
    }

    public final void attributeList(Properties properties) throws ParseException {
        if (this.getToken((int)2).kind != 37) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.property(properties);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 124: {
                    break;
                }
                default: {
                    this.jj_la1[66] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(124);
            this.property(properties);
        }
    }

    public final void property(Properties properties) throws ParseException {
        String string = this.caseSensitiveIdentifierOrKeyword();
        this.jj_consume_token(37);
        String string2 = this.caseSensitiveIdentifierOrKeyword();
        properties.put(string, string2);
    }

    public final String caseSensitiveIdentifierOrKeyword() throws ParseException {
        String string = null;
        switch (this.jj_nt.kind) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                string = this.keyword();
                return string;
            }
            case 131: {
                Token token = this.jj_consume_token(131);
                return token.image;
            }
        }
        this.jj_la1[67] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String caseSensitiveIdentifier() throws ParseException {
        Token token = this.jj_consume_token(131);
        return token.image;
    }

    public final String keyword() throws ParseException {
        Object var2_1 = null;
        Token token = switch (this.jj_nt.kind) {
            case 14 -> this.jj_consume_token(14);
            case 15 -> this.jj_consume_token(15);
            case 16 -> this.jj_consume_token(16);
            case 17 -> this.jj_consume_token(17);
            case 18 -> this.jj_consume_token(18);
            case 19 -> this.jj_consume_token(19);
            case 20 -> this.jj_consume_token(20);
            case 21 -> this.jj_consume_token(21);
            case 22 -> this.jj_consume_token(22);
            case 23 -> this.jj_consume_token(23);
            case 24 -> this.jj_consume_token(24);
            case 25 -> this.jj_consume_token(25);
            case 26 -> this.jj_consume_token(26);
            case 27 -> this.jj_consume_token(27);
            case 28 -> this.jj_consume_token(28);
            case 29 -> this.jj_consume_token(29);
            case 30 -> this.jj_consume_token(30);
            case 31 -> this.jj_consume_token(31);
            case 32 -> this.jj_consume_token(32);
            case 33 -> this.jj_consume_token(33);
            case 34 -> this.jj_consume_token(34);
            case 36 -> this.jj_consume_token(36);
            case 38 -> this.jj_consume_token(38);
            case 39 -> this.jj_consume_token(39);
            case 40 -> this.jj_consume_token(40);
            case 41 -> this.jj_consume_token(41);
            case 42 -> this.jj_consume_token(42);
            case 43 -> this.jj_consume_token(43);
            case 45 -> this.jj_consume_token(45);
            case 46 -> this.jj_consume_token(46);
            case 47 -> this.jj_consume_token(47);
            case 49 -> this.jj_consume_token(49);
            case 50 -> this.jj_consume_token(50);
            case 51 -> this.jj_consume_token(51);
            case 52 -> this.jj_consume_token(52);
            case 53 -> this.jj_consume_token(53);
            case 54 -> this.jj_consume_token(54);
            case 55 -> this.jj_consume_token(55);
            case 56 -> this.jj_consume_token(56);
            case 57 -> this.jj_consume_token(57);
            case 58 -> this.jj_consume_token(58);
            case 59 -> this.jj_consume_token(59);
            case 60 -> this.jj_consume_token(60);
            case 61 -> this.jj_consume_token(61);
            case 62 -> this.jj_consume_token(62);
            case 63 -> this.jj_consume_token(63);
            case 64 -> this.jj_consume_token(64);
            case 65 -> this.jj_consume_token(65);
            case 66 -> this.jj_consume_token(66);
            case 67 -> this.jj_consume_token(67);
            case 68 -> this.jj_consume_token(68);
            case 69 -> this.jj_consume_token(69);
            case 70 -> this.jj_consume_token(70);
            case 71 -> this.jj_consume_token(71);
            case 72 -> this.jj_consume_token(72);
            case 73 -> this.jj_consume_token(73);
            case 74 -> this.jj_consume_token(74);
            case 75 -> this.jj_consume_token(75);
            case 77 -> this.jj_consume_token(77);
            case 78 -> this.jj_consume_token(78);
            case 79 -> this.jj_consume_token(79);
            case 81 -> this.jj_consume_token(81);
            case 82 -> this.jj_consume_token(82);
            case 83 -> this.jj_consume_token(83);
            case 84 -> this.jj_consume_token(84);
            case 86 -> this.jj_consume_token(86);
            case 87 -> this.jj_consume_token(87);
            case 88 -> this.jj_consume_token(88);
            case 89 -> this.jj_consume_token(89);
            case 90 -> this.jj_consume_token(90);
            case 91 -> this.jj_consume_token(91);
            case 92 -> this.jj_consume_token(92);
            case 93 -> this.jj_consume_token(93);
            case 94 -> this.jj_consume_token(94);
            case 95 -> this.jj_consume_token(95);
            case 96 -> this.jj_consume_token(96);
            case 97 -> this.jj_consume_token(97);
            case 98 -> this.jj_consume_token(98);
            case 99 -> this.jj_consume_token(99);
            case 100 -> this.jj_consume_token(100);
            case 101 -> this.jj_consume_token(101);
            case 102 -> this.jj_consume_token(102);
            case 103 -> this.jj_consume_token(103);
            case 104 -> this.jj_consume_token(104);
            case 105 -> this.jj_consume_token(105);
            case 106 -> this.jj_consume_token(106);
            case 107 -> this.jj_consume_token(107);
            case 108 -> this.jj_consume_token(108);
            case 109 -> this.jj_consume_token(109);
            case 110 -> this.jj_consume_token(110);
            case 111 -> this.jj_consume_token(111);
            case 112 -> this.jj_consume_token(112);
            case 113 -> this.jj_consume_token(113);
            case 114 -> this.jj_consume_token(114);
            case 115 -> this.jj_consume_token(115);
            case 116 -> this.jj_consume_token(116);
            case 117 -> this.jj_consume_token(117);
            case 118 -> this.jj_consume_token(118);
            case 119 -> this.jj_consume_token(119);
            case 120 -> this.jj_consume_token(120);
            case 121 -> this.jj_consume_token(121);
            case 122 -> this.jj_consume_token(122);
            default -> {
                this.jj_la1[68] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
        return token.image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, n);
        }
    }

    private final boolean jj_3R_77() {
        return this.jj_scan_token(49);
    }

    private final boolean jj_3R_105() {
        return this.jj_scan_token(117);
    }

    private final boolean jj_3R_66() {
        return this.jj_scan_token(25);
    }

    private final boolean jj_3R_78() {
        return this.jj_scan_token(48);
    }

    private final boolean jj_3R_99() {
        return this.jj_scan_token(102);
    }

    private final boolean jj_3R_65() {
        return this.jj_scan_token(24);
    }

    private final boolean jj_3R_117() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(14)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(15)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(16)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(17)) {
                        this.jj_scanpos = token;
                        if (this.jj_scan_token(18)) {
                            this.jj_scanpos = token;
                            if (this.jj_scan_token(19)) {
                                this.jj_scanpos = token;
                                if (this.jj_scan_token(20)) {
                                    this.jj_scanpos = token;
                                    if (this.jj_scan_token(21)) {
                                        this.jj_scanpos = token;
                                        if (this.jj_scan_token(22)) {
                                            this.jj_scanpos = token;
                                            if (this.jj_scan_token(23)) {
                                                this.jj_scanpos = token;
                                                if (this.jj_scan_token(24)) {
                                                    this.jj_scanpos = token;
                                                    if (this.jj_scan_token(25)) {
                                                        this.jj_scanpos = token;
                                                        if (this.jj_scan_token(26)) {
                                                            this.jj_scanpos = token;
                                                            if (this.jj_scan_token(27)) {
                                                                this.jj_scanpos = token;
                                                                if (this.jj_scan_token(28)) {
                                                                    this.jj_scanpos = token;
                                                                    if (this.jj_scan_token(29)) {
                                                                        this.jj_scanpos = token;
                                                                        if (this.jj_scan_token(30)) {
                                                                            this.jj_scanpos = token;
                                                                            if (this.jj_scan_token(31)) {
                                                                                this.jj_scanpos = token;
                                                                                if (this.jj_scan_token(32)) {
                                                                                    this.jj_scanpos = token;
                                                                                    if (this.jj_scan_token(33)) {
                                                                                        this.jj_scanpos = token;
                                                                                        if (this.jj_scan_token(34)) {
                                                                                            this.jj_scanpos = token;
                                                                                            if (this.jj_scan_token(36)) {
                                                                                                this.jj_scanpos = token;
                                                                                                if (this.jj_scan_token(38)) {
                                                                                                    this.jj_scanpos = token;
                                                                                                    if (this.jj_scan_token(39)) {
                                                                                                        this.jj_scanpos = token;
                                                                                                        if (this.jj_scan_token(40)) {
                                                                                                            this.jj_scanpos = token;
                                                                                                            if (this.jj_scan_token(41)) {
                                                                                                                this.jj_scanpos = token;
                                                                                                                if (this.jj_scan_token(42)) {
                                                                                                                    this.jj_scanpos = token;
                                                                                                                    if (this.jj_scan_token(43)) {
                                                                                                                        this.jj_scanpos = token;
                                                                                                                        if (this.jj_scan_token(45)) {
                                                                                                                            this.jj_scanpos = token;
                                                                                                                            if (this.jj_scan_token(46)) {
                                                                                                                                this.jj_scanpos = token;
                                                                                                                                if (this.jj_scan_token(47)) {
                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                    if (this.jj_scan_token(49)) {
                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                        if (this.jj_scan_token(50)) {
                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                            if (this.jj_scan_token(51)) {
                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                if (this.jj_scan_token(52)) {
                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                    if (this.jj_scan_token(53)) {
                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                        if (this.jj_scan_token(54)) {
                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                            if (this.jj_scan_token(55)) {
                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                if (this.jj_scan_token(56)) {
                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                    if (this.jj_scan_token(57)) {
                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                        if (this.jj_scan_token(58)) {
                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                            if (this.jj_scan_token(59)) {
                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                if (this.jj_scan_token(60)) {
                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                    if (this.jj_scan_token(61)) {
                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                        if (this.jj_scan_token(62)) {
                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                            if (this.jj_scan_token(63)) {
                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                if (this.jj_scan_token(64)) {
                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                    if (this.jj_scan_token(65)) {
                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                        if (this.jj_scan_token(66)) {
                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                            if (this.jj_scan_token(67)) {
                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                if (this.jj_scan_token(68)) {
                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                    if (this.jj_scan_token(69)) {
                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                        if (this.jj_scan_token(70)) {
                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                            if (this.jj_scan_token(71)) {
                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                if (this.jj_scan_token(72)) {
                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                    if (this.jj_scan_token(73)) {
                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                        if (this.jj_scan_token(74)) {
                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                            if (this.jj_scan_token(75)) {
                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                if (this.jj_scan_token(77)) {
                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                    if (this.jj_scan_token(78)) {
                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                        if (this.jj_scan_token(79)) {
                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                            if (this.jj_scan_token(81)) {
                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                if (this.jj_scan_token(82)) {
                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                    if (this.jj_scan_token(83)) {
                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                        if (this.jj_scan_token(84)) {
                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                            if (this.jj_scan_token(86)) {
                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                if (this.jj_scan_token(87)) {
                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(88)) {
                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(89)) {
                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(90)) {
                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(91)) {
                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(92)) {
                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(93)) {
                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(94)) {
                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(95)) {
                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(96)) {
                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(97)) {
                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(98)) {
                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(99)) {
                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(100)) {
                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(101)) {
                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(102)) {
                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(103)) {
                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(104)) {
                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(105)) {
                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(106)) {
                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(107)) {
                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(108)) {
                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(109)) {
                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(110)) {
                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(111)) {
                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(112)) {
                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(113)) {
                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(114)) {
                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(115)) {
                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(116)) {
                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(117)) {
                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(118)) {
                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(119)) {
                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(120)) {
                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(121)) {
                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(122)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_83() {
        return this.jj_scan_token(60);
    }

    private final boolean jj_3R_70() {
        return this.jj_scan_token(33);
    }

    private final boolean jj_3R_96() {
        return this.jj_scan_token(100);
    }

    private final boolean jj_3R_76() {
        return this.jj_scan_token(46);
    }

    private final boolean jj_3R_68() {
        return this.jj_scan_token(31);
    }

    private final boolean jj_3R_85() {
        return this.jj_scan_token(66);
    }

    private final boolean jj_3R_116() {
        return this.jj_scan_token(131);
    }

    private final boolean jj_3R_61() {
        return this.jj_scan_token(21);
    }

    private final boolean jj_3R_97() {
        return this.jj_scan_token(101);
    }

    private final boolean jj_3R_86() {
        return this.jj_scan_token(70);
    }

    private final boolean jj_3R_115() {
        return this.jj_3R_117();
    }

    private final boolean jj_3R_114() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_115()) {
            this.jj_scanpos = token;
            if (this.jj_3R_116()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_75() {
        return this.jj_scan_token(45);
    }

    private final boolean jj_3R_79() {
        return this.jj_scan_token(54);
    }

    private final boolean jj_3R_111() {
        return this.jj_3R_114();
    }

    private final boolean jj_3R_63() {
        return this.jj_scan_token(22);
    }

    private final boolean jj_3R_110() {
        return false;
    }

    private final boolean jj_3R_56() {
        return this.jj_3R_109();
    }

    private final boolean jj_3R_95() {
        return this.jj_scan_token(99);
    }

    private final boolean jj_3R_55() {
        return this.jj_3R_108();
    }

    private final boolean jj_3R_54() {
        return this.jj_3R_107();
    }

    private final boolean jj_3R_90() {
        return this.jj_scan_token(78);
    }

    private final boolean jj_3R_53() {
        return this.jj_3R_106();
    }

    private final boolean jj_3R_52() {
        return this.jj_3R_105();
    }

    private final boolean jj_3R_60() {
        return this.jj_scan_token(15);
    }

    private final boolean jj_3R_51() {
        return this.jj_3R_104();
    }

    private final boolean jj_3R_50() {
        return this.jj_3R_103();
    }

    private final boolean jj_3R_92() {
        return this.jj_scan_token(86);
    }

    private final boolean jj_3R_49() {
        return this.jj_3R_102();
    }

    private final boolean jj_3R_48() {
        return this.jj_3R_101();
    }

    private final boolean jj_3R_57() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 37;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_110()) {
            return true;
        }
        return this.jj_3R_111();
    }

    private final boolean jj_3R_104() {
        return this.jj_scan_token(113);
    }

    private final boolean jj_3R_47() {
        return this.jj_3R_100();
    }

    private final boolean jj_3R_46() {
        return this.jj_3R_99();
    }

    private final boolean jj_3R_45() {
        return this.jj_3R_98();
    }

    private final boolean jj_3R_44() {
        return this.jj_3R_97();
    }

    private final boolean jj_3R_43() {
        return this.jj_3R_96();
    }

    private final boolean jj_3R_42() {
        return this.jj_3R_95();
    }

    private final boolean jj_3R_41() {
        return this.jj_3R_94();
    }

    private final boolean jj_3R_40() {
        return this.jj_3R_93();
    }

    private final boolean jj_3R_39() {
        return this.jj_3R_92();
    }

    private final boolean jj_3R_38() {
        return this.jj_3R_91();
    }

    private final boolean jj_3R_37() {
        return this.jj_3R_90();
    }

    private final boolean jj_3R_82() {
        return this.jj_scan_token(58);
    }

    private final boolean jj_3R_36() {
        return this.jj_3R_89();
    }

    private final boolean jj_3R_35() {
        return this.jj_3R_88();
    }

    private final boolean jj_3_2() {
        return this.jj_3R_57();
    }

    private final boolean jj_3R_34() {
        return this.jj_3R_87();
    }

    private final boolean jj_3R_33() {
        return this.jj_3R_86();
    }

    private final boolean jj_3R_32() {
        return this.jj_3R_85();
    }

    private final boolean jj_3R_109() {
        return this.jj_scan_token(121);
    }

    private final boolean jj_3R_89() {
        return this.jj_scan_token(74);
    }

    private final boolean jj_3R_84() {
        return this.jj_scan_token(65);
    }

    private final boolean jj_3R_31() {
        return this.jj_3R_84();
    }

    private final boolean jj_3R_81() {
        return this.jj_scan_token(56);
    }

    private final boolean jj_3R_30() {
        return this.jj_3R_83();
    }

    private final boolean jj_3R_94() {
        return this.jj_scan_token(98);
    }

    private final boolean jj_3R_29() {
        return this.jj_3R_82();
    }

    private final boolean jj_3R_103() {
        return this.jj_scan_token(112);
    }

    private final boolean jj_3R_28() {
        return this.jj_3R_81();
    }

    private final boolean jj_3R_27() {
        return this.jj_3R_80();
    }

    private final boolean jj_3R_26() {
        return this.jj_3R_79();
    }

    private final boolean jj_3R_24() {
        return this.jj_3R_77();
    }

    private final boolean jj_3R_23() {
        return this.jj_3R_76();
    }

    private final boolean jj_3R_22() {
        return this.jj_3R_75();
    }

    private final boolean jj_3R_91() {
        return this.jj_scan_token(84);
    }

    private final boolean jj_3R_25() {
        return this.jj_3R_78();
    }

    private final boolean jj_3R_21() {
        return this.jj_3R_74();
    }

    private final boolean jj_3R_20() {
        return this.jj_3R_73();
    }

    private final boolean jj_3R_73() {
        return this.jj_scan_token(41);
    }

    private final boolean jj_3R_19() {
        return this.jj_3R_72();
    }

    private final boolean jj_3R_18() {
        return this.jj_3R_71();
    }

    private final boolean jj_3R_17() {
        return this.jj_3R_70();
    }

    private final boolean jj_3R_16() {
        return this.jj_3R_69();
    }

    private final boolean jj_3R_15() {
        return this.jj_3R_68();
    }

    private final boolean jj_3R_113() {
        return this.jj_scan_token(71);
    }

    private final boolean jj_3R_14() {
        return this.jj_3R_67();
    }

    private final boolean jj_3R_13() {
        return this.jj_3R_66();
    }

    private final boolean jj_3R_12() {
        return this.jj_3R_65();
    }

    private final boolean jj_3R_11() {
        return this.jj_3R_64();
    }

    private final boolean jj_3R_112() {
        return this.jj_scan_token(39);
    }

    private final boolean jj_3R_108() {
        return this.jj_scan_token(120);
    }

    private final boolean jj_3R_102() {
        return this.jj_scan_token(110);
    }

    private final boolean jj_3R_74() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_112()) {
            this.jj_scanpos = token;
            if (this.jj_3R_113()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_10() {
        return this.jj_3R_63();
    }

    private final boolean jj_3R_9() {
        return this.jj_3R_62();
    }

    private final boolean jj_3R_8() {
        return this.jj_3R_61();
    }

    private final boolean jj_3R_7() {
        return this.jj_3R_60();
    }

    private final boolean jj_3R_6() {
        return this.jj_3R_59();
    }

    private final boolean jj_3R_71() {
        return this.jj_scan_token(34);
    }

    private final boolean jj_3R_64() {
        return this.jj_scan_token(23);
    }

    private final boolean jj_3R_93() {
        return this.jj_scan_token(94);
    }

    private final boolean jj_3R_5() {
        return this.jj_3R_58();
    }

    private final boolean jj_3_1() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 77 && this.getToken((int)3).kind != 79 && this.getToken((int)3).kind != 80;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_5()) {
            this.jj_scanpos = token;
            if (this.jj_3R_6()) {
                this.jj_scanpos = token;
                if (this.jj_3R_7()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_8()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_9()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_10()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_11()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3R_12()) {
                                        this.jj_scanpos = token;
                                        if (this.jj_3R_13()) {
                                            this.jj_scanpos = token;
                                            if (this.jj_3R_14()) {
                                                this.jj_scanpos = token;
                                                if (this.jj_3R_15()) {
                                                    this.jj_scanpos = token;
                                                    if (this.jj_3R_16()) {
                                                        this.jj_scanpos = token;
                                                        if (this.jj_3R_17()) {
                                                            this.jj_scanpos = token;
                                                            if (this.jj_3R_18()) {
                                                                this.jj_scanpos = token;
                                                                if (this.jj_3R_19()) {
                                                                    this.jj_scanpos = token;
                                                                    if (this.jj_3R_20()) {
                                                                        this.jj_scanpos = token;
                                                                        if (this.jj_3R_21()) {
                                                                            this.jj_scanpos = token;
                                                                            if (this.jj_3R_22()) {
                                                                                this.jj_scanpos = token;
                                                                                if (this.jj_3R_23()) {
                                                                                    this.jj_scanpos = token;
                                                                                    if (this.jj_3R_24()) {
                                                                                        this.jj_scanpos = token;
                                                                                        if (this.jj_3R_25()) {
                                                                                            this.jj_scanpos = token;
                                                                                            if (this.jj_3R_26()) {
                                                                                                this.jj_scanpos = token;
                                                                                                if (this.jj_3R_27()) {
                                                                                                    this.jj_scanpos = token;
                                                                                                    if (this.jj_3R_28()) {
                                                                                                        this.jj_scanpos = token;
                                                                                                        if (this.jj_3R_29()) {
                                                                                                            this.jj_scanpos = token;
                                                                                                            if (this.jj_3R_30()) {
                                                                                                                this.jj_scanpos = token;
                                                                                                                if (this.jj_3R_31()) {
                                                                                                                    this.jj_scanpos = token;
                                                                                                                    if (this.jj_3R_32()) {
                                                                                                                        this.jj_scanpos = token;
                                                                                                                        if (this.jj_3R_33()) {
                                                                                                                            this.jj_scanpos = token;
                                                                                                                            if (this.jj_3R_34()) {
                                                                                                                                this.jj_scanpos = token;
                                                                                                                                if (this.jj_3R_35()) {
                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                    if (this.jj_3R_36()) {
                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                        if (this.jj_3R_37()) {
                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                            if (this.jj_3R_38()) {
                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                if (this.jj_3R_39()) {
                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                    if (this.jj_3R_40()) {
                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                        if (this.jj_3R_41()) {
                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                            if (this.jj_3R_42()) {
                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                if (this.jj_3R_43()) {
                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                    if (this.jj_3R_44()) {
                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                        if (this.jj_3R_45()) {
                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                            if (this.jj_3R_46()) {
                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                if (this.jj_3R_47()) {
                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                    if (this.jj_3R_48()) {
                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                        if (this.jj_3R_49()) {
                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                            if (this.jj_3R_50()) {
                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                if (this.jj_3R_51()) {
                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                    if (this.jj_3R_52()) {
                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                        if (this.jj_3R_53()) {
                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                            if (this.jj_3R_54()) {
                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                if (this.jj_3R_55()) {
                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                    if (this.jj_3R_56()) {
                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_101() {
        return this.jj_scan_token(109);
    }

    private final boolean jj_3R_107() {
        return this.jj_scan_token(119);
    }

    private final boolean jj_3R_88() {
        return this.jj_scan_token(73);
    }

    private final boolean jj_3R_87() {
        return this.jj_scan_token(72);
    }

    private final boolean jj_3R_69() {
        return this.jj_scan_token(32);
    }

    private final boolean jj_3R_62() {
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_72() {
        return this.jj_scan_token(38);
    }

    private final boolean jj_3R_59() {
        return this.jj_scan_token(14);
    }

    private final boolean jj_3R_98() {
        return this.jj_scan_token(106);
    }

    private final boolean jj_3R_106() {
        return this.jj_scan_token(118);
    }

    private final boolean jj_3R_80() {
        return this.jj_scan_token(55);
    }

    private final boolean jj_3R_58() {
        return this.jj_scan_token(77);
    }

    private final boolean jj_3R_100() {
        return this.jj_scan_token(105);
    }

    private final boolean jj_3R_67() {
        return this.jj_scan_token(26);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{-2014789632, 262144, 0, 0, 0, 0, 0, 0x100000, 262144, 0, -16384, 262144, 65536, 0, 0, 0, 0, 0, 0, 0x10010000, 0, 0, 0x20020000, 0x20020000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -16384, 0, 0, 0, 0, 0, 0, 0, 0, 0, 262144, 0, 0, 262144, 0, 0, 0, 0, 262144, 0, 0, 0, 262144, 262144, 0, 0, -16384, -16384};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{365126343, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 0, 0, 0, -69673, 0, 0, 262144, 0, 264192, 264192, 262144, 262144, 528392, 0, 0, 0, 0, 128, 0, 0, 0, 0x100000, 0x8008000, 0, 0, 0, 0, 0, 0x60000000, 0x60000000, 0x60000000, 0x60000000, 0, 0, -69673, 0, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 0, 0, 0, Integer.MIN_VALUE, 0, 0, 0, 0, -69673, -69673};
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[]{1079003078, 0, 0, 32768, 64, 0x8000000, 0, 0, 0, 1, -2166785, 0, 0x26000000, 0, 1, 0, 0, 0, 0, 639766544, 0, 0, 0, 0, 128, 8, 262144, Integer.MIN_VALUE, 524288, 0, 0, 0, 0x10000000, 0x1000008, 2048, 0, 0, 0, 0, 0, 0, -2166785, 0, 1, 0, 0, 0, 0x800000, 0x800000, 0x8000000, 0, 0, 0, 0, 0, 0, 64, 0x8000000, 0, 0, 64, 0x8000000, 0, 0, 0, 0, 0, -2166785, -2166785};
    }

    private static void jj_la1_3() {
        jj_la1_3 = new int[]{65234556, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x7FFFFFF, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 0x4000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x8000000, 0x7FFFFFF, 0, 0, 0x10000000, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 1874304, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x10000000, 0x7FFFFFF, 0x7FFFFFF};
    }

    private static void jj_la1_4() {
        jj_la1_4 = new int[]{0, 0, 136, 136, 0, 0, 0, 0, 0, 0, 136, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 0, 8, 0, 0, 0, 0, 136, 136, 0, 136, 0, 0, 0, 0, 0, 128, 0, 8, 6, 0, 0, 128, 6, 8, 8, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 8, 0};
    }

    public ij(CharStream charStream) {
        int n;
        this.token_source = new ijTokenManager(charStream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (n = 0; n < 69; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(CharStream charStream) {
        int n;
        this.token_source.ReInit(charStream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (n = 0; n < 69; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public ij(ijTokenManager ijTokenManager2) {
        int n;
        this.token_source = ijTokenManager2;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (n = 0; n < 69; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(ijTokenManager ijTokenManager2) {
        int n;
        this.token_source = ijTokenManager2;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (n = 0; n < 69; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = this.jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.jj_nt = this.token;
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        if (this.jj_scanpos.kind != n) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            int n3;
            this.jj_expentry = new int[this.jj_endpos];
            for (n3 = 0; n3 < this.jj_endpos; ++n3) {
                this.jj_expentry[n3] = this.jj_lasttokens[n3];
            }
            n3 = 0;
            Enumeration<int[]> enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = enumeration.nextElement();
                if (nArray.length != this.jj_expentry.length) continue;
                n3 = 1;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (nArray[i] == this.jj_expentry[i]) continue;
                    n3 = 0;
                    break;
                }
                if (n3 == 0) continue;
                break;
            }
            if (n3 == 0) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[136];
        for (n2 = 0; n2 < 136; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 69; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) != 0) {
                    blArray[32 + n] = true;
                }
                if ((jj_la1_2[n2] & 1 << n) != 0) {
                    blArray[64 + n] = true;
                }
                if ((jj_la1_3[n2] & 1 << n) != 0) {
                    blArray[96 + n] = true;
                }
                if ((jj_la1_4[n2] & 1 << n) == 0) continue;
                blArray[128 + n] = true;
            }
        }
        for (n2 = 0; n2 < 136; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, ijConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            try {
                JJCalls jJCalls = this.jj_2_rtns[i];
                do {
                    if (jJCalls.gen <= this.jj_gen) continue;
                    this.jj_la = jJCalls.arg;
                    this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((jJCalls = jJCalls.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static {
        ij.jj_la1_0();
        ij.jj_la1_1();
        ij.jj_la1_2();
        ij.jj_la1_3();
        ij.jj_la1_4();
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

