/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjdoc;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.javacc.jjdoc.Generator;
import org.javacc.jjdoc.HTMLGenerator;
import org.javacc.jjdoc.JJDocGlobals;
import org.javacc.jjdoc.JJDocOptions;
import org.javacc.parser.Action;
import org.javacc.parser.BNFProduction;
import org.javacc.parser.CharacterRange;
import org.javacc.parser.Choice;
import org.javacc.parser.Expansion;
import org.javacc.parser.JavaCCGlobals;
import org.javacc.parser.JavaCCParserInternals;
import org.javacc.parser.JavaCodeProduction;
import org.javacc.parser.Lookahead;
import org.javacc.parser.NonTerminal;
import org.javacc.parser.NormalProduction;
import org.javacc.parser.OneOrMore;
import org.javacc.parser.RCharacterList;
import org.javacc.parser.RChoice;
import org.javacc.parser.REndOfFile;
import org.javacc.parser.RJustName;
import org.javacc.parser.ROneOrMore;
import org.javacc.parser.RSequence;
import org.javacc.parser.RStringLiteral;
import org.javacc.parser.RZeroOrMore;
import org.javacc.parser.RZeroOrOne;
import org.javacc.parser.RegularExpression;
import org.javacc.parser.Sequence;
import org.javacc.parser.SingleCharacter;
import org.javacc.parser.Token;
import org.javacc.parser.TokenProduction;
import org.javacc.parser.TryBlock;
import org.javacc.parser.ZeroOrMore;
import org.javacc.parser.ZeroOrOne;

public class JJDoc
extends JavaCCGlobals {
    static void start() {
        PrintWriter printWriter = JJDoc.create_output_stream();
        Generator generator = JJDocOptions.getText() ? new Generator(printWriter) : new HTMLGenerator(printWriter);
        generator.documentStart();
        JJDoc.emitTokenProductions(generator, rexprlist);
        JJDoc.emitNormalProductions(generator, bnfproductions);
        generator.documentEnd();
        printWriter.close();
    }

    private static Token getPrecedingSpecialToken(Token token) {
        Token token2 = token;
        while (token2.specialToken != null) {
            token2 = token2.specialToken;
        }
        return token2 != token ? token2 : null;
    }

    private static void emitTopLevelSpecialTokens(Token token, Generator generator) {
        if (token == null) {
            return;
        }
        token = JJDoc.getPrecedingSpecialToken(token);
        String string = "";
        if (token != null) {
            cline = token.beginLine;
            ccol = token.beginColumn;
            while (token != null) {
                string = string + JJDoc.printTokenOnly(token);
                token = token.next;
            }
        }
        generator.specialTokens(string);
    }

    private static boolean toplevelExpansion(Expansion expansion) {
        return expansion.parent != null && (expansion.parent instanceof NormalProduction || expansion.parent instanceof TokenProduction);
    }

    private static void emitTokenProductions(Generator generator, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            TokenProduction tokenProduction = (TokenProduction)enumeration.nextElement();
        }
    }

    private static void emitNormalProductions(Generator generator, Vector vector) {
        generator.nonterminalsStart();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            NormalProduction normalProduction = (NormalProduction)enumeration.nextElement();
            JJDoc.emitTopLevelSpecialTokens(normalProduction.firstToken, generator);
            if (normalProduction instanceof BNFProduction) {
                generator.productionStart(normalProduction);
                if (normalProduction.expansion instanceof Choice) {
                    boolean bl = true;
                    Choice choice = (Choice)normalProduction.expansion;
                    Enumeration enumeration2 = choice.choices.elements();
                    while (enumeration2.hasMoreElements()) {
                        Expansion expansion = (Expansion)enumeration2.nextElement();
                        generator.expansionStart(expansion, bl);
                        JJDoc.emitExpansionTree(expansion, generator);
                        generator.expansionEnd(expansion, bl);
                        bl = false;
                    }
                } else {
                    generator.expansionStart(normalProduction.expansion, true);
                    JJDoc.emitExpansionTree(normalProduction.expansion, generator);
                    generator.expansionEnd(normalProduction.expansion, true);
                }
                generator.productionEnd(normalProduction);
                continue;
            }
            if (!(normalProduction instanceof JavaCodeProduction)) continue;
            generator.javacode((JavaCodeProduction)normalProduction);
        }
        generator.nonterminalsEnd();
    }

    private static void emitExpansionTree(Expansion expansion, Generator generator) {
        if (expansion instanceof Action) {
            JJDoc.emitExpansionAction((Action)expansion, generator);
        } else if (expansion instanceof Choice) {
            JJDoc.emitExpansionChoice((Choice)expansion, generator);
        } else if (expansion instanceof Lookahead) {
            JJDoc.emitExpansionLookahead((Lookahead)expansion, generator);
        } else if (expansion instanceof NonTerminal) {
            JJDoc.emitExpansionNonTerminal((NonTerminal)expansion, generator);
        } else if (expansion instanceof OneOrMore) {
            JJDoc.emitExpansionOneOrMore((OneOrMore)expansion, generator);
        } else if (expansion instanceof RegularExpression) {
            JJDoc.emitExpansionRegularExpression((RegularExpression)expansion, generator);
        } else if (expansion instanceof Sequence) {
            JJDoc.emitExpansionSequence((Sequence)expansion, generator);
        } else if (expansion instanceof TryBlock) {
            JJDoc.emitExpansionTryBlock((TryBlock)expansion, generator);
        } else if (expansion instanceof ZeroOrMore) {
            JJDoc.emitExpansionZeroOrMore((ZeroOrMore)expansion, generator);
        } else if (expansion instanceof ZeroOrOne) {
            JJDoc.emitExpansionZeroOrOne((ZeroOrOne)expansion, generator);
        } else {
            System.out.println("Oops: Unknown expansion type.");
        }
    }

    private static void emitExpansionAction(Action action, Generator generator) {
    }

    private static void emitExpansionChoice(Choice choice, Generator generator) {
        Enumeration enumeration = choice.choices.elements();
        while (enumeration.hasMoreElements()) {
            Expansion expansion = (Expansion)enumeration.nextElement();
            JJDoc.emitExpansionTree(expansion, generator);
            if (!enumeration.hasMoreElements()) continue;
            generator.text(" | ");
        }
    }

    private static void emitExpansionLookahead(Lookahead lookahead, Generator generator) {
    }

    private static void emitExpansionNonTerminal(NonTerminal nonTerminal, Generator generator) {
        generator.nonTerminalStart(nonTerminal);
        generator.text(nonTerminal.name);
        generator.nonTerminalEnd(nonTerminal);
    }

    private static void emitExpansionOneOrMore(OneOrMore oneOrMore, Generator generator) {
        generator.text("( ");
        JJDoc.emitExpansionTree(oneOrMore.expansion, generator);
        generator.text(" )+");
    }

    private static void emitExpansionRegularExpression(RegularExpression regularExpression, Generator generator) {
        generator.reStart(regularExpression);
        JJDoc.emitRE(regularExpression, generator);
        generator.reEnd(regularExpression);
    }

    private static void emitExpansionSequence(Sequence sequence, Generator generator) {
        boolean bl = true;
        Enumeration enumeration = sequence.units.elements();
        while (enumeration.hasMoreElements()) {
            boolean bl2;
            Expansion expansion = (Expansion)enumeration.nextElement();
            if (expansion instanceof Lookahead || expansion instanceof Action) continue;
            if (!bl) {
                generator.text(" ");
            }
            boolean bl3 = bl2 = expansion instanceof Choice || expansion instanceof Sequence;
            if (bl2) {
                generator.text("( ");
            }
            JJDoc.emitExpansionTree(expansion, generator);
            if (bl2) {
                generator.text(" )");
            }
            bl = false;
        }
    }

    private static void emitExpansionTryBlock(TryBlock tryBlock, Generator generator) {
        boolean bl = tryBlock.exp instanceof Choice;
        if (bl) {
            generator.text("( ");
        }
        JJDoc.emitExpansionTree(tryBlock.exp, generator);
        if (bl) {
            generator.text(" )");
        }
    }

    private static void emitExpansionZeroOrMore(ZeroOrMore zeroOrMore, Generator generator) {
        generator.text("( ");
        JJDoc.emitExpansionTree(zeroOrMore.expansion, generator);
        generator.text(" )*");
    }

    private static void emitExpansionZeroOrOne(ZeroOrOne zeroOrOne, Generator generator) {
        generator.text("( ");
        JJDoc.emitExpansionTree(zeroOrOne.expansion, generator);
        generator.text(" )?");
    }

    private static void emitRE(RegularExpression regularExpression, Generator generator) {
        boolean bl;
        boolean bl2 = !regularExpression.label.equals("");
        boolean bl3 = regularExpression instanceof RJustName;
        boolean bl4 = regularExpression instanceof REndOfFile;
        boolean bl5 = regularExpression instanceof RStringLiteral;
        boolean bl6 = regularExpression.tpContext != null;
        boolean bl7 = bl = bl3 || bl4 || bl2 || !bl5 && bl6;
        if (bl) {
            generator.text("<");
            if (!bl3) {
                if (regularExpression.private_rexp) {
                    generator.text("#");
                }
                if (bl2) {
                    generator.text(regularExpression.label);
                    generator.text(": ");
                }
            }
        }
        if (regularExpression instanceof RCharacterList) {
            RCharacterList rCharacterList = (RCharacterList)regularExpression;
            if (rCharacterList.negated_list) {
                generator.text("~");
            }
            generator.text("[");
            Enumeration enumeration = rCharacterList.descriptors.elements();
            while (enumeration.hasMoreElements()) {
                char[] cArray;
                Object e = enumeration.nextElement();
                if (e instanceof SingleCharacter) {
                    generator.text("\"");
                    cArray = new char[]{((SingleCharacter)e).ch};
                    generator.text(JJDoc.add_escapes(new String(cArray)));
                    generator.text("\"");
                } else if (e instanceof CharacterRange) {
                    generator.text("\"");
                    cArray = new char[]{((CharacterRange)e).left};
                    generator.text(JJDoc.add_escapes(new String(cArray)));
                    generator.text("\"-\"");
                    cArray[0] = ((CharacterRange)e).right;
                    generator.text(JJDoc.add_escapes(new String(cArray)));
                    generator.text("\"");
                } else {
                    System.out.println("Oops: unknown character list element type.");
                }
                if (!enumeration.hasMoreElements()) continue;
                generator.text(",");
            }
            generator.text("]");
        } else if (regularExpression instanceof RChoice) {
            RChoice rChoice = (RChoice)regularExpression;
            Enumeration enumeration = rChoice.choices.elements();
            while (enumeration.hasMoreElements()) {
                RegularExpression regularExpression2 = (RegularExpression)enumeration.nextElement();
                JJDoc.emitRE(regularExpression2, generator);
                if (!enumeration.hasMoreElements()) continue;
                generator.text(" | ");
            }
        } else if (regularExpression instanceof REndOfFile) {
            generator.text("EOF");
        } else if (regularExpression instanceof RJustName) {
            RJustName rJustName = (RJustName)regularExpression;
            generator.text(rJustName.label);
        } else if (regularExpression instanceof ROneOrMore) {
            ROneOrMore rOneOrMore = (ROneOrMore)regularExpression;
            generator.text("(");
            JJDoc.emitRE(rOneOrMore.regexpr, generator);
            generator.text(")+");
        } else if (regularExpression instanceof RSequence) {
            RSequence rSequence = (RSequence)regularExpression;
            Enumeration enumeration = rSequence.units.elements();
            while (enumeration.hasMoreElements()) {
                RegularExpression regularExpression3 = (RegularExpression)enumeration.nextElement();
                boolean bl8 = false;
                if (regularExpression3 instanceof RChoice) {
                    bl8 = true;
                }
                if (bl8) {
                    generator.text("(");
                }
                JJDoc.emitRE(regularExpression3, generator);
                if (bl8) {
                    generator.text(")");
                }
                if (!enumeration.hasMoreElements()) continue;
                generator.text(" ");
            }
        } else if (regularExpression instanceof RStringLiteral) {
            RStringLiteral rStringLiteral = (RStringLiteral)regularExpression;
            generator.text("\"" + JavaCCParserInternals.add_escapes(rStringLiteral.image) + "\"");
        } else if (regularExpression instanceof RZeroOrMore) {
            RZeroOrMore rZeroOrMore = (RZeroOrMore)regularExpression;
            generator.text("(");
            JJDoc.emitRE(rZeroOrMore.regexpr, generator);
            generator.text(")*");
        } else if (regularExpression instanceof RZeroOrOne) {
            RZeroOrOne rZeroOrOne = (RZeroOrOne)regularExpression;
            generator.text("(");
            JJDoc.emitRE(rZeroOrOne.regexpr, generator);
            generator.text(")?");
        } else {
            System.out.println("Oops: Unknown regular expression type.");
        }
        if (bl) {
            generator.text(">");
        }
    }

    private static String v2s(Vector vector, boolean bl) {
        String string = "";
        boolean bl2 = true;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Token token = (Token)enumeration.nextElement();
            Token token2 = JJDoc.getPrecedingSpecialToken(token);
            if (bl2) {
                if (token2 != null) {
                    cline = token2.beginLine;
                    ccol = token2.beginColumn;
                } else {
                    cline = token.beginLine;
                    ccol = token.beginColumn;
                }
                string = JJDoc.ws(ccol - 1);
                bl2 = false;
            }
            while (token2 != null) {
                string = string + JJDoc.printToken(token2);
                token2 = token2.next;
            }
            string = string + JJDoc.printToken(token);
        }
        return string;
    }

    private static PrintWriter create_output_stream() {
        PrintWriter printWriter;
        if (JJDocOptions.getOutputFile().equals("")) {
            String string;
            int n;
            if (JJDocGlobals.input_file.equals("standard input")) {
                return new PrintWriter(new OutputStreamWriter(System.out));
            }
            String string2 = ".html";
            if (JJDocOptions.getText()) {
                string2 = ".txt";
            }
            JJDocGlobals.output_file = (n = JJDocGlobals.input_file.lastIndexOf(46)) == -1 ? JJDocGlobals.input_file + string2 : ((string = JJDocGlobals.input_file.substring(n)).equals(string2) ? JJDocGlobals.input_file + string2 : JJDocGlobals.input_file.substring(0, n) + string2);
        } else {
            JJDocGlobals.output_file = JJDocOptions.getOutputFile();
        }
        try {
            printWriter = new PrintWriter(new FileWriter(JJDocGlobals.output_file));
        }
        catch (IOException iOException) {
            System.err.println("JJDoc: can't open output stream on file " + JJDocGlobals.output_file + ".  Using standard output.");
            printWriter = new PrintWriter(new OutputStreamWriter(System.out));
        }
        return printWriter;
    }

    private static String ws(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + " ";
        }
        return string;
    }
}

