/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjtree;

import org.javacc.jjtree.IO;
import org.javacc.jjtree.JJTreeParser;
import org.javacc.jjtree.JJTreeParserTreeConstants;
import org.javacc.jjtree.Node;
import org.javacc.jjtree.NodeScope;
import org.javacc.jjtree.Token;

public class SimpleNode
implements Node {
    private Node parent;
    private Node[] children;
    private int id;
    private int myOrdinal;
    private Token first;
    private Token last;
    private boolean whitingOut = false;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(JJTreeParser jJTreeParser, int n) {
        this(n);
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
        ((SimpleNode)node).setOrdinal(n);
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return JJTreeParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.dump(string + " ");
            }
        }
    }

    public int getOrdinal() {
        return this.myOrdinal;
    }

    public void setOrdinal(int n) {
        this.myOrdinal = n;
    }

    public Token getFirstToken() {
        return this.first;
    }

    public void setFirstToken(Token token) {
        this.first = token;
    }

    public Token getLastToken() {
        return this.last;
    }

    public void setLastToken(Token token) {
        this.last = token;
    }

    public void print(IO iO) {
        if (this.getLastToken().next == this.getFirstToken()) {
            return;
        }
        Token token = this.getFirstToken();
        Token token2 = new Token();
        token2.next = token;
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            SimpleNode simpleNode = (SimpleNode)this.jjtGetChild(i);
            while ((token2 = token2.next) != simpleNode.getFirstToken()) {
                this.print(token2, iO);
            }
            simpleNode.print(iO);
            token2 = simpleNode.getLastToken();
        }
        while (token2 != this.getLastToken()) {
            token2 = token2.next;
            this.print(token2, iO);
        }
    }

    String translateImage(Token token) {
        return token.image;
    }

    String whiteOut(Token token) {
        String string = "";
        for (int i = 0; i < token.image.length(); ++i) {
            string = string + " ";
        }
        return string;
    }

    protected void print(Token token, IO iO) {
        NodeScope nodeScope;
        Token token2 = token.specialToken;
        if (token2 != null) {
            while (token2.specialToken != null) {
                token2 = token2.specialToken;
            }
            while (token2 != null) {
                iO.print(this.addUnicodeEscapes(this.translateImage(token2)));
                token2 = token2.next;
            }
        }
        if ((nodeScope = NodeScope.getEnclosingNodeScope(this)) == null) {
            iO.print(this.addUnicodeEscapes(this.translateImage(token)));
            return;
        }
        if (token.image.equals("jjtThis")) {
            iO.print(nodeScope.getNodeVariable());
            return;
        }
        if (token.image.equals("jjtree") && token.next.image.equals(".") && token.next.next.image.equals("currentNode") && token.next.next.next.image.equals("(") && token.next.next.next.next.image.equals(")")) {
            this.whitingOut = true;
        }
        if (this.whitingOut) {
            if (token.image.equals("jjtree")) {
                iO.print(nodeScope.getNodeVariable());
                iO.print(" ");
            } else if (token.image.equals(")")) {
                iO.print(" ");
                this.whitingOut = false;
            } else {
                for (int i = 0; i < token.image.length(); ++i) {
                    iO.print(" ");
                }
            }
            return;
        }
        iO.print(this.addUnicodeEscapes(this.translateImage(token)));
    }

    protected String addUnicodeEscapes(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ((c < ' ' || c > '~') && c != '\t' && c != '\n' && c != '\r' && c != '\f') {
                String string3 = "0000" + Integer.toString(c, 16);
                string2 = string2 + "\\u" + string3.substring(string3.length() - 4, string3.length());
                continue;
            }
            string2 = string2 + c;
        }
        return string2;
    }

    static void openJJTreeComment(IO iO, String string) {
        if (string != null) {
            iO.print("/*@bgen(jjtree) " + string + " */");
        } else {
            iO.print("/*@bgen(jjtree)*/");
        }
    }

    static void closeJJTreeComment(IO iO) {
        iO.print("/*@egen*/");
    }

    String getIndentation(SimpleNode simpleNode) {
        return this.getIndentation(simpleNode, 0);
    }

    String getIndentation(SimpleNode simpleNode, int n) {
        String string = "";
        for (int i = n + 1; i < simpleNode.getFirstToken().beginColumn; ++i) {
            string = string + " ";
        }
        return string;
    }
}

