/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.scope.view;

import java.lang.annotation.Annotation;
import java.util.Map;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.bean.ViewScoped;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PreDestroyViewMapEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.apache.deltaspike.core.util.context.AbstractContext;
import org.apache.deltaspike.core.util.context.ContextualStorage;

public class ViewScopedContext
extends AbstractContext
implements SystemEventListener {
    private static final String CONTEXTUAL_MAP_NAME = "deltaspike.contextualInstanceMap";
    private boolean isJsfSubscribed = false;
    private BeanManager beanManager;

    public ViewScopedContext(BeanManager beanManager) {
        super(beanManager);
        this.beanManager = beanManager;
    }

    protected ContextualStorage getContextualStorage(Contextual<?> contextual, boolean createIfNotExists) {
        Map<String, Object> viewMap = this.getViewMap();
        ContextualStorage storage = (ContextualStorage)viewMap.get(CONTEXTUAL_MAP_NAME);
        if (storage == null && createIfNotExists) {
            storage = new ContextualStorage(this.beanManager, false, this.isPassivatingScope());
            viewMap.put(CONTEXTUAL_MAP_NAME, storage);
        }
        return storage;
    }

    public <T> T get(Contextual<T> bean) {
        this.subscribeToJsf();
        return (T)super.get(bean);
    }

    public <T> T get(Contextual<T> bean, CreationalContext<T> creationalContext) {
        this.subscribeToJsf();
        return (T)super.get(bean, creationalContext);
    }

    public Class<? extends Annotation> getScope() {
        return ViewScoped.class;
    }

    public boolean isActive() {
        return this.getViewRoot() != null;
    }

    private void subscribeToJsf() {
        if (!this.isJsfSubscribed) {
            FacesContext.getCurrentInstance().getApplication().subscribeToEvent(PreDestroyViewMapEvent.class, (SystemEventListener)this);
            this.isJsfSubscribed = true;
        }
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof UIViewRoot;
    }

    public void processEvent(SystemEvent event) {
        if (event instanceof PreDestroyViewMapEvent) {
            this.destroyAllActive();
        }
    }

    protected UIViewRoot getViewRoot() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            return context.getViewRoot();
        }
        return null;
    }

    protected Map<String, Object> getViewMap() {
        UIViewRoot viewRoot = this.getViewRoot();
        if (viewRoot != null) {
            return viewRoot.getViewMap(true);
        }
        return null;
    }
}

