/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.servlet.impl.produce;

import java.security.Principal;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Typed;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.deltaspike.core.api.common.DeltaSpike;
import org.apache.deltaspike.servlet.impl.produce.RequestResponseHolder;
import org.apache.deltaspike.servlet.impl.produce.ServletContextHolder;

public class ServletObjectProducer {
    @Produces
    @DeltaSpike
    public ServletContext getServletContext() {
        return ServletContextHolder.get();
    }

    @Produces
    @DeltaSpike
    @RequestScoped
    public ServletRequest getServletRequest() {
        return RequestResponseHolder.REQUEST.get();
    }

    @Produces
    @Typed(value={HttpServletRequest.class})
    @DeltaSpike
    @RequestScoped
    public HttpServletRequest getHttpServletRequest() {
        ServletRequest request = RequestResponseHolder.REQUEST.get();
        if (request instanceof HttpServletRequest) {
            return (HttpServletRequest)request;
        }
        throw new IllegalStateException("The current request is not a HttpServletRequest");
    }

    @Produces
    @DeltaSpike
    @RequestScoped
    public ServletResponse getServletResponse() {
        return RequestResponseHolder.RESPONSE.get();
    }

    @Produces
    @Typed(value={HttpServletResponse.class})
    @DeltaSpike
    @RequestScoped
    public HttpServletResponse getHttpServletResponse() {
        ServletResponse response = RequestResponseHolder.RESPONSE.get();
        if (response instanceof HttpServletResponse) {
            return (HttpServletResponse)response;
        }
        throw new IllegalStateException("The current response is not a HttpServletResponse");
    }

    @Produces
    @DeltaSpike
    @RequestScoped
    public HttpSession getHttpSession() {
        ServletRequest request = RequestResponseHolder.REQUEST.get();
        if (request instanceof HttpServletRequest) {
            return ((HttpServletRequest)request).getSession(true);
        }
        throw new IllegalStateException("Cannot produce HttpSession because the current request is not a HttpServletRequest");
    }

    @Produces
    @DeltaSpike
    @RequestScoped
    public Principal getPrincipal() {
        return this.getHttpServletRequest().getUserPrincipal();
    }
}

