/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.extendedResponse;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.ldap.codec.api.ExtendedResponseDecorator;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreExtendedResponseValue
extends GrammarAction<LdapMessageContainer<ExtendedResponseDecorator<?>>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreExtendedResponseValue.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreExtendedResponseValue() {
        super("Store response value");
    }

    public void action(LdapMessageContainer<ExtendedResponseDecorator<?>> container) throws DecoderException {
        ExtendedResponseDecorator<?> extendedResponse = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            extendedResponse.setResponseValue(Strings.EMPTY_BYTES);
        } else {
            extendedResponse.setResponseValue(tlv.getValue().getData());
        }
        container.setGrammarEndAllowed(true);
        if (IS_DEBUG) {
            LOG.debug("Extended value : {}", (Object)extendedResponse.getResponseValue());
        }
    }
}

