/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;

public final class FacsimileTelephoneNumberSyntaxChecker
extends SyntaxChecker {
    private static final String DEFAULT_REGEXP = "^ *[+]? *((\\([0-9- ,;/#*]+\\))|[0-9- ,;/#*]+)+$";
    private final String defaultRegexp;
    private Pattern defaultPattern;
    private static final String TWO_DIMENSIONAL = "twoDimensional";
    private static final String FINE_RESOLUTION = "fineResolution";
    private static final String UNLIMITED_LENGTH = "unlimitedLength";
    private static final String B4_LENGTH = "b4Length";
    private static final String A3_LENGTH = "a3Width";
    private static final String B4_WIDTH = "b4Width";
    private static final String UNCOMPRESSED = "uncompressed";
    private static Set<String> faxParameters = new HashSet<String>();
    public static final FacsimileTelephoneNumberSyntaxChecker INSTANCE;

    private FacsimileTelephoneNumberSyntaxChecker(String oid) {
        this(oid, DEFAULT_REGEXP, Pattern.compile(DEFAULT_REGEXP));
    }

    private FacsimileTelephoneNumberSyntaxChecker(String oid, String defaultRegexp, Pattern defaultPattern) {
        super(oid);
        this.defaultPattern = defaultPattern;
        this.defaultRegexp = defaultRegexp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getRegexp() {
        if (this.defaultRegexp == null) {
            return DEFAULT_REGEXP;
        }
        return this.defaultRegexp;
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{"null"}));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        if (strValue.length() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{value}));
            }
            return false;
        }
        int dollarPos = strValue.indexOf(36);
        if (dollarPos == -1) {
            boolean result = this.defaultPattern.matcher(strValue).matches();
            if (LOG.isDebugEnabled()) {
                if (result) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_04489_SYNTAX_VALID, (Object[])new Object[]{value}));
                } else {
                    LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{value}));
                }
            }
            return result;
        }
        if (dollarPos > 0) {
            boolean result = this.defaultPattern.matcher(strValue.substring(0, dollarPos - 1)).matches();
            if (LOG.isDebugEnabled()) {
                if (result) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_04489_SYNTAX_VALID, (Object[])new Object[]{value}));
                } else {
                    LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{value}));
                    return false;
                }
            }
            HashSet<String> paramsSeen = new HashSet<String>();
            while (dollarPos > 0) {
                int newDollar = strValue.indexOf(36, dollarPos + 1);
                String faxParam = newDollar == -1 ? strValue.substring(dollarPos + 1) : strValue.substring(dollarPos + 1, newDollar);
                if (faxParam.length() == 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{value}));
                    }
                    return false;
                }
                if (!faxParameters.contains(faxParam = Strings.toLowerCaseAscii((String)faxParam)) || paramsSeen.contains(faxParam)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{value}));
                    }
                    return false;
                }
                paramsSeen.add(faxParam);
                dollarPos = newDollar;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_04489_SYNTAX_VALID, (Object[])new Object[]{value}));
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{value}));
        }
        return false;
    }

    static {
        faxParameters.add(Strings.toLowerCaseAscii((String)TWO_DIMENSIONAL));
        faxParameters.add(Strings.toLowerCaseAscii((String)FINE_RESOLUTION));
        faxParameters.add(Strings.toLowerCaseAscii((String)UNLIMITED_LENGTH));
        faxParameters.add(Strings.toLowerCaseAscii((String)B4_LENGTH));
        faxParameters.add(Strings.toLowerCaseAscii((String)A3_LENGTH));
        faxParameters.add(Strings.toLowerCaseAscii((String)B4_WIDTH));
        faxParameters.add(Strings.toLowerCaseAscii((String)UNCOMPRESSED));
        INSTANCE = new FacsimileTelephoneNumberSyntaxChecker("1.3.6.1.4.1.1466.115.121.1.22");
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<FacsimileTelephoneNumberSyntaxChecker> {
        private String defaultRegexp;
        private Pattern defaultPattern;

        private Builder() {
            super("1.3.6.1.4.1.1466.115.121.1.22");
            this.setDefaultRegexp(FacsimileTelephoneNumberSyntaxChecker.DEFAULT_REGEXP);
        }

        @Override
        public FacsimileTelephoneNumberSyntaxChecker build() {
            return new FacsimileTelephoneNumberSyntaxChecker(this.oid, this.defaultRegexp, this.defaultPattern);
        }

        public Builder setDefaultRegexp(String regexp) {
            this.defaultRegexp = regexp;
            try {
                this.defaultPattern = Pattern.compile(regexp);
            }
            catch (PatternSyntaxException pse) {
                this.defaultPattern = Pattern.compile(FacsimileTelephoneNumberSyntaxChecker.DEFAULT_REGEXP);
            }
            return this;
        }
    }
}

