/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.fortress.core.model.Administrator;
import org.apache.directory.fortress.core.model.Constraint;
import org.apache.directory.fortress.core.model.ConstraintUtil;
import org.apache.directory.fortress.core.model.ParentUtil;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.core.util.Config;

@XmlRootElement(name="fortUserAdminRole")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="userAdminRole", propOrder={"osPs", "osUs", "beginInclusive", "beginRange", "endInclusive", "endRange", "parents"})
public class UserAdminRole
extends UserRole
implements Administrator {
    private static final long serialVersionUID = 1L;
    private Set<String> osPs;
    private Set<String> osUs;
    private String beginRange;
    private String endRange;
    private boolean beginInclusive;
    private boolean endInclusive;
    private Set<String> parents;
    private static final String P = "P";
    private static final String U = "U";
    private static final String R = "R";
    private static final String LEFT_PAREN = "(";
    private static final String RIGHT_PAREN = ")";
    private static final String LEFT_BRACKET = "[";
    private static final String RIGHT_BRACKET = "]";

    public UserAdminRole() {
    }

    public UserAdminRole(String userId, String name) {
        this.userId = userId;
        this.name = name;
    }

    public UserAdminRole(String userId, Constraint con) {
        this.userId = userId;
        ConstraintUtil.copy(con, this);
    }

    @Override
    public void load(String szRawData, String contextId, ParentUtil parentUtil) {
        if (szRawData != null && szRawData.length() > 0) {
            String[] tokens = StringUtils.splitPreserveAllTokens((String)szRawData, (String)Config.getInstance().getDelimiter());
            block11: for (int i = 0; i < tokens.length; ++i) {
                if (!StringUtils.isNotEmpty((CharSequence)tokens[i])) continue;
                switch (i) {
                    case 0: {
                        this.name = tokens[i];
                        this.parents = parentUtil.getParentsCB(this.name.toUpperCase(), contextId);
                        continue block11;
                    }
                    case 1: {
                        this.setTimeout(Integer.parseInt(tokens[i]));
                        continue block11;
                    }
                    case 2: {
                        this.setBeginTime(tokens[i]);
                        continue block11;
                    }
                    case 3: {
                        this.setEndTime(tokens[i]);
                        continue block11;
                    }
                    case 4: {
                        this.setBeginDate(tokens[i]);
                        continue block11;
                    }
                    case 5: {
                        this.setEndDate(tokens[i]);
                        continue block11;
                    }
                    case 6: {
                        this.setBeginLockDate(tokens[i]);
                        continue block11;
                    }
                    case 7: {
                        this.setEndLockDate(tokens[i]);
                        continue block11;
                    }
                    case 8: {
                        this.setDayMask(tokens[i]);
                        continue block11;
                    }
                    default: {
                        String szValue = tokens[i];
                        int indx = szValue.indexOf("P:");
                        if (indx >= 0) {
                            String szOsP = szValue.substring(indx + 2);
                            this.setOsP(szOsP);
                        }
                        if ((indx = szValue.indexOf("U:")) >= 0) {
                            String szOsU = szValue.substring(indx + 2);
                            this.setOsU(szOsU);
                        }
                        if ((indx = szValue.indexOf("R:")) < 0) continue block11;
                        String szRangeRaw = szValue.substring(indx + 2);
                        this.setRoleRangeRaw(szRangeRaw);
                    }
                }
            }
        }
    }

    @Override
    public String getRawData() {
        String delimeter = Config.getInstance().getDelimiter();
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append(delimeter);
        sb.append(this.getTimeout());
        sb.append(delimeter);
        if (this.getBeginTime() != null) {
            sb.append(this.getBeginTime());
        }
        sb.append(delimeter);
        if (this.getEndTime() != null) {
            sb.append(this.getEndTime());
        }
        sb.append(delimeter);
        if (this.getBeginDate() != null) {
            sb.append(this.getBeginDate());
        }
        sb.append(delimeter);
        if (this.getEndDate() != null) {
            sb.append(this.getEndDate());
        }
        sb.append(delimeter);
        if (this.getBeginLockDate() != null) {
            sb.append(this.getBeginLockDate());
        }
        sb.append(delimeter);
        if (this.getEndLockDate() != null) {
            sb.append(this.getEndLockDate());
        }
        sb.append(delimeter);
        if (this.getDayMask() != null) {
            sb.append(this.getDayMask());
        }
        if (this.getOsUSet() != null) {
            for (String org : this.getOsUSet()) {
                sb.append(delimeter);
                sb.append(U);
                sb.append(':');
                sb.append(org);
            }
        }
        if (this.getOsPSet() != null) {
            for (String org : this.getOsPSet()) {
                sb.append(delimeter);
                sb.append(P);
                sb.append(':');
                sb.append(org);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getRoleRangeRaw())) {
            sb.append(delimeter);
            sb.append(R);
            sb.append(':');
            sb.append(this.getRoleRangeRaw());
        }
        String szRole = sb.toString();
        return szRole;
    }

    @Override
    public void setRoleRangeRaw(String szRaw) {
        if (StringUtils.isNotEmpty((CharSequence)szRaw)) {
            int bindx = szRaw.indexOf(LEFT_PAREN);
            if (bindx > -1) {
                this.setBeginInclusive(false);
            } else {
                bindx = szRaw.indexOf(LEFT_BRACKET);
                this.setBeginInclusive(true);
            }
            int eindx = szRaw.indexOf(RIGHT_PAREN);
            if (eindx > -1) {
                this.setEndInclusive(false);
            } else {
                eindx = szRaw.indexOf(RIGHT_BRACKET);
                this.setEndInclusive(true);
            }
            int cindx = szRaw.indexOf(58);
            if (cindx > -1) {
                String szBeginRange = szRaw.substring(bindx + 1, cindx);
                String szEndRange = szRaw.substring(cindx + 1, eindx);
                this.setBeginRange(szBeginRange);
                this.setEndRange(szEndRange);
            }
        }
    }

    @Override
    public String getRoleRangeRaw() {
        Object szRaw = "";
        if (this.beginRange != null) {
            szRaw = this.isBeginInclusive() ? (String)szRaw + LEFT_BRACKET : (String)szRaw + LEFT_PAREN;
            szRaw = (String)szRaw + this.getBeginRange();
            szRaw = (String)szRaw + ":";
            szRaw = (String)szRaw + this.getEndRange();
            szRaw = this.isEndInclusive() ? (String)szRaw + RIGHT_BRACKET : (String)szRaw + RIGHT_PAREN;
        }
        return szRaw;
    }

    @Override
    public Set<String> getOsPSet() {
        return this.osPs;
    }

    @Override
    public void setOsPSet(Set<String> osPs) {
        this.osPs = osPs;
    }

    @Override
    public void setOsP(String osP) {
        if (this.osPs == null) {
            this.osPs = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        }
        this.osPs.add(osP);
    }

    @Override
    public Set<String> getOsUSet() {
        return this.osUs;
    }

    @Override
    public void setOsUSet(Set<String> osUs) {
        this.osUs = osUs;
    }

    @Override
    public void setOsU(String osU) {
        if (this.osUs == null) {
            this.osUs = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        }
        this.osUs.add(osU);
    }

    @Override
    public String getBeginRange() {
        return this.beginRange;
    }

    @Override
    public void setBeginRange(String beginRange) {
        this.beginRange = beginRange;
    }

    @Override
    public String getEndRange() {
        return this.endRange;
    }

    @Override
    public void setEndRange(String endRange) {
        this.endRange = endRange;
    }

    @Override
    public boolean isBeginInclusive() {
        return this.beginInclusive;
    }

    @Override
    public void setBeginInclusive(boolean beginInclusive) {
        this.beginInclusive = beginInclusive;
    }

    @Override
    public boolean isEndInclusive() {
        return this.endInclusive;
    }

    @Override
    public void setEndInclusive(boolean endInclusive) {
        this.endInclusive = endInclusive;
    }

    @Override
    public Set<String> getParents() {
        return this.parents;
    }

    @Override
    public void setParents(Set<String> parents) {
        this.parents = parents;
    }

    @Override
    public boolean equals(Object thatObj) {
        if (this == thatObj) {
            return true;
        }
        if (this.getName() == null) {
            return false;
        }
        if (!(thatObj instanceof UserAdminRole)) {
            return false;
        }
        UserAdminRole thatRole = (UserAdminRole)thatObj;
        if (thatRole.getName() == null) {
            return false;
        }
        return thatRole.getName().equalsIgnoreCase(this.getName()) && thatRole.getUserId().equalsIgnoreCase(this.getUserId());
    }

    @Override
    public int hashCode() {
        int result = this.osPs != null ? this.osPs.hashCode() : 0;
        result = 31 * result + (this.osUs != null ? this.osUs.hashCode() : 0);
        result = 31 * result + (this.beginRange != null ? this.beginRange.hashCode() : 0);
        result = 31 * result + (this.endRange != null ? this.endRange.hashCode() : 0);
        result = 31 * result + (this.beginInclusive ? 1 : 0);
        result = 31 * result + (this.endInclusive ? 1 : 0);
        result = 31 * result + (this.parents != null ? this.parents.hashCode() : 0);
        return result;
    }
}

