---
{
    "title": "Import Overview",
    "language": "en"
}
---

<!-- 
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->

# Import Overview

## Supported Data Sources

Doris provides a variety of data import solutions, and you can choose different data import methods for different data sources.

### By Scene

| Data Source                          | Import Method                                                |
| ------------------------------------ | ------------------------------------------------------------ |
| Object Storage (s3), HDFS            | [Import data using Broker](./import-scenes/external-storage-load.md) |
| Local file                           | [Import local data](./import-scenes/local-file-load.md)    |
| Kafka                                | [Subscribe to Kafka data](./import-scenes/kafka-load.md)   |
| Mysql, PostgreSQL, Oracle, SQLServer | [Sync data via external table](./import-scenes/external-table-load.md) |
| Import via JDBC                      | [Sync data using JDBC](./import-scenes/jdbc-load.md)       |
| Import JSON format data              | [JSON format data import](./import-way/load-json-format.md) |

### Divided by Import Method

| Import method name | Use method                                                   |
| ------------------ | ------------------------------------------------------------ |
| Spark Load         | [Import external data via Spark](./import-way/spark-load-manual.md) |
| Broker Load        | [Import external storage data via Broker](./import-way/broker-load-manual.md) |
| Stream Load        | [Stream import data (local file and memory data)](./import-way/stream-load-manual.md) |
| Routine Load       | [Import Kafka data](./import-way/routine-load-manual.md)   |
| Insert Into        | [External table imports data through INSERT](./import-way/insert-into-manual.md) |
| S3 Load            | [Object storage data import of S3 protocol](./import-way/s3-load-manual.md) |
| MySql Load         | [Local data import of MySql protocol](./import-way/mysql-load-manual.md) |

## Supported Data Formats

Different import methods support slightly different data formats.

| Import Methods | Supported Formats       |
| -------------- | ----------------------- |
| Broker Load    | parquet, orc, csv, gzip |
| Stream Load    | csv, json, parquet, orc |
| Routine Load   | csv, json               |
| MySql Load     | csv                     |

## Import Instructions

The data import implementation of Apache Doris has the following common features, which are introduced here to help you better use the data import function

## Import Atomicity Guarantees

Each import job of Doris, whether it is batch import using Broker Load or single import using INSERT statement, is a complete transaction operation. The import transaction can ensure that the data in a batch takes effect atomically, and there will be no partial data writing.

At the same time, an import job will have a Label. This Label is unique under a database (Database) and is used to uniquely identify an import job. Label can be specified by the user, and some import functions will also be automatically generated by the system.

Label is used to ensure that the corresponding import job can only be successfully imported once. A successfully imported Label, when used again, will be rejected with the error `Label already used`. Through this mechanism, `At-Most-Once` semantics can be implemented in Doris. If combined with the `At-Least-Once` semantics of the upstream system, the `Exactly-Once` semantics of imported data can be achieved.

For best practices on atomicity guarantees, see Importing Transactions and Atomicity.

## Synchronous and Asynchronous Imports

Import methods are divided into synchronous and asynchronous. For the synchronous import method, the returned result indicates whether the import succeeds or fails. For the asynchronous import method, a successful return only means that the job was submitted successfully, not that the data was imported successfully. You need to use the corresponding command to check the running status of the import job.

## Import the Data of Array Types

The array function can only be supported in vectorization scenarios, but non-vectorization scenarios are not supported.
if you want to apply the array function to import data, you should enable vectorization engine. Then you need to cast the input parameter column into the array type according to the parameter of the array function. Finally, you can continue to use the array function.

For example, in the following import, you need to cast columns b14 and a13 into `array<string>` type, and then use the `array_union` function.

```sql
LOAD LABEL label_03_14_49_34_898986_19090452100 ( 
  DATA INFILE("hdfs://test.hdfs.com:9000/user/test/data/sys/load/array_test.data") 
  INTO TABLE `test_array_table` 
  COLUMNS TERMINATED BY "|" (`k1`, `a1`, `a2`, `a3`, `a4`, `a5`, `a6`, `a7`, `a8`, `a9`, `a10`, `a11`, `a12`, `a13`, `b14`) 
  SET(a14=array_union(cast(b14 as array<string>), cast(a13 as array<string>))) WHERE size(a2) > 270) 
  WITH BROKER "hdfs" ("username"="test_array", "password"="") 
  PROPERTIES( "max_filter_ratio"="0.8" );
```
