---
{
    "title": "ARRAY_AGG",
    "language": "en"
}
---

<!-- 
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->

## ARRAY_AGG

### description

#### Syntax

`ARRAY_AGG(col)`

Concatenation of values in a column (including the null value) into an array can be used for multiple rows to one row (row to column).

### notice

- The order of the elements in an array is not guaranteed.
- Returns the array generated by the transformation. The element type in the array is the same as the col type.

### example

```sql
mysql> select * from test_doris_array_agg;

+------+------+

| c1   | c2   |

+------+------+

|    1 | a    |

|    1 | b    |

|    2 | c    |

|    2 | NULL |

|    3 | NULL |

+------+------+

mysql> select c1, array_agg(c2) from test_doris_array_agg group by c1;

+------+-----------------+

| c1   | array_agg(`c2`) |

+------+-----------------+

|    1 | ["a","b"]       |

|    2 | [NULL,"c"]      |

|    3 | [NULL]          |

+------+-----------------+
```

### keywords

ARRAY_AGG
