// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.apache.doris.catalog.authorizer.ranger.cache;

import org.apache.doris.catalog.authorizer.ranger.doris.RangerDorisAccessController;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ranger.plugin.service.RangerAuthContextListener;

public class RangerCacheInvalidateListener implements RangerAuthContextListener {
    private static final Logger LOG = LogManager.getLogger(RangerDorisAccessController.class);

    private RangerCache cache;

    public RangerCacheInvalidateListener(RangerCache cache) {
        this.cache = cache;
    }

    @Override
    public void contextChanged() {
        LOG.info("ranger context changed");
        cache.invalidateDataMaskCache();
        cache.invalidateRowFilterCache();
    }
}
