---
id: getting-started
title: Getting started
sidebar_label: Getting started
---

## Install

Install apache-dubbo-js using npm:

```sh
npm install apache-dubbo-js
```

Or

```sh
yarn add apache-dubbo-js
```

## How to Usage?

```typescript
//=====================service.ts==================
//generated by interpret tools
import {BasicTypeProvider} from './providers/com/alibaba/dubbo/demo/BasicTypeProvider';
import {DemoProvider} from './providers/com/alibaba/dubbo/demo/DemoProvider';
import {ErrorProvider} from './providers/com/alibaba/dubbo/demo/ErrorProvider';

export default {
  BasicTypeProvider,
  DemoProvider,
  ErrorProvider,
};

//===============dubbo.ts========================
import {Dubbo} from 'apache-dubbo-js';
import service from './service';

//create dubbo object, it like a service container
const dubbo = new Dubbo<typeof service>({
  application: {name: 'node-dubbo'},
  //zookeeper address
  register: 'localhost:2181',
  service,
});

//main method
(async () => {
  const result1 = await dubbo.service.DemoProvider.sayHello('node');
  //print {err: null, res:'hello node from dubbo service'}
  const res = await dubbo.service.DemoProvider.echo();
  //print {err: null, res: 'pang'}
  const res = await dubbo.service.DemoProvider.getUserInfo();
  //status: 'ok', info: { id: '1', name: 'test' }
})();
```
