/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap;

import com.navercorp.pinpoint.bootstrap.AgentIds;
import com.navercorp.pinpoint.bootstrap.AgentProperties;
import com.navercorp.pinpoint.bootstrap.BootLogger;
import com.navercorp.pinpoint.bootstrap.IdValidator;
import com.navercorp.pinpoint.common.util.AgentUuidUtils;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class AgentIdResolver {
    public static final String APPLICATION_NAME = "applicationName";
    public static final String AGENT_ID = "agentId";
    public static final String AGENT_NAME = "agentName";
    public static final String SYSTEM_PROPERTY_PREFIX = "pinpoint.";
    public static final String APPLICATION_NAME_SYSTEM_PROPERTY = "pinpoint.applicationName";
    public static final String AGENT_ID_SYSTEM_PROPERTY = "pinpoint.agentId";
    public static final String AGENT_NAME_SYSTEM_PROPERTY = "pinpoint.agentName";
    public static final String ENV_PROPERTY_PREFIX = "PINPOINT_";
    public static final String APPLICATION_NAME_ENV_PROPERTY = "PINPOINT_APPLICATION_NAME";
    public static final String AGENT_ID_ENV_PROPERTY = "PINPOINT_AGENT_ID";
    public static final String AGENT_NAME_ENV_PROPERTY = "PINPOINT_AGENT_NAME";
    private final BootLogger logger = BootLogger.getLogger(this.getClass());
    private final List<AgentProperties> agentPropertyList;
    private final IdValidator idValidator = new IdValidator();

    public AgentIdResolver(List<AgentProperties> agentPropertyList) {
        this.agentPropertyList = Objects.requireNonNull(agentPropertyList, "agentPropertyList");
    }

    public AgentIds resolve() {
        String applicationName;
        String agentId = this.getAgentId();
        if (StringUtils.isEmpty((String)agentId)) {
            this.logger.info("Failed to resolve AgentId(-Dpinpoint.agentId)");
            agentId = this.newRandomAgentId();
            this.logger.info("Auto generate AgentId='" + agentId + "'");
        }
        if (StringUtils.isEmpty((String)(applicationName = this.getApplicationName()))) {
            this.logger.warn("Failed to resolve ApplicationName(-Dpinpoint.applicationName)");
            return null;
        }
        String agentName = this.getAgentName();
        if (StringUtils.isEmpty((String)agentName)) {
            this.logger.info("No AgentName(-Dpinpoint.agentName) provided, it's optional!");
        }
        return new AgentIds(agentId, agentName, applicationName);
    }

    private String newRandomAgentId() {
        UUID agentUUID = UUID.randomUUID();
        return AgentUuidUtils.encode((UUID)agentUUID);
    }

    private String getAgentId() {
        String source = null;
        for (AgentProperties agentProperty : this.agentPropertyList) {
            String agentId = agentProperty.getAgentId();
            if (StringUtils.isEmpty((String)agentId) || !this.idValidator.validateAgentId(agentProperty.getType(), agentId)) continue;
            this.logger.info((Object)((Object)agentProperty.getType()) + " " + agentProperty.getAgentIdKey() + "=" + agentId);
            source = agentId;
        }
        return source;
    }

    private String getAgentName() {
        String source = "";
        for (AgentProperties agentProperty : this.agentPropertyList) {
            String agentName = agentProperty.getAgentName();
            if (!this.idValidator.validateAgentName(agentProperty.getType(), agentName)) continue;
            this.logger.info((Object)((Object)agentProperty.getType()) + " " + agentProperty.getAgentNameKey() + "=" + agentName);
            source = agentName;
        }
        return source;
    }

    private String getApplicationName() {
        String source = null;
        for (AgentProperties agentProperty : this.agentPropertyList) {
            String applicationName = agentProperty.getApplicationName();
            if (StringUtils.isEmpty((String)applicationName) || !this.idValidator.validateApplicationName(agentProperty.getType(), applicationName)) continue;
            this.logger.info((Object)((Object)agentProperty.getType()) + " " + agentProperty.getApplicationNameKey() + "=" + applicationName);
            source = applicationName;
        }
        return source;
    }
}

