/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.agentdir;

import com.navercorp.pinpoint.bootstrap.BootLogger;
import com.navercorp.pinpoint.bootstrap.agentdir.FileUtils;
import com.navercorp.pinpoint.bootstrap.agentdir.JarDescription;
import com.navercorp.pinpoint.bootstrap.agentdir.JarFileUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BootDir {
    private final BootLogger logger = BootLogger.getLogger(this.getClass());
    private final List<Path> jars;

    public BootDir(Path baseDir, List<JarDescription> jarDescriptions) {
        Objects.requireNonNull(baseDir, "baseDir");
        Objects.requireNonNull(jarDescriptions, "jarDescriptions");
        this.jars = this.verify(baseDir, jarDescriptions);
    }

    private List<Path> verify(Path baseDir, List<JarDescription> jarDescriptions) {
        List<Path> jarFiles = FileUtils.listFiles(baseDir, "*.jar");
        if (jarFiles.isEmpty()) {
            this.logger.info(baseDir + " is empty");
            return null;
        }
        ArrayList<Path> resolvedJarList = new ArrayList<Path>(jarDescriptions.size());
        for (JarDescription jarDescription : jarDescriptions) {
            Path jarFileName = this.find(jarFiles, jarDescription);
            if (jarFileName == null) {
                String errorMessage = jarDescription.getSimplePattern() + " not found";
                if (!jarDescription.isRequired()) continue;
                throw new IllegalStateException(errorMessage);
            }
            resolvedJarList.add(jarFileName.toAbsolutePath());
        }
        return resolvedJarList;
    }

    private Path find(List<Path> jarFiles, JarDescription jarDescription) {
        String jarName = jarDescription.getJarName();
        Pattern pattern = jarDescription.getVersionPattern();
        List<Path> jarPathList = this.findFileByPattern(jarFiles, pattern);
        if (jarPathList.isEmpty()) {
            this.logger.info(jarName + " not found.");
            return null;
        }
        if (jarPathList.size() == 1) {
            Path file = jarPathList.get(0);
            this.logger.info("found " + jarName + " path:" + file);
            return FileUtils.toRealPath(file);
        }
        this.logger.warn("too many " + jarName + " found. " + jarPathList);
        return null;
    }

    private List<Path> findFileByPattern(List<Path> jarFiles, Pattern pattern) {
        ArrayList<Path> findList = new ArrayList<Path>();
        for (Path jarFile : jarFiles) {
            String fileName = jarFile.getFileName().toString();
            Matcher matcher = pattern.matcher(fileName);
            if (!matcher.matches()) continue;
            findList.add(jarFile);
        }
        return findList;
    }

    public List<Path> getJarPath() {
        return this.jars;
    }

    public List<JarFile> openJarFiles() {
        ArrayList<JarFile> jarFileList = new ArrayList<JarFile>(this.jars.size());
        for (Path jarPath : this.jars) {
            JarFile jarFile = JarFileUtils.openJarFile(jarPath.toFile());
            jarFileList.add(jarFile);
        }
        return jarFileList;
    }
}

