/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.annotation;

import com.navercorp.pinpoint.common.util.DataType;
import com.navercorp.pinpoint.common.util.IntBooleanIntBooleanValue;
import com.navercorp.pinpoint.common.util.IntStringStringValue;
import com.navercorp.pinpoint.common.util.IntStringValue;
import com.navercorp.pinpoint.common.util.LongIntIntByteByteStringValue;
import com.navercorp.pinpoint.common.util.StringStringValue;
import com.navercorp.pinpoint.grpc.trace.PAnnotationValue;
import com.navercorp.pinpoint.grpc.trace.PIntBooleanIntBooleanValue;
import com.navercorp.pinpoint.grpc.trace.PIntStringStringValue;
import com.navercorp.pinpoint.grpc.trace.PIntStringValue;
import com.navercorp.pinpoint.grpc.trace.PLongIntIntByteByteStringValue;
import com.navercorp.pinpoint.grpc.trace.PStringStringValue;
import com.navercorp.pinpoint.profiler.context.Annotation;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcAnnotationSerializable;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcAnnotationValueMapper;
import com.navercorp.pinpoint.profiler.context.thrift.AnnotationValueThriftMapper;
import com.navercorp.pinpoint.profiler.context.thrift.ThriftAnnotationSerializable;
import com.navercorp.pinpoint.thrift.dto.TAnnotationValue;
import com.navercorp.pinpoint.thrift.dto.TIntBooleanIntBooleanValue;
import com.navercorp.pinpoint.thrift.dto.TIntStringStringValue;
import com.navercorp.pinpoint.thrift.dto.TIntStringValue;
import com.navercorp.pinpoint.thrift.dto.TLongIntIntByteByteStringValue;
import com.navercorp.pinpoint.thrift.dto.TStringStringValue;

public class DataTypeAnnotation
implements Annotation<DataType>,
GrpcAnnotationSerializable,
ThriftAnnotationSerializable {
    private final int key;
    private final DataType value;

    DataTypeAnnotation(int key, DataType value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public int getAnnotationKey() {
        return this.getKey();
    }

    @Override
    public int getKey() {
        return this.key;
    }

    @Override
    public DataType getValue() {
        return this.value;
    }

    @Override
    public PAnnotationValue apply(GrpcAnnotationValueMapper context) {
        PAnnotationValue.Builder builder = context.getAnnotationBuilder();
        DataType dataType = this.value;
        if (dataType instanceof IntStringValue) {
            IntStringValue v = (IntStringValue)dataType;
            PIntStringValue pIntStringValue = context.newIntStringValue(v);
            builder.setIntStringValue(pIntStringValue);
            return builder.build();
        }
        if (dataType instanceof StringStringValue) {
            StringStringValue v = (StringStringValue)dataType;
            PStringStringValue pStringStringValue = context.newStringStringValue(v);
            builder.setStringStringValue(pStringStringValue);
            return builder.build();
        }
        if (dataType instanceof IntStringStringValue) {
            IntStringStringValue v = (IntStringStringValue)dataType;
            PIntStringStringValue pIntStringStringValue = context.newIntStringStringValue(v);
            builder.setIntStringStringValue(pIntStringStringValue);
            return builder.build();
        }
        if (dataType instanceof LongIntIntByteByteStringValue) {
            LongIntIntByteByteStringValue v = (LongIntIntByteByteStringValue)dataType;
            PLongIntIntByteByteStringValue pValue = context.newLongIntIntByteByteStringValue(v);
            builder.setLongIntIntByteByteStringValue(pValue);
            return builder.build();
        }
        if (dataType instanceof IntBooleanIntBooleanValue) {
            IntBooleanIntBooleanValue v = (IntBooleanIntBooleanValue)dataType;
            PIntBooleanIntBooleanValue pValue = context.newIntBooleanIntBooleanValue(v);
            builder.setIntBooleanIntBooleanValue(pValue);
            return builder.build();
        }
        throw new UnsupportedOperationException("unsupported type:" + dataType);
    }

    @Override
    public TAnnotationValue apply(AnnotationValueThriftMapper context) {
        DataType dataType = this.value;
        if (dataType instanceof IntStringValue) {
            IntStringValue v = (IntStringValue)dataType;
            TIntStringValue tIntStringValue = new TIntStringValue(v.getIntValue());
            if (v.getStringValue() != null) {
                tIntStringValue.setStringValue(v.getStringValue());
            }
            return TAnnotationValue.intStringValue((TIntStringValue)tIntStringValue);
        }
        if (dataType instanceof StringStringValue) {
            StringStringValue v = (StringStringValue)dataType;
            TStringStringValue tStringStringValue = new TStringStringValue(v.getStringValue1());
            if (v.getStringValue2() != null) {
                tStringStringValue.setStringValue2(v.getStringValue2());
            }
            return TAnnotationValue.stringStringValue((TStringStringValue)tStringStringValue);
        }
        if (dataType instanceof IntStringStringValue) {
            IntStringStringValue v = (IntStringStringValue)dataType;
            TIntStringStringValue tIntStringStringValue = new TIntStringStringValue(v.getIntValue());
            if (v.getStringValue1() != null) {
                tIntStringStringValue.setStringValue1(v.getStringValue1());
            }
            if (v.getStringValue2() != null) {
                tIntStringStringValue.setStringValue2(v.getStringValue2());
            }
            return TAnnotationValue.intStringStringValue((TIntStringStringValue)tIntStringStringValue);
        }
        if (dataType instanceof LongIntIntByteByteStringValue) {
            LongIntIntByteByteStringValue v = (LongIntIntByteByteStringValue)dataType;
            TLongIntIntByteByteStringValue tvalue = new TLongIntIntByteByteStringValue(v.getLongValue(), v.getIntValue1());
            if (v.getIntValue2() != -1) {
                tvalue.setIntValue2(v.getIntValue2());
            }
            if (v.getByteValue1() != -1) {
                tvalue.setByteValue1(v.getByteValue1());
            }
            if (v.getByteValue2() != -1) {
                tvalue.setByteValue2(v.getByteValue2());
            }
            if (v.getStringValue() != null) {
                tvalue.setStringValue(v.getStringValue());
            }
            return TAnnotationValue.longIntIntByteByteStringValue((TLongIntIntByteByteStringValue)tvalue);
        }
        if (dataType instanceof IntBooleanIntBooleanValue) {
            IntBooleanIntBooleanValue v = (IntBooleanIntBooleanValue)dataType;
            TIntBooleanIntBooleanValue tvalue = new TIntBooleanIntBooleanValue(v.getIntValue1(), v.isBooleanValue1(), v.getIntValue2(), v.isBooleanValue2());
            return TAnnotationValue.intBooleanIntBooleanValue((TIntBooleanIntBooleanValue)tvalue);
        }
        throw new UnsupportedOperationException("unsupported type:" + dataType);
    }

    public String toString() {
        return "DataTypeAnnotation{" + this.key + "=" + this.value + '}';
    }
}

